/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin;

import java.util.ArrayList;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class BudgetOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("year");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("pid");
        e.getFieldKeys().add("istotal");
        e.getFieldKeys().add("ispres");
        e.getFieldKeys().add("isprev");
        e.getFieldKeys().add("budgetitemnum");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("budgetamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operationKey = this.getOperateKey();
                if ("submit".equals(operationKey)) {
                    for (ExtendedDataEntity dataEntry : dataEntities) {
                        DynamicObject project;
                        DynamicObject dataEntity = dataEntry.getDataEntity();
                        String billStatus = dataEntity.getString("billstatus");
                        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) || (project = dataEntity.getDynamicObject("project")) == null) continue;
                        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                        String sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)dataEntity.getString("sourcetype")) ? "IN" : "OUT";
                        qFilter.and("sourcetype", "=", (Object)sourceType);
                        DynamicObjectCollection itemEntities = dataEntity.getDynamicObjectCollection("treeentryentity");
                        if ("OUT".equals(dataEntity.getString("sourcetype")) && !itemEntities.isEmpty()) {
                            Optional<DynamicObject> isTotal = itemEntities.stream().filter(o -> o.getBoolean("istotal")).findFirst();
                            Optional<DynamicObject> topLevel = itemEntities.stream().filter(o -> !o.getBoolean("istotal")).filter(o -> o.getLong("pid") == 0L).findFirst();
                            if (isTotal.isPresent() && topLevel.isPresent()) {
                                this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u7f16\u5236\u4e0d\u5141\u8bb8\u589e\u52a0\u9876\u7ea7\u9884\u7b97\u9879\u3002\u53ea\u5141\u8bb8\u589e\u52a0\u4e0b\u7ea7\u9884\u7b97\u9879\uff0c\u53ea\u80fd\u901a\u8fc7\u603b\u4f53\u9884\u7b97\u7f16\u5236\u589e\u52a0\u9876\u7ea7\u9884\u7b97\u9879\u3002", (String)"BudgetOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            }
                        }
                        ArrayList<DynamicObject> numberList = new ArrayList<DynamicObject>();
                        for (DynamicObject itemEntity : itemEntities) {
                            String itemNum = itemEntity.getString("budgetitemnum");
                            if (StringUtils.isEmpty((CharSequence)itemNum)) continue;
                            Optional<DynamicObject> first = numberList.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("budgetitemnum"), (CharSequence)itemNum)).findFirst();
                            if (first.isPresent()) {
                                DynamicObject sameEntity = first.get();
                                String sameSeq = sameEntity.getString("seq");
                                String curSeq = itemEntity.getString("seq");
                                String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u9884\u7b97\u9879\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BudgetOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), sameSeq, curSeq);
                                this.addErrorMessage(dataEntry, tip);
                                continue;
                            }
                            numberList.add(itemEntity);
                            boolean isPres = itemEntity.getBoolean("ispres");
                            boolean isPrev = itemEntity.getBoolean("isprev");
                            boolean isTotal = itemEntity.getBoolean("istotal");
                            if (isPres || isPrev || isTotal) continue;
                            QFilter numQFilter = new QFilter("number", "=", (Object)itemNum);
                            boolean exists = QueryServiceHelper.exists((String)"pmas_projectbudget", (QFilter[])new QFilter[]{qFilter, numQFilter});
                            if (!exists) continue;
                            this.addErrorMessage(dataEntry, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u7f16\u7801\uff1a%1$s\uff0c\u9879\u76ee\u5185\u5df2\u5b58\u5728\u3002", (String)"BudgetOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), itemNum));
                        }
                    }
                }
            }
        });
    }
}

