/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.ApprovalAmtModifyOpHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.TimeUtils;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class ApprovalAmtModifyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ApprovalAmtModifyOp.class);
    private static final String NUMBER_PREFIX = "_AMT_MODIFY_";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("year");
        e.getFieldKeys().add("afterproamt");
        e.getFieldKeys().add("prooutbudgetsumamt");
        e.getFieldKeys().add("afterproyearamt");
        e.getFieldKeys().add("outamount");
        e.getFieldKeys().add("kind");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("controlinfoentry");
        e.getFieldKeys().add("afterundertakeamt");
        e.getFieldKeys().add("fundsourceentry");
        e.getFieldKeys().add("fundsourcetype");
        e.getFieldKeys().add("fundscale");
        e.getFieldKeys().add("fundamount");
        e.getFieldKeys().add("entrycurrency");
        e.getFieldKeys().add("fundformofinvest");
        e.getFieldKeys().add("funddescription");
        e.getFieldKeys().add("seq");
        e.getFieldKeys().add("fundsumamount");
        e.getFieldKeys().add("fundoldamount");
        e.getFieldKeys().add("budgetcontrolmode");
        e.getFieldKeys().add("realbudgetentry");
        e.getFieldKeys().add("controlinfoentry");
        e.getFieldKeys().add("realprobudgetname");
        e.getFieldKeys().add("realproname");
        e.getFieldKeys().add("realbudgetitem");
        e.getFieldKeys().add("realundertakeamt");
        e.getFieldKeys().add("realundertakeorg");
        e.getFieldKeys().add("realproid");
        e.getFieldKeys().add("realundertakeperiod");
        e.getFieldKeys().add("realdifferenceamt");
        e.getFieldKeys().add("realpronumber");
        e.getFieldKeys().add("realbeforeamt");
        e.getFieldKeys().add("ctrloutitem");
        e.getFieldKeys().add("undertakeorg");
        e.getFieldKeys().add("ctrloutitemname");
        e.getFieldKeys().add("entryproname");
        e.getFieldKeys().add("undertakeorg");
        e.getFieldKeys().add("undertakeperiod");
        e.getFieldKeys().add("undertakeamt");
        e.getFieldKeys().add("undertakeratio");
        e.getFieldKeys().add("afterundertakeamt");
        e.getFieldKeys().add("entryproid");
        e.getFieldKeys().add("differundertakeamt");
        e.getFieldKeys().add("modifybillno");
        e.getFieldKeys().add("modifyname");
        e.getFieldKeys().add("projectbugamt");
        e.getFieldKeys().add("proyearbudgetamt");
        e.getFieldKeys().add("projectapplydate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        block6: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "submit": {
                    String budgetControlMode = dataEntity.getString("budgetcontrolmode");
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue()) || !ApprovalAmtModifyOpHelper.validateIsOccupyAmount((DynamicObject)dataEntity)) continue block6;
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                        ApprovalAmtModifyOpHelper.validateBudgetBalance((DynamicObject)dataEntity);
                    }
                    ApprovalAmtModifyOpHelper.saveBudgetRecord((DynamicObject)dataEntity);
                    continue block6;
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        block12: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "submit": {
                    String budgetControlMode = dataEntity.getString("budgetcontrolmode");
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue()) || !ApprovalAmtModifyOpHelper.validateIsOccupyAmount((DynamicObject)dataEntity)) continue block12;
                    QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
                    DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
                    if (budgetRecord == null) {
                        qFilter = new QFilter("billno", "=", (Object)dataEntity.getString("billno"));
                        qFilter.and("billsource", "=", (Object)"pmas_approval_amtmodify");
                        budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
                    }
                    if (budgetRecord != null) {
                        budgetRecord.set("relatebillid", (Object)dataEntity.getPkValue().toString());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetRecord});
                    }
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                        ApprovalAmtModifyOpHelper.occupyChangeAmount((DynamicObject)dataEntity, (DynamicObject)budgetRecord);
                        continue block12;
                    }
                    ApprovalAmtModifyOpHelper.occupyAmount((DynamicObject)dataEntity, (DynamicObject)budgetRecord);
                    continue block12;
                }
                case "unsubmit": {
                    String budgetControlMode = dataEntity.getString("budgetcontrolmode");
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue()) || !ApprovalAmtModifyOpHelper.validateIsOccupyAmount((DynamicObject)dataEntity)) continue block12;
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                        ApprovalAmtModifyOpHelper.returnOccupyChangeAmount((DynamicObject)dataEntity, (String)"unsubmit");
                    } else {
                        ApprovalAmtModifyOpHelper.returnOccupyAmount((DynamicObject)dataEntity, (String)"unsubmit");
                    }
                    ApprovalAmtModifyOpHelper.updateBudgetRecordField((DynamicObject)dataEntity, (String)"unsubmit");
                    continue block12;
                }
                case "audit": {
                    this.auditEvents(dataEntity);
                    continue block12;
                }
                case "delete": {
                    QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
                    DeleteServiceHelper.delete((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
                    continue block12;
                }
            }
        }
    }

    protected void auditEvents(DynamicObject dataEntity) {
        DynamicObject project = dataEntity.getDynamicObject("project");
        QFilter qFilter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter});
        ApprovalAmtModifyOpHelper.saveApprovalAndSysPro((DynamicObject)dataEntity, (DynamicObject)approval);
        this.updateBudgetCtrlInfo(dataEntity);
        ApprovalAmtModifyOpHelper.saveAdjustFundSource((DynamicObject)dataEntity);
        String budgetControlMode = dataEntity.getString("budgetcontrolmode");
        if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue()) && ApprovalAmtModifyOpHelper.validateIsOccupyAmount((DynamicObject)dataEntity)) {
            if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                ApprovalAmtModifyOpHelper.returnOccupyChangeAmount((DynamicObject)dataEntity, (String)"audit");
                BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)dataEntity, (BudgetCtrlEnum)BudgetCtrlEnum.AUDIT);
            }
            ApprovalAmtModifyOpHelper.updateBudgetRecordField((DynamicObject)dataEntity, (String)"audit");
        }
        ApprovalAmtModifyOpHelper.updateProjectBudgetCtrl((DynamicObject)approval);
    }

    private void updateBudgetCtrlInfo(DynamicObject dataEntity) {
        DynamicObject yearBudgetCtrlBill;
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (project == null) {
            return;
        }
        BigDecimal afterProAmt = dataEntity.getBigDecimal("afterproamt");
        BigDecimal afterProYearAmt = dataEntity.getBigDecimal("afterproyearamt");
        Date year = dataEntity.getDate("year");
        QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject totalBudgetCtrlBill = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrlBill != null) {
            totalBudgetCtrlBill.set("proappamt", (Object)afterProAmt);
            SaveServiceHelper.update((DynamicObject)totalBudgetCtrlBill);
        }
        qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        if (year != null) {
            int curYearInt = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            qFilter.and("YEAR(yyear)", "=", (Object)curYearInt);
        }
        if ((yearBudgetCtrlBill = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter})) != null) {
            yearBudgetCtrlBill.set("yearproamt", (Object)afterProYearAmt);
            SaveServiceHelper.update((DynamicObject)yearBudgetCtrlBill);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        BigDecimal sumAmount;
                        DynamicObjectCollection controlEntries;
                        BigDecimal outAmount;
                        BigDecimal afterProYearAmt;
                        BigDecimal proOutBudgetSumAmt;
                        BigDecimal afterProAmt;
                        DynamicObject entity = dataEntity.getDataEntity();
                        DynamicObject project = entity.getDynamicObject("project");
                        if (project != null) {
                            QFilter qFilter = new QFilter("project", "=", project.getPkValue());
                            qFilter.and("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
                            if (QueryServiceHelper.exists((String)"pmas_approval_amtmodify", (QFilter[])new QFilter[]{qFilter})) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u9879\u76ee\u91d1\u989d\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u91cd\u590d\u53d8\u66f4\u3002", (String)"ApprovalAmtModifyOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if ((afterProAmt = entity.getBigDecimal("afterproamt")).compareTo(proOutBudgetSumAmt = entity.getBigDecimal("prooutbudgetsumamt")) < 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u540e\u9879\u76ee\u7acb\u9879\u91d1\u989d\u201d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u201c\u9879\u76ee\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u201d\u3002", (String)"ApprovalAmtModifyOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        if ((afterProYearAmt = entity.getBigDecimal("afterproyearamt")).compareTo(outAmount = entity.getBigDecimal("outamount")) < 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u540e\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u201d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u201c\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u201d\u3002", (String)"ApprovalAmtModifyOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        if ((controlEntries = entity.getDynamicObjectCollection("controlinfoentry")).size() > 0 && (sumAmount = controlEntries.stream().map(obj -> obj.getBigDecimal("afterundertakeamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(afterProYearAmt) != 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u540e\u627f\u62c5\u91d1\u989d\u4e4b\u548c\u201d\u5fc5\u987b\u7b49\u4e8e\u201c\u53d8\u66f4\u540e\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u201d\u3002", (String)"ApprovalAmtModifyOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        if (afterProAmt.compareTo(afterProYearAmt) < 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u540e\u9879\u76ee\u7acb\u9879\u91d1\u989d\u201d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u201c\u53d8\u66f4\u540e\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u201d\u3002", (String)"ApprovalAmtModifyOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        this.checkBudgetControlMode(dataEntity);
                        this.checkBudgetCtrlMode(dataEntity);
                    }
                }
            }

            private void checkBudgetControlMode(ExtendedDataEntity dataEntity) {
                if (BudgetCtlModeEnum.CONTROLANDADJUST.getValue().equals(dataEntity.getValue("budgetcontrolmode"))) {
                    DynamicObjectCollection controlEntrys = (DynamicObjectCollection)dataEntity.getValue("controlinfoentry");
                    for (DynamicObject entry : controlEntrys) {
                        DynamicObject underTakeOrg = entry.getDynamicObject("undertakeorg");
                        if (underTakeOrg != null) continue;
                        return;
                    }
                    for (int i = 0; i < controlEntrys.size() - 1; ++i) {
                        for (int j = i; j < controlEntrys.size() - 1; ++j) {
                            DynamicObject controlEntry = (DynamicObject)controlEntrys.get(i);
                            DynamicObject ctrloutitem = controlEntry.getDynamicObject("ctrloutitem");
                            DynamicObject org = controlEntry.getDynamicObject("undertakeorg");
                            Date period = controlEntry.getDate("undertakeperiod");
                            String ctrloutitemname = controlEntry.getString("ctrloutitemname");
                            String proName = ((DynamicObject)controlEntrys.get(i)).getString("entryproname");
                            if (this.validateSplitTypeData(dataEntity, controlEntry)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ApprovalAmtModifyOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitem.getString("name"), org.getString("name"), DateUtil.formatDateYear((Date)period), proName));
                            }
                            if (this.validateSplitTypeData(dataEntity, controlEntry)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ApprovalAmtModifyOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitemname, org.getString("name"), DateUtil.formatDate2((Date)period), proName));
                            }
                            if (!this.validateSplitTypeData(dataEntity, controlEntry)) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ApprovalAmtModifyOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitem.getString("name"), org.getString("name"), DateUtil.formatDate2((Date)period), proName));
                        }
                    }
                }
            }

            protected boolean validateSplitTypeData(ExtendedDataEntity dataEntity, DynamicObject controlEntry) {
                String ctrloutitemname = controlEntry.getString("ctrloutitemname");
                DynamicObject ctrloutitem = controlEntry.getDynamicObject("ctrloutitem");
                DynamicObject org = controlEntry.getDynamicObject("undertakeorg");
                Date period = controlEntry.getDate("undertakeperiod");
                long proId = controlEntry.getLong("entryproid");
                String ctrloutitemnameNext = controlEntry.getString("ctrloutitemname");
                DynamicObject ctrloutitemNext = controlEntry.getDynamicObject("ctrloutitem");
                DynamicObject orgNext = controlEntry.getDynamicObject("undertakeorg");
                Date periodNext = controlEntry.getDate("undertakeperiod");
                long proIdNext = controlEntry.getLong("entryproid");
                String splittype = dataEntity.getDataEntity().getString("splittype");
                if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splittype) && ctrloutitem.equals(ctrloutitemNext) && org.getPkValue() == orgNext.getPkValue() && TimeUtils.isSameYear((Date)period, (Date)periodNext) && proId == proIdNext) {
                    return false;
                }
                if (SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(splittype) && ctrloutitemname.equals(ctrloutitemnameNext) && org.getPkValue() == orgNext.getPkValue() && TimeUtils.isSameMonth((Date)period, (Date)periodNext) && proId == proIdNext) {
                    return false;
                }
                return !SplitTypeEnum.SUMSPLIT.getValue().equals(splittype) || ctrloutitem.getPkValue() != ctrloutitemNext.getPkValue() || org.getPkValue() != orgNext.getPkValue() || !TimeUtils.isSameMonth((Date)period, (Date)periodNext) || proId != proIdNext;
            }

            private void checkBudgetCtrlMode(ExtendedDataEntity exDateEntity) {
                DynamicObject dataEntity = exDateEntity.getDataEntity();
                String budgetControlMode = dataEntity.getString("budgetcontrolmode");
                if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                    DynamicObjectCollection controlinfoentryCol = dataEntity.getDynamicObjectCollection("controlinfoentry");
                    for (DynamicObject entry : controlinfoentryCol) {
                        String entryProName = entry.getString("entryproname");
                        if (entryProName != null && !entryProName.isEmpty()) continue;
                        this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u9879\u76ee\u540d\u79f0\u3002", (String)"ApprovalAmtModifyOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }
}

