/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.ProjValidEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.coderule.CodeRuleHelper;

public class ProApprovalAdjustOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ProApprovalAdjustOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("proname");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("pro");
        e.getFieldKeys().add("parentpro");
        e.getFieldKeys().add("planbegindate");
        e.getFieldKeys().add("planenddate");
        e.getFieldKeys().add("proaddress");
        e.getFieldKeys().add("department");
        e.getFieldKeys().add("accountorg");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("purpose");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            this.updateProjectData(dataEntities);
        }
    }

    private void updateProjectData(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            ILocaleString proName = dataEntity.getLocaleString("proname");
            DynamicObject pro = dataEntity.getDynamicObject("pro");
            String name = pro.getString("name");
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"bd_project");
            QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{projectFilter});
            ArrayList<DynamicObject> updateProList = new ArrayList<DynamicObject>();
            updateProList.add(project);
            if (!StringUtils.equals((CharSequence)name, (CharSequence)proName.getLocaleValue())) {
                DynamicObject parentPro = dataEntity.getDynamicObject("parentpro");
                if (parentPro == null) {
                    project.set("fullname", (Object)proName);
                } else {
                    ILocaleString parentFullName = parentPro.getLocaleString("fullname");
                    LocaleString fullName = new LocaleString();
                    fullName.setLocaleValue_en(String.format("%s.%s", parentFullName.getLocaleValue_en(), proName.getLocaleValue_en()));
                    fullName.setLocaleValue_zh_CN(String.format("%s.%s", parentFullName.getLocaleValue_zh_CN(), proName.getLocaleValue_zh_CN()));
                    fullName.setLocaleValue_zh_TW(String.format("%s.%s", parentFullName.getLocaleValue_zh_TW(), proName.getLocaleValue_zh_TW()));
                    project.set("fullname", (Object)fullName);
                }
                this.updateFullName(updateProList, proName, project);
            }
            projectApproval.set("department", (Object)dataEntity.getDynamicObject("department"));
            projectApproval.set("accountorg", (Object)dataEntity.getDynamicObject("accountorg"));
            SaveServiceHelper.update((DynamicObject)projectApproval);
            project.set("name", (Object)proName);
            project.set("planbegindate", dataEntity.get("planbegindate"));
            project.set("planenddate", dataEntity.get("planenddate"));
            project.set("proaddress", dataEntity.get("proaddress"));
            project.set("department", dataEntity.get("department"));
            project.set("pmascreateorg", dataEntity.get("createorg"));
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])updateProList.toArray(new DynamicObject[0]));
                }
                catch (Exception e1) {
                    logger.error("\u66f4\u65b0\u9879\u76ee\u5f02\u5e38\u3002", (Throwable)e1);
                    h.markRollback();
                    throw e1;
                }
            }
            ProApprovalAdjustOp.saveProGoal(dataEntity, project, projectApproval);
        }
    }

    private static void saveProGoal(DynamicObject proApprovalAdjust, DynamicObject project, DynamicObject projectApproval) {
        boolean isPurposeSame;
        ArrayList<DynamicObject> goalList = new ArrayList<DynamicObject>();
        String purpose = proApprovalAdjust.getString("purpose");
        QFilter proIdFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("objstatus", "=", (Object)ProjValidEnum.VALID.getValue());
        DynamicObject relationObj = BusinessDataServiceHelper.loadSingle((String)"pmas_projectobjective", (QFilter[])new QFilter[]{proIdFilter, statusFilter});
        boolean bl = isPurposeSame = relationObj != null && purpose != null && purpose.equals(relationObj.getString("objective"));
        if (isPurposeSame) {
            return;
        }
        DynamicObject goal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectobjective"));
        goalList.add(goal);
        DynamicObject org = projectApproval.getDynamicObject("org");
        goal.set("org", (Object)org);
        goal.set("project", (Object)project);
        goal.set("issys", (Object)DefaultEnum.YES.getValue());
        goal.set("projkind", projectApproval.get("kind"));
        goal.set("objstatus", (Object)ProjValidEnum.VALID.getValue());
        goal.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        goal.set("creator", projectApproval.get("creator"));
        Date now = new Date();
        goal.set("createtime", (Object)now);
        goal.set("auditor", projectApproval.get("auditor"));
        goal.set("auditdate", (Object)now);
        goal.set("modifier", projectApproval.get("modifier"));
        goal.set("modifytime", (Object)now);
        BigDecimal version = BigDecimal.ONE;
        if (relationObj != null) {
            relationObj.set("objstatus", (Object)ProjValidEnum.INVALID.getValue());
            relationObj.set("operationdate", (Object)new Date());
            relationObj.set("operator", (Object)RequestContext.get().getUserId());
            relationObj.set("opinion", (Object)ResManager.loadKDString((String)"\u5df2\u8fdb\u884c\u8c03\u6574\u3002", (String)"ProApprovalAdjustOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
            goal.set("relationobj", (Object)relationObj);
            version = relationObj.getBigDecimal("version").add(BigDecimal.ONE);
            goalList.add(relationObj);
        }
        goal.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s_\u9879\u76ee\u76ee\u6807_%2$s", (String)"ProApprovalAdjustOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), project.get("name"), version));
        String billNo = CodeRuleHelper.getBillNo((String)"pmas_projectobjective", (DynamicObject)goal, (String)org.getPkValue().toString());
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            billNo = project.get("number") + "_GOAL_" + version;
        }
        goal.set("billno", (Object)billNo);
        goal.set("version", (Object)version);
        goal.set("objective", (Object)purpose);
        goal.set("createorg", projectApproval.get("createorg"));
        SaveServiceHelper.save((DynamicObject[])goalList.toArray(new DynamicObject[0]));
    }

    private void updateFullName(List<DynamicObject> updateProList, ILocaleString proName, DynamicObject parentPro) {
        QFilter parentFilter = new QFilter("parent", "=", parentPro.getPkValue());
        DynamicObject[] sonProjects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,name,fullname", (QFilter[])new QFilter[]{parentFilter});
        if (sonProjects != null && sonProjects.length > 0) {
            Set sonProjectIdSet = Arrays.stream(sonProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            for (DynamicObject sonProject : sonProjects = BusinessDataServiceHelper.load((Object[])sonProjectIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"))) {
                LocaleString fullName = new LocaleString();
                ILocaleString sonProjectName = sonProject.getLocaleString("name");
                fullName.setLocaleValue_en(String.format("%s.%s", proName.getLocaleValue_en(), sonProjectName.getLocaleValue_en()));
                fullName.setLocaleValue_zh_CN(String.format("%s.%s", proName.getLocaleValue_zh_CN(), sonProjectName.getLocaleValue_zh_CN()));
                fullName.setLocaleValue_zh_TW(String.format("%s.%s", proName.getLocaleValue_zh_TW(), sonProjectName.getLocaleValue_zh_TW()));
                sonProject.set("fullname", (Object)fullName);
                updateProList.add(sonProject);
                this.updateFullName(updateProList, sonProjectName, sonProject);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"submit".equals(key)) continue;
            isAddValid = true;
            break;
        }
        if (isAddValid) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    String operateKey = this.getOperateKey();
                    ExtendedDataEntity[] dataEntities = this.getDataEntities();
                    switch (operateKey) {
                        case "submit": {
                            for (ExtendedDataEntity dataEntity : dataEntities) {
                                String proAdjustName = (String)dataEntity.getValue("proname");
                                String billno = (String)dataEntity.getValue("billno");
                                if (!StringUtils.isEmpty((CharSequence)proAdjustName)) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u9879\u76ee\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProApprovalAdjustOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billno));
                            }
                            break;
                        }
                    }
                }
            });
        }
    }
}

