/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.projadjust.ChLeaderGenerateTeamAdjust;
import kd.pmgt.pmas.business.helper.projadjust.GenerateParam;
import kd.pmgt.pmas.business.helper.projadjust.GenerateParamBuilder;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TeamAdjustDescEnum;

public class ProjLeaderChangeOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_CHANGELEADER = "changeleader";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)OPERATION_CHANGELEADER, (CharSequence)operationKey)) {
            for (DynamicObject obj : e.getDataEntities()) {
                this.changeProjLeader(obj);
            }
        }
    }

    private void changeProjLeader(DynamicObject obj) {
        DynamicObject nowLeaderObj = obj.getDynamicObject("nowleader");
        String nowTelNo = obj.getString("nowleadertelno");
        DynamicObject oriLeaderObj = obj.getDynamicObject("orileader");
        String oriTelNo = obj.getString("orileadertelno");
        Object projectID = obj.get("project");
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectID, (String)"bd_project");
        if (projectObj == null) {
            return;
        }
        Boolean exsitsProjectTeam = ProjLeaderChangeOp.exsitsProjectTeam(projectObj);
        if (exsitsProjectTeam.booleanValue()) {
            this.createTeamAdjust(projectObj, oriLeaderObj, oriTelNo, nowLeaderObj, nowTelNo);
        } else {
            this.createProjectTeam(projectObj, nowLeaderObj, nowTelNo);
        }
    }

    private void createTeamAdjust(DynamicObject projectObj, DynamicObject oriLeaderObj, String oriTelNo, DynamicObject nowLeaderObj, String nowTelNo) {
        DynamicObject[] preNowTeamMenbers = ProjectApprovalHelper.getNowTeamMenbers((DynamicObject)projectObj);
        DynamicObject[] preOutNowTeamMenbers = ProjectApprovalHelper.getOutNowTeamMenbers((DynamicObject)projectObj);
        ProjLeaderChangeOp.delLeaderFromNowTeam(projectObj, oriLeaderObj, oriTelNo, TeamAdjustDescEnum.CHANGE_LEADER);
        boolean existsProjLeader = ProjectApprovalHelper.existsProjLeader((DynamicObject)nowLeaderObj, (DynamicObject)projectObj);
        if (existsProjLeader) {
            return;
        }
        Boolean saveResult = ProjectApprovalHelper.createnNowTeam((DynamicObject)projectObj, (DynamicObject)nowLeaderObj, (String)nowTelNo, (TeamAdjustDescEnum)TeamAdjustDescEnum.CHANGE_LEADER, (boolean)true);
        if (saveResult.booleanValue()) {
            GenerateParam generateParam = GenerateParamBuilder.generateParam().withProjectObj(projectObj).withPreNowTeamMenbers(preNowTeamMenbers).withPreOutNowTeamMenbers(preOutNowTeamMenbers).withProjLeaderObj(nowLeaderObj).withOriProjLeaderObj(oriLeaderObj).withTelNo(nowTelNo).withOriTelNo(oriTelNo).build();
            ChLeaderGenerateTeamAdjust generateTeamAdjust = new ChLeaderGenerateTeamAdjust();
            generateTeamAdjust.generateTeamAdjust(generateParam, TeamAdjustDescEnum.CHANGE_LEADER);
        }
    }

    private void createProjectTeam(DynamicObject projectObj, DynamicObject nowLeaderObj, String nowTelNo) {
        DynamicObject projTeamObj = BusinessDataServiceHelper.newDynamicObject((String)"pmas_team");
        projTeamObj.set("project", (Object)projectObj);
        projTeamObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        projTeamObj.set("type", (Object)BillTypeEnum.NEW);
        projTeamObj.set("proleader", (Object)nowLeaderObj);
        projTeamObj.set("leaderconttype", (Object)nowTelNo);
        projectObj = BusinessDataServiceHelper.loadSingleFromCache((Object)projectObj.getPkValue(), (String)"bd_project");
        projTeamObj.set("org", (Object)projectObj.getDynamicObject("pmascreateorg"));
        String number = String.format(ResManager.loadKDString((String)"%s_\u9879\u76ee\u56e2\u961f", (String)"ProjLeaderChangeOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), projectObj.get("name"));
        projTeamObj.set("billno", (Object)number);
        projTeamObj.set("description", (Object)TeamAdjustDescEnum.CHANGE_LEADER.getDesc());
        projTeamObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        projTeamObj.set("createtime", (Object)TimeServiceHelper.now());
        projTeamObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        projTeamObj.set("modifytime", (Object)TimeServiceHelper.now());
        projTeamObj.set("auditor", (Object)RequestContext.get().getCurrUserId());
        projTeamObj.set("auditdate", (Object)TimeServiceHelper.now());
        projTeamObj.set("issys", (Object)1);
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)RequestContext.get().getCurrUserId());
        if (userMainOrgId != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)userMainOrgId, (String)"bos_org");
            projTeamObj.set("createorg", (Object)org);
        }
        DynamicObjectCollection teamEntrys = projTeamObj.getDynamicObjectCollection("teamentry");
        DynamicObject teamMember = teamEntrys.addNew();
        teamMember.set("member", (Object)nowLeaderObj);
        DynamicObject projLeaderRoleObj = ProjectApprovalHelper.getProjLeaderRoleObj();
        teamMember.set("role", (Object)projLeaderRoleObj);
        teamMember.set("telno", (Object)nowTelNo);
        teamMember.set("note", (Object)TeamAdjustDescEnum.CHANGE_LEADER.getDesc());
        teamMember.set("ischarge", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projTeamObj});
        DynamicObject nowTeamObj = BusinessDataServiceHelper.newDynamicObject((String)"pmas_nowteam");
        nowTeamObj.set("project", (Object)projectObj);
        nowTeamObj.set("seqno", (Object)-1);
        nowTeamObj.set("member", (Object)nowLeaderObj);
        nowTeamObj.set("role", (Object)projLeaderRoleObj);
        nowTeamObj.set("telno", (Object)nowTelNo);
        nowTeamObj.set("description", (Object)TeamAdjustDescEnum.CHANGE_LEADER.getDesc());
        nowTeamObj.set("ischarge", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nowTeamObj});
    }

    private static Boolean exsitsProjectTeam(DynamicObject projectObj) {
        DynamicObject[] projectTeams = BusinessDataServiceHelper.load((String)"pmas_team", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", projectObj.getPkValue()).and(new QFilter("type", "=", (Object)BillTypeEnum.NEW))});
        return projectTeams != null && projectTeams.length > 0;
    }

    private static void delLeaderFromNowTeam(DynamicObject projectObj, DynamicObject projleaderObj, String telNo, TeamAdjustDescEnum descEnum) {
        if (projleaderObj == null || projectObj == null) {
            return;
        }
        DynamicObject nowTeamObj = ProjectApprovalHelper.getNowTeamObj((DynamicObject)projleaderObj, (DynamicObject)projectObj);
        if (nowTeamObj == null) {
            return;
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"pmas_nowteam", (DynamicObject[])new DynamicObject[]{nowTeamObj}, (OperateOption)OperateOption.create());
    }
}

