/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class ProjectPurchasePlanOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("purchasescale");
        e.getFieldKeys().add("projectbugamt");
        e.getFieldKeys().add("totalamount");
        e.getFieldKeys().add("billname");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                if ("submit".equalsIgnoreCase(key)) {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        BigDecimal purchaseAmount;
                        DynamicObject entity = dataEntity.getDataEntity();
                        BigDecimal purchaseScale = entity.getBigDecimal("purchasescale");
                        BigDecimal projectBugamt = entity.getBigDecimal("projectbugamt");
                        BigDecimal totalAmount = entity.getBigDecimal("totalamount");
                        if (totalAmount.compareTo(purchaseAmount = purchaseScale.divide(BigDecimal.valueOf(100L)).multiply(projectBugamt)) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684\u91c7\u8d2d\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e%2$s\uff08\u9879\u76ee\u7acb\u9879\u91d1\u989d*\u91c7\u8d2d\u8d39\u7528\u63a7\u5236\u6bd4\u4f8b\uff09\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ProjectPurchasePlanOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entity.getString("billname"), purchaseAmount));
                    }
                }
            }
        });
    }
}

