/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmbs.common.enums.AuditStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AddTmemberOp
extends AbstractOperationServicePlugIn {
    private static final String DIRECREJECT_OP = "direcreject";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("applicant");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("tmemberentry");
        e.getFieldKeys().add("auditstatus");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("role");
        e.getFieldKeys().add("member");
        e.getFieldKeys().add("telno");
        e.getFieldKeys().add("note");
        e.getFieldKeys().add("outtmemberentry");
        e.getFieldKeys().add("outmember");
        e.getFieldKeys().add("outrole");
        e.getFieldKeys().add("outtelno");
        e.getFieldKeys().add("outnote");
        e.getFieldKeys().add("outpartner");
        e.getFieldKeys().add("outroleobj");
        e.getFieldKeys().add("outbizparter");
        e.getFieldKeys().add("isapplybill");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        Object[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "unsubmit": {
                ArrayList<Object> updateList = new ArrayList<Object>();
                for (Object obj : dataEntities) {
                    obj.set("auditstatus", null);
                    updateList.add(obj);
                }
                if (updateList.size() <= 0) break;
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray(new DynamicObject[0]));
                break;
            }
            case "audit": {
                ArrayList<DynamicObject> insertNowTeams = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> insertOutNowTeams = new ArrayList<DynamicObject>();
                for (Object object : dataEntities) {
                    DynamicObject project = object.getDynamicObject("project");
                    DynamicObjectCollection entries = object.getDynamicObjectCollection("tmemberentry");
                    object.set("auditstatus", (Object)AuditStatusEnum.AUDITED.getValue());
                    for (DynamicObject entry : entries) {
                        DynamicObject nowMember = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"));
                        nowMember.set("project", project.getPkValue());
                        nowMember.set("member", entry.get("member"));
                        nowMember.set("role", entry.get("role"));
                        nowMember.set("telno", entry.get("telno"));
                        nowMember.set("ischarge", (Object)"0");
                        nowMember.set("description", entry.get("note"));
                        insertNowTeams.add(nowMember);
                    }
                    DynamicObjectCollection outEntries = object.getDynamicObjectCollection("outtmemberentry");
                    for (DynamicObject entry : outEntries) {
                        DynamicObject outNowMember = BusinessDataServiceHelper.newDynamicObject((String)"pmas_outnowteam");
                        outNowMember.set("project", project.getPkValue());
                        outNowMember.set("member", entry.get("outmember"));
                        outNowMember.set("role", entry.get("outrole"));
                        outNowMember.set("telno", entry.get("outtelno"));
                        outNowMember.set("description", entry.get("outnote"));
                        outNowMember.set("outpartner", entry.get("outpartner"));
                        outNowMember.set("roleobj", entry.get("outroleobj"));
                        outNowMember.set("outbizparter", entry.get("outbizparter"));
                        insertOutNowTeams.add(outNowMember);
                    }
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"), (Object[])insertNowTeams.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"), (Object[])insertOutNowTeams.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((IDataEntityType)dataEntities[0].getDataEntityType(), (Object[])dataEntities);
                break;
            }
            case "direcreject": {
                for (DynamicObject dynamicObject : dataEntities) {
                    dynamicObject.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                    dynamicObject.set("auditstatus", (Object)AuditStatusEnum.REJECTED.getValue());
                    dynamicObject.set("auditor", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("auditdate", (Object)new Date());
                }
                SaveServiceHelper.save((IDataEntityType)dataEntities[0].getDataEntityType(), (Object[])dataEntities);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
                for (DynamicObject obj : dataEntities) {
                    obj.set("auditstatus", (Object)AuditStatusEnum.AUDITING.getValue());
                    updateList.add(obj);
                }
                if (updateList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray(new DynamicObject[0]));
                }
                for (DynamicObject rowData : dataEntities) {
                    if (rowData.getBoolean("isapplybill")) continue;
                    LocaleString title = new LocaleString();
                    String billno = rowData.getString("billno");
                    title.setLocaleValue(String.format(ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u5f20\u201c\u56e2\u961f\u52a0\u5165\u7533\u8bf7\u5355\u201d\uff08\u7f16\u53f7\uff1a%s\uff09\u9700\u8981\u60a8\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"AddTmemberOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billno));
                    DynamicObject project = rowData.getDynamicObject("project");
                    LocaleString content = new LocaleString();
                    DynamicObject applicant = rowData.getDynamicObject("applicant");
                    content.setLocaleValue(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u53d1\u8d77\u52a0\u5165\u56e2\u961f\u7533\u8bf7\u5355\uff0c\u7533\u8bf7\u52a0\u5165\u9879\u76ee\u201c%2$s\u201d\u3002\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"AddTmemberOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), applicant.getLocaleString("name").getLocaleValue(), project.getLocaleString("name").getLocaleValue()));
                    LocaleString tag = new LocaleString();
                    tag.setLocaleValue(ResManager.loadKDString((String)"\u6210\u5458\u7533\u8bf7\u6279\u590d", (String)"AddTmemberOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    QFilter qFilter = new QFilter("project", "in", project.getPkValue());
                    qFilter.and("ischarge", "=", (Object)Boolean.TRUE);
                    DynamicObject[] proChargemans = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"project,member,role", (QFilter[])new QFilter[]{qFilter});
                    Set receiverSet = Arrays.stream(proChargemans).map(chargeman -> chargeman.getLong("member_id")).collect(Collectors.toSet());
                    ArrayList<Long> receivers = new ArrayList<Long>(10);
                    receivers.addAll(receiverSet);
                    String clientUrl = UrlService.getDomainContextUrl();
                    long pkValue = (Long)rowData.getPkValue();
                    String suffix = String.format("/index.html?formId=%s&pkId=%s&type=list&list_formId=bos_list", "pmas_addtmemberbatch", pkValue);
                    String url = clientUrl + suffix;
                    this.sendMessage("pmas_addtmemberbill", (ILocaleString)title, (ILocaleString)content, (ILocaleString)tag, "pmas_addtmemberbill_submit", url, "submit", pkValue, receivers);
                }
                break;
            }
            case "audit": {
                for (DynamicObject rowData : dataEntities) {
                    if (rowData.getBoolean("isapplybill")) continue;
                    LocaleString title = new LocaleString();
                    String billno = rowData.getString("billno");
                    title.setLocaleValue(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u201c\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u201d\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u5df2\u7531\u9879\u76ee\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AddTmemberOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billno));
                    LocaleString content = new LocaleString();
                    String userName = RequestContext.get().getUserName();
                    content.setLocaleValue(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7ba1\u7406\u5458\u201c%s\u201d\u5df2\u540c\u610f\u60a8\u7684\u7533\u8bf7\uff0c\u8bf7\u67e5\u770b\u5355\u636e\u8be6\u60c5\u3002", (String)"AddTmemberOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), userName));
                    LocaleString tag = new LocaleString();
                    tag.setLocaleValue(ResManager.loadKDString((String)"\u7533\u8bf7\u52a0\u5165\u56e2\u961f", (String)"AddTmemberOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    DynamicObject applicant = rowData.getDynamicObject("applicant");
                    ArrayList<Long> receivers = new ArrayList<Long>();
                    receivers.add((Long)applicant.getPkValue());
                    String clientUrl = UrlService.getDomainContextUrl();
                    long pkValue = (Long)rowData.getPkValue();
                    String suffix = String.format("/index.html?formId=%s&pkId=%s", "pmas_addtmemberbatch", pkValue);
                    String url = clientUrl + suffix;
                    this.sendMessage("pmas_addtmemberbatch", (ILocaleString)title, (ILocaleString)content, (ILocaleString)tag, "pmas_addtmemberbatch_audit", url, "audit", pkValue, receivers);
                }
                break;
            }
            case "direcreject": {
                for (DynamicObject rowData : dataEntities) {
                    LocaleString title = new LocaleString();
                    String billno = rowData.getString("billno");
                    title.setLocaleValue(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u201c\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u201d\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u5df2\u7531\u9879\u76ee\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AddTmemberOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billno));
                    LocaleString content = new LocaleString();
                    String userName = RequestContext.get().getUserName();
                    content.setLocaleValue(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7ba1\u7406\u5458%s\u5df2\u9a73\u56de\u60a8\u7684\u7533\u8bf7\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002\u5982\u9700\u52a0\u5165\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u6c9f\u901a\u540e\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"AddTmemberOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), userName));
                    LocaleString tag = new LocaleString();
                    tag.setLocaleValue(ResManager.loadKDString((String)"\u7533\u8bf7\u52a0\u5165\u56e2\u961f", (String)"AddTmemberOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    DynamicObject applicant = rowData.getDynamicObject("applicant");
                    ArrayList<Long> receivers = new ArrayList<Long>();
                    receivers.add((Long)applicant.getPkValue());
                    String clientUrl = UrlService.getDomainContextUrl();
                    long pkValue = (Long)rowData.getPkValue();
                    String suffix = String.format("/index.html?formId=%s&pkId=%s", "pmas_addtmemberbatch", pkValue);
                    String url = clientUrl + suffix;
                    this.sendMessage("pmas_addtmemberbatch", (ILocaleString)title, (ILocaleString)content, (ILocaleString)tag, "pmas_addtmemberbatch_direcreject", url, "audit", pkValue, receivers);
                }
                break;
            }
        }
    }

    private void sendMessage(String entityNumber, ILocaleString title, ILocaleString content, ILocaleString tag, String tplScene, String url, String operate, long pkValue, List<Long> receivers) {
        MessageInfo message = new MessageInfo();
        message.setMessageTitle(title);
        message.setMessageContent(content);
        message.setMessageTag(tag);
        message.setTplScene(tplScene);
        message.setEntityNumber(entityNumber);
        message.setBizDataId(Long.valueOf(pkValue));
        message.setOperation(operate);
        message.setUserIds(receivers);
        message.setType("message");
        StringBuilder notifyType = new StringBuilder();
        notifyType.append(MessageChannels.MC).append(",");
        notifyType.append(MessageChannels.SMS).append(",");
        notifyType.append(MessageChannels.EMAIL).append(",");
        notifyType.append(MessageChannels.YUNZHIJIA);
        message.setNotifyType(notifyType.toString());
        message.setContentUrl(url);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        this.submitValidate(dataEntity);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                        this.checkTeamMemberRepeat(dataEntity);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)AddTmemberOp.DIRECREJECT_OP, (CharSequence)key)) continue;
                    DynamicObject obj = dataEntity.getDataEntity();
                    String billStatus = obj.getString("billstatus");
                    if (!StatusEnum.CHECKED.getValue().equals(billStatus)) continue;
                    String billNo = obj.getString("billno");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u9a73\u56de\u3002", (String)"AddTmemberOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo));
                    break;
                }
            }

            protected boolean checkTeamMemberRepeat(ExtendedDataEntity dataEntity) {
                DynamicObject[] nowTeams;
                DynamicObject obj = dataEntity.getDataEntity();
                String billNo = obj.getString("billno");
                DynamicObject project = obj.getDynamicObject("project");
                Long projectId = project == null ? null : Long.valueOf(project.getPkValue().toString());
                HashMap<Object, ArrayList> projectMemberRoles = new HashMap<Object, ArrayList>();
                QFilter projectFiler = new QFilter("project", "in", (Object)projectId);
                for (DynamicObject nowTeam : nowTeams = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"project,member,role", (QFilter[])new QFilter[]{projectFiler})) {
                    project = nowTeam.getDynamicObject("project");
                    DynamicObject member = nowTeam.getDynamicObject("member");
                    DynamicObject role = nowTeam.getDynamicObject("role");
                    Object projectPk = project.getPkValue();
                    ArrayList memberRoleList = projectMemberRoles.computeIfAbsent(projectPk, k -> new ArrayList(10));
                    String memberRole = member == null ? null : member.getPkValue() + "," + (role == null ? null : role.getPkValue().toString());
                    memberRoleList.add(memberRole);
                }
                DynamicObjectCollection teamMemberEntry = obj.getDynamicObjectCollection("tmemberentry");
                for (DynamicObject entryObj : teamMemberEntry) {
                    DynamicObject member = entryObj.getDynamicObject("member");
                    DynamicObject role = entryObj.getDynamicObject("role");
                    String memberRole = member.getPkValue() + "," + (role == null ? null : role.getPkValue().toString());
                    ArrayList members = (ArrayList)projectMemberRoles.get(project.getPkValue());
                    if (members == null || !members.contains(memberRole)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u3002\u7533\u8bf7\u660e\u7ec6\uff08\u59d3\u540d\uff1a%2$s\uff0c\u89d2\u8272\uff1a%3$s\uff09\u5728\u9879\u76ee\u56e2\u961f\u4e2d\u5df2\u5b58\u5728\u3002\u8bf7\u79fb\u9664\u8be5\u7533\u8bf7\u660e\u7ec6\u3002", (String)"AddTmemberOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, member.getString("name"), role == null ? "" : role.getString("name")));
                    return true;
                }
                return false;
            }

            protected boolean submitValidate(ExtendedDataEntity dataEntity) {
                DynamicObject obj = dataEntity.getDataEntity();
                DynamicObjectCollection tMemberEntry = obj.getDynamicObjectCollection("tmemberentry");
                DynamicObjectCollection outTMemberEntry = obj.getDynamicObjectCollection("outtmemberentry");
                String billNo = obj.getString("billno");
                if (!(tMemberEntry != null && tMemberEntry.size() != 0 || outTMemberEntry != null && outTMemberEntry.size() != 0)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u7533\u8bf7\u660e\u7ec6\u3002", (String)"AddTmemberOp_9", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo));
                    return true;
                }
                DynamicObject project = obj.getDynamicObject("project");
                DynamicObject applicant = obj.getDynamicObject("applicant");
                Long billid = Long.valueOf(obj.getPkValue().toString());
                Long projectId = project == null ? null : Long.valueOf(project.getPkValue().toString());
                Long applicantId = applicant == null ? null : Long.valueOf(applicant.getPkValue().toString());
                boolean isApplyBill = obj.getBoolean("isapplybill");
                QFilter filter = new QFilter("project", "=", (Object)projectId);
                filter.and("applicant", "=", (Object)applicantId);
                filter.and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
                filter.and("id", "!=", (Object)billid);
                filter.and("isapplybill", "=", (Object)isApplyBill);
                DynamicObject[] addTeamMembers = BusinessDataServiceHelper.load((String)"pmas_addtmemberbill", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{filter});
                if (addTeamMembers.length > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b8c\u6210\u9879\u76ee\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u5355\uff0c\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"AddTmemberOp_10", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), applicant != null ? applicant.getString("name") : null, project != null ? project.getString("name") : null, obj.getDataEntityType().getDisplayName()));
                    return true;
                }
                boolean isRepeat = this.checkTeamMemberRepeat(dataEntity);
                if (isRepeat) {
                    return true;
                }
                this.checkOutTeamMemberRepeat(dataEntity, outTMemberEntry, billNo, project);
                return false;
            }

            protected void checkOutTeamMemberRepeat(ExtendedDataEntity dataEntity, DynamicObjectCollection outTMemberEntry, String billNo, DynamicObject project) {
                if (!CollectionUtils.isEmpty((Collection)outTMemberEntry)) {
                    int line = 1;
                    for (DynamicObject targetObj : outTMemberEntry) {
                        boolean exists;
                        DynamicObject targetMember = targetObj.getDynamicObject("outpartner");
                        DynamicObject targetRole = targetObj.getDynamicObject("outroleobj");
                        DynamicObject targetBizPartner = targetObj.getDynamicObject("outbizparter");
                        long count = outTMemberEntry.stream().filter(itemObj -> {
                            DynamicObject member = itemObj.getDynamicObject("outpartner");
                            DynamicObject role = itemObj.getDynamicObject("outroleobj");
                            DynamicObject bizPartner = itemObj.getDynamicObject("outbizparter");
                            return this.objEquals(targetMember, member) && this.objEquals(targetRole, role) && this.objEquals(targetBizPartner, bizPartner);
                        }).count();
                        if (count > 1L) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u7533\u8bf7\u660e\u7ec6-\u5916\u90e8\u4eba\u5458\uff08\u59d3\u540d\uff1a%2$s\uff1b\u89d2\u8272\uff1a%3$s\uff1b\u5546\u52a1\u4f19\u4f34\uff1a%4$s\uff09\uff0c\u5b58\u5728\u4e0e\u7b2c%5$s\u884c\u91cd\u590d\u7684\u8bb0\u5f55\u3002", (String)"AddTmemberOp_11", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, targetMember.getString("name"), targetRole.getString("name"), targetBizPartner.getString("name"), line));
                            break;
                        }
                        if (project != null && targetMember != null && targetRole != null && (exists = ProjectApprovalHelper.existsOutMember((DynamicObject)targetMember, (DynamicObject)targetRole, (DynamicObject)project))) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u7533\u8bf7\u660e\u7ec6-\u5916\u90e8\u4eba\u5458\uff08\u59d3\u540d\uff1a%2$s\uff1b\u89d2\u8272\uff1a%3$s\uff1b\u5546\u52a1\u4f19\u4f34\uff1a%4$s\uff09\u5728\u6700\u65b0\u5916\u90e8\u9879\u76ee\u56e2\u961f\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4ece\u7533\u8bf7\u660e\u7ec6\u4e2d\u79fb\u9664\u3002", (String)"AddTmemberOp_12", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, targetMember.getString("name"), targetRole.getString("name"), targetBizPartner.getString("name")));
                            break;
                        }
                        ++line;
                    }
                }
            }

            protected boolean objEquals(DynamicObject source, DynamicObject target) {
                return source != null && target != null && source.getPkValue().equals(target.getPkValue());
            }
        });
    }
}

