/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FundSourceOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("isvalid");
        e.getFieldKeys().add("year");
        e.getFieldKeys().add("fundentry");
        e.getFieldKeys().add("amount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> auditObjs = new ArrayList<DynamicObject>();
                for (DynamicObject obj : dataEntities) {
                    DynamicObject[] validObjs;
                    QFilter projFilter = new QFilter("project", "=", obj.getDynamicObject("project").getPkValue());
                    QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
                    Date yearDate = obj.getDate("year");
                    QFilter yearFilter = null;
                    if (yearDate != null) {
                        LocalDate yearLocalDate = yearDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        int year = yearLocalDate.getYear();
                        yearFilter = new QFilter("YEAR(year)", "=", (Object)year);
                    }
                    if ((validObjs = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id,billno,isvalid", (QFilter[])new QFilter[]{projFilter, isValidFilter, yearFilter})).length > 0) {
                        DynamicObject fund = validObjs[0];
                        fund.set("isvalid", (Object)"0");
                        updateObjs.add(fund);
                    }
                    obj.set("isvalid", (Object)"1");
                    auditObjs.add(obj);
                }
                if (updateObjs.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateObjs.get(0)).getDataEntityType(), (Object[])updateObjs.toArray(new DynamicObject[updateObjs.size()]));
                }
                if (auditObjs.size() <= 0) break;
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)auditObjs.get(0)).getDataEntityType(), (Object[])auditObjs.toArray(new DynamicObject[auditObjs.size()]));
                break;
            }
            case "unaudit": {
                ArrayList<DynamicObject> unauditObjs = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
                for (DynamicObject obj : dataEntities) {
                    BigDecimal version = obj.getBigDecimal("version");
                    QFilter projFilter = new QFilter("project", "=", obj.getDynamicObject("project").getPkValue());
                    QFilter versionFilter = new QFilter("version", "<", (Object)version);
                    DynamicObject[] validObjs = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id,billno,isvalid", (QFilter[])new QFilter[]{projFilter, versionFilter}, (String)"version desc");
                    if (validObjs.length > 0) {
                        DynamicObject fund = validObjs[0];
                        fund.set("isvalid", (Object)"1");
                        updateList.add(fund);
                    }
                    obj.set("isvalid", (Object)"0");
                    unauditObjs.add(obj);
                }
                if (updateList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray(new DynamicObject[updateList.size()]));
                }
                if (unauditObjs.size() <= 0) break;
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)unauditObjs.get(0)).getDataEntityType(), (Object[])unauditObjs.toArray(new DynamicObject[unauditObjs.size()]));
                break;
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        block3 : switch (operationKey) {
            case "unaudit": {
                for (DynamicObject obj : dataEntities) {
                    QFilter projFilter = new QFilter("project", "=", obj.getDynamicObject("project").getPkValue());
                    QFilter version = new QFilter("version", ">", obj.get("version"));
                    DynamicObjectCollection count = QueryServiceHelper.query((String)"pmas_projfundsource", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{projFilter, version});
                    if (count.size() <= 0) continue;
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u53cd\u5ba1\u6838\uff0c\u5b58\u5728\u6bd4\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u66f4\u9ad8\u7248\u672c\u7684\u8d44\u91d1\u6765\u6e90\u5355\u636e\u3002", (String)"FundSourceOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), obj.getString("billno")));
                    e.setCancel(true);
                    break block3;
                }
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if ("submit".equalsIgnoreCase(this.getOperateKey())) {
                    for (ExtendedDataEntity extDataEntity : this.dataEntities) {
                        DynamicObject dataEntity = extDataEntity.getDataEntity();
                        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("fundentry");
                        int index = 0;
                        for (DynamicObject entry : entryEntity) {
                            ++index;
                            if (entry.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) continue;
                            this.addErrorMessage(extDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"FundSourceOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), index));
                        }
                    }
                }
            }
        });
    }
}

