/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.business.helper.BudgetBillHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.OverallCtrlYearEnums;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.ProjectCtrlBudgetEnums;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SysCheckBudgetAmtParamEnums;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmbs.common.utils.TimeUtils;

public class OutBudgetSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("undertakeorg");
        fieldKeys.add("undertakeperiod");
        fieldKeys.add("entryproname");
        fieldKeys.add("currentratio");
        fieldKeys.add("currentamt");
        fieldKeys.add("ctrlbudgetitemname");
        fieldKeys.add("ctrlbudgetitem");
        fieldKeys.add("budgetcontrolmode");
        fieldKeys.add("controlinfoentry");
        fieldKeys.add("ctrlbudgetitem_id");
        fieldKeys.add("undertakeorg_id");
        fieldKeys.add("splittype");
        fieldKeys.add("project");
        fieldKeys.add("org");
        fieldKeys.add("type");
        fieldKeys.add("year");
        fieldKeys.add("projectcostcontrol");
        fieldKeys.add("totalamount");
        fieldKeys.add("prevamount");
        fieldKeys.add("presamount");
        fieldKeys.add("totalyearamt");
        fieldKeys.add("treeentryentity");
        fieldKeys.add("budgetamount");
        fieldKeys.add("projectbudgetitem");
        fieldKeys.add("budgetitemname");
        fieldKeys.add("currency");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OutBudgetSubmitValidator());
    }

    private static Map<String, Object> getBudgetOutRootByName(DynamicObjectCollection treeEntryEntitys) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (DynamicObject entry : treeEntryEntitys) {
            String parentId = entry.getString("pid");
            String budgetItemName = entry.getString("budgetitemname");
            DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)parentId) || budgetItemName == null || budgetItemName.trim().isEmpty() || budgetItem == null) continue;
            map.put(budgetItemName, budgetItem.getPkValue());
        }
        return map;
    }

    static class OutBudgetSubmitValidator
    extends AbstractValidator {
        OutBudgetSubmitValidator() {
        }

        public void validate() {
            block24: {
                ExtendedDataEntity[] dataEntities;
                String key;
                block23: {
                    ExtendedDataEntity[] dataEntities2;
                    key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.SUBMIT.getValue())) break block23;
                    for (ExtendedDataEntity dataEntity : dataEntities2 = this.getDataEntities()) {
                        DynamicObject bill = dataEntity.getDataEntity();
                        String billStatus = bill.getString("billstatus");
                        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) continue;
                        if (this.checkBudgetStageAmt(dataEntity)) {
                            return;
                        }
                        if (this.checkBudgetItem(dataEntity)) {
                            return;
                        }
                        DynamicObject outBudgetObj = dataEntity.getDataEntity();
                        DynamicObject project = outBudgetObj.getDynamicObject("project");
                        DynamicObject approval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
                        if (approval != null) {
                            this.checkBudgetAmt(dataEntity, "overallCtrlYear", approval.getString("overallctrlyear"));
                            this.checkBudgetAmt(dataEntity, "projectCtrlBudget", approval.getString("projectctrlbudget"));
                        }
                        String budgetControlMode = outBudgetObj.getString("budgetcontrolmode");
                        if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue(), (CharSequence)budgetControlMode)) {
                            return;
                        }
                        DynamicObjectCollection controlinfoentryCol = outBudgetObj.getDynamicObjectCollection("controlinfoentry");
                        String splitType = outBudgetObj.getString("splittype");
                        if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetControlMode)) {
                            for (DynamicObject entry : controlinfoentryCol) {
                                String entryProName = entry.getString("entryproname");
                                if (entryProName != null && !entryProName.isEmpty()) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u9879\u76ee\u540d\u79f0\u3002", (String)"OutBudgetSubmitOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                break;
                            }
                        }
                        HashMap<String, ArrayList<Integer>> dimensionsLineMap = new HashMap<String, ArrayList<Integer>>(16);
                        BigDecimal totalAmount = outBudgetObj.getBigDecimal("totalyearamt");
                        BigDecimal totalEntryCurrentAmt = BigDecimal.ZERO;
                        BigDecimal totalRatio = BigDecimal.ZERO;
                        HashMap<String, BigDecimal> budgetItemAmtMap = new HashMap<String, BigDecimal>(16);
                        HashMap<String, BigDecimal> budgetItemNameAmtMap = new HashMap<String, BigDecimal>(16);
                        for (int i = 0; i < controlinfoentryCol.size(); ++i) {
                            DynamicObject controlInfoEntry = (DynamicObject)controlinfoentryCol.get(i);
                            String ctrlBudgetItemId = controlInfoEntry.getString("ctrlbudgetitem_id");
                            String undertakeOrgId = controlInfoEntry.getString("undertakeorg_id");
                            Date undertakePeriodDate = controlInfoEntry.getDate("undertakeperiod");
                            String entryProName = controlInfoEntry.getString("entryproname");
                            BigDecimal currentRatio = controlInfoEntry.getBigDecimal("currentratio");
                            BigDecimal currentAmt = controlInfoEntry.getBigDecimal("currentamt");
                            StringBuilder dimensionsKey = new StringBuilder();
                            dimensionsKey.append(undertakeOrgId).append(undertakePeriodDate).append(entryProName).append(ctrlBudgetItemId);
                            ArrayList<Integer> lineList = (ArrayList<Integer>)dimensionsLineMap.get(dimensionsKey.toString());
                            if (lineList == null) {
                                lineList = new ArrayList<Integer>(10);
                            }
                            lineList.add(i + 1);
                            dimensionsLineMap.put(dimensionsKey.toString(), lineList);
                            totalRatio = totalRatio.add(currentRatio);
                            totalEntryCurrentAmt = totalEntryCurrentAmt.add(currentAmt);
                            BigDecimal ctrlBudgetAmt = (BigDecimal)budgetItemAmtMap.get(ctrlBudgetItemId);
                            if (ctrlBudgetAmt == null) {
                                budgetItemAmtMap.put(ctrlBudgetItemId, currentAmt);
                            } else {
                                budgetItemAmtMap.put(ctrlBudgetItemId, ctrlBudgetAmt.add(currentAmt));
                            }
                            String ctrlOutItemName = controlInfoEntry.getString("ctrlbudgetitemname");
                            BigDecimal ctrlOutItemAmt = (BigDecimal)budgetItemNameAmtMap.get(ctrlOutItemName);
                            if (ctrlOutItemAmt == null) {
                                budgetItemNameAmtMap.put(ctrlOutItemName, currentAmt);
                                continue;
                            }
                            budgetItemNameAmtMap.put(ctrlOutItemName, ctrlOutItemAmt.add(currentAmt));
                        }
                        Collection listCollection = dimensionsLineMap.values();
                        for (Object list : listCollection) {
                            if (list.size() <= 1 || StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) continue;
                            String tipStringBuilder = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9884\u7b97\u5206\u644a\u4fe1\u606f\u7684\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutBudgetSubmitOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), list.toString());
                            this.addErrorMessage(dataEntity, tipStringBuilder);
                        }
                        if (totalAmount.compareTo(totalEntryCurrentAmt) != 0 && !StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u91d1\u989d\u4e0e\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"OutBudgetSubmitOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (StringUtils.equals((CharSequence)SplitTypeEnum.SUMSPLIT.getValue(), (CharSequence)splitType) || StringUtils.equals((CharSequence)SplitTypeEnum.BUDGETAMTSPLIT.getValue(), (CharSequence)splitType)) {
                            Object budgetOut;
                            Object list;
                            DynamicObjectCollection budgetOutCol = outBudgetObj.getDynamicObjectCollection("treeentryentity");
                            list = budgetOutCol.iterator();
                            while (list.hasNext()) {
                                BigDecimal ctrlOutItemAmt;
                                String outItemName;
                                budgetOut = (DynamicObject)list.next();
                                long pid = budgetOut.getLong("pid");
                                if (pid != 0L || !StringUtils.isNotBlank((CharSequence)(outItemName = budgetOut.getString("budgetitemname"))) || (ctrlOutItemAmt = (BigDecimal)budgetItemNameAmtMap.get(outItemName)) != null) continue;
                                String tip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u5206\u5f55\u7684%s\u5c1a\u672a\u8fdb\u884c\u5206\u644a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutBudgetSubmitOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName);
                                this.addErrorMessage(dataEntity, tip);
                                return;
                            }
                            Map itemMap = OutBudgetSubmitOp.getBudgetOutRootByName(budgetOutCol);
                            for (DynamicObject entry : controlinfoentryCol) {
                                String ctrlBudgetItemName = entry.getString("ctrlbudgetitemname");
                                DynamicObject ctrlBudgetItem = entry.getDynamicObject("ctrlbudgetitem");
                                if (ctrlBudgetItem != null && itemMap.get(ctrlBudgetItemName) != null && itemMap.get(ctrlBudgetItemName).equals(ctrlBudgetItem.getPkValue())) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u660e\u7ec6\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u652f\u51fa\u9884\u7b97\u9879\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutBudgetSubmitOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrlBudgetItemName));
                            }
                            budgetOut = budgetOutCol.iterator();
                            while (budgetOut.hasNext()) {
                                BigDecimal ctrlOutItemAmt;
                                DynamicObject budgetOut2 = (DynamicObject)budgetOut.next();
                                long pid = budgetOut2.getLong("pid");
                                if (pid != 0L) continue;
                                String outItemName = budgetOut2.getString("budgetitemname");
                                BigDecimal outItemAmt = budgetOut2.getBigDecimal("budgetamount");
                                if (!StringUtils.isNotBlank((CharSequence)outItemName) || (ctrlOutItemAmt = (BigDecimal)budgetItemNameAmtMap.get(outItemName)) == null || outItemAmt.compareTo(ctrlOutItemAmt) <= 0) continue;
                                int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)((DynamicObject)dataEntity.getValue("currency")));
                                String tip = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u4e2d\uff0c\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\uff08%2$s\uff09\u5927\u4e8e\u9884\u7b97\u5206\u644a\u91d1\u989d\uff08%3$s\uff09\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"OutBudgetSubmitOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName, outItemAmt.setScale(amountAccuracy, RoundingMode.HALF_UP), ctrlOutItemAmt.setScale(amountAccuracy, RoundingMode.HALF_UP));
                                this.addErrorMessage(dataEntity, tip);
                                return;
                            }
                        }
                        if (!StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetControlMode)) continue;
                        for (DynamicObject entry : controlinfoentryCol) {
                            DynamicObject underTakeOrg = entry.getDynamicObject("undertakeorg");
                            if (underTakeOrg != null) continue;
                            return;
                        }
                        for (int i = 0; i < controlinfoentryCol.size() - 1; ++i) {
                            for (int j = i; j < controlinfoentryCol.size() - 1; ++j) {
                                String ctrloutitemname = ((DynamicObject)controlinfoentryCol.get(i)).getString("ctrlbudgetitemname");
                                DynamicObject ctrloutitem = ((DynamicObject)controlinfoentryCol.get(i)).getDynamicObject("ctrlbudgetitem");
                                DynamicObject org = ((DynamicObject)controlinfoentryCol.get(i)).getDynamicObject("undertakeorg");
                                Date period = ((DynamicObject)controlinfoentryCol.get(i)).getDate("undertakeperiod");
                                long proId = ((DynamicObject)controlinfoentryCol.get(i)).getLong("entryproid");
                                String proName = ((DynamicObject)controlinfoentryCol.get(i)).getString("entryproname");
                                String ctrloutitemnameNext = ((DynamicObject)controlinfoentryCol.get(j + 1)).getString("ctrlbudgetitemname");
                                DynamicObject ctrloutitemNext = ((DynamicObject)controlinfoentryCol.get(j + 1)).getDynamicObject("ctrlbudgetitem");
                                DynamicObject orgNext = ((DynamicObject)controlinfoentryCol.get(j + 1)).getDynamicObject("undertakeorg");
                                Date periodNext = ((DynamicObject)controlinfoentryCol.get(j + 1)).getDate("undertakeperiod");
                                long proIdNext = ((DynamicObject)controlinfoentryCol.get(j + 1)).getLong("entryproid");
                                if (SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(dataEntity.getValue("splittype")) && ctrloutitemname.equals(ctrloutitemnameNext) && org.getPkValue() == orgNext.getPkValue() && TimeUtils.isSameMonth((Date)period, (Date)periodNext) && proId == proIdNext) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"OutBudgetSubmitOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitemname, org.getString("name"), DateUtil.formatDate2((Date)period), proName));
                                }
                                if (!SplitTypeEnum.SUMSPLIT.getValue().equals(dataEntity.getValue("splittype")) || ctrloutitem.getPkValue() != ctrloutitemNext.getPkValue() || org.getPkValue() != orgNext.getPkValue() || !TimeUtils.isSameMonth((Date)period, (Date)periodNext) || proId != proIdNext) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"OutBudgetSubmitOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitem.getString("name"), org.getString("name"), DateUtil.formatDate2((Date)period), proName));
                            }
                        }
                    }
                    break block24;
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.AUDIT.getValue())) break block24;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkBudgetItem(dataEntity);
                }
            }
        }

        private void checkBudgetAmt(ExtendedDataEntity dataEntity, String paramsCtrl, String ctrlType) {
            DynamicObject outBudgetObj = dataEntity.getDataEntity();
            DynamicObject project = outBudgetObj.getDynamicObject("project");
            if (project != null) {
                BigDecimal compareAmt;
                BigDecimal newSumOutBudgetAmt = outBudgetObj.getBigDecimal("totalamount");
                BigDecimal budgetSumAmt = new BudgetBillHelper().getAllAssertBudgetSumAmt(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.OUT.getValue());
                if (budgetSumAmt.compareTo(BigDecimal.ZERO) != 0) {
                    String type = outBudgetObj.getString("type");
                    if ("NEW".equals(type)) {
                        BigDecimal presAmount = outBudgetObj.getBigDecimal("presamount");
                        newSumOutBudgetAmt = budgetSumAmt.subtract(presAmount).add(newSumOutBudgetAmt);
                    } else if ("ADJUST".equals(type)) {
                        newSumOutBudgetAmt = budgetSumAmt.subtract(outBudgetObj.getBigDecimal("prevamount")).add(newSumOutBudgetAmt);
                    }
                }
                DynamicObject approval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
                boolean isExist = new BudgetBillHelper().checkIsExistBudgetBill(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.TOTAL.getValue());
                if ("overallCtrlYear".equals(paramsCtrl) && approval != null && isExist && !StringUtils.equals((CharSequence)OverallCtrlYearEnums.UN_CTRL.getValue(), (CharSequence)approval.getString("overallctrlyear")) && newSumOutBudgetAmt.compareTo(compareAmt = new BudgetBillHelper().getAllAssertBudgetSumAmt(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.TOTAL.getValue())) > 0) {
                    if (OverallCtrlYearEnums.STRICT_CTRL.getValue().equals(ctrlType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u989d\u201d\u8d85\u8fc7\u201c\u9884\u7b97\u603b\u91d1\u989d\u201d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"OutBudgetSubmitOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    } else if (OverallCtrlYearEnums.REMIND_CTRL.getValue().equals(ctrlType)) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u989d\u8d85\u9884\u7b97\u603b\u91d1\u989d\u3002", (String)"OutBudgetSubmitOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                }
                if ("projectCtrlBudget".equals(paramsCtrl) && approval != null && !StringUtils.equals((CharSequence)ProjectCtrlBudgetEnums.UN_CTRL.getValue(), (CharSequence)approval.getString("projectctrlbudget"))) {
                    BigDecimal budgetTotalAmt = outBudgetObj.getBigDecimal("totalamount");
                    BigDecimal totalYearAmt = outBudgetObj.getBigDecimal("totalyearamt");
                    if (totalYearAmt.compareTo(BigDecimal.ZERO) > 0 && budgetTotalAmt.compareTo(totalYearAmt) > 0) {
                        if (ProjectCtrlBudgetEnums.STRICT_CTRL.getValue().equals(ctrlType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\uff0c\u5efa\u8bae\u901a\u8fc7\u201c\u7acb\u9879\u91d1\u989d\u53d8\u66f4\u5355\u201d\u53d8\u66f4\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u7684\u503c\u3002", (String)"OutBudgetSubmitOp_16", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        } else if (ProjectCtrlBudgetEnums.REMIND_CTRL.getValue().equals(ctrlType)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\uff0c\u5efa\u8bae\u901a\u8fc7\u201c\u7acb\u9879\u91d1\u989d\u53d8\u66f4\u5355\u201d\u53d8\u66f4\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u7684\u503c\u3002", (String)"OutBudgetSubmitOp_16", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (newSumOutBudgetAmt.compareTo(compareAmt = approval.getBigDecimal("projcetbugamt")) > 0) {
                        if (ProjectCtrlBudgetEnums.STRICT_CTRL.getValue().equals(ctrlType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\uff0c\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u989d\u8d85\u9879\u76ee\u7acb\u9879\u91d1\u989d\uff0c\u7cfb\u7edf\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"OutBudgetSubmitOp_11", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        } else if (ProjectCtrlBudgetEnums.REMIND_CTRL.getValue().equals(ctrlType)) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u603b\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\uff0c\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u989d\u8d85\u9879\u76ee\u7acb\u9879\u91d1\u989d\u3002", (String)"OutBudgetSubmitOp_12", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
        }

        private boolean checkBudgetStageAmt(ExtendedDataEntity dataEntity) {
            DynamicObject outBudgetObj = dataEntity.getDataEntity();
            DynamicObject project = outBudgetObj.getDynamicObject("project");
            if (project != null) {
                DynamicObject org = outBudgetObj.getDynamicObject("org");
                if (org == null) {
                    return false;
                }
                Object systemParameter = SystemParamHelper.getSystemParameter((String)"multicheckamttype", (String)"pmco", (Long)Long.parseLong(org.getPkValue().toString()));
                if (systemParameter == null) {
                    return false;
                }
                String paramValue = systemParameter.toString();
                if (StringUtils.equals((CharSequence)paramValue, (CharSequence)SysCheckBudgetAmtParamEnums.UNALLOW.getValue())) {
                    BigDecimal totalAmount = outBudgetObj.getBigDecimal("totalamount");
                    BigDecimal presAmount = outBudgetObj.getBigDecimal("presamount");
                    if (presAmount.compareTo(BigDecimal.ZERO) > 0 && totalAmount.compareTo(presAmount) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u9636\u6bb5\u201c\u9884\u7b97\u603b\u91d1\u989d\u201d\u8d85\u51fa\u4e0a\u9636\u6bb5\u201c\u9884\u7b97\u603b\u91d1\u989d\u201d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"OutBudgetSubmitOp_13", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean checkBudgetItem(ExtendedDataEntity dataEntity) {
            DynamicObjectCollection treeEntryEntity;
            String errorTip = "";
            DynamicObject outBudgetObj = dataEntity.getDataEntity();
            DynamicObject currency = outBudgetObj.getDynamicObject("currency");
            int precision = currency == null ? 4 : currency.getInt("amtprecision");
            DynamicObject project = outBudgetObj.getDynamicObject("project");
            if (project == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"OutBudgetSubmitOp_14", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                return true;
            }
            boolean exists = new BudgetBillHelper().checkIsExistBudgetBill(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.OUT.getValue());
            int curYear = outBudgetObj.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            boolean projectCostControl = outBudgetObj.getBoolean("projectcostcontrol");
            DynamicObject approval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
            if (projectCostControl && exists && approval != null && ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue().equals(approval.getString("probudgetctrl")) && (treeEntryEntity = outBudgetObj.getDynamicObjectCollection("treeentryentity")) != null && treeEntryEntity.size() > 0) {
                for (DynamicObject entity : treeEntryEntity) {
                    BigDecimal occupyAmt;
                    Optional<DynamicObject> firstObject;
                    DynamicObjectCollection yearBudgetRecords;
                    BigDecimal budgetAmount = entity.getBigDecimal("budgetamount");
                    DynamicObject budgetItem = entity.getDynamicObject("projectbudgetitem");
                    if (budgetItem == null) continue;
                    budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(budgetItem.getPkValue().toString()), (String)"pmas_projectbudgetperform");
                    BigDecimal budgetAmt = budgetItem.getBigDecimal("budgetamount");
                    String type = outBudgetObj.getString("type");
                    if ("NEW".equals(type)) {
                        budgetAmount = budgetAmount.add(budgetAmt);
                    } else if ("ADJUST".equals(type) && (yearBudgetRecords = budgetItem.getDynamicObjectCollection("yearbudgetrecord")).size() > 0 && (firstObject = yearBudgetRecords.stream().filter(o -> o.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear() == curYear).findFirst()).isPresent()) {
                        DynamicObject record = firstObject.get();
                        BigDecimal curYearAmt = record.getBigDecimal("curyearamt");
                        budgetAmount = budgetAmt.subtract(curYearAmt).add(budgetAmount);
                    }
                    if (budgetAmount.compareTo(occupyAmt = budgetItem.getBigDecimal("occupyamt")) >= 0) continue;
                    errorTip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u9884\u7b97\u7d2f\u8ba1\u503c\u201c%2$s\u201d\uff0c\u4e0d\u5f97\u5c0f\u4e8e\u5df2\u5360\u7528\u91d1\u989d\u201c%3$s\u201d\u3002", (String)"OutBudgetSubmitOp_15", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entity.getString("budgetitemname"), budgetAmount.setScale(precision, RoundingMode.HALF_UP), occupyAmt.setScale(precision, RoundingMode.HALF_UP));
                    this.addErrorMessage(dataEntity, errorTip);
                }
            }
            return StringUtils.isNotBlank((CharSequence)errorTip);
        }
    }
}

