/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.business.helper.ProjTeamOpHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ProjTeamOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("teamentry");
        e.getFieldKeys().add("member");
        e.getFieldKeys().add("role");
        e.getFieldKeys().add("telno");
        e.getFieldKeys().add("note");
        e.getFieldKeys().add("ischarge");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("chdteamentry");
        e.getFieldKeys().add("ischargechd");
        e.getFieldKeys().add("chteamouterentry");
        e.getFieldKeys().add("outchdteamentry");
        e.getFieldKeys().add("outerteamentry");
        e.getFieldKeys().add("outerteamuser");
        e.getFieldKeys().add("outteamrole");
        e.getFieldKeys().add("outerteamtelno");
        e.getFieldKeys().add("outerteamdescription");
        e.getFieldKeys().add("entryorg");
        e.getFieldKeys().add("entrycompany");
        e.getFieldKeys().add("outpartner");
        e.getFieldKeys().add("outroleobj");
        e.getFieldKeys().add("entryorg");
        e.getFieldKeys().add("entrycompany");
        e.getFieldKeys().add("outroleobj");
        e.getFieldKeys().add("outpartner");
        e.getFieldKeys().add("outchdpartner");
        e.getFieldKeys().add("outchdroleobj");
        e.getFieldKeys().add("chdorg");
        e.getFieldKeys().add("chdcompany");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                ProjTeamOpHelper.beforeDoSubmitOp((BeforeOperationArgs)e);
                break;
            }
            case "unaudit": {
                ProjTeamOpHelper.beforeDoUnaudit((BeforeOperationArgs)e);
                break;
            }
        }
    }

    private boolean checkBillMutex(DynamicObject obj) {
        if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
            DynamicObject[] exists;
            DynamicObject proj = obj.getDynamicObject("project");
            Object projPk = proj == null ? null : proj.getPkValue();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            QFilter billFilter = new QFilter("id", "!=", obj.getPkValue());
            qFilterList.add(billFilter);
            if (projPk != null) {
                qFilterList.add(new QFilter("project", "=", (Object)Long.valueOf(projPk.toString())));
            }
            return (exists = BusinessDataServiceHelper.load((String)"pmas_team", (String)"id,billname,billno,billstatus", (QFilter[])qFilterList.toArray(new QFilter[0]))).length > 0;
        }
        return false;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                ProjTeamOpHelper.doBeginAudit((DynamicObject[])dataEntities);
                break;
            }
            case "unaudit": {
                ProjTeamOpHelper.doBeginUnAudit((DynamicObject[])dataEntities);
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!StringUtils.equals((CharSequence)"save", (CharSequence)key) && !StringUtils.equals((CharSequence)"submit", (CharSequence)key)) continue;
            isAddValid = true;
            break;
        }
        if (isAddValid) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    String operateKey = this.getOperateKey();
                    block8: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObject obj = dataEntity.getDataEntity();
                        String billSign = obj.getDynamicObjectType().getName();
                        switch (operateKey) {
                            case "save": {
                                if (!ProjTeamOp.this.checkBillMutex(obj)) continue block8;
                                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\u3002\u5df2\u521b\u5efa\u56e2\u961f\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u3002", (String)"ProjTeamOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), obj.getString("billno"), obj.getString("project.name")));
                                continue block8;
                            }
                            case "submit": {
                                DynamicObjectCollection chdEntries;
                                Object outChdTeamEntrys;
                                if (StringUtils.equals((CharSequence)"pmas_teamadjust", (CharSequence)billSign)) {
                                    DynamicObjectCollection chTeamEntrys = obj.getDynamicObjectCollection("chteamentry");
                                    DynamicObjectCollection outChTeamEntrys = obj.getDynamicObjectCollection("chteamouterentry");
                                    if (CollectionUtils.isEmpty((Collection)chTeamEntrys) && CollectionUtils.isEmpty((Collection)outChTeamEntrys)) {
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6(\u5185\u90e8\u4eba\u5458\u6216\u8005\u5916\u90e8)\u9700\u81f3\u5c11\u6709\u4e00\u884c\u8c03\u6574\u8bb0\u5f55\u3002", (String)"ProjTeamOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                    }
                                    if (!CollectionUtils.isEmpty((Collection)(outChdTeamEntrys = obj.getDynamicObjectCollection("outchdteamentry")))) {
                                        int line = 1;
                                        Iterator iterator = outChdTeamEntrys.iterator();
                                        while (iterator.hasNext()) {
                                            DynamicObject targetObj = (DynamicObject)iterator.next();
                                            String targetMember = "";
                                            DynamicObject outchdpartner = targetObj.getDynamicObject("outchdpartner");
                                            if (outchdpartner != null) {
                                                targetMember = outchdpartner.getString("name");
                                            }
                                            DynamicObject targetRole = targetObj.getDynamicObject("outchdroleobj");
                                            String finalTargetMember = targetMember;
                                            long count = outChdTeamEntrys.stream().filter(itemObj -> {
                                                DynamicObject role;
                                                String member = "";
                                                DynamicObject memberDyn = itemObj.getDynamicObject("outchdpartner");
                                                if (memberDyn != null) {
                                                    member = memberDyn.getString("name");
                                                }
                                                boolean isCompare = (role = itemObj.getDynamicObject("outchdroleobj")) == null && targetRole == null ? true : role != null && targetRole != null && role.getPkValue().equals(targetRole.getPkValue());
                                                return StringUtils.equals((CharSequence)finalTargetMember, (CharSequence)member) && isCompare;
                                            }).count();
                                            if (count > 1L) {
                                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u8c03\u6574\u540e\uff0c\u201c\u5916\u90e8\u4eba\u5458\u201d\u5df2\u5b58\u5728\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\u7684\u8bb0\u5f55\uff08\u59d3\u540d\uff1a%2$s\uff0c\u89d2\u8272\uff1a%3$s\uff09\u3002", (String)"ProjTeamOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), line, targetMember, targetRole != null ? targetRole.getString("name") : null));
                                                break;
                                            }
                                            ++line;
                                        }
                                    }
                                }
                                if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
                                    DynamicObjectCollection entries = obj.getDynamicObjectCollection("teamentry");
                                    if (!entries.isEmpty()) {
                                        DynamicObject teamObj;
                                        boolean isExistCharge = false;
                                        outChdTeamEntrys = entries.iterator();
                                        while (outChdTeamEntrys.hasNext() && !(isExistCharge = (teamObj = (DynamicObject)outChdTeamEntrys.next()).getBoolean("ischarge"))) {
                                        }
                                        if (!isExistCharge) {
                                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u9879\u76ee\u7ba1\u7406\u5458\u3002", (String)"ProjTeamOp_9", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                        }
                                    }
                                    if (!ProjTeamOp.this.checkBillMutex(obj)) continue block8;
                                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u9879\u76ee\uff1a%2$s\u3002\u5df2\u521b\u5efa\u56e2\u961f\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u3002", (String)"ProjTeamOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), obj.getString("billno"), obj.getString("project.name")));
                                    continue block8;
                                }
                                if (!BillTypeEnum.ADJUST.getValue().equals(obj.getString("type"))) continue block8;
                                boolean fromDatabase = obj.getDataEntityState().getFromDatabase();
                                if (fromDatabase && (Long)obj.getPkValue() != 0L) {
                                    obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pmas_teamadjust");
                                }
                                if ((chdEntries = obj.getDynamicObjectCollection("chdteamentry")).isEmpty()) continue block8;
                                boolean isExistCharge = false;
                                for (DynamicObject entry : chdEntries) {
                                    Boolean ischarge = (Boolean)entry.get("ischargechd");
                                    if (!ischarge.booleanValue()) continue;
                                    isExistCharge = true;
                                    break;
                                }
                                if (isExistCharge) continue block8;
                                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u9879\u76ee\u7ba1\u7406\u5458", (String)"ProjTeamOp_10", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                continue block8;
                            }
                        }
                    }
                }
            });
        }
    }
}

