/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.form.i18n.MMPMsgUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.pmgt.pmas.business.helper.ApproveContext;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.DocuimentTypeEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.IndexWarnLightEnum;
import kd.pmgt.pmbs.common.enums.InvestBudgetEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.common.thread.PmgtThreadPools;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.TimeUtils;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ProjectApproveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ProjectApproveOp.class);
    private static final String PROSTATUS_FORM_KEY = "bd_projectstatus";
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PROJECT_COST_CONTROL = "projectcostcontrol";
    public static final String ISREPORT = "isreport";
    public static final String REALBUDGETENTRY = "realbudgetentry";
    private static final String OPERATION_APPROVAL_SUBMIT = "approvalsubmit";
    private static final String OPERATION_REPORT_SUBMIT = "reportsubmit";
    private static final String OPERATION_APPROVAL_CONFIRM = "approvalconfirm";
    private static final String OPERATION_APPROVAL_REFUSE = "approvalrefuse";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("pro");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("parentpro");
        e.getFieldKeys().add("budgetctrl");
        e.getFieldKeys().add(BUDGET_CONTROL_MODE);
        e.getFieldKeys().add(PROJECT_COST_CONTROL);
        e.getFieldKeys().add("budgetpro");
        e.getFieldKeys().add("budgetpronumber");
        e.getFieldKeys().add("budgetproname");
        e.getFieldKeys().add("budgetperiod");
        e.getFieldKeys().add("proleader");
        e.getFieldKeys().add("syscreateorg");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("outamount");
        e.getFieldKeys().add("currencyfield");
        e.getFieldKeys().add("prostatus");
        e.getFieldKeys().add("planbegindate");
        e.getFieldKeys().add("planenddate");
        e.getFieldKeys().add("leaderconttype");
        e.getFieldKeys().add("budgetout");
        e.getFieldKeys().add("budgetout");
        e.getFieldKeys().add("budgetout.pid");
        e.getFieldKeys().add("outitem");
        e.getFieldKeys().add("bdoutamount");
        e.getFieldKeys().add("outbudsumamount");
        e.getFieldKeys().add("promanager");
        e.getFieldKeys().add("kind");
        e.getFieldKeys().add("fundsourceentry");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("sumamount");
        e.getFieldKeys().add("ischarge");
        e.getFieldKeys().add("teamrole");
        e.getFieldKeys().add("teamuser");
        e.getFieldKeys().add("teamtelno");
        e.getFieldKeys().add("teamdescription");
        e.getFieldKeys().add(ISREPORT);
        e.getFieldKeys().add("reportorg");
        e.getFieldKeys().add("repaudstatus");
        e.getFieldKeys().add("splittype");
        e.getFieldKeys().add("projectapplydate");
        e.getFieldKeys().add("upfile");
        e.getFieldKeys().add("teamouterstaffentity");
        e.getFieldKeys().add("outerteamuser");
        e.getFieldKeys().add("outteamrole");
        e.getFieldKeys().add("outerteamtelno");
        e.getFieldKeys().add("outteampartner");
        e.getFieldKeys().add("outroleobj");
        e.getFieldKeys().add("outbizpartner");
        e.getFieldKeys().add("outerteamdescription");
        e.getFieldKeys().add("proappteamentity");
        e.getFieldKeys().add("projectapplydate");
        e.getFieldKeys().add("outamount");
        e.getFieldKeys().add("budgetstage");
        e.getFieldKeys().add(REALBUDGETENTRY);
        e.getFieldKeys().add("realbudgetentry.seq");
        e.getFieldKeys().add("realbudgetentry.realprobudgetname");
        e.getFieldKeys().add("realbudgetentry.realbudgetitem");
        e.getFieldKeys().add("realbudgetentry.realundertakeorg");
        e.getFieldKeys().add("realbudgetentry.realundertakeperiod");
        e.getFieldKeys().add("realbudgetentry.realproname");
        e.getFieldKeys().add("realbudgetentry.realpronumber");
        e.getFieldKeys().add("realbudgetentry.realproid");
        e.getFieldKeys().add("realbudgetentry.realundertakeamt");
        e.getFieldKeys().add("controlinfoentry");
        e.getFieldKeys().add("controlinfoentry.seq");
        e.getFieldKeys().add("controlinfoentry.ctrloutitem");
        e.getFieldKeys().add("controlinfoentry.ctrloutitemname");
        e.getFieldKeys().add("controlinfoentry.undertakeorg");
        e.getFieldKeys().add("controlinfoentry.undertakeperiod");
        e.getFieldKeys().add("controlinfoentry.entryproname");
        e.getFieldKeys().add("controlinfoentry.entrypronumber");
        e.getFieldKeys().add("controlinfoentry.entryproid");
        e.getFieldKeys().add("controlinfoentry.undertakeamt");
        e.getFieldKeys().add("budgetout.seq");
        e.getFieldKeys().add("workentity");
        e.getFieldKeys().add("projectstage");
        e.getFieldKeys().add("workitem");
        e.getFieldKeys().add("keyitem");
        e.getFieldKeys().add("sysbill");
        e.getFieldKeys().add("keypropconfig");
        e.getFieldKeys().add("keypropertyid");
        e.getFieldKeys().add("estimateendtime");
        e.getFieldKeys().add("supervisionid");
        e.getFieldKeys().add("hiddendata");
        e.getFieldKeys().add("pmbs_prokindctrlsetting");
        e.getFieldKeys().add("declarevalue");
        e.getFieldKeys().add("standardindex");
        e.getFieldKeys().add("indexwarnlight");
        e.getFieldKeys().add("approvalstatus");
        e.getFieldKeys().add("needapproval");
        e.getFieldKeys().add("proyearbudgetamt");
        e.getFieldKeys().add("sourceamount");
        e.getFieldKeys().add("sourcesumamount");
        e.getFieldKeys().add("projcetbugamt");
        e.getFieldKeys().add("probudgetctrl");
        e.getFieldKeys().add("proaddress");
        e.getFieldKeys().add("department");
        e.getFieldKeys().add("approvalapply");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("isupdateflow");
        e.getFieldKeys().add("purchaseplanentry");
        e.getFieldKeys().add("purchaseprice");
        e.getFieldKeys().add("purchaseamount");
        e.getFieldKeys().add("purchasebaseunit");
        e.getFieldKeys().add("purchasegroup");
        e.getFieldKeys().add("purchaseqty");
        e.getFieldKeys().add("purchasematerial");
        e.getFieldKeys().add("purchasedescription");
        e.getFieldKeys().add("purchasescale");
        e.getFieldKeys().add("isneedpurchaseplan");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        block12: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "submit": {
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (needApproval) {
                        return;
                    }
                    this.saveBudgetRecord(dataEntity);
                    continue block12;
                }
                case "approvalsubmit": {
                    this.saveBudgetRecord(dataEntity);
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (!needApproval) {
                        return;
                    }
                    dataEntity.set("approvalstatus", (Object)ApprovalStatusEnum.ONGOING.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                    continue block12;
                }
                case "reportsubmit": {
                    this.saveBudgetRecord(dataEntity);
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (!needApproval) {
                        return;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                    continue block12;
                }
                case "unaudit": {
                    this.afterUnAudit(dataEntity);
                    if (dataEntity.getBoolean(ISREPORT)) continue block12;
                    this.returnOccupyAmtAndClearRecord(dataEntity, "unaudit", "unauditoccupy");
                    this.updateBudgetRecordField(null, dataEntity, "unaudit");
                    continue block12;
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        block23: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            switch (operationKey) {
                case "save": {
                    this.saveOperation(e, dataEntity);
                    continue block23;
                }
                case "submit": {
                    this.reverseWritingToApprovalApply(dataEntity, "submit");
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (needApproval) {
                        return;
                    }
                    this.afterSubmit(dataEntity);
                    continue block23;
                }
                case "approvalsubmit": 
                case "reportsubmit": {
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (!needApproval) {
                        return;
                    }
                    this.afterSubmit(dataEntity);
                    continue block23;
                }
                case "unsubmit": {
                    this.reverseWritingToApprovalApply(dataEntity, "unsubmit");
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (needApproval) {
                        return;
                    }
                    this.returnOccupyAmtAndClearRecord(dataEntity, "unsubmit", "unsubmitoccupy");
                    this.afterUnSubmit(dataEntity);
                    continue block23;
                }
                case "auditrefuse": {
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    if (needApproval) {
                        return;
                    }
                    this.returnOccupyAmtAndClearRecord(dataEntity, "auditrefuse", "auditrefuseoccupy");
                    this.afterAuditRefuse(dataEntity);
                    this.updateBudgetRecordField(null, dataEntity, "auditrefuse");
                    continue block23;
                }
                case "audit": {
                    boolean isAsyncAudit = ProjectPermFilterHelper.getProApprovalAsyncAuditSysParam();
                    if (isAsyncAudit) {
                        dataEntity.set("isupdateflow", (Object)true);
                        boolean isReport = dataEntity.getBoolean(ISREPORT);
                        boolean needApprovalF = dataEntity.getBoolean("needapproval");
                        if (!isReport && !needApprovalF) {
                            DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)PROSTATUS_FORM_KEY);
                            dataEntity.set("prostatus", (Object)proStatus);
                        }
                        CompletableFuture.runAsync(() -> {
                            dataEntity.set("isupdateflow", (Object)true);
                            Object pro = dataEntity.get("pro");
                            ProjectApprovalHelper.setProStatus((DynamicObject)dataEntity);
                            boolean isReport2 = dataEntity.getBoolean(ISREPORT);
                            boolean needApprovalF2 = dataEntity.getBoolean("needapproval");
                            if (!isReport2 && !needApprovalF2) {
                                DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)PROSTATUS_FORM_KEY);
                                dataEntity.set("prostatus", (Object)proStatus);
                            }
                            ApproveContext context = this.buildApprovalContext(dataEntity);
                            ProjectApprovalHelper.saveSysProAuto((DynamicObject)dataEntity, (ApproveContext)context);
                            ProjectApprovalHelper.setProStatus((DynamicObject)dataEntity);
                            if (isReport) {
                                return;
                            }
                            if (needApprovalF) {
                                return;
                            }
                            this.afterAudit(dataEntity);
                            dataEntity.set("isupdateflow", (Object)false);
                        }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_AUDIT_BOTPPRO_POOL).execute(arg_0)).exceptionally(exception -> {
                            logger.error("UpdateFlowException\uff1a" + exception.getMessage());
                            dataEntity.set("isupdateflow", (Object)false);
                            throw new KDBizException(exception.getMessage());
                        });
                        continue block23;
                    }
                    dataEntity.set("isupdateflow", (Object)false);
                    Object pro = dataEntity.get("pro");
                    ProjectApprovalHelper.setProStatus((DynamicObject)dataEntity);
                    boolean isReport2 = dataEntity.getBoolean(ISREPORT);
                    boolean needApprovalF2 = dataEntity.getBoolean("needapproval");
                    if (!isReport2 && !needApprovalF2) {
                        DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)PROSTATUS_FORM_KEY);
                        dataEntity.set("prostatus", (Object)proStatus);
                    }
                    ApproveContext context = this.buildApprovalContext(dataEntity);
                    ProjectApprovalHelper.saveSysProAuto((DynamicObject)dataEntity, (ApproveContext)context);
                    ProjectApprovalHelper.setProStatus((DynamicObject)dataEntity);
                    if (isReport2) {
                        return;
                    }
                    if (needApprovalF2) {
                        return;
                    }
                    this.afterAudit(dataEntity);
                    dataEntity.set("isupdateflow", (Object)false);
                    continue block23;
                }
                case "approvalconfirm": {
                    dataEntity.set("approvalstatus", (Object)ApprovalStatusEnum.PASS.getValue());
                    DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)PROSTATUS_FORM_KEY);
                    dataEntity.set("prostatus", (Object)proStatus);
                    boolean needApproval = dataEntity.getBoolean("needapproval");
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                    if (!needApproval) continue block23;
                    this.returnOccupyAmtAndClearRecord(dataEntity, OPERATION_APPROVAL_CONFIRM, "unsubmitoccupy");
                    ProjectApprovalHelper.synProjLeader((DynamicObject)dataEntity);
                    this.afterAudit(dataEntity);
                    continue block23;
                }
                case "unaudit": {
                    this.reverseWritingToApprovalApply(dataEntity, "unaudit");
                    boolean isReport = dataEntity.getBoolean(ISREPORT);
                    if (isReport) {
                        return;
                    }
                    this.clearIndexWarnLight(dataEntity);
                    this.deleteBudgetRecord(dataEntity, "delete");
                    continue block23;
                }
                case "approvalrefuse": {
                    this.returnOccupyAmtAndClearRecord(dataEntity, OPERATION_APPROVAL_REFUSE, "unsubmitoccupy");
                    this.updateBudgetRecordField(null, dataEntity, "unsubmit");
                    dataEntity.set("approvalstatus", (Object)ApprovalStatusEnum.FAIL.getValue());
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                    continue block23;
                }
            }
        }
    }

    private void reverseWritingToApprovalApply(DynamicObject dataEntity, String operation) {
        DynamicObject approvalApplyBaseData = dataEntity.getDynamicObject("approvalapply");
        if (approvalApplyBaseData != null) {
            dataEntity.getDataEntityType();
            DynamicObject approvalApplyBill = BusinessDataServiceHelper.loadSingle((Object)approvalApplyBaseData.getPkValue(), (String)"pmas_approval_apply", (String)"isapproval");
            if (StringUtils.equals((CharSequence)operation, (CharSequence)"submit")) {
                approvalApplyBill.set("isapproval", (Object)Boolean.TRUE);
            } else if (StringUtils.equals((CharSequence)operation, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operation, (CharSequence)"unaudit")) {
                approvalApplyBill.set("isapproval", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approvalApplyBill});
        }
    }

    private void clearIndexWarnLight(DynamicObject dataEntity) {
        DynamicObjectCollection indexEntry = dataEntity.getDynamicObjectCollection("indexentry");
        for (DynamicObject index : indexEntry) {
            index.set("indexwarnlight", null);
        }
    }

    protected void occupyAmount(DynamicObject obj, String operate) {
        ProjectApprovalHelper.occupyAmount((DynamicObject)obj, (String)operate);
    }

    protected void returnOccupyAmtAndClearRecord(DynamicObject obj, String curOperate, String registerOp) {
        ProjectApprovalHelper.returnOccupyAmtAndClearRecord((DynamicObject)obj, (String)curOperate, (String)registerOp);
    }

    protected void saveOperation(BeginOperationTransactionArgs e, DynamicObject dataEntity) {
        if (dataEntity.getString("billstatus") == null) {
            dataEntity.set("prostatus", null);
            if (e.isCancelOperation()) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey) || StringUtils.equals((CharSequence)OPERATION_APPROVAL_SUBMIT, (CharSequence)operateKey) || StringUtils.equals((CharSequence)OPERATION_REPORT_SUBMIT, (CharSequence)operateKey)) {
            for (DynamicObject obj : dataEntities) {
                boolean needApproval = obj.getBoolean("needapproval");
                if (needApproval && !StringUtils.equals((CharSequence)OPERATION_APPROVAL_SUBMIT, (CharSequence)operateKey)) {
                    return;
                }
                this.occupyAmount(obj, operateKey);
                if (!StringUtils.equals((CharSequence)OPERATION_APPROVAL_SUBMIT, (CharSequence)operateKey)) continue;
                ProjectApprovalHelper.proAppApprovalReport((DynamicObject)obj);
            }
        }
    }

    protected void afterUnAudit(DynamicObject dataEntity) {
        DynamicObject pro = dataEntity.getDynamicObject("pro");
        if (pro == null) {
            return;
        }
        pro = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"bd_project");
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmas_pro_approval");
        if (!dataEntity.getBoolean(ISREPORT)) {
            ProjectApprovalHelper.checkOccurUnSysBiz((DynamicObject)pro);
            String budgetControlMode = appPro.getString(BUDGET_CONTROL_MODE);
            if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                try {
                    BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)dataEntity, (BudgetCtrlEnum)BudgetCtrlEnum.UNAUDIT);
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        ProjectApprovalHelper.deleteRelateBiz((DynamicObject)appPro, (DynamicObject)pro);
    }

    protected void afterAudit(DynamicObject dataEntity) {
        try (TXHandle h = TX.requiresNew();){
            try {
                dataEntity.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
        ApproveContext context = this.buildApprovalContext(dataEntity);
        ProjectApprovalHelper.updateDownFlowBill((ApproveContext)context);
        DynamicObject approvePro = context.getApprovePro();
        approvePro.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        approvePro.set("isupdateflow", (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getApprovePro()});
    }

    @NotNull
    private ApproveContext buildApprovalContext(DynamicObject dataEntity) {
        ApproveContext context = new ApproveContext();
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmas_pro_approval");
        appPro.set("auditor", dataEntity.get("auditor"));
        appPro.set("auditdate", dataEntity.get("auditdate"));
        context.setApprovePro(appPro);
        DynamicObject project = appPro.getDynamicObject("pro");
        if (project != null) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            context.setSysPro(project);
            appPro.set("pro", (Object)project);
        } else {
            project = dataEntity.getDynamicObject("pro");
            if (project != null) {
                project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                context.setSysPro(project);
                appPro.set("pro", (Object)project);
            }
        }
        ProjectApprovalHelper.synProjLeader((DynamicObject)appPro);
        return context;
    }

    protected void updateBudgetRecordField(ApproveContext context, DynamicObject dataEntity, String operate) {
        ProjectApprovalHelper.updateBudgetRecordField((ApproveContext)context, (DynamicObject)dataEntity, (String)operate);
    }

    protected DynamicObject[] getProjectMainDataCtrlView() {
        QFilter qFilter = new QFilter("basedata", "=", (Object)"bd_project");
        DynamicObject[] bdBasedataviews = BusinessDataServiceHelper.load((String)"bd_basedataview", (String)"id,basedata,ctrlview", (QFilter[])new QFilter[]{qFilter});
        if (bdBasedataviews.length == 0) {
            QFilter qFilter1 = new QFilter("basedataid", "=", (Object)"bd_project");
            bdBasedataviews = BusinessDataServiceHelper.load((String)"bd_bddefctrlstrtgy", (String)"id,basedataid,ctrlview", (QFilter[])new QFilter[]{qFilter1});
        }
        return bdBasedataviews;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            List<String> operationArrays = Arrays.asList("submit", "unaudit", "audit", "save", OPERATION_APPROVAL_SUBMIT, OPERATION_REPORT_SUBMIT);
            if (!operationArrays.contains(key)) continue;
            isAddValid = true;
            break;
        }
        if (isAddValid) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    String operateKey = this.getOperateKey();
                    ExtendedDataEntity[] dataEntities = this.getDataEntities();
                    HashSet<Object> isApprovalApplyIds = new HashSet<Object>(16);
                    block14: for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject projectApproval = dataEntity.getDataEntity();
                        switch (operateKey) {
                            case "reportsubmit": {
                                this.validateEntryAmt(dataEntity);
                                continue block14;
                            }
                            case "approvalsubmit": {
                                this.validateSubmit(dataEntity);
                                this.validateBeforeSubmit(dataEntity, false);
                                this.validateEntryAmt(dataEntity);
                                this.checkProjectAttachment(dataEntity);
                                this.checkBudgetControlMode(dataEntity);
                                this.checkBudgetCtrlMode(dataEntity);
                                continue block14;
                            }
                            case "submit": {
                                this.validateSubmit(dataEntity);
                                this.validateBeforeSubmit(dataEntity, false);
                                this.validateEntryAmt(dataEntity);
                                boolean needApproval = dataEntity.getDataEntity().getBoolean("needapproval");
                                if (!needApproval) {
                                    this.checkProjectAttachment(dataEntity);
                                }
                                this.checkBudgetControlMode(dataEntity);
                                this.checkBudgetCtrlMode(dataEntity);
                                this.checkApplyIsApproval(dataEntity, isApprovalApplyIds);
                                this.checkPurchasePlanAmount(dataEntity);
                                continue block14;
                            }
                            case "unaudit": {
                                this.validateUnaudit(dataEntity);
                                continue block14;
                            }
                            case "save": {
                                if (!Arrays.asList(StatusEnum.CHECKED.getValue(), StatusEnum.UNCHECKED.getValue()).contains(projectApproval.getString("billstatus"))) continue block14;
                                boolean isInProcess = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)projectApproval.getPkValue().toString()));
                                boolean isApprovalStatus = projectApproval.getBoolean("isapprovalstatus");
                                boolean validateBillNoAndParent = !isApprovalStatus && !isInProcess;
                                this.validateBeforeSubmit(dataEntity, validateBillNoAndParent);
                                continue block14;
                            }
                        }
                    }
                }

                private void checkApplyIsApproval(ExtendedDataEntity dataEntity, Set<Object> isApprovalApplyIds) {
                    DynamicObject approvalApply = dataEntity.getDataEntity().getDynamicObject("approvalapply");
                    if (approvalApply != null) {
                        if (approvalApply.getBoolean("isapproval") || isApprovalApplyIds.contains(approvalApply.getPkValue())) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u201c\u7acb\u9879\u7533\u8bf7\u5355\u201d\u7684\u5bf9\u5e94\u9879\u76ee\u5df2\u6709\u5ba1\u6279\u4e2d\u7684\u201c\u9879\u76ee\u7acb\u9879\u5355\u201d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7\u7acb\u9879\u3002", (String)"ProjectApproveOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        } else {
                            isApprovalApplyIds.add(approvalApply.getPkValue());
                        }
                    }
                }

                @Deprecated
                protected void hasApprovalSubmitWorkFlow(ExtendedDataEntity dataEntity) {
                }

                private void validateUnaudit(ExtendedDataEntity dataEntity) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    String billStatus = obj.getString("billstatus");
                    if (billStatus.equals(StatusEnum.CHECKED.getValue())) {
                        String repaudstatus = obj.getString("repaudstatus");
                        if (repaudstatus != null && !repaudstatus.isEmpty()) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0a\u62a5\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjectApproveOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        DynamicObject project = obj.getDynamicObject("pro");
                        QFilter qFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.DECLARE.getValue());
                        if (project != null) {
                            qFilter.and("inventry.projectno", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                        }
                        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)"", (QFilter[])new QFilter[]{qFilter});
                        String refFormId = "";
                        if (plans.length > 0) {
                            refFormId = "pmim_aunualinvestplan";
                        }
                        if (StringUtils.isEmpty((CharSequence)refFormId)) {
                            qFilter = new QFilter("docuimenttype", "=", (Object)DocuimentTypeEnum.SPEDECLARE.getValue());
                            if (project != null) {
                                qFilter.and("inventry.projectno", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                            }
                            if ((plans = BusinessDataServiceHelper.load((String)"pmim_specialdeclarainvest", (String)"", (QFilter[])new QFilter[]{qFilter})).length > 0) {
                                refFormId = "pmim_specialdeclarainvest";
                            }
                        }
                        if (StringUtils.isNotEmpty((CharSequence)refFormId) && project != null) {
                            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
                            String billName = refMainType.getDisplayName().toString();
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u5173\u8054\u4e1a\u52a1\u5355\u636e\u201c%2$s\u201d\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002\u8bf7\u5148\u5220\u9664\u5173\u8054\u4e1a\u52a1\u5355\u636e\u3002", (String)"ProjectApproveOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), project.getString("name"), billName));
                        }
                    }
                }

                private void validateEntryAmt(ExtendedDataEntity dataEntity) {
                    DynamicObjectCollection outBudgets;
                    DynamicObject obj = dataEntity.getDataEntity();
                    StringBuilder msgTip = new StringBuilder();
                    DynamicObjectCollection sourceEntry = obj.getDynamicObjectCollection("fundsourceentry");
                    if (sourceEntry.size() > 0) {
                        for (int i = 0; i < sourceEntry.size(); ++i) {
                            DynamicObject source = (DynamicObject)sourceEntry.get(i);
                            BigDecimal amount = source.getBigDecimal("amount");
                            BigDecimal sumAmount = source.getBigDecimal("sumamount");
                            if (amount.compareTo(BigDecimal.ZERO) <= 0 || sumAmount.compareTo(BigDecimal.ZERO) <= 0 || sumAmount.compareTo(amount) >= 0) continue;
                            if (StringUtils.isNotBlank((CharSequence)msgTip.toString())) {
                                msgTip.append("\n");
                            }
                            msgTip.append(String.format(ResManager.loadKDString((String)"\u201c\u8d44\u91d1\u6765\u6e90\u201d\u7b2c%1$s\u884c\uff1a\u5e74\u5ea6\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u603b\u91d1\u989d\u3002", (String)"ProjectApproveOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), i + 1));
                        }
                    }
                    if ((outBudgets = obj.getDynamicObjectCollection("budgetout")).size() > 0) {
                        for (int i = 0; i < outBudgets.size(); ++i) {
                            DynamicObject outBudget = (DynamicObject)outBudgets.get(i);
                            BigDecimal outAmount = outBudget.getBigDecimal("bdoutamount");
                            BigDecimal outBudSumAmt = outBudget.getBigDecimal("outbudsumamount");
                            if (outAmount.compareTo(BigDecimal.ZERO) <= 0 || outBudSumAmt.compareTo(BigDecimal.ZERO) <= 0 || outBudSumAmt.compareTo(outAmount) >= 0) continue;
                            if (StringUtils.isNotBlank((CharSequence)msgTip.toString())) {
                                msgTip.append("\n");
                            }
                            msgTip.append(String.format(ResManager.loadKDString((String)"\u201c\u652f\u51fa\u9884\u7b97\u201d\u7b2c%1$s\u884c\uff1a\u5e74\u5ea6\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u603b\u91d1\u989d\u3002", (String)"ProjectApproveOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), i + 1));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)msgTip.toString())) {
                        this.addErrorMessage(dataEntity, msgTip.toString());
                    }
                }

                private void validateSubmit(ExtendedDataEntity dataEntity) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    Date begin = obj.getDate("planbegindate");
                    Date end = obj.getDate("planenddate");
                    if (begin != null && end != null && begin.getTime() > end.getTime()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u3002", (String)"ProjectApproveOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (obj.getDynamicObject("reportorg") == null && (obj.getBoolean(ProjectApproveOp.ISREPORT) || obj.getBoolean("needapproval"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4e0a\u62a5\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u201c\u9879\u76ee\u4e91>\u57fa\u7840\u8d44\u6599>\u4e0a\u62a5\u7ec4\u7ec7\u5c42\u7ea7\u8bbe\u7f6e\u201d\u4e2d\u7ef4\u62a4\u4e0a\u62a5\u7ec4\u7ec7\u3002", (String)"ProjectApproveOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection entryEntity = (DynamicObjectCollection)dataEntity.getValue("proappteamentity");
                    if (entryEntity.isEmpty()) {
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u4eba\u5458", (String)"ProjectApproveOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    } else {
                        DynamicObject teamObj;
                        boolean isExistCharge = false;
                        Iterator iterator = entryEntity.iterator();
                        while (iterator.hasNext() && !(isExistCharge = (teamObj = (DynamicObject)iterator.next()).getBoolean("ischarge"))) {
                        }
                        if (!isExistCharge) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u9879\u76ee\u7ba1\u7406\u5458\u3002", (String)"ProjectApproveOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        Map<String, List<DynamicObject>> collect = entryEntity.stream().filter(d -> d.get("teamuser") != null && d.get("teamrole") != null).collect(Collectors.groupingBy(d1 -> d1.getDynamicObject("teamuser").getPkValue() + "#" + d1.getDynamicObject("teamrole").getPkValue()));
                        collect.values().stream().filter(d -> d.size() > 1).findFirst().ifPresent(t -> this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272\u3002", (String)"ProjectApproveOp_9", (String)"pmgt-pmas-opplugin", (Object[])new Object[0])));
                    }
                }

                private void checkBudgetControlMode(ExtendedDataEntity dataEntity) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    if (BudgetCtlModeEnum.CONTROLANDADJUST.getValue().equals(dataEntity.getValue(ProjectApproveOp.BUDGET_CONTROL_MODE))) {
                        DynamicObjectCollection controlEntrys = (DynamicObjectCollection)dataEntity.getValue("controlinfoentry");
                        BigDecimal undertakeTotalAmount = BigDecimal.ZERO;
                        for (DynamicObject entry : controlEntrys) {
                            undertakeTotalAmount = undertakeTotalAmount.add((BigDecimal)entry.get("undertakeamt"));
                        }
                        if (undertakeTotalAmount.compareTo((BigDecimal)dataEntity.getValue("proyearbudgetamt")) != 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u91d1\u989d\u4e0e\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ProjectApproveOp_10", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        if (SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(dataEntity.getValue("splittype")) || SplitTypeEnum.SUMSPLIT.getValue().equals(dataEntity.getValue("splittype"))) {
                            DynamicObjectCollection budgetOutEntrys = obj.getDynamicObjectCollection("budgetout");
                            Map budgetOutMap = ProjectApprovalHelper.getBudgetOutRoot((DynamicObjectCollection)budgetOutEntrys);
                            Map controlMap = ProjectApprovalHelper.getControlinfoEntryByName((DynamicObjectCollection)controlEntrys);
                            Map itemMap = ProjectApprovalHelper.getBudgetOutRootByName((DynamicObjectCollection)budgetOutEntrys);
                            for (Map.Entry entry : itemMap.entrySet()) {
                                String outItemName = (String)entry.getKey();
                                if (controlMap.containsKey(outItemName)) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u5206\u5f55\u7684%s\u5c1a\u672a\u8fdb\u884c\u5206\u644a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveOp_11", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName));
                                return;
                            }
                            for (DynamicObject dynamicObject : controlEntrys) {
                                String ctrlOutItemName = dynamicObject.getString("ctrloutitemname");
                                DynamicObject ctrlOutItem = dynamicObject.getDynamicObject("ctrloutitem");
                                if (ctrlOutItem != null && itemMap.get(ctrlOutItemName) != null && itemMap.get(ctrlOutItemName).equals(ctrlOutItem.getPkValue())) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u548c\u9884\u7b97\u5206\u644a\u660e\u7ec6\u4e2d\uff0c\u9884\u7b97\u9879\u201c%s\u201d\u5bf9\u5e94\u7684\u6807\u51c6\u9884\u7b97\u9879\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u9884\u7b97\u5206\u644a\u660e\u7ec6\u4e2d\u7684\u9884\u7b97\u9879\u540d\u79f0\u3002", (String)"ProjectApproveOp_12", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrlOutItemName));
                                return;
                            }
                            for (Map.Entry entry : controlMap.entrySet()) {
                                if (budgetOutMap.containsKey(entry.getKey()) && ((BigDecimal)entry.getValue()).compareTo((BigDecimal)budgetOutMap.get(entry.getKey())) >= 0) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u4e2d\uff0c\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\uff08%2$s\uff09\u5927\u4e8e\u9884\u7b97\u5206\u644a\u91d1\u989d\uff08%3$s\uff09\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ProjectApproveOp_13", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entry.getKey(), budgetOutMap.get(entry.getKey()), entry.getValue()));
                                return;
                            }
                        }
                        for (DynamicObject entry : controlEntrys) {
                            DynamicObject underTakeOrg = entry.getDynamicObject("undertakeorg");
                            if (underTakeOrg != null) continue;
                            return;
                        }
                        for (int i = 0; i < controlEntrys.size() - 1; ++i) {
                            for (int j = i; j < controlEntrys.size() - 1; ++j) {
                                String ctrloutitemname = ((DynamicObject)controlEntrys.get(i)).getString("ctrloutitemname");
                                DynamicObject ctrloutitem = ((DynamicObject)controlEntrys.get(i)).getDynamicObject("ctrloutitem");
                                DynamicObject org = ((DynamicObject)controlEntrys.get(i)).getDynamicObject("undertakeorg");
                                Date date = ((DynamicObject)controlEntrys.get(i)).getDate("undertakeperiod");
                                long proId = ((DynamicObject)controlEntrys.get(i)).getLong("entryproid");
                                String proName = ((DynamicObject)controlEntrys.get(i)).getString("entryproname");
                                String ctrloutitemnameNext = ((DynamicObject)controlEntrys.get(j + 1)).getString("ctrloutitemname");
                                DynamicObject ctrloutitemNext = ((DynamicObject)controlEntrys.get(j + 1)).getDynamicObject("ctrloutitem");
                                DynamicObject orgNext = ((DynamicObject)controlEntrys.get(j + 1)).getDynamicObject("undertakeorg");
                                Date periodNext = ((DynamicObject)controlEntrys.get(j + 1)).getDate("undertakeperiod");
                                long proIdNext = ((DynamicObject)controlEntrys.get(j + 1)).getLong("entryproid");
                                if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(dataEntity.getValue("splittype")) && org.getPkValue() == orgNext.getPkValue() && ctrloutitem.equals(ctrloutitemNext) && TimeUtils.isSameYear((Date)date, (Date)periodNext) && proId == proIdNext) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ProjectApproveOp_14", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitem.getString("name"), org.getString("name"), DateUtil.formatDateYear((Date)date), proName));
                                }
                                if (SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(dataEntity.getValue("splittype")) && ctrloutitemname.equals(ctrloutitemnameNext) && org.getPkValue() == orgNext.getPkValue() && TimeUtils.isSameMonth((Date)date, (Date)periodNext) && proId == proIdNext) {
                                    String msg = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ProjectApproveOp_14", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitemname, org.getString("name"), DateUtil.formatDate2((Date)date), proName);
                                    String messageInfo = MMPMsgUtils.getMessageInfo((String)msg, (String)"PMAS-P-173751");
                                    this.addErrorMessage(dataEntity, messageInfo);
                                }
                                if (!SplitTypeEnum.SUMSPLIT.getValue().equals(dataEntity.getValue("splittype")) || ctrloutitem.getPkValue() != ctrloutitemNext.getPkValue() || org.getPkValue() != orgNext.getPkValue() || !TimeUtils.isSameMonth((Date)date, (Date)periodNext) || proId != proIdNext) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\u9884\u7b97\u9879\uff0c%2$s\u7ec4\u7ec7\uff0c%3$s\u671f\u95f4\uff0c%4$s\u9879\u76ee\u3002", (String)"ProjectApproveOp_14", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctrloutitem.getString("name"), org.getString("name"), DateUtil.formatDate2((Date)date), proName));
                            }
                        }
                    }
                }

                private void checkProjectAttachment(ExtendedDataEntity dataEntity) {
                    QFilter enableFilter;
                    QFilter projectKindFilter;
                    DynamicObject proKindCtrl;
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject kind = obj.getDynamicObject("kind");
                    if (kind != null && (proKindCtrl = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"attachtypeentry,attachtypeentry.attachtype,attachtypeentry.necessary", (QFilter[])new QFilter[]{projectKindFilter = new QFilter("projectkind", "=", kind.getPkValue()), enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue())})) != null) {
                        DynamicObjectCollection fileCtrls = proKindCtrl.getDynamicObjectCollection("attachtypeentry");
                        DynamicObjectCollection proFileEntrys = obj.getDynamicObjectCollection("attachtypeentry");
                        for (DynamicObject proFileEntry : proFileEntrys) {
                            DynamicObject proType = proFileEntry.getDynamicObject("attachtype");
                            DynamicObjectCollection files = proFileEntry.getDynamicObjectCollection("upfile");
                            for (DynamicObject fileCtrl : fileCtrls) {
                                DynamicObject ctrlType = fileCtrl.getDynamicObject("attachtype");
                                boolean isMustPut = fileCtrl.getBoolean("necessary");
                                if (proType == null || ctrlType == null || !proType.getPkValue().equals(ctrlType.getPkValue()) || !isMustPut || !files.isEmpty()) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u201c\u9879\u76ee\u5206\u7c7b\u7ba1\u63a7\u201d\u7684\u8bbe\u7f6e\u6761\u4ef6\u4e0a\u4f20\u76f8\u5173\u7acb\u9879\u7533\u62a5\u6750\u6599\u3002", (String)"ProjectApproveOp_15", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                }

                private void validateBeforeSubmit(ExtendedDataEntity exDateEntity, boolean validateBillNoAndParent) {
                    DynamicObject[] numApprove;
                    DynamicObject dataEntity = exDateEntity.getDataEntity();
                    DynamicObject project = dataEntity.getDynamicObject("pro");
                    if (validateBillNoAndParent && (numApprove = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dataEntity.getString("billno")), new QFilter("parentpro", "=", dataEntity.getDynamicObject("parentpro") != null ? dataEntity.getDynamicObject("parentpro").getPkValue() : Long.valueOf(0L))})) != null && numApprove.length > 0) {
                        this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u201c\u7acb\u9879\u7f16\u53f7\u201d\u3001\u201c\u4e0a\u7ea7\u9879\u76ee\u201d\u5747\u5df2\u5b58\u5728\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"ProjectApproveOp_16", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                    if (project != null) {
                        DynamicObject[] projectApprove = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                        if (projectApprove.length > 1 || projectApprove.length > 0 && !dataEntity.getPkValue().toString().equals(projectApprove[0].getPkValue().toString())) {
                            this.addErrorMessage(exDateEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u5b58\u5728\u7acb\u9879\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u9879\u76ee\u7acb\u9879\u8bb0\u5f55\u3002", (String)"ProjectApproveOp_17", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), project.get("name"), projectApprove[0].getString("billno")));
                        }
                    } else if (ProjectApproveOp.this.getProjectMainDataCtrlView().length <= 0) {
                        this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ba1\u63a7\u7b56\u7565>\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u914d\u7f6e\u4e3b\u6570\u636e\u201c\u9879\u76ee\u201d\u7684\u201c\u63a7\u5236\u89c6\u56fe\u201d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_18", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    } else {
                        DynamicObject sysOrg = dataEntity.getDynamicObject("syscreateorg");
                        DynamicObject org = dataEntity.getDynamicObject("org");
                        if (sysOrg == null) {
                            this.addErrorMessage(exDateEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u7cfb\u7edf\u4e91>\u57fa\u7840\u8d44\u6599>\u4e3b\u6570\u636e\u201d\u4e0b\u9879\u76ee\u4e3b\u6570\u636e\u63a7\u5236\u89c6\u56fe\u4e2d\u662f\u5426\u5305\u542b\u7ec4\u7ec7\u201c%s\u201d\u3002", (String)"ProjectApproveOp_19", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), org.getString("name")));
                        }
                    }
                    DynamicObjectCollection outUsers = dataEntity.getDynamicObjectCollection("teamouterstaffentity");
                    if (!CollectionUtils.isEmpty((Collection)outUsers)) {
                        int line = 1;
                        for (DynamicObject targetObj : outUsers) {
                            boolean exists;
                            DynamicObject targetMember = targetObj.getDynamicObject("outteampartner");
                            DynamicObject targetRole = targetObj.getDynamicObject("outroleobj");
                            DynamicObject targetBizPartner = targetObj.getDynamicObject("outbizpartner");
                            long count = outUsers.stream().filter(itemObj -> {
                                DynamicObject member = itemObj.getDynamicObject("outteampartner");
                                DynamicObject role = itemObj.getDynamicObject("outroleobj");
                                DynamicObject bizPartner = itemObj.getDynamicObject("outbizpartner");
                                return this.objEquals(targetMember, member) && this.objEquals(targetRole, role) && this.objEquals(targetBizPartner, bizPartner);
                            }).count();
                            if (count > 1L) {
                                this.addErrorMessage(exDateEntity, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6-\u5916\u90e8\u4eba\u5458\u5b58\u5728\u4e0e\u7b2c%4$s\u884c\u91cd\u590d\u7684\u8bb0\u5f55\uff08\u59d3\u540d\uff1a%1$s\uff1b\u89d2\u8272\uff1a%2$s\uff1b\u5546\u52a1\u4f19\u4f34\uff1a%4$s\uff09\u3002", (String)"ProjectApproveOp_20", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), targetMember.getString("name"), targetRole.getString("name"), targetBizPartner.getString("name"), line));
                            }
                            if (project != null && targetMember != null && targetRole != null && (exists = ProjectApprovalHelper.existsOutMember((DynamicObject)targetMember, (DynamicObject)targetRole, (DynamicObject)project))) {
                                this.addErrorMessage(exDateEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f-\u5916\u90e8\u4eba\u5458\u5df2\u5b58\u5728\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\u7684\u8bb0\u5f55\u3002\uff08\u59d3\u540d\uff1a%2$s\uff0c\u89d2\u8272\uff1a%3$s\uff0c\u5546\u52a1\u4f19\u4f34\uff1a%4$s\uff09\u3002", (String)"ProjectApproveOp_21", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), line, targetMember.getString("name"), targetRole.getString("name"), targetBizPartner.getString("name")));
                            }
                            ++line;
                        }
                    }
                    DynamicObject approvalApply = dataEntity.getDynamicObject("approvalapply");
                    DynamicObject kind = dataEntity.getDynamicObject("kind");
                    if (approvalApply != null && kind != null) {
                        BigDecimal projectBudgetAmt = dataEntity.getBigDecimal("projcetbugamt");
                        BigDecimal proYearBudgetAmt = dataEntity.getBigDecimal("proyearbudgetamt");
                        BigDecimal applyBudgetAmt = approvalApply.getBigDecimal("totalamount");
                        BigDecimal applyYearBudgetAmt = approvalApply.getBigDecimal("annualamount");
                        QFilter projectKindFilter = new QFilter("projectkind", "=", kind.getPkValue());
                        DynamicObject projectKindControlSetting = QueryServiceHelper.queryOne((String)"pmbs_prokindctrlsetting", (String)"applyctrlapprovalamt", (QFilter[])projectKindFilter.toArray());
                        String applyCtrlApprovalAmt = projectKindControlSetting.getString("applyctrlapprovalamt");
                        if (projectBudgetAmt.compareTo(applyBudgetAmt) > 0 || proYearBudgetAmt.compareTo(applyYearBudgetAmt) > 0) {
                            if (StringUtils.equals((CharSequence)InvestBudgetEnum.REMINDER_CONTROL.getValue(), (CharSequence)applyCtrlApprovalAmt)) {
                                this.addWarningMessage(exDateEntity, ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u91d1\u989d\u8d85\u8fc7\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\uff0c\u6216\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u8d85\u8fc7\u7acb\u9879\u7533\u8bf7\u5e74\u5ea6\u91d1\u989d\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectApproveOp_22", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            } else if (StringUtils.equals((CharSequence)InvestBudgetEnum.STRICT_CONTROL.getValue(), (CharSequence)applyCtrlApprovalAmt)) {
                                this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u91d1\u989d\u8d85\u8fc7\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\uff0c\u6216\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u8d85\u8fc7\u7acb\u9879\u7533\u8bf7\u5e74\u5ea6\u91d1\u989d\u3002\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_23", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                }

                protected boolean objEquals(DynamicObject source, DynamicObject target) {
                    return source != null && target != null && source.getPkValue().equals(target.getPkValue());
                }

                private void checkBudgetCtrlMode(ExtendedDataEntity exDateEntity) {
                    BigDecimal outBudgetAmount;
                    DynamicObject dataEntity = exDateEntity.getDataEntity();
                    String budgetControlMode = dataEntity.getString(ProjectApproveOp.BUDGET_CONTROL_MODE);
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                        DynamicObjectCollection budgetoutEntries;
                        String splitType = dataEntity.getString("splittype");
                        DynamicObjectCollection controlinfoentryCol = dataEntity.getDynamicObjectCollection("controlinfoentry");
                        for (DynamicObject entry : controlinfoentryCol) {
                            String entryProName = entry.getString("entryproname");
                            if (entryProName != null && !entryProName.isEmpty()) continue;
                            this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u9879\u76ee\u540d\u79f0\u3002", (String)"ProjectApproveOp_24", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        BigDecimal outBudgetAmount2 = dataEntity.getBigDecimal("proyearbudgetamt");
                        if (outBudgetAmount2.compareTo(BigDecimal.ZERO) > 0) {
                            budgetoutEntries = dataEntity.getDynamicObjectCollection("budgetout");
                            if (budgetoutEntries.getRowCount() <= 0 && !StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                                this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u8c03\u5242\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_25", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            }
                            try {
                                BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)dataEntity, (BudgetCtrlEnum)BudgetCtrlEnum.SUBMIT);
                            }
                            catch (Exception e) {
                                this.addErrorMessage(exDateEntity, e.getMessage());
                            }
                        } else if (outBudgetAmount2.compareTo(BigDecimal.ZERO) == 0 && (budgetoutEntries = dataEntity.getDynamicObjectCollection("budgetout")).getRowCount() <= 0 && !StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                            this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u8c03\u5242\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_25", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) && ((outBudgetAmount = dataEntity.getBigDecimal("proyearbudgetamt")).compareTo(BigDecimal.ZERO) > 0 || outBudgetAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        String splitType = dataEntity.getString("splittype");
                        DynamicObjectCollection realBudgetEntry = dataEntity.getDynamicObjectCollection(ProjectApproveOp.REALBUDGETENTRY);
                        if (realBudgetEntry.getRowCount() <= 0 && !StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                            this.addErrorMessage(exDateEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u5360\u7528\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_26", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                    }
                }

                private void checkPurchasePlanAmount(ExtendedDataEntity dataEntity) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    boolean isNeedPurchase = entity.getBoolean("isneedpurchaseplan");
                    if (isNeedPurchase) {
                        DynamicObjectCollection entries = entity.getDynamicObjectCollection("purchaseplanentry");
                        if (entries.size() == 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u91c7\u8d2d\u8ba1\u5212\u5206\u5f55\u3002", (String)"ProjectApproveOp_29", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entity.getString("billname")));
                            return;
                        }
                        BigDecimal purchaseScale = entity.getBigDecimal("purchasescale");
                        BigDecimal projectBugamt = entity.getBigDecimal("projcetbugamt");
                        BigDecimal purchaseAmount = purchaseScale.divide(BigDecimal.valueOf(100L)).multiply(projectBugamt);
                        BigDecimal totalAmount = entries.stream().map(obj -> obj.getBigDecimal("purchaseamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        if (totalAmount.compareTo(purchaseScale.divide(BigDecimal.valueOf(100L)).multiply(projectBugamt)) > 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\u7684\u91c7\u8d2d\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e%2$s\uff08\u9879\u76ee\u7acb\u9879\u91d1\u989d*\u91c7\u8d2d\u8d39\u7528\u63a7\u5236\u6bd4\u4f8b\uff09\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ProjectApproveOp_30", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entity.getString("billname"), purchaseAmount));
                        }
                    }
                }
            });
        }
    }

    protected void afterSubmit(DynamicObject obj) {
        this.updateSupervision(obj);
        this.setIndexWarnLight(obj);
    }

    private void setIndexWarnLight(DynamicObject obj) {
        DynamicObjectCollection indexEntry = obj.getDynamicObjectCollection("indexentry");
        for (DynamicObject index : indexEntry) {
            BigDecimal declareValue = index.getBigDecimal("declarevalue");
            BigDecimal standardIndex = index.getBigDecimal("standardindex");
            if (declareValue.compareTo(BigDecimal.ZERO) == 0 || standardIndex.compareTo(BigDecimal.ZERO) == 0) {
                index.set("indexwarnlight", null);
                continue;
            }
            if (declareValue.compareTo(standardIndex) >= 0) {
                index.set("indexwarnlight", (Object)IndexWarnLightEnum.PASS.getValue());
                continue;
            }
            index.set("indexwarnlight", (Object)IndexWarnLightEnum.NO_PASS.getValue());
        }
    }

    private void updateSupervision(DynamicObject obj) {
        DynamicObjectCollection workEntry = obj.getDynamicObjectCollection("workentity");
        if (workEntry != null && !workEntry.isEmpty()) {
            MainEntityType DT = EntityMetadataCache.getDataEntityType((String)"pmbs_workexecution");
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds((IDataEntityType)DT, workEntry.size());
            int i = 0;
            for (DynamicObject work : workEntry) {
                work.set("supervisionid", (Object)ids[i]);
                ++i;
            }
        }
    }

    protected void saveBudgetRecord(DynamicObject dataEntity) {
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        String billNo = dataEntity.getString("billno");
        Long pk = (Long)dataEntity.getPkValue();
        QFilter qFilter = pk == 0L ? new QFilter("billno", "=", (Object)billNo) : new QFilter("relatebillid", "=", (Object)pk.toString());
        DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, relatebillid, billsource, budgetstage, totalamount, group, currency, projectapplydate, budgetcontrolmode, projectcostcontrol, isvalid, description,yearrealbudgetentry.id, realbudgetentry.seq, realbudgetentry.realprobudgetname, realbudgetentry.realbudgetitem, realbudgetentry.realundertakeorg, realbudgetentry.realundertakeperiod, realbudgetentry.realproname, realbudgetentry.realpronumber, realbudgetentry.realproid, realbudgetentry.realundertakeamt", (QFilter[])new QFilter[]{qFilter});
        if (budgetRecord != null) {
            String billSource = budgetRecord.getString("billsource");
            if (StringUtils.equals((CharSequence)"pmas_pro_approval", (CharSequence)billSource)) {
                this.setBudgetRecordFieldValue(dataEntity, budgetRecord, true);
            } else {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
                budgetRecord = new DynamicObject((DynamicObjectType)dt);
                budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
                this.setBudgetRecordFieldValue(dataEntity, budgetRecord, false);
            }
        } else {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
            budgetRecord = new DynamicObject((DynamicObjectType)dt);
            budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
            this.setBudgetRecordFieldValue(dataEntity, budgetRecord, false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetRecord});
    }

    protected void setBudgetRecordFieldValue(DynamicObject dataEntity, DynamicObject budgetRecord, boolean isExistRecord) {
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        budgetRecord.set("billno", dataEntity.get("billno"));
        budgetRecord.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
        budgetRecord.set("org", dataEntity.get("org"));
        budgetRecord.set("billsource", (Object)"pmas_pro_approval");
        Long pk = (Long)dataEntity.getPkValue();
        if (pk != 0L) {
            budgetRecord.set("relatebillid", (Object)pk.toString());
        }
        budgetRecord.set("budgetstage", dataEntity.get("budgetstage"));
        budgetRecord.set("totalamount", dataEntity.get("outamount"));
        budgetRecord.set("group", dataEntity.get("kind"));
        budgetRecord.set("currency", dataEntity.get("currencyfield"));
        budgetRecord.set("projectapplydate", dataEntity.get("projectapplydate"));
        budgetRecord.set(BUDGET_CONTROL_MODE, dataEntity.get(BUDGET_CONTROL_MODE));
        budgetRecord.set(PROJECT_COST_CONTROL, dataEntity.get(PROJECT_COST_CONTROL));
        if (!isExistRecord) {
            budgetRecord.set("createtime", (Object)new Date());
        }
        budgetRecord.set("modifytime", (Object)new Date());
        DynamicObjectCollection realBudgetEntryCol = dataEntity.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectCollection outBudgetControlInfoEntry = budgetRecord.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectType type = outBudgetControlInfoEntry.getDynamicObjectType();
        outBudgetControlInfoEntry.clear();
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) || StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            for (DynamicObject realBudgetEntry : realBudgetEntryCol) {
                DynamicObject outBudgetControlInfo = new DynamicObject(type);
                outBudgetControlInfo.set("seq", realBudgetEntry.get("seq"));
                outBudgetControlInfo.set("realprobudgetname", realBudgetEntry.get("realprobudgetname"));
                outBudgetControlInfo.set("realbudgetitem", realBudgetEntry.get("realbudgetitem"));
                outBudgetControlInfo.set("realundertakeorg", realBudgetEntry.get("realundertakeorg"));
                outBudgetControlInfo.set("realundertakeperiod", realBudgetEntry.get("realundertakeperiod"));
                outBudgetControlInfo.set("realproname", realBudgetEntry.get("realproname"));
                outBudgetControlInfo.set("realpronumber", realBudgetEntry.get("realpronumber"));
                outBudgetControlInfo.set("realproid", realBudgetEntry.get("realproid"));
                outBudgetControlInfo.set("realundertakeamt", realBudgetEntry.get("realundertakeamt"));
                outBudgetControlInfoEntry.add((Object)outBudgetControlInfo);
            }
        }
    }

    protected void deleteBudgetRecord(DynamicObject dataEntity, String operate) {
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
        if (curBudgetRecord != null) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord"), (Object[])new Object[]{curBudgetRecord.getPkValue()});
        }
    }

    protected void afterUnSubmit(DynamicObject obj) {
        ProjectApprovalHelper.deleteProStatus((DynamicObject)obj);
        this.updateBudgetRecordField(null, obj, "unsubmit");
        this.clearIndexWarnLight(obj);
        this.deleteBudgetRecord(obj, "delete");
    }

    protected void afterAuditRefuse(DynamicObject obj) {
        DynamicObject pro = (DynamicObject)obj.get("pro");
        Object pkValue = obj.getPkValue();
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_pro_approval");
        DynamicObject[] proStatuses = BusinessDataServiceHelper.load((String)PROSTATUS_FORM_KEY, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ProjectStatusEnum.APPROVAL_FAIL.getValue())});
        DynamicObject appFailStatus = proStatuses[0];
        appPro.set("prostatus", (Object)appFailStatus);
        if (pro != null) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"bd_project");
            project.set("prostatus", (Object)appFailStatus);
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        appPro.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appPro});
    }
}

