/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;

public class ProjectApproveSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_APPROVAL_SUBMIT = "approvalsubmit";
    private static final String OPERATION_REPORT_SUBMIT = "reportsubmit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("undertakeorg");
        fieldKeys.add("undertakeperiod");
        fieldKeys.add("entryproname");
        fieldKeys.add("undertakeratio");
        fieldKeys.add("undertakeamt");
        fieldKeys.add("outamount");
        fieldKeys.add("budgetcontrolmode");
        fieldKeys.add("ctrloutitem");
        fieldKeys.add("ctrloutitemname");
        fieldKeys.add("realprobudgetname");
        fieldKeys.add("realbudgetitem");
        fieldKeys.add("realundertakeorg");
        fieldKeys.add("realundertakeperiod");
        fieldKeys.add("realproname");
        fieldKeys.add("realpronumber");
        fieldKeys.add("realproid");
        fieldKeys.add("realundertakeamt");
        fieldKeys.add("needapproval");
        fieldKeys.add("currencyfield");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ProjectApproveSubmitValidator());
    }

    static class ProjectApproveSubmitValidator
    extends AbstractValidator {
        ProjectApproveSubmitValidator() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) || ProjectApproveSubmitOp.OPERATION_APPROVAL_SUBMIT.equals(key) || ProjectApproveSubmitOp.OPERATION_REPORT_SUBMIT.equals(key)) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String tip;
                    Optional<DynamicObject> optional;
                    DynamicObjectCollection budgetOutCol;
                    DynamicObject approveObj = dataEntity.getDataEntity();
                    boolean needApproval = approveObj.getBoolean("needapproval");
                    if (needApproval && !StringUtils.equals((CharSequence)ProjectApproveSubmitOp.OPERATION_APPROVAL_SUBMIT, (CharSequence)key)) {
                        return;
                    }
                    DynamicObjectCollection controlinfoentryCol = approveObj.getDynamicObjectCollection("controlinfoentry");
                    String budgetControlMode = approveObj.getString("budgetcontrolmode");
                    if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue(), (CharSequence)budgetControlMode) || StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetControlMode)) {
                        return;
                    }
                    if (controlinfoentryCol.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u4fe1\u606f\u5206\u5f55\u81f3\u5c11\u9700\u8981\u4e00\u884c\u3002", (String)"ProjectApproveSubmitOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    HashMap<String, ArrayList<Integer>> dimensionsLineMap = new HashMap<String, ArrayList<Integer>>(16);
                    BigDecimal outAmount = approveObj.getBigDecimal("proyearbudgetamt");
                    BigDecimal totalEntryAmt = BigDecimal.ZERO;
                    BigDecimal totalRatio = BigDecimal.ZERO;
                    HashMap<String, BigDecimal> budgetItemAmtMap = new HashMap<String, BigDecimal>(16);
                    HashMap<String, String> budgetItemIdNameMap = new HashMap<String, String>(16);
                    HashMap<String, BigDecimal> budgetItemNameAmtMap = new HashMap<String, BigDecimal>(16);
                    for (int i = 0; i < controlinfoentryCol.size(); ++i) {
                        DynamicObject controlInfoEntry = (DynamicObject)controlinfoentryCol.get(i);
                        String ctrlBudgetItemId = controlInfoEntry.getString("ctrloutitem_id");
                        String undertakeOrgId = controlInfoEntry.getString("undertakeorg_id");
                        Date undertakePeriodDate = controlInfoEntry.getDate("undertakeperiod");
                        String entryProName = controlInfoEntry.getString("entryproname");
                        BigDecimal undertakeRatio = controlInfoEntry.getBigDecimal("undertakeratio");
                        BigDecimal undertakeAmt = controlInfoEntry.getBigDecimal("undertakeamt");
                        String ctrlOutItemName = controlInfoEntry.getString("ctrloutitemname");
                        StringBuilder dimensionsKey = new StringBuilder();
                        dimensionsKey.append(undertakeOrgId).append(undertakePeriodDate).append(entryProName).append(ctrlBudgetItemId);
                        ArrayList<Integer> lineList = (ArrayList<Integer>)dimensionsLineMap.get(dimensionsKey.toString());
                        if (lineList == null) {
                            lineList = new ArrayList<Integer>(10);
                        }
                        lineList.add(i + 1);
                        dimensionsLineMap.put(dimensionsKey.toString(), lineList);
                        totalRatio = totalRatio.add(undertakeRatio);
                        totalEntryAmt = totalEntryAmt.add(undertakeAmt);
                        budgetItemAmtMap.merge(ctrlBudgetItemId, undertakeAmt, BigDecimal::add);
                        budgetItemNameAmtMap.merge(ctrlOutItemName, undertakeAmt, BigDecimal::add);
                    }
                    HashMap<String, BigDecimal> outBudgetItemAmtMap = new HashMap<String, BigDecimal>(16);
                    String splitType = approveObj.getString("splittype");
                    if (StringUtils.equals((CharSequence)SplitTypeEnum.SUMSPLIT.getValue(), (CharSequence)splitType)) {
                        budgetOutCol = approveObj.getDynamicObjectCollection("budgetout");
                        for (DynamicObject budgetOut : budgetOutCol) {
                            DynamicObject outItem;
                            long pid = budgetOut.getLong("pid");
                            if (pid != 0L || (outItem = budgetOut.getDynamicObject("outitem")) == null) continue;
                            String outItemId = outItem.getString("id");
                            BigDecimal outItemAmt = budgetOut.getBigDecimal("bdoutamount");
                            budgetItemIdNameMap.put(outItemId, outItem.getString("name"));
                            outBudgetItemAmtMap.merge(outItemId, outItemAmt, BigDecimal::add);
                        }
                        for (DynamicObject out : budgetOutCol) {
                            String outItemName = out.getString("outitemname");
                            optional = controlinfoentryCol.stream().filter(dyn -> dyn.getString("ctrloutitemname").equals(outItemName)).findFirst();
                            if (optional.isPresent()) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u5206\u5f55\u7684%s\u5c1a\u672a\u8fdb\u884c\u5206\u644a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveSubmitOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName);
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                        for (DynamicObject ctl : controlinfoentryCol) {
                            String ctlOutItemName = ctl.getString("ctrloutitemname");
                            optional = budgetOutCol.stream().filter(dyn -> dyn.getString("outitemname").equals(ctlOutItemName)).findFirst();
                            if (optional.isPresent()) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u660e\u7ec6\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u652f\u51fa\u9884\u7b97\u9879\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveSubmitOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctlOutItemName);
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                        for (Map.Entry entry : outBudgetItemAmtMap.entrySet()) {
                            BigDecimal budgetItemAmt = (BigDecimal)budgetItemAmtMap.get(entry.getKey());
                            if (budgetItemAmt == null || budgetItemAmt.compareTo((BigDecimal)entry.getValue()) >= 0) continue;
                            int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)((DynamicObject)dataEntity.getValue("currencyfield")));
                            tip = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u4e2d\uff0c\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\uff08%2$s\uff09\u5927\u4e8e\u9884\u7b97\u5206\u644a\u91d1\u989d\uff08%3$s\uff09\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ProjectApproveSubmitOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), budgetItemIdNameMap.get(entry.getKey()), ((BigDecimal)entry.getValue()).setScale(amountAccuracy, RoundingMode.HALF_UP), budgetItemAmt.setScale(amountAccuracy, RoundingMode.HALF_UP));
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                    } else if (StringUtils.equals((CharSequence)SplitTypeEnum.BUDGETAMTSPLIT.getValue(), (CharSequence)splitType)) {
                        budgetOutCol = approveObj.getDynamicObjectCollection("budgetout");
                        for (DynamicObject out : budgetOutCol) {
                            String outItemName = out.getString("outitemname");
                            optional = controlinfoentryCol.stream().filter(dyn -> dyn.getString("ctrloutitemname").equals(outItemName)).findFirst();
                            if (optional.isPresent()) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u5206\u5f55\u7684%s\u5c1a\u672a\u8fdb\u884c\u5206\u644a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveSubmitOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName);
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                        for (DynamicObject ctl : controlinfoentryCol) {
                            String ctlOutItemName = ctl.getString("ctrloutitemname");
                            optional = budgetOutCol.stream().filter(dyn -> dyn.getString("outitemname").equals(ctlOutItemName)).findFirst();
                            if (optional.isPresent()) continue;
                            tip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u660e\u7ec6\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u652f\u51fa\u9884\u7b97\u9879\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveSubmitOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), ctlOutItemName);
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                        for (DynamicObject budgetOut : budgetOutCol) {
                            BigDecimal ctrlOutItemAmt;
                            long pid = budgetOut.getLong("pid");
                            if (pid != 0L) continue;
                            String outItemName = budgetOut.getString("outitemname");
                            BigDecimal outItemAmt = budgetOut.getBigDecimal("bdoutamount");
                            if (!StringUtils.isNotBlank((CharSequence)outItemName) || (ctrlOutItemAmt = (BigDecimal)budgetItemNameAmtMap.get(outItemName)) == null || outItemAmt.compareTo(ctrlOutItemAmt) <= 0) continue;
                            int amountAccuracy = CurrencyHelper.getAmountAccuracy((DynamicObject)((DynamicObject)dataEntity.getValue("currencyfield")));
                            String tip2 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u4e2d\uff0c\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\uff08%2$s\uff09\u5927\u4e8e\u9884\u7b97\u5206\u644a\u91d1\u989d\uff08%3$s\uff09\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ProjectApproveSubmitOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), outItemName, outItemAmt.setScale(amountAccuracy, RoundingMode.HALF_UP), ctrlOutItemAmt.setScale(amountAccuracy, RoundingMode.HALF_UP));
                            this.addErrorMessage(dataEntity, tip2);
                            return;
                        }
                    } else if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType) && totalRatio.compareTo(BigDecimal.valueOf(100L)) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6bd4\u4f8b\u7d2f\u8ba1\u503c\u5e94\u4e3a100%\u3002", (String)"ProjectApproveSubmitOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (outAmount.compareTo(totalEntryAmt) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7b97\u5206\u644a\u91d1\u989d\u4e0e\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ProjectApproveSubmitOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    Collection listCol = dimensionsLineMap.values();
                    for (List list : listCol) {
                        if (list.size() <= 1) continue;
                        String tipStringBuilder = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9884\u7b97\u63a7\u5236\u4fe1\u606f\u7684\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectApproveSubmitOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), list.toString());
                        this.addErrorMessage(dataEntity, tipStringBuilder);
                    }
                }
            }
        }
    }
}

