/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.lang3.StringUtils;

public class TeamMemberRoleOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("role");
        e.getFieldKeys().add("member");
        e.getFieldKeys().add("telno");
        e.getFieldKeys().add("note");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) continue;
                    this.checkTeamMemberRole(dataEntity);
                }
            }

            protected boolean checkTeamMemberRole(ExtendedDataEntity dataEntity) {
                DynamicObject obj = dataEntity.getDataEntity();
                String billNo = obj.getString("billno");
                DynamicObjectCollection tMemberEntry = obj.getDynamicObjectCollection("tmemberentry");
                if (tMemberEntry != null && tMemberEntry.size() > 0) {
                    for (DynamicObject teamMember : tMemberEntry) {
                        DynamicObject member = teamMember.getDynamicObject("member");
                        DynamicObject role = teamMember.getDynamicObject("role");
                        if (role != null) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u56e2\u961f\u6210\u5458\u201c%2$s\u201d\u7684\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TeamMemberRoleOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, member.getString("name")));
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

