/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.BudgetBillHelper;
import kd.pmgt.pmas.business.helper.ProjectBudgetGenerateHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.ProjectCtrlBudgetEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SysCheckBudgetAmtParamEnums;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;

public class TotalBudgetBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("sourcetype");
        fieldKeys.add("version");
        fieldKeys.add("currency");
        fieldKeys.add("project");
        fieldKeys.add("org");
        fieldKeys.add("budgetstage");
        fieldKeys.add("totalamount");
        fieldKeys.add("presamount");
        fieldKeys.add("prevamount");
        fieldKeys.add("type");
        fieldKeys.add("isvalid");
        fieldKeys.add("proapprovalamt");
        fieldKeys.add("planbegindate");
        fieldKeys.add("planenddate");
        fieldKeys.add("projectapplydate");
        fieldKeys.add("treeentryentity");
        fieldKeys.add("seq");
        fieldKeys.add("budgetamount");
        fieldKeys.add("budgetitem");
        fieldKeys.add("budgetitemname");
        fieldKeys.add("budgetitemnum");
        fieldKeys.add("descriptionentry");
        fieldKeys.add("isGroupNode");
        fieldKeys.add("pid");
        fieldKeys.add("projectbudgetitem");
        fieldKeys.add("siamount");
        fieldKeys.add("viamount");
        fieldKeys.add("vichangeamount");
        fieldKeys.add("sichangeamount");
        fieldKeys.add("treeentryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TotalBudgetValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("audit".equals(operationKey)) {
            this.doAudit(dataEntities);
        }
    }

    protected void doAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> updateBudget = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> auditBudget = new ArrayList<DynamicObject>(10);
        ArrayList updateProjectItems = new ArrayList();
        ArrayList addProjectItems = new ArrayList();
        for (DynamicObject budget : dataEntities) {
            QFilter sourceTypeFilter;
            QFilter isValid;
            DynamicObject project = budget.getDynamicObject("project");
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject[] validBudgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id,billno,isvalid", (QFilter[])new QFilter[]{proFilter, isValid = new QFilter("isvalid", "=", (Object)"1"), sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue())});
            if (validBudgets.length > 0) {
                for (DynamicObject validBudget : validBudgets) {
                    validBudget.set("isvalid", (Object)DefaultEnum.NO.getValue());
                    updateBudget.add(validBudget);
                }
            }
            budget.set("isvalid", (Object)DefaultEnum.YES.getValue());
            auditBudget.add(budget);
            DynamicObject projectApproval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
            if (isNew) {
                ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)budget, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.TOTAL.getValue());
            } else if (projectApproval != null && ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue().equals(projectApproval.getString("probudgetctrl"))) {
                ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)budget, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.TOTAL.getValue());
            }
            if (!updateProjectItems.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateProjectItems.get(0)).getDataEntityType(), (Object[])updateProjectItems.toArray(new DynamicObject[0]));
            }
            if (!addProjectItems.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)addProjectItems.get(0)).getDataEntityType(), (Object[])addProjectItems.toArray(new DynamicObject[0]));
            }
            if (!updateBudget.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateBudget.toArray(new DynamicObject[0]));
            }
            if (!auditBudget.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])auditBudget.toArray(new DynamicObject[0]));
            }
            if (isNew) {
                if (projectApproval == null || ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue().equals(projectApproval.getString("probudgetctrl"))) {
                    // empty if block
                }
                ProBudgetControlHelper.updateTotalBudgetCtrlData((DynamicObject)budget);
            }
            if (projectApproval == null) continue;
            projectApproval.set("planbegindate", (Object)budget.getDate("planbegindate"));
            projectApproval.set("planenddate", (Object)budget.getDate("planenddate"));
            SaveServiceHelper.update((DynamicObject)projectApproval);
        }
    }

    public static ProjectCtrlBudgetEnums getProjectBudgetControlType(DynamicObject project) {
        QFilter proKindQFilter;
        DynamicObject projectKindSetting;
        Object group;
        ProjectCtrlBudgetEnums proBudgetCtrl = ProjectCtrlBudgetEnums.UN_CTRL;
        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"overallctrlyear", (QFilter[])new QFilter[]{projectFilter});
        if (approval != null) {
            proBudgetCtrl = ProjectCtrlBudgetEnums.getEnumByValue((Object)approval.getString("overallctrlyear"));
        } else if ((project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")) != null && project.getDynamicObject("group") != null && (group = project.getDynamicObject("group").getPkValue()) != null && StringUtils.isNotEmpty((CharSequence)group.toString()) && (projectKindSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{proKindQFilter = new QFilter("projectkind", "=", (Object)Long.parseLong(group.toString()))})) != null) {
            proBudgetCtrl = ProjectCtrlBudgetEnums.getEnumByValue((Object)projectKindSetting.getString("overallctrlyear"));
        }
        if (proBudgetCtrl == null) {
            proBudgetCtrl = ProjectCtrlBudgetEnums.UN_CTRL;
        }
        return proBudgetCtrl;
    }

    static class TotalBudgetValidator
    extends AbstractValidator {
        TotalBudgetValidator() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)OperationEnum.SUBMIT.getValue())) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    if (this.checkBudgetStageAmt(dataEntity)) {
                        return;
                    }
                    boolean isNew = false;
                    DynamicObject budgetObj = dataEntity.getDataEntity();
                    DynamicObject project = budgetObj.getDynamicObject("project");
                    if (project != null) {
                        isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
                    }
                    if (!isNew) {
                        if (this.checkBudgetItem(dataEntity)) {
                            return;
                        }
                        if (this.checkTotalAmtAndYearAmt(dataEntity)) {
                            return;
                        }
                    } else if (this.checkTotalAmt(dataEntity)) {
                        return;
                    }
                    if (this.checkBudgetAmt(dataEntity)) {
                        return;
                    }
                    if (!this.checkSubmitTotal(dataEntity)) continue;
                    return;
                }
            }
        }

        protected boolean checkTotalAmt(ExtendedDataEntity dataEntity) {
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject project = budgetObj.getDynamicObject("project");
            if (project != null) {
                DynamicObject currency = budgetObj.getDynamicObject("currency");
                int precision = currency == null ? 4 : currency.getInt("amtprecision");
                QFilter qfilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qfilter.and("tbudgettype", "=", (Object)"OUT");
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qfilter});
                if (totalBudgetCtrl != null) {
                    BigDecimal occupyAmt;
                    BigDecimal totalAmount;
                    DynamicObject exist = ProBudgetControlHelper.checkExistValidYearBudget((Long)Long.parseLong(project.getPkValue().toString()), (String)"OUT", null);
                    DynamicObjectCollection details = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                    if (!details.isEmpty()) {
                        DynamicObjectCollection entities = budgetObj.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject entity : entities) {
                            BigDecimal sumBudAmt;
                            DynamicObject proBudgetItem = entity.getDynamicObject("projectbudgetitem");
                            if (proBudgetItem == null) continue;
                            long proBudgetItemId = Long.parseLong(proBudgetItem.getPkValue().toString());
                            Optional<DynamicObject> first = details.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == proBudgetItemId).findFirst();
                            if (!first.isPresent()) continue;
                            DynamicObject detail = first.get();
                            BigDecimal budgetAmount = entity.getBigDecimal("budgetamount");
                            BigDecimal compareAmount = detail.getBigDecimal("occupyamt");
                            BigDecimal preOccupyAmt = detail.getBigDecimal("preoccupyamt");
                            compareAmount = compareAmount.add(preOccupyAmt);
                            BigDecimal usageAmt = detail.getBigDecimal("usageamt");
                            BigDecimal preUsageAmt = detail.getBigDecimal("preoccupyusageamt");
                            if (compareAmount.compareTo(usageAmt = usageAmt.add(preUsageAmt)) < 0) {
                                compareAmount = usageAmt;
                            }
                            if (exist != null && compareAmount.compareTo(sumBudAmt = detail.getBigDecimal("sumbudamt")) < 0) {
                                compareAmount = sumBudAmt;
                            }
                            if (budgetAmount.compareTo(compareAmount) >= 0) continue;
                            String name = entity.getString("budgetitemname");
                            String errorTip = String.format(ResManager.loadKDString((String)"%1$s\u672c\u9636\u6bb5\u91d1\u989d%2$s\u4e0d\u80fd\u5c0f\u4e8e%3$s", (String)"TotalBudgetBillOp_9", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), name, budgetAmount.setScale(precision, RoundingMode.HALF_UP), compareAmount.setScale(precision, RoundingMode.HALF_UP));
                            ProjectCtrlBudgetEnums projectBudgetControlType = TotalBudgetBillOp.getProjectBudgetControlType(project);
                            if (ProjectCtrlBudgetEnums.STRICT_CTRL.getValue().equals(projectBudgetControlType.getValue())) {
                                this.addErrorMessage(dataEntity, errorTip);
                                return true;
                            }
                            if (!ProjectCtrlBudgetEnums.REMIND_CTRL.getValue().equals(projectBudgetControlType.getValue())) continue;
                            this.addWarningMessage(dataEntity, errorTip);
                        }
                    }
                    if ((totalAmount = budgetObj.getBigDecimal("totalamount")).compareTo(occupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt")) < 0) {
                        String errorTip = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u672c\u9636\u6bb5\u9884\u7b97\u91d1\u989d\u5e94\u5927\u4e8e\u201c%1$s\u201d\u3002", (String)"TotalBudgetBillOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), occupyAmt.setScale(precision, RoundingMode.HALF_UP));
                        this.addErrorMessage(dataEntity, errorTip);
                        return true;
                    }
                    BigDecimal sumBudAmt = totalBudgetCtrl.getBigDecimal("tsumbudamt");
                    if (totalAmount.compareTo(sumBudAmt) < 0) {
                        String errorTip = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u672c\u9636\u6bb5\u9884\u7b97\u91d1\u989d\u5e94\u5927\u4e8e\u201c%1$s\u201d\u3002", (String)"TotalBudgetBillOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), sumBudAmt.setScale(precision, RoundingMode.HALF_UP));
                        ProjectCtrlBudgetEnums projectBudgetControlType = TotalBudgetBillOp.getProjectBudgetControlType(project);
                        if (ProjectCtrlBudgetEnums.STRICT_CTRL.getValue().equals(projectBudgetControlType.getValue())) {
                            this.addErrorMessage(dataEntity, errorTip);
                            return true;
                        }
                        if (ProjectCtrlBudgetEnums.REMIND_CTRL.getValue().equals(projectBudgetControlType.getValue())) {
                            this.addWarningMessage(dataEntity, errorTip);
                        }
                    }
                }
            }
            return false;
        }

        protected boolean checkSubmitTotal(ExtendedDataEntity dataEntity) {
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject project = budgetObj.getDynamicObject("project");
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
            QFilter idFilter = new QFilter("id", "!=", budgetObj.getPkValue());
            DynamicObject[] totalBudgets = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"id, billno", (QFilter[])new QFilter[]{proFilter, statusFilter, sourceTypeFilter, idFilter});
            if (totalBudgets.length > 0) {
                DynamicObject totalBudget = totalBudgets[0];
                String errorTip = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u901a\u8fc7\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u603b\u4f53\u9884\u7b97\u5355\u636e\u201c%s\u201d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"TotalBudgetBillOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), totalBudget.getString("billno"));
                this.addErrorMessage(dataEntity, errorTip);
                return true;
            }
            return false;
        }

        private boolean checkBudgetAmt(ExtendedDataEntity dataEntity) {
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject currency = budgetObj.getDynamicObject("currency");
            int precision = currency == null ? 4 : currency.getInt("amtprecision");
            DynamicObject project = budgetObj.getDynamicObject("project");
            if (project != null) {
                BigDecimal totalAmt = budgetObj.getBigDecimal("totalamount");
                BigDecimal proApprovalAmt = budgetObj.getBigDecimal("proapprovalamt");
                if (proApprovalAmt.compareTo(totalAmt) < 0) {
                    DynamicObject approval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
                    if (approval != null && ProjectCtrlBudgetEnums.STRICT_CTRL.getValue().equals(approval.getString("projectctrlbudget"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u9884\u7b97\u91d1\u989d\u201d\uff08%1$s\uff09\u8d85\u51fa\u201c\u9879\u76ee\u7acb\u9879\u91d1\u989d\u201d\uff08%2$s\uff09\uff0c\u7cfb\u7edf\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TotalBudgetBillOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), totalAmt.setScale(precision, RoundingMode.HALF_UP), proApprovalAmt.setScale(precision, RoundingMode.HALF_UP)));
                        return true;
                    }
                    if (approval != null && ProjectCtrlBudgetEnums.REMIND_CTRL.getValue().equals(approval.getString("projectctrlbudget"))) {
                        this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u9884\u7b97\u91d1\u989d\u201d\uff08%1$s\uff09\u8d85\u8fc7\u201c\u9879\u76ee\u7acb\u9879\u91d1\u989d\u201d\uff08%2$s\uff09\u3002", (String)"TotalBudgetBillOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), totalAmt.setScale(precision, RoundingMode.HALF_UP), proApprovalAmt.setScale(precision, RoundingMode.HALF_UP)));
                        return false;
                    }
                }
            }
            return false;
        }

        private boolean checkBudgetItem(ExtendedDataEntity dataEntity) {
            String errorTip = "";
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject currency = budgetObj.getDynamicObject("currency");
            int precision = currency == null ? 4 : currency.getInt("amtprecision");
            DynamicObject project = budgetObj.getDynamicObject("project");
            if (project == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"TotalBudgetBillOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                return true;
            }
            boolean exists = new BudgetBillHelper().checkIsExistBudgetBill(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.TOTAL.getValue());
            DynamicObject approval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
            if (approval != null && approval.getBoolean("projectcostcontrol") && exists) {
                DynamicObjectCollection treeEntryEntity;
                if (ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue().equals(approval.getString("probudgetctrl")) && (treeEntryEntity = budgetObj.getDynamicObjectCollection("treeentryentity")).size() > 0) {
                    for (DynamicObject entity : treeEntryEntity) {
                        BigDecimal occupyAmt;
                        BigDecimal budgetAmount = entity.getBigDecimal("budgetamount");
                        DynamicObject budgetItem = entity.getDynamicObject("projectbudgetitem");
                        if (budgetItem == null) continue;
                        budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(budgetItem.getPkValue().toString()), (String)"pmas_projectbudgetperform");
                        BigDecimal budgetAmt = budgetItem.getBigDecimal("budgetamount");
                        String type = budgetObj.getString("type");
                        if ("ADJUST".equals(type)) {
                            BigDecimal viAmount = entity.getBigDecimal("viamount");
                            budgetAmount = budgetAmt.subtract(viAmount).add(budgetAmount);
                        }
                        if (budgetAmount.compareTo(occupyAmt = budgetItem.getBigDecimal("occupyamt")) >= 0) continue;
                        errorTip = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u201c%1$s\u201d\u7684\u9884\u7b97\u7d2f\u8ba1\u503c\u201c%2$s\u201d\uff0c\u4e0d\u5f97\u5c0f\u4e8e\u5df2\u5360\u7528\u91d1\u989d\u201c%3$s\u201d\u3002", (String)"TotalBudgetBillOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), entity.getString("budgetitemname"), budgetAmount.setScale(precision, RoundingMode.HALF_UP), occupyAmt.setScale(precision, RoundingMode.HALF_UP));
                        this.addErrorMessage(dataEntity, errorTip);
                    }
                }
                return StringUtils.isNotBlank((CharSequence)errorTip);
            }
            return false;
        }

        private boolean checkTotalAmtAndYearAmt(ExtendedDataEntity dataEntity) {
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject currency = budgetObj.getDynamicObject("currency");
            int precision = currency == null ? 4 : currency.getInt("amtprecision");
            DynamicObject project = budgetObj.getDynamicObject("project");
            if (project != null) {
                BigDecimal yearSumBudgets = new BudgetBillHelper().getAllAssertBudgetSumAmt(Long.valueOf(Long.parseLong(project.getPkValue().toString())), BudgetSourceTypeEnum.OUT.getValue());
                BigDecimal totalAmt = budgetObj.getBigDecimal("totalamount");
                if (totalAmt.compareTo(yearSumBudgets) < 0) {
                    String errorTip = String.format(ResManager.loadKDString((String)"\u672c\u9636\u6bb5\u9884\u7b97\u603b\u91d1\u989d%1$s\u5c0f\u4e8e\u5e74\u5ea6\u9884\u7b97\u91d1\u989d\u7d2f\u8ba1\u503c%2$s\u3002\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"TotalBudgetBillOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), totalAmt.setScale(precision, RoundingMode.HALF_UP), yearSumBudgets.setScale(precision, RoundingMode.HALF_UP));
                    this.addErrorMessage(dataEntity, errorTip);
                    return true;
                }
            }
            return false;
        }

        private boolean checkBudgetStageAmt(ExtendedDataEntity dataEntity) {
            DynamicObject budgetStage;
            DynamicObject preBudgetStage;
            DynamicObject org;
            String paramValue;
            DynamicObject budgetObj = dataEntity.getDataEntity();
            DynamicObject project = budgetObj.getDynamicObject("project");
            if (project != null && StringUtils.equals((CharSequence)(paramValue = SystemParamHelper.getSystemParameter((String)"multicheckamttype", (String)"pmco", (Long)Long.parseLong((org = budgetObj.getDynamicObject("org")).getPkValue().toString())).toString()), (CharSequence)SysCheckBudgetAmtParamEnums.UNALLOW.getValue()) && (preBudgetStage = new BudgetBillHelper().getPreBudgetStage(project, budgetStage = budgetObj.getDynamicObject("budgetstage"), BudgetSourceTypeEnum.TOTAL.getValue())) != null) {
                BigDecimal totalAmount = budgetObj.getBigDecimal("totalamount");
                BigDecimal presAmount = budgetObj.getBigDecimal("presamount");
                if (presAmount.compareTo(BigDecimal.ZERO) > 0 && totalAmount.compareTo(presAmount) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u9636\u6bb5\u201c\u9884\u7b97\u603b\u91d1\u989d\u201d\u8d85\u51fa\u4e0a\u9636\u6bb5\u201c\u9884\u7b97\u603b\u91d1\u989d\u201d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TotalBudgetBillOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    return true;
                }
            }
            return false;
        }
    }
}

