/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public abstract class AbstractContractItemBookPlugin
extends AbstractPmbsListPlugin
implements BeforeFilterF7SelectListener,
HyperLinkClickListener {
    protected static final String ORG_FIELD_NAME = "org.id";
    protected static final String BOS_ORG = "bos_org";
    protected static final String ALL_ORG_ID = "allorgid";
    protected static final String ID_NAME = "id,name";
    protected static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    protected static final String ORG = "org";
    protected static final String TASKCOMPLETESTATUS = "taskcompletestatus";
    private static final Log logger = LogFactory.getLog(AbstractContractItemBookPlugin.class);
    private static final String EXPORTEXCEL = "exportexcel";

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection contractItemEntries = dataEntity.getDynamicObjectCollection(this.getContractItemEntryEntityId());
        DynamicObject contractItem = (DynamicObject)contractItemEntries.get(rowIndex);
        switch (fieldName) {
            case "contract": {
                this.contractHyperLinkClick(contractItem);
                break;
            }
            case "contractproject": {
                this.contractProjectHyperLinkClick(contractItem);
                break;
            }
            case "nodesetting": {
                this.nodeSettingHyperLinkClick(contractItem);
                break;
            }
        }
    }

    protected void contractHyperLinkClick(DynamicObject contractColItem) {
        DynamicObject contract = contractColItem.getDynamicObject("contract");
        if (contract != null) {
            HashMap<String, String> customMap = new HashMap<String, String>(8);
            customMap.put("contractId", contract.getPkValue().toString());
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("formId", "pmct_contractkanban");
            map.put("customParams", customMap);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
    }

    protected void contractProjectHyperLinkClick(DynamicObject contractColItem) {
        DynamicObject contract = contractColItem.getDynamicObject("contract");
        if (contract != null) {
            DynamicObject project = contract.getDynamicObject("project");
            if (project == null) {
                return;
            }
            Long projectId = (Long)project.getPkValue();
            DynamicObject proApproval = QueryServiceHelper.queryOne((String)"pmas_pro_approval", (String)"id,pro", (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)projectId)});
            if (proApproval != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                HashMap<String, String> custormMap = new HashMap<String, String>();
                custormMap.put("proAppId", proApproval.getString("id"));
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            } else {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("formId", "bd_project");
                map.put("pkId", projectId.toString());
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        }
    }

    protected void nodeSettingHyperLinkClick(DynamicObject contractColItem) {
        String nodeSettingSource = contractColItem.getString("nodesettingsource");
        DynamicObject nodeSetting = contractColItem.getDynamicObject("nodesetting");
        if (StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue()) && nodeSetting != null) {
            DynamicObject lastestTask;
            DynamicObject sourcetask;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Long taskId = (Long)nodeSetting.getPkValue();
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", "islatest", "sourcetask"));
            if (!task.getBoolean("islatest") && (sourcetask = task.getDynamicObject("sourcetask")) != null && (lastestTask = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourcetask.getPkValue()), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())})) != null) {
                taskId = (Long)lastestTask.getPkValue();
            }
            paramMap.put("formId", "pmpt_reporttaskview");
            paramMap.put("pkId", String.valueOf(taskId));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        if (StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)beforeFilterF7SelectEvent.getFieldName()) || StringUtils.equals((CharSequence)"org.name", (CharSequence)beforeFilterF7SelectEvent.getFieldName())) {
            this.beforeOrgSelect(beforeFilterF7SelectEvent);
        }
    }

    protected void beforeOrgSelect(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        beforeFilterF7SelectEvent.setRefEntityId(BOS_ORG);
        beforeFilterF7SelectEvent.setRefPropKey("id");
        beforeFilterF7SelectEvent.getQfilters().add(new QFilter("id", "in", this.getOrgsByCacheString(null)));
    }

    protected List<Long> getOrgsByCacheString(String orgIds) {
        String allOrgs = this.getPageCache().get(ALL_ORG_ID);
        if (orgIds == null) {
            String string = orgIds = allOrgs == null ? "" : allOrgs;
        }
        if (orgIds.contains("\"")) {
            orgIds = orgIds.replace("\"", "");
        }
        ArrayList<Long> orgList = new ArrayList<Long>(16);
        if (StringUtils.equals((CharSequence)"[]", (CharSequence)orgIds) && allOrgs != null) {
            orgIds = this.getPageCache().get(ALL_ORG_ID);
        }
        if (orgIds != null && orgIds.length() > 2) {
            String[] orgs;
            String substring = orgIds.substring(1, orgIds.length() - 1);
            for (String org : orgs = substring.split(",")) {
                orgList.add(Long.valueOf(org.trim()));
            }
        }
        return orgList;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.initOrgFilterColumn(filterColumnList);
        JSONArray org = (JSONArray)this.getView().getFormShowParameter().getCustomParam(ORG);
        if (null != org) {
            for (FilterColumn filterColumn : filterColumnList) {
                if (filterColumn.getFieldName().contains(ORG)) {
                    filterColumn.setDefaultValues(new ArrayList(org));
                    continue;
                }
                filterColumn.setDefaultValue(null);
            }
        }
    }

    protected void initOrgFilterColumn(List<FilterColumn> filterColumnList) {
        FilterColumn orgFilterColumn = null;
        for (FilterColumn filterColumn : filterColumnList) {
            if (!"org.name".equals(filterColumn.getFieldName())) continue;
            orgFilterColumn = filterColumn;
        }
        if (orgFilterColumn != null) {
            CommonFilterColumn orgColumn = this.buildOrgFilterColumn(orgFilterColumn);
            HashSet<Long> hasPermOrgs = new HashSet<Long>(16);
            if (orgColumn.getComboItems() != null) {
                for (ComboItem item : orgColumn.getComboItems()) {
                    hasPermOrgs.add(Long.valueOf(item.getValue()));
                }
            }
            this.getPageCache().put(ALL_ORG_ID, ((Object)hasPermOrgs).toString());
        }
    }

    protected CommonFilterColumn buildOrgFilterColumn(FilterColumn orgFilterColumn) {
        CommonFilterColumn orgColumn = (CommonFilterColumn)orgFilterColumn;
        orgColumn.setMustInput(true);
        orgColumn.setMulti(true);
        List<ComboItem> combos = this.buildOrgComboItems();
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        orgColumn.setDefaultValues(new Object[]{String.valueOf(RequestContext.get().getOrgId())});
        return orgColumn;
    }

    protected List<ComboItem> buildOrgComboItems() {
        ORM orm;
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getAppId(), (String)"pmbs_contractcolitembook", (String)"47150e89000000ac");
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = permOrgResult.hasAllOrgPerm();
        DynamicObjectCollection col = null;
        if (hasAllOrgPerm) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        } else if (!hasPermOrgs.isEmpty()) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)});
        }
        if (col != null && !col.isEmpty()) {
            for (DynamicObject org : col) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(org.getString("name")));
                item.setValue(String.valueOf(org.getPkValue()));
                combos.add(item);
            }
        }
        cacheString = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return combos;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        this.checkOperationPermission(args);
        DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
        this.setBillListSelectRows(selectContractPayItem);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)EXPORTEXCEL)) {
            this.exportExcel();
        }
    }

    public void checkOperationPermission(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String permissionItemId = operate.getPermissionItemId();
        if (StringUtils.isNotEmpty((CharSequence)permissionItemId)) {
            LocaleString operateName = operate.getOperateName();
            int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)this.getAppId(), (String)this.getContractItemEntityId(), (String)permissionItemId);
            if (permission != 1) {
                args.setCancel(true);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractContractItemBookPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), this.getContractItemEntityName(), operateName.getLocaleValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcel() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection contractItemEntries = dataEntity.getDynamicObjectCollection(this.getContractItemEntryEntityId());
        if (contractItemEntries == null || contractItemEntries.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AbstractContractItemBookPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileName = this.getExcelName();
        HSSFWorkbook wb = new HSSFWorkbook();
        ArrayList<String[]> headerList = new ArrayList<String[]>(4);
        ArrayList<String[]> columnList = new ArrayList<String[]>(4);
        ArrayList<JSONArray> jsonDataList = new ArrayList<JSONArray>(4);
        this.initContractPayItemBookExeclDate(headerList, columnList, jsonDataList);
        this.fillSheet(this.getContractItemEntityName(), (String[])headerList.get(0), (String[])columnList.get(0), (JSONArray)jsonDataList.get(0), wb);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        this.getView().download(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"AbstractContractItemBookPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
    }

    public void fillSheet(String sheetName, String[] header, String[] columnKey, JSONArray data, HSSFWorkbook wb) {
        HSSFSheet sheet = wb.createSheet(sheetName);
        Row valueRow = sheet.createRow(0);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell valueCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            valueCell = valueRow.createCell(i);
            valueCell.setCellValue(header[i]);
            valueCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle contentCellStyle = wb.createCellStyle();
        contentCellStyle.setBorderTop(BorderStyle.THIN);
        contentCellStyle.setBorderLeft(BorderStyle.THIN);
        contentCellStyle.setBorderRight(BorderStyle.THIN);
        contentCellStyle.setBorderBottom(BorderStyle.THIN);
        DataFormat format = sheet.getWorkbook().createDataFormat();
        contentCellStyle.setDataFormat(format.getFormat("TEXT"));
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                valueRow = sheet.createRow(i + 1);
                for (int j = 0; j < columnKey.length; ++j) {
                    valueCell = valueRow.createCell(j);
                    Object columnValue = jsonObject.get((Object)columnKey[j]);
                    if (columnValue != null) {
                        String columnValueStr = columnValue.toString();
                        if (columnValueStr.contains("cmd")) {
                            columnValueStr = columnValueStr.replace("cmd", "");
                        } else if (columnValueStr.contains("_PID_HLINKS")) {
                            columnValueStr = columnValueStr.replace("_PID_HLINKS", "");
                        } else if (columnValueStr.contains("IMPORTXML")) {
                            columnValueStr = columnValueStr.replace("IMPORTXML", "");
                        }
                        valueCell.setCellValue(columnValueStr);
                    }
                    valueCell.setCellStyle((CellStyle)contentCellStyle);
                }
            }
        }
    }

    protected String getExcelName() {
        Date currentDate = DateUtil.getCurrentDate();
        String dateFormat = "yyyyMMdd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String currentShortDate = simpleDateFormat.format(currentDate);
        return this.getContractItemEntityName() + currentShortDate + ".xls";
    }

    protected void initContractPayItemBookExeclDate(List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection contractColItemEntries = dataEntity.getDynamicObjectCollection(this.getContractItemEntryEntityId());
        JSONArray jsonArray = new JSONArray();
        Map<String, String> contractPayItemHeaderMap = this.getContractItemHeaderMap();
        headerList.add(contractPayItemHeaderMap.values().toArray(new String[0]));
        String[] columnKeys = contractPayItemHeaderMap.keySet().toArray(new String[0]);
        columnList.add(columnKeys);
        for (int i = 0; i < contractColItemEntries.size(); ++i) {
            JSONObject jsonObject;
            DynamicObject contractPayItemEntry = (DynamicObject)contractColItemEntries.get(i);
            if (!this.putContractPayItemToJsonObject(contractPayItemEntry, jsonObject = new JSONObject())) continue;
            jsonArray.add((Object)jsonObject);
        }
        jsonDataList.add(jsonArray);
    }

    protected DynamicObject[] getSelectContractPayItem() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection contractColItemEntries = dataEntity.getDynamicObjectCollection(this.getContractItemEntryEntityId());
        EntryGrid contractColItemEntryGird = (EntryGrid)this.getView().getControl(this.getContractItemEntryEntityId());
        int[] selectRows = contractColItemEntryGird.getSelectRows();
        if (selectRows != null && selectRows.length > 0 && contractColItemEntries.size() > 0) {
            ArrayList<Long> selectIds = new ArrayList<Long>(selectRows.length);
            for (int index : selectRows) {
                DynamicObject contractPayItem = (DynamicObject)contractColItemEntries.get(index);
                selectIds.add((Long)contractPayItem.getPkValue());
            }
            return BusinessDataServiceHelper.load((Object[])selectIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getContractItemEntityId()));
        }
        return null;
    }

    protected void setBillListSelectRows(DynamicObject[] selectContractPayItems) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        selectedRows.clear();
        if (selectContractPayItems != null) {
            for (int i = 0; i < selectContractPayItems.length; ++i) {
                DynamicObject selectContractPayItem = selectContractPayItems[i];
                ListSelectedRow listSelectedRow = new ListSelectedRow(selectContractPayItem.getPkValue());
                listSelectedRow.setNumber(selectContractPayItem.getString("name"));
                selectedRows.add(i, (Object)listSelectedRow);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        EntryGrid contractPayItemEntryGird = (EntryGrid)this.getView().getControl(this.getContractItemEntryEntityId());
        contractPayItemEntryGird.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        this.removeCustomControlFilter(e);
        Object org = this.getView().getFormShowParameter().getCustomParam(ORG);
        ArrayList<QFilter> qFilters = e.getQFilters();
        if (null != org) {
            for (QFilter qFilter : qFilters) {
                if (!qFilter.getProperty().equals("id")) continue;
                qFilters = new ArrayList<QFilter>(1);
                qFilters.add(qFilter);
                this.loadData(qFilters, Boolean.TRUE);
                break;
            }
        } else {
            this.loadData((List<QFilter>)qFilters, Boolean.FALSE);
        }
        super.setFilter(e);
    }

    protected void loadData(List<QFilter> qFilters, Boolean ifTrackUpFlag) {
        DynamicObject[] queryResults;
        ListCache listCache;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection contractPayItemEntries = dataEntity.getDynamicObjectCollection(this.getContractItemEntryEntityId());
        contractPayItemEntries.clear();
        if (this.getPageCache().get(ORG) == null && (listCache = new ListCache(this.getPageCache())).getFilterMode().isPresent()) {
            Integer integer = (Integer)listCache.getFilterMode().get();
            ControlFilters controlFilters = this.getControlFilters();
            if (integer == 1 && controlFilters != null && !controlFilters.getFilters().isEmpty()) {
                List orgList = ((ControlFilter)this.getControlFilters().getFilters().get(ORG_FIELD_NAME)).getValue();
                if (orgList.size() > 0) {
                    List orgIds = orgList.stream().map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                    this.getPageCache().put(ORG, SerializationUtils.toJsonString(orgIds));
                }
            } else {
                this.getPageCache().put(ORG, SerializationUtils.toJsonString(this.getOrgsByCacheString(null)));
            }
        }
        if (!ifTrackUpFlag.booleanValue()) {
            qFilters = this.setCustomFilter(qFilters);
        }
        if ((queryResults = BusinessDataServiceHelper.load((String)this.getContractItemEntityId(), (String)this.getAllProperty(), (QFilter[])qFilters.toArray(new QFilter[0]))) != null && queryResults.length > 0) {
            Map<Long, DynamicObject> projectMap = this.getBdProjectToProjectMap(queryResults);
            Map taskCompileMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])queryResults);
            ArrayList<kd.bos.entity.report.CellStyle> cellStyles = new ArrayList<kd.bos.entity.report.CellStyle>(queryResults.length);
            int index = 0;
            String timePropertyName = this.getTimePropertyName();
            for (DynamicObject queryResult : queryResults) {
                if (!this.isCheckFitFilterCondition(queryResult, taskCompileMap) || !this.checkContractStatus(queryResult.getDynamicObject("contract"))) continue;
                DynamicObject tempContractPayItem = contractPayItemEntries.addNew();
                this.fillContractPayItemEntry(tempContractPayItem, projectMap, taskCompileMap, queryResult);
                kd.bos.entity.report.CellStyle cellStyle = this.setCellStyle(index, timePropertyName, this.getPlanPayTimeForeColor(queryResult, timePropertyName));
                cellStyles.add(cellStyle);
                ++index;
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl(this.getContractItemEntryEntityId());
            grid.setCellStyle(cellStyles);
        }
        this.getModel().updateEntryCache(contractPayItemEntries);
        this.getModel().updateCache();
        this.getView().updateView(this.getContractItemEntryEntityId());
    }

    protected abstract String getAllProperty();

    protected String getPlanPayTimeForeColor(DynamicObject queryResult, String timeName) {
        Date planPayTime = queryResult.getDate(timeName);
        if (planPayTime != null) {
            Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth((Date)new Date());
            if (DateUtil.compareByDay((Date)planPayTime, (Date)lastDayOfThisMonth) <= 0) {
                return "red";
            }
            return "green";
        }
        return "black";
    }

    protected Map<Long, DynamicObject> getBdProjectToProjectMap(DynamicObject[] queryResults) {
        HashSet<Long> projectIds = new HashSet<Long>(queryResults.length);
        for (DynamicObject queryResult : queryResults) {
            DynamicObject project;
            DynamicObject contract = queryResult.getDynamicObject("contract");
            if (contract == null || (project = contract.getDynamicObject("project")) == null) continue;
            projectIds.add((Long)project.getPkValue());
        }
        DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "id", "prostatus", "pro"), (QFilter[])new QFilter[]{new QFilter("pro", "in", projectIds)});
        HashMap<Long, DynamicObject> projectMap = new HashMap<Long, DynamicObject>(projectApprovals.length);
        for (DynamicObject projectApproval : projectApprovals) {
            DynamicObject bdProject = projectApproval.getDynamicObject("pro");
            if (bdProject == null) continue;
            projectMap.put((Long)bdProject.getPkValue(), projectApproval);
        }
        return projectMap;
    }

    protected kd.bos.entity.report.CellStyle setCellStyle(int index, String columnKey, String foreColor) {
        kd.bos.entity.report.CellStyle cellStyle = new kd.bos.entity.report.CellStyle();
        cellStyle.setForeColor(foreColor);
        cellStyle.setFieldKey(columnKey);
        cellStyle.setRow(index);
        cellStyle.setStyles();
        return cellStyle;
    }

    protected boolean isCheckFitFilterCondition(DynamicObject queryResult, Map<String, Map<Object, String>> taskCompileMap) {
        DynamicObject contract = queryResult.getDynamicObject("contract");
        if (contract == null) {
            return false;
        }
        String taskCompleteStatus = this.getPageCache().get(TASKCOMPLETESTATUS);
        if (StringUtils.isNotEmpty((CharSequence)taskCompleteStatus)) {
            Map<Object, String> taskMessageMap = taskCompileMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
            DynamicObject nodeSetting = queryResult.getDynamicObject("nodesetting");
            String nodeSettingSource = queryResult.getString("nodesettingsource");
            if (taskMessageMap != null && nodeSetting != null && StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue())) {
                String taskStatus = taskMessageMap.get(nodeSetting.getPkValue());
                return !StringUtils.isNotEmpty((CharSequence)taskStatus) || StringUtils.equals((CharSequence)taskStatus, (CharSequence)taskCompleteStatus);
            }
        }
        return true;
    }

    public boolean getTaskStatus(Map<String, Map<Object, String>> taskCompileMap, DynamicObject tempContractPayItem) {
        Map<Object, String> taskMessageMap = taskCompileMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        String nodeSettingSource = tempContractPayItem.getString("nodesettingsource");
        DynamicObject nodeSetting = tempContractPayItem.getDynamicObject("nodesetting");
        if (taskMessageMap != null && nodeSetting != null && StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue())) {
            String taskStatus = taskMessageMap.get(nodeSetting.getPkValue());
            return StringUtils.equals((CharSequence)taskStatus, (CharSequence)"complete");
        }
        return false;
    }

    protected List<QFilter> setCustomFilter(List<QFilter> qFilters) {
        List OrgIds;
        String orgIdsString;
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        if (StringUtils.isNotEmpty((CharSequence)(orgIdsString = this.getPageCache().get(ORG))) && (OrgIds = (List)SerializationUtils.fromJsonString((String)orgIdsString, List.class)) != null && OrgIds.size() > 0) {
            qFilters.add(new QFilter("contract.org", "in", (Object)OrgIds));
        }
        qFilters.add(new QFilter("contract.openedcontract", "=", (Object)Boolean.FALSE));
        qFilters.add(new QFilter("contract.multipartsettlement", "=", (Object)Boolean.FALSE));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        return qFilters;
    }

    protected String getAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return appId == null ? "pmct" : appId;
    }

    protected boolean checkContractStatus(DynamicObject contract) {
        DynamicObject contractStatus = contract.getDynamicObject("contractstatus");
        String selectProperties = String.join((CharSequence)",", "number", "ispreset");
        contractStatus = BusinessDataServiceHelper.loadSingle((Object)contractStatus.getPkValue(), (String)"pmct_contractstatus", (String)selectProperties);
        boolean isPreset = contractStatus.getBoolean("ispreset");
        String contractStatusNumber = contractStatus.getString("number");
        return isPreset && StringUtils.equals((CharSequence)contractStatusNumber, (CharSequence)"04");
    }

    protected abstract String getContractItemEntryEntityId();

    protected abstract String getContractItemEntityId();

    protected abstract String getContractItemEntityName();

    protected abstract Map<String, String> getContractItemHeaderMap();

    protected abstract boolean putContractPayItemToJsonObject(DynamicObject var1, JSONObject var2);

    protected abstract void removeCustomControlFilter(SetFilterEvent var1);

    protected abstract void fillContractPayItemEntry(DynamicObject var1, Map<Long, DynamicObject> var2, Map<String, Map<Object, String>> var3, DynamicObject var4);

    protected abstract String getTimePropertyName();
}

