/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.business.report.OutBudgetReportHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import kd.pmgt.pmbs.common.utils.OpenPageUtils;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class BudgetPerformMonitorFormPlugin
extends AbstractPmbsListPlugin
implements BeforeFilterF7SelectListener,
HyperLinkClickListener {
    protected static final Log logger = LogFactory.getLog(BudgetPerformMonitorFormPlugin.class);
    protected static final String BUDGETCURRENCY = "budgetcurrency";
    protected static final String BILLCURRENCY = "billcurrency";
    protected static final String PERFORMBILLENTRY = "performbillentry";
    protected static final String BUDGETENTRY = "budgetentry";
    protected static final String ID_NAME = "id,name";
    protected static final String BOS_ORG = "bos_org";
    protected static final String ORG_FIELD_NAME = "org.id";
    protected static final String PROJECT_FIELD_ID = "project.id";
    protected static final String PROJECT_FIELD_NAME = "project.name";
    protected static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    protected static final String ORG_ID = "orgid";
    protected static final String ALL_ORG_ID = "allorgid";
    protected static final String CHECKBILLID = "checkbillid";
    protected static final String PROJECTFILTERID = "projectfilterid";
    protected static final String PROJECTFILTERNAME = "projectfiltername";
    protected static final String FILTERNAME = "filftername";
    protected static final String ALLPROJECTID = "allprojectid";
    private String[] columns = new String[]{"name", "budgetamount", "remindamt", "controlamt", "occupyamt", "performamt", "remainamt", "remainrate"};
    private String[] headers = null;
    protected static final String AMOUNTRECORD = "amountrecord";
    protected static final String SELECTED_CONTRACTID = "selectedcontractid";
    protected static final String PAYDIRECTION = "payDirection";
    protected static final Long FAILEDSTATUSID = 696208189016036352L;
    private String[] sheets = null;
    private String[] proBudgetColumnKeys = new String[]{"name", "budgetamount", "remindamt", "controlamt", "occupyamt", "performamt", "actualpayamount", "remainamt", "remainrate"};
    private String[] proBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u9192\u9650\u989d", (String)"BudgetPerformMonitorFormPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f3a\u63a7\u9650\u989d", (String)"BudgetPerformMonitorFormPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5360\u7528\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_19", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5269\u4f59\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5269\u4f59\u6bd4\u4f8b\uff08%\uff09", (String)"BudgetPerformMonitorFormPlugin_40", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private String[] contBudgetColumnKeys = new String[]{"name", "contbillno", "contbillname", "contbillstatus", "occupyamount", "contractsubmitamt", "settlesubmitamt", "applysubmitamt", "paysubmitamt"};
    private String[] contBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"BudgetPerformMonitorFormPlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"BudgetPerformMonitorFormPlugin_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u5408\u540c\u5df2\u5360\u7528\u9884\u7b97\u91d1\u989d", (String)"BudgetPerformMonitorFormPlugin_23", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2460", (String)"BudgetPerformMonitorFormPlugin_24", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2461", (String)"BudgetPerformMonitorFormPlugin_25", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2462", (String)"BudgetPerformMonitorFormPlugin_26", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u4ed8\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2463", (String)"BudgetPerformMonitorFormPlugin_27", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private String[] budgetRecordColumnKeys = new String[]{"name", "contbillno", "contbillname", "billtype", "billno", "billname", "billamt", "billstatus", "billcreator", "billcreatedate", "billauditor", "billauditdate"};
    private String[] budgetRecordHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"BudgetPerformMonitorFormPlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b", (String)"BudgetPerformMonitorFormPlugin_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"BudgetPerformMonitorFormPlugin_29", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"BudgetPerformMonitorFormPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\uff08\u9879\u76ee\u5e01\uff09", (String)"BudgetPerformMonitorFormPlugin_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"BudgetPerformMonitorFormPlugin_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"BudgetPerformMonitorFormPlugin_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"BudgetPerformMonitorFormPlugin_33", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"BudgetPerformMonitorFormPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u65e5\u671f", (String)"BudgetPerformMonitorFormPlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        EntryGrid performEntryGrid = (EntryGrid)this.getView().getControl(PERFORMBILLENTRY);
        performEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid contPerformEntryGrid = (EntryGrid)this.getView().getControl("contperformentry");
        contPerformEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid budgetEntryGrid = (EntryGrid)this.getView().getControl(BUDGETENTRY);
        budgetEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        if (StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)arg0.getFieldName())) {
            this.beforeOrgSelect(arg0);
        } else if (StringUtils.equals((CharSequence)PROJECT_FIELD_ID, (CharSequence)arg0.getFieldName())) {
            this.beforeProjectSelect(arg0);
        } else if (StringUtils.equals((CharSequence)PROJECT_FIELD_NAME, (CharSequence)arg0.getFieldName())) {
            this.beforeProjectSelect(arg0);
        }
    }

    protected void beforeProjectSelect(BeforeFilterF7SelectEvent arg0) {
        Set<Long> projectIdSet = this.loadProjectPerm();
        if (projectIdSet.size() > 0) {
            arg0.getQfilters().add(new QFilter("id", "in", projectIdSet));
        }
    }

    protected Set<Long> loadProjectPerm() {
        long userId = RequestContext.get().getCurrUserId();
        String billFormId = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        String orgIds = this.getPageCache().get(ORG_ID);
        List<Long> orgIdList = this.getOrgsByCacheString(orgIds);
        Set projectIds = StringUtils.isBlank((CharSequence)orgIds) || StringUtils.equals((CharSequence)"[]", (CharSequence)orgIds) ? ProjectTeamPermissionHelper.loadHasPermProjects((QFilter)this.getProjectStatusFilter(), (boolean)isTeamPerm, (boolean)Boolean.TRUE, (Long)userId, orgIdList, (String)appId, (String)billFormId) : ProjectTeamPermissionHelper.loadHasPermProjects((QFilter)this.getProjectStatusFilter(), (boolean)isTeamPerm, (boolean)Boolean.FALSE, (Long)userId, orgIdList, (String)appId, (String)billFormId);
        Set otherCloudProjectIdList = ProjectF7FilterHelper.getOtherCloudProjectIdList(orgIdList);
        projectIds.addAll(otherCloudProjectIdList);
        return projectIds;
    }

    protected QFilter getProjectStatusFilter() {
        return new QFilter("prostatus", "!=", (Object)FAILEDSTATUSID).and(new QFilter("prostatus", "!=", (Object)0L));
    }

    protected QFilter getOrgFilter() {
        String orgIds = this.getPageCache().get(ORG_ID);
        List<Long> orgIdList = this.getOrgsByCacheString(orgIds);
        return new QFilter("pmascreateorg", "in", orgIdList);
    }

    protected List<Long> getOrgsByCacheString(String orgIds) {
        String allOrgs = this.getPageCache().get(ALL_ORG_ID);
        if (orgIds == null) {
            String string = orgIds = allOrgs == null ? "" : allOrgs;
        }
        if (orgIds.contains("\"")) {
            orgIds = orgIds.replace("\"", "");
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        if (StringUtils.equals((CharSequence)"[]", (CharSequence)orgIds) && allOrgs != null) {
            orgIds = this.getPageCache().get(ALL_ORG_ID);
        }
        if (orgIds != null && orgIds.length() > 2) {
            String[] orgs;
            String substring = orgIds.substring(1, orgIds.length() - 1);
            for (String org : orgs = substring.split(",")) {
                orgList.add(Long.valueOf(org.trim()));
            }
        }
        return orgList;
    }

    protected void beforeOrgSelect(BeforeFilterF7SelectEvent arg0) {
        arg0.setRefEntityId(BOS_ORG);
        arg0.setRefPropKey("id");
        arg0.getQfilters().add(new QFilter("id", "in", this.getOrgsByCacheString(null)));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.initOrgFilterColumn(filterColumnList);
        this.initProjectFilterColumn(filterColumnList);
    }

    protected void initProjectFilterColumn(List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)PROJECT_FIELD_NAME, (CharSequence)fieldName)) continue;
            CommonFilterColumn projectFilterColumn = (CommonFilterColumn)filterColumn;
            this.setProjectComboItems(projectFilterColumn);
        }
    }

    protected void setProjectComboItems(CommonFilterColumn projectFilterColumn) {
        Set<Long> projectIds = this.loadProjectPerm();
        QFilter qFilter = new QFilter("id", "in", projectIds);
        List projectComboItems = BuildCommonFilterList.buildComboItem((String)"bd_project", (QFilter)qFilter);
        projectFilterColumn.setComboItems(projectComboItems);
        this.getPageCache().put(ALLPROJECTID, projectIds.toString());
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object projectId = parameter.getCustomParam("projectId");
        if (!StringUtils.isBlank((Object)projectId)) {
            String projectPKStr = ((Long)projectId).toString();
            projectFilterColumn.setDefaultValue(projectPKStr);
        } else if (!projectComboItems.isEmpty()) {
            projectFilterColumn.setDefaultValue(((ComboItem)projectComboItems.get(0)).getValue());
        } else {
            projectFilterColumn.setDefaultValue(null);
        }
    }

    protected void initOrgFilterColumn(List<FilterColumn> filterColumnList) {
        CommonFilterColumn orgColumn = this.buildOrgFilterColumn();
        if (!filterColumnList.contains(orgColumn)) {
            filterColumnList.add(0, (FilterColumn)orgColumn);
            HashSet<Long> hasPermOrgs = new HashSet<Long>();
            if (orgColumn.getComboItems() != null) {
                for (ComboItem item : orgColumn.getComboItems()) {
                    hasPermOrgs.add(Long.valueOf(item.getId()));
                }
            }
            this.getPageCache().put(ALL_ORG_ID, ((Object)hasPermOrgs).toString());
        }
    }

    protected CommonFilterColumn buildOrgFilterColumn() {
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setKey(ORG_FIELD_NAME);
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"BudgetPerformMonitorFormPlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])));
        orgColumn.setFieldName(ORG_FIELD_NAME);
        orgColumn.setMustInput(false);
        orgColumn.setMulti(false);
        List<ComboItem> combos = this.buildOrgComboItems();
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        return orgColumn;
    }

    protected List<ComboItem> buildOrgComboItems() {
        ORM orm;
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getAppId(), (String)"pmas_projectbudgetperform", (String)"47150e89000000ac");
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = permOrgResult.hasAllOrgPerm();
        DynamicObjectCollection col = null;
        if (hasAllOrgPerm) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        } else if (!hasPermOrgs.isEmpty()) {
            orm = ORM.create();
            col = orm.query(BOS_ORG, ID_NAME, new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)});
        }
        if (col != null && !col.isEmpty()) {
            for (DynamicObject org : col) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getPkValue()));
                item.setCaption(new LocaleString(org.getString("name")));
                item.setValue(String.valueOf(org.getPkValue()));
                combos.add(item);
            }
        }
        cacheString = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return combos;
    }

    protected String getAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return appId == null ? "pmsc" : appId;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.putOrgValuesInCache(args);
        this.rebuildProjectFilterColumn();
        super.filterContainerSearchClick(args);
    }

    protected void rebuildProjectFilterColumn() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        List items = filterGridView.getItems();
        for (Control item : items) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)item;
            String fieldName = commonFilterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)PROJECT_FIELD_NAME)) continue;
            this.setProjectComboItems(commonFilterColumn);
        }
    }

    protected void putOrgValuesInCache(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        for (int i = 0; i < customFiterList.size(); ++i) {
            List orgIds;
            Map customFiter = (Map)customFiterList.get(i);
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)((String)fieldNames.get(0))) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.isEmpty()) continue;
            this.getPageCache().put(ORG_ID, orgIds.toString());
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.removeOrgFilterAndUpdateProjectValue(e);
        List qFilters = e.getQFilters();
        this.loadData(qFilters);
        super.setFilter(e);
    }

    protected void loadData(List<QFilter> qFilters) {
        this.getModel().deleteEntryData(PERFORMBILLENTRY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"contperformentry", PERFORMBILLENTRY});
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"incomeamount", "remainincomeamt", "actualinrate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"remindamt", "controlamt", "performamt", "actualpayamount", "remainamt", "remainrate"});
        }
        this.getModel().deleteEntryData(BUDGETENTRY);
        if (!qFilters.isEmpty()) {
            List orgList = new ArrayList<Long>(16);
            Iterator<QFilter> iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter filter = iterator.next();
                String cp = filter.getCP();
                this.getPageCache().put(FILTERNAME, cp);
                String property = filter.getProperty();
                if (!StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)property) && !StringUtils.equals((CharSequence)"org.name", (CharSequence)property)) continue;
                iterator.remove();
                if (filter.getValue() instanceof ArrayList) {
                    orgList = (List)filter.getValue();
                    continue;
                }
                orgList.add(Long.parseLong(filter.getValue().toString()));
            }
            DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity(BUDGETENTRY);
            String cpName = this.getPageCache().get(FILTERNAME);
            if (cpName.equals("=")) {
                DynamicObject[] budgets = null;
                if (payDirection != null) {
                    this.getPageCache().put(PAYDIRECTION, payDirection);
                    qFilters.add(new QFilter("sourcetype", "=", (Object)payDirection));
                    budgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"name, description, siamount, viamount, budgetamount, vichangeamount, budgetitem, sourcetype, project, parent, currency, sequence, remindrate, controlrate, remainrate, remindamt, controlamt, preoccupyamt, occupyamt, performamt, remainamt, contcurrency, org, contractcurrency,actualamt", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"sequence asc");
                } else {
                    qFilters.add(new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue()));
                    budgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"name, description, siamount, viamount, budgetamount, vichangeamount, budgetitem, sourcetype, project, parent, currency, sequence, remindrate, controlrate, remainrate, remindamt, controlamt, preoccupyamt, occupyamt, performamt, remainamt, contcurrency, org, contractcurrency,actualamt", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"sequence asc");
                }
                String projectId = this.getPageCache().get(PROJECTFILTERID);
                if (StringUtils.isNotEmpty((CharSequence)projectId) && !orgList.isEmpty()) {
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)ID_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))});
                    DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "org", "department", "syscreateorg", "accountorg", "createorg"), (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    if (proApp != null) {
                        List<Long> projectOrgList = Arrays.asList(Long.parseLong(proApp.getDynamicObject("org").getPkValue().toString()), Long.parseLong(proApp.getDynamicObject("department").getPkValue().toString()), Long.parseLong(proApp.getDynamicObject("syscreateorg").getPkValue().toString()), Long.parseLong(proApp.getDynamicObject("accountorg").getPkValue().toString()), Long.parseLong(proApp.getDynamicObject("createorg").getPkValue().toString()));
                        orgList.retainAll(projectOrgList);
                        if (orgList.isEmpty()) {
                            budgets = null;
                        }
                    }
                }
                if (budgets != null && budgets.length > 0) {
                    DynamicObject firstRow = this.buildTotalRow(budgetEntryEntity);
                    budgetEntryEntity.add((Object)firstRow);
                    DynamicObject[] totalBudgets = this.findAllBudgets(budgets, null);
                    Set<Long> parentIdSet = this.getAllParents(totalBudgets);
                    DynamicObjectType dt = budgetEntryEntity.getDynamicObjectType();
                    for (DynamicObject budget : budgets) {
                        budgetEntryEntity.add((Object)this.buildBudgetEntry(budget, dt, parentIdSet));
                    }
                    firstRow.set(BUDGETCURRENCY, ((DynamicObject)budgetEntryEntity.get(1)).get(BUDGETCURRENCY));
                }
                this.mergeBudgetEntryDataToRow(budgetEntryEntity);
                this.getModel().updateEntryCache(budgetEntryEntity);
            }
        }
        this.getView().updateView(BUDGETENTRY);
    }

    protected DynamicObject buildTotalRow(DynamicObjectCollection budgetEntryEntity) {
        DynamicObject[] project;
        DynamicObject firstRow = new DynamicObject(budgetEntryEntity.getDynamicObjectType());
        firstRow.set("id", (Object)"1");
        firstRow.set("pid", (Object)"0");
        firstRow.set("name", (Object)ResManager.loadKDString((String)"\u603b\u9884\u7b97", (String)"BudgetPerformMonitorFormPlugin_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        String projectId = this.getPageCache().get(PROJECTFILTERID);
        String projectName = this.getPageCache().get(PROJECTFILTERNAME);
        if (projectName != null) {
            firstRow.set("name", (Object)String.format(ResManager.loadKDString((String)"%s\u603b\u9884\u7b97", (String)"BudgetPerformMonitorFormPlugin_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectName));
        } else if (projectId != null && (project = BusinessDataServiceHelper.load((String)"bd_project", (String)ID_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))})) != null && project.length > 0) {
            firstRow.set("name", (Object)String.format(ResManager.loadKDString((String)"%s\u603b\u9884\u7b97", (String)"BudgetPerformMonitorFormPlugin_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), project[0].getString("name")));
        }
        return firstRow;
    }

    protected void mergeBudgetEntryDataToRow(DynamicObjectCollection budgetEntryEntity) {
        if (budgetEntryEntity.isEmpty()) {
            return;
        }
        BigDecimal totalBudgetAmt = BigDecimal.ZERO;
        BigDecimal totalPreOccupyAmt = BigDecimal.ZERO;
        BigDecimal totalOccupyAmt = BigDecimal.ZERO;
        BigDecimal totalPerformAmt = BigDecimal.ZERO;
        BigDecimal totalRemainAmt = BigDecimal.ZERO;
        BigDecimal totalActualPayAmt = BigDecimal.ZERO;
        BigDecimal totalActualIncomeAmt = BigDecimal.ZERO;
        BigDecimal totalRemainActualIncomeAmt = BigDecimal.ZERO;
        for (DynamicObject rowEntity : budgetEntryEntity) {
            if (!StringUtils.equals((CharSequence)rowEntity.getString("pid"), (CharSequence)"0") || StringUtils.equals((CharSequence)rowEntity.getString("id"), (CharSequence)"1")) continue;
            totalBudgetAmt = totalBudgetAmt.add(rowEntity.getBigDecimal("budgetamount"));
            totalPreOccupyAmt = totalPreOccupyAmt.add(rowEntity.getBigDecimal("preoccupyamt"));
            totalOccupyAmt = totalOccupyAmt.add(rowEntity.getBigDecimal("occupyamt"));
            totalPerformAmt = totalPerformAmt.add(rowEntity.getBigDecimal("performamt"));
            totalRemainAmt = totalRemainAmt.add(rowEntity.getBigDecimal("remainamt"));
            totalActualPayAmt = totalActualPayAmt.add(rowEntity.getBigDecimal("actualpayamount"));
            totalActualIncomeAmt = totalActualIncomeAmt.add(rowEntity.getBigDecimal("incomeamount"));
            totalRemainActualIncomeAmt = totalRemainActualIncomeAmt.add(rowEntity.getBigDecimal("remainincomeamt"));
        }
        DynamicObject firstEntry = (DynamicObject)budgetEntryEntity.get(0);
        firstEntry.set("budgetamount", (Object)totalBudgetAmt);
        firstEntry.set("preoccupyamt", (Object)totalPreOccupyAmt);
        firstEntry.set("occupyamt", (Object)totalOccupyAmt);
        firstEntry.set("performamt", (Object)totalPerformAmt);
        firstEntry.set("remainamt", (Object)totalRemainAmt);
        firstEntry.set("actualpayamount", (Object)totalActualPayAmt);
        firstEntry.set("incomeamount", (Object)totalActualIncomeAmt);
        firstEntry.set("remainincomeamt", (Object)totalRemainActualIncomeAmt);
        BigDecimal remainRate = BigDecimal.ZERO;
        BigDecimal actualInRate = BigDecimal.ZERO;
        if (totalBudgetAmt.compareTo(BigDecimal.ZERO) != 0) {
            remainRate = totalRemainAmt.divide(totalBudgetAmt, 10, RoundingMode.HALF_UP);
            actualInRate = totalActualIncomeAmt.divide(totalBudgetAmt, 10, RoundingMode.HALF_UP);
        }
        firstEntry.set("remainrate", (Object)remainRate);
        firstEntry.set("actualinrate", (Object)actualInRate);
    }

    protected Set<Long> getAllParents(DynamicObject[] totalBudgets) {
        HashSet<Long> parentIdSet = new HashSet<Long>(16);
        for (DynamicObject budget : totalBudgets) {
            long parentId = budget.getLong("parent");
            if (budget.get("parent") == null || parentId == 0L) continue;
            parentIdSet.add(parentId);
        }
        return parentIdSet;
    }

    protected DynamicObject[] findAllBudgets(DynamicObject[] budgets, Set<Long> loadIdSet) {
        if (loadIdSet == null) {
            loadIdSet = new HashSet<Long>(budgets.length);
        }
        HashSet<Long> parentIdSet = new HashSet<Long>(budgets.length);
        for (DynamicObject budget : budgets) {
            long parentId = budget.getLong("parent");
            if (budget.get("parent") != null && parentId != 0L) {
                parentIdSet.add(parentId);
            }
            loadIdSet.add(budget.getLong("id"));
        }
        parentIdSet.removeAll(loadIdSet);
        if (!parentIdSet.isEmpty()) {
            DynamicObject[] parentBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"name, description, siamount, viamount, budgetamount, vichangeamount, budgetitem, sourcetype, project, parent, currency, sequence, remindrate, controlrate, remainrate, remindamt, controlamt, preoccupyamt, occupyamt, performamt, remainamt, contcurrency, org, contractcurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", parentIdSet)});
            DynamicObject[] totalBudgets = new DynamicObject[budgets.length + parentBudgets.length];
            System.arraycopy(budgets, 0, totalBudgets, 0, budgets.length);
            System.arraycopy(parentBudgets, 0, totalBudgets, budgets.length, parentBudgets.length);
            return this.findAllBudgets(totalBudgets, loadIdSet);
        }
        return budgets;
    }

    protected DynamicObject buildBudgetEntry(DynamicObject budget, DynamicObjectType dt, Set<Long> parentIdSet) {
        DynamicObject budgetEntry = new DynamicObject(dt);
        String payDirection = this.getPageCache().get(PAYDIRECTION);
        budgetEntry.set("id", budget.getPkValue());
        if (budget.get("parent") != null) {
            budgetEntry.set("pid", (Object)budget.getLong("parent"));
        }
        budgetEntry.set("name", budget.get("name"));
        BigDecimal budgetAmount = budget.getBigDecimal("budgetamount");
        budgetEntry.set("budgetamount", (Object)budgetAmount);
        budgetEntry.set("remindamt", budget.get("remindamt"));
        budgetEntry.set("controlamt", budget.get("controlamt"));
        budgetEntry.set("preoccupyamt", budget.get("preoccupyamt"));
        budgetEntry.set("occupyamt", budget.get("occupyamt"));
        budgetEntry.set("performamt", budget.get("performamt"));
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue())) {
            budgetEntry.set("actualpayamount", (Object)budget.getBigDecimal("actualamt"));
            BigDecimal remainAmt = budgetAmount.subtract(budget.getBigDecimal("occupyamt"));
            budgetEntry.set("remainamt", (Object)remainAmt);
            if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
                budgetEntry.set("remainrate", (Object)remainAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP));
            }
        } else {
            BigDecimal actualAmt = budget.getBigDecimal("actualamt");
            budgetEntry.set("incomeamount", (Object)actualAmt);
            budgetEntry.set("remainincomeamt", (Object)budgetAmount.subtract(actualAmt));
            if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
                budgetEntry.set("actualinrate", (Object)actualAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP));
            }
        }
        budgetEntry.set(BUDGETCURRENCY, budget.get("currency"));
        if (!parentIdSet.contains(budget.getLong("id"))) {
            budgetEntry.set("checkbill", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"BudgetPerformMonitorFormPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        return budgetEntry;
    }

    protected void removeOrgFilterAndUpdateProjectValue(SetFilterEvent e) {
        this.getPageCache().remove(PROJECTFILTERID);
        this.getPageCache().remove(PROJECTFILTERNAME);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            Object projectName;
            String proName;
            QFilter filter = (QFilter)iterator.next();
            String cp = filter.getCP();
            this.getPageCache().put(FILTERNAME, cp);
            String property = filter.getProperty();
            if (StringUtils.equals((CharSequence)PROJECT_FIELD_ID, (CharSequence)property)) {
                Object projectId = filter.getValue();
                String projectStr = projectId == null ? "" : projectId.toString();
                if (projectStr.trim().isEmpty()) continue;
                String allProjectId = this.getPageCache().get(ALLPROJECTID);
                if (allProjectId == null || !allProjectId.contains(projectStr)) {
                    iterator.remove();
                    continue;
                }
                this.getPageCache().put(PROJECTFILTERID, projectStr);
                continue;
            }
            if (!StringUtils.equals((CharSequence)PROJECT_FIELD_ID, (CharSequence)property) && !StringUtils.equals((CharSequence)PROJECT_FIELD_NAME, (CharSequence)property) || (proName = (projectName = filter.getValue()) != null ? projectName.toString() : null) == null || proName.trim().isEmpty()) continue;
            this.getPageCache().put(PROJECTFILTERNAME, proName);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"exportexcel")) {
            this.exportExcel();
        }
    }

    private String[] getSheets() {
        if (this.sheets == null) {
            String isNew = this.getPageCache().get("isNew");
            this.sheets = StringUtils.isNotEmpty((CharSequence)isNew) && Boolean.parseBoolean(isNew) ? new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u6267\u884c\u76d1\u63a7\u6570\u636e", (String)"BudgetPerformMonitorFormPlugin_41", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])} : new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u6267\u884c\u76d1\u63a7\u6570\u636e", (String)"BudgetPerformMonitorFormPlugin_41", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u9884\u7b97\u6570\u636e", (String)"BudgetPerformMonitorFormPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u9879\u6267\u884c\u8bb0\u5f55", (String)"BudgetPerformMonitorFormPlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
        }
        return this.sheets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcel() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(BUDGETENTRY);
        if (entryEntity == null || entryEntity.size() < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a\u3002", (String)"BudgetPerformMonitorFormPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String firstRowName = ((DynamicObject)entryEntity.get(0)).getString("name");
        String projectName = firstRowName != null && firstRowName.length() > 3 ? firstRowName.substring(0, firstRowName.length() - 3) : ResManager.loadKDString((String)"\u9879\u76ee", (String)"BudgetPerformMonitorFormPlugin_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
        String payDirection = this.getPageCache().get(PAYDIRECTION);
        String fileName = StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue()) ? String.format(ResManager.loadKDString((String)"%s\u652f\u51fa\u9884\u7b97\u6267\u884c\u76d1\u63a7.xls", (String)"BudgetPerformMonitorFormPlugin_38", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectName) : String.format(ResManager.loadKDString((String)"%s\u6536\u5165\u9884\u7b97\u6267\u884c\u76d1\u63a7.xls", (String)"BudgetPerformMonitorFormPlugin_39", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectName);
        HSSFWorkbook wb = new HSSFWorkbook();
        String[] sheets = this.getSheets();
        ArrayList<String[]> headerList = new ArrayList<String[]>();
        ArrayList<String[]> columnList = new ArrayList<String[]>();
        ArrayList<JSONArray> jsonDataList = new ArrayList<JSONArray>();
        this.initProBudgetExcelData(headerList, columnList, jsonDataList);
        for (int i = 0; i < sheets.length; ++i) {
            BudgetPerformMonitorFormPlugin.fillSheet(sheets[i], (String[])headerList.get(i), (String[])columnList.get(i), (JSONArray)jsonDataList.get(i), wb);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        PermCheckParam permCheckParam = new PermCheckParam(url, this.getFormId(), this.getView().getFormShowParameter().getAppId(), "47150e89000000ac");
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        this.getView().download(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"BudgetPerformMonitorFormPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public String getFormId() {
        return "pmas_projectbudgetperform";
    }

    protected void initProBudgetExcelData(List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList) {
        DynamicObject[] budgetPerforms;
        DynamicObject currency;
        DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity(BUDGETENTRY);
        JSONArray jsonArray = new JSONArray();
        HashSet<DynamicObject> detailBudgetRowSet = new HashSet<DynamicObject>(budgetEntryEntity.size());
        Tree tree = this.buildTree(budgetEntryEntity);
        List treeNodeList = tree.getList();
        BigDecimal oneHundred = new BigDecimal("100");
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TreeNode node = (TreeNode)treeNodeList.get(i);
            StringBuilder blank = new StringBuilder();
            int level = node.getLevel();
            while (--level > 0) {
                blank.append("    ");
            }
            DynamicObject budgetEntryRow = node.getData();
            JSONObject jsonObject = new JSONObject();
            currency = budgetEntryRow.getDynamicObject(BUDGETCURRENCY);
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            String checkBill = budgetEntryRow.getString("checkbill");
            if (StringUtils.isNotEmpty((CharSequence)checkBill)) {
                detailBudgetRowSet.add(budgetEntryRow);
            }
            jsonObject.put(this.proBudgetColumnKeys[0], (Object)String.format("%s%s", blank, budgetEntryRow.getString("name")));
            jsonObject.put(this.proBudgetColumnKeys[1], (Object)budgetEntryRow.getBigDecimal("budgetamount").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[2], (Object)budgetEntryRow.getBigDecimal("remindamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[3], (Object)budgetEntryRow.getBigDecimal("controlamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[4], (Object)budgetEntryRow.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[5], (Object)budgetEntryRow.getBigDecimal("performamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[6], (Object)budgetEntryRow.getBigDecimal("actualpayamount").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[7], (Object)budgetEntryRow.getBigDecimal("remainamt").setScale(precision, RoundingMode.HALF_UP));
            BigDecimal remainRate = budgetEntryRow.getBigDecimal("remainrate").multiply(oneHundred);
            jsonObject.put(this.proBudgetColumnKeys[8], (Object)remainRate.setScale(2, RoundingMode.HALF_UP));
            jsonArray.add((Object)jsonObject);
        }
        headerList.add(this.proBudgetHeaders);
        columnList.add(this.proBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        for (DynamicObject detailBudgetRow : detailBudgetRowSet) {
            DynamicObject currency2 = detailBudgetRow.getDynamicObject(BUDGETCURRENCY);
            int precision = currency2 == null ? 10 : currency2.getInt("amtprecision");
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", detailBudgetRow.getPkValue());
            DynamicObject[] contBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt,actualsubmitamt,actualauditamt,projectcurrency", (QFilter[])new QFilter[]{budgetItemFilter});
            HashSet<Object> contractIdSet = new HashSet<Object>(contBudgets.length);
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                contractIdSet.add(contract.getPkValue());
            }
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contracttpl"));
            HashMap<Object, Object> contractMap = new HashMap<Object, Object>(contracts.length);
            for (DynamicObject dynamicObject : contracts) {
                contractMap.put(dynamicObject.getPkValue(), dynamicObject);
            }
            for (DynamicObject dynamicObject : contBudgets) {
                DynamicObject contract = dynamicObject.getDynamicObject("contract");
                if (contract == null) continue;
                JSONObject jsonObject = new JSONObject();
                contract = (DynamicObject)contractMap.get(contract.getPkValue());
                jsonObject.put(this.contBudgetColumnKeys[0], (Object)detailBudgetRow.getString("name"));
                jsonObject.put(this.contBudgetColumnKeys[1], contract.get("billno"));
                jsonObject.put(this.contBudgetColumnKeys[2], contract.get("billname"));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)contract.get("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(this.contBudgetColumnKeys[3], (Object)statusEnum.getName());
                }
                jsonObject.put(this.contBudgetColumnKeys[4], (Object)dynamicObject.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[5], (Object)dynamicObject.getBigDecimal("contractsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[6], (Object)dynamicObject.getBigDecimal("settlesubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[7], (Object)dynamicObject.getBigDecimal("payapplysubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[8], (Object)dynamicObject.getBigDecimal("actualsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(this.contBudgetHeaders);
        columnList.add(this.contBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        Set detailBudgetRowIdSet = detailBudgetRowSet.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        for (DynamicObject budgetPerform : budgetPerforms = BusinessDataServiceHelper.load((Object[])detailBudgetRowIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudgetperform"))) {
            currency = budgetPerform.getDynamicObject("currency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntryObj : performEntry) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(this.budgetRecordColumnKeys[0], budgetPerform.get("name"));
                DynamicObject dynamicObject = performEntryObj.getDynamicObject("contract");
                if (dynamicObject != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[1], dynamicObject.get("billno"));
                    jsonObject.put(this.budgetRecordColumnKeys[2], dynamicObject.get("billname"));
                }
                if (performEntryObj.getDynamicObject("billtype") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[3], (Object)performEntryObj.getDynamicObject("billtype").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[4], (Object)performEntryObj.getString("billno"));
                jsonObject.put(this.budgetRecordColumnKeys[5], (Object)performEntryObj.getString("billname"));
                jsonObject.put(this.budgetRecordColumnKeys[6], (Object)performEntryObj.getBigDecimal("billamt").setScale(precision, RoundingMode.HALF_UP));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)performEntryObj.getString("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[7], (Object)statusEnum.getName());
                }
                if (performEntryObj.getDynamicObject("billcreator") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[8], (Object)performEntryObj.getDynamicObject("billcreator").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[9], (Object)performEntryObj.getDate("billcreatedate"));
                if (performEntryObj.getDynamicObject("billauditor") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[10], (Object)performEntryObj.getDynamicObject("billauditor").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[11], (Object)performEntryObj.getDate("billauditdate"));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(this.budgetRecordHeaders);
        columnList.add(this.budgetRecordColumnKeys);
        jsonDataList.add(jsonArray);
    }

    public Tree buildTree(DynamicObjectCollection budgetEntryEntity) {
        ArrayList<TreeNode> nodesList = new ArrayList<TreeNode>(budgetEntryEntity.size());
        for (int i = 1; i < budgetEntryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)budgetEntryEntity.get(i);
            String id = row.getString("id");
            String pid = row.getString("pid");
            nodesList.add(new TreeNode(id, pid, "", row));
        }
        return Tree.buildTreeByPid(nodesList);
    }

    protected static void fillSheet(String sheetName, String[] header, String[] columnKey, JSONArray data, HSSFWorkbook wb) {
        HSSFSheet sheet = wb.createSheet(sheetName);
        Row valueRow = sheet.createRow(0);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell valueCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            valueCell = valueRow.createCell(i);
            valueCell.setCellValue(header[i]);
            valueCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle contentCellStyle = wb.createCellStyle();
        HSSFDataFormat dataFormat = wb.createDataFormat();
        contentCellStyle.setDataFormat(dataFormat.getFormat("@"));
        contentCellStyle.setBorderTop(BorderStyle.THIN);
        contentCellStyle.setBorderLeft(BorderStyle.THIN);
        contentCellStyle.setBorderRight(BorderStyle.THIN);
        contentCellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                valueRow = sheet.createRow(i + 1);
                for (int j = 0; j < columnKey.length; ++j) {
                    valueCell = valueRow.createCell(j);
                    valueCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    valueCell.setCellStyle((CellStyle)contentCellStyle);
                }
            }
        }
    }

    protected DynamicObject buildPerformEntry(DynamicObject performEntryObj, DynamicObjectType dynamicObjectType, DynamicObject currency) {
        DynamicObject billType = performEntryObj.getDynamicObject("billtype");
        if (performEntryObj.getBoolean("performtype") || billType != null && billType.getString("number").equals("pmct_applymentpay")) {
            DynamicObject budgetEntry = new DynamicObject(dynamicObjectType);
            budgetEntry.set("id", performEntryObj.getPkValue());
            budgetEntry.set("billtype", (Object)billType);
            budgetEntry.set("billno", (Object)performEntryObj.getString("billno"));
            budgetEntry.set("billname", (Object)performEntryObj.getString("billname"));
            budgetEntry.set("billamt", (Object)performEntryObj.getBigDecimal("billamt"));
            budgetEntry.set("billstatus", (Object)performEntryObj.getString("billstatus"));
            budgetEntry.set("billcreator", (Object)performEntryObj.getDynamicObject("billcreator"));
            budgetEntry.set("billcreatedate", (Object)performEntryObj.getDate("billcreatedate"));
            budgetEntry.set("billauditor", (Object)performEntryObj.getDynamicObject("billauditor"));
            budgetEntry.set("billauditdate", (Object)performEntryObj.getDate("billauditdate"));
            budgetEntry.set("billid", (Object)performEntryObj.getLong("billid"));
            if (currency != null) {
                budgetEntry.set(BILLCURRENCY, (Object)currency);
            }
            return budgetEntry;
        }
        return null;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        switch (fieldName) {
            case "billno": {
                this.billNoHyperLinkClick(rowIndex);
                break;
            }
            case "checkbill": {
                this.checkBillHyperLinkClick(rowIndex);
                break;
            }
            case "contractsubmitamt": 
            case "settlesubmitamt": 
            case "applysubmitamt": 
            case "paysubmitamt": 
            case "occupyamount": 
            case "reqfundsubmitamt": 
            case "actualinsubmitamt": 
            case "contcostsplitamt": {
                this.amountHyperLinkClick(rowIndex, fieldName);
                break;
            }
            case "contbillno": {
                this.contBillNoHyperLinkClick(rowIndex);
                break;
            }
        }
    }

    protected void checkBillHyperLinkClick(int rowIndex) {
        this.getModel().deleteEntryData("contperformentry");
        this.getPageCache().remove(AMOUNTRECORD);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(BUDGETENTRY, rowIndex);
        String checkBillId = this.getPageCache().get(CHECKBILLID);
        if (StringUtils.equals((CharSequence)checkBillId, (CharSequence)rowEntity.getPkValue().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contperformentry", PERFORMBILLENTRY});
            this.getPageCache().remove(CHECKBILLID);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contperformentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{PERFORMBILLENTRY});
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", rowEntity.getPkValue());
            DynamicObject[] contBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt,actualsubmitamt,actualauditamt,projectcurrency", (QFilter[])new QFilter[]{budgetItemFilter});
            HashSet<Object> contractIdSet = new HashSet<Object>(contBudgets.length);
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                contractIdSet.add(contract.getPkValue());
            }
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contracttpl"));
            HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(contracts.length);
            for (DynamicObject contract : contracts) {
                contractMap.put(contract.getPkValue(), contract);
            }
            String payDirection = this.getPageCache().get(PAYDIRECTION);
            if (StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"reqfundsubmitamt", "reqfundauditamt", "actualinsubmitamt", "actualinauditamt"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"applysubmitamt", "applyauditamt", "paysubmitamt", "payauditamt"});
            }
            DynamicObjectCollection contPerformEntry = this.getModel().getEntryEntity("contperformentry");
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                DynamicObject contPerformEntryObj = contPerformEntry.addNew();
                contract = (DynamicObject)contractMap.get(contract.getPkValue());
                contPerformEntryObj.set("id", contBudget.getPkValue());
                contPerformEntryObj.set("contbillno", contract.get("billno"));
                contPerformEntryObj.set("contbillname", contract.get("billname"));
                String formId = StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue()) ? "pmct_outcontract" : "pmct_incontract";
                QFilter filter = new QFilter("number", "=", (Object)formId);
                DynamicObject objectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"", (QFilter[])new QFilter[]{filter});
                contPerformEntryObj.set("contbilltype", (Object)objectType);
                contPerformEntryObj.set("contbillstatus", contract.get("billstatus"));
                contPerformEntryObj.set("occupyamount", contBudget.get("occupyamt"));
                contPerformEntryObj.set("contractsubmitamt", contBudget.get("contractsubmitamt"));
                contPerformEntryObj.set("contractauditamt", contBudget.get("contractauditamt"));
                contPerformEntryObj.set("settlesubmitamt", contBudget.get("settlesubmitamt"));
                contPerformEntryObj.set("settleauditamt", contBudget.get("settleauditamt"));
                if (StringUtils.equals((CharSequence)payDirection, (CharSequence)BudgetSourceTypeEnum.OUT.getValue())) {
                    contPerformEntryObj.set("applysubmitamt", contBudget.get("payapplysubmitamt"));
                    contPerformEntryObj.set("applyauditamt", contBudget.get("payapplyauditamt"));
                    contPerformEntryObj.set("paysubmitamt", contBudget.get("actualsubmitamt"));
                    contPerformEntryObj.set("payauditamt", contBudget.get("actualauditamt"));
                } else {
                    contPerformEntryObj.set("reqfundsubmitamt", contBudget.get("payapplysubmitamt"));
                    contPerformEntryObj.set("reqfundauditamt", contBudget.get("payapplyauditamt"));
                    contPerformEntryObj.set("actualinsubmitamt", contBudget.get("actualsubmitamt"));
                    contPerformEntryObj.set("actualinauditamt", contBudget.get("actualauditamt"));
                }
                contPerformEntryObj.set("procurrency", contBudget.get("projectcurrency"));
                contPerformEntryObj.set("contractid", (Object)contract.getPkValue().toString());
                contPerformEntryObj.set("probudgetid", (Object)rowEntity.getPkValue().toString());
            }
            budgetItemFilter = new QFilter("id", "=", rowEntity.getPkValue());
            DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"currency, , performentry.billid, performentry.billno, performentry.billname, performentry.billtype, performentry.billstatus, performentry.performamttype, performentry.billamtoncont", (QFilter[])new QFilter[]{budgetItemFilter});
            for (DynamicObject otherBillBudget : projectBudget.getDynamicObjectCollection("performentry")) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)otherBillBudget.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) continue;
                DynamicObject contPerformEntryObj = contPerformEntry.addNew();
                contPerformEntryObj.set("id", otherBillBudget.getPkValue());
                contPerformEntryObj.set("contractid", otherBillBudget.get("billid"));
                contPerformEntryObj.set("contbillno", otherBillBudget.get("billno"));
                contPerformEntryObj.set("contbillname", otherBillBudget.get("billname"));
                contPerformEntryObj.set("contbilltype", otherBillBudget.get("billtype"));
                contPerformEntryObj.set("contbillstatus", otherBillBudget.get("billstatus"));
                contPerformEntryObj.set("procurrency", projectBudget.get("currency"));
                contPerformEntryObj.set("occupyamount", otherBillBudget.get("billamtoncont"));
                contPerformEntryObj.set("probudgetid", (Object)rowEntity.getPkValue().toString());
            }
            this.getModel().updateEntryCache(contPerformEntry);
            this.getView().updateView("contperformentry");
            this.getPageCache().put(CHECKBILLID, rowEntity.getPkValue().toString());
        }
    }

    protected void amountHyperLinkClick(int rowIndex, String columnName) {
        this.getModel().deleteEntryData(PERFORMBILLENTRY);
        String amountColumnRow = this.getPageCache().get(AMOUNTRECORD);
        String performAmtType = null;
        if (StringUtils.equals((CharSequence)columnName, (CharSequence)"contractsubmitamt")) {
            performAmtType = PerformAmountTypeEnum.CONTRACT.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"settlesubmitamt")) {
            performAmtType = PerformAmountTypeEnum.SETTLE.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"applysubmitamt")) {
            performAmtType = PerformAmountTypeEnum.PAY.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"paysubmitamt")) {
            performAmtType = PerformAmountTypeEnum.ACTUAL_PAY.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"reqfundsubmitamt")) {
            performAmtType = PerformAmountTypeEnum.INCOME.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"actualinsubmitamt")) {
            performAmtType = PerformAmountTypeEnum.ACTUAL_INCOME.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"occupyamount")) {
            performAmtType = "";
        }
        String amountColumnValue = String.format("%s%s", columnName, rowIndex);
        if (StringUtils.equals((CharSequence)amountColumnRow, (CharSequence)amountColumnValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PERFORMBILLENTRY});
            this.getPageCache().remove(AMOUNTRECORD);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PERFORMBILLENTRY});
            String proBudgetId = (String)this.getModel().getValue("probudgetid", rowIndex);
            String contractId = (String)this.getModel().getValue("contractid", rowIndex);
            this.getPageCache().put(SELECTED_CONTRACTID, contractId);
            DynamicObject budgetPerform = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(proBudgetId), (String)"pmas_projectbudgetperform");
            if (budgetPerform != null) {
                DynamicObject proCurrency = budgetPerform.getDynamicObject("currency");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PERFORMBILLENTRY);
                DynamicObjectType dt = entryEntity.getDynamicObjectType();
                if (entryEntity != null) {
                    DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
                    for (DynamicObject performEntryObj : performEntry) {
                        DynamicObject performEntryObject = this.buildPerformBillEntry(performEntryObj, dt, proCurrency, performAmtType);
                        if (performEntryObject == null) continue;
                        entryEntity.add((Object)performEntryObject);
                    }
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView(PERFORMBILLENTRY);
                }
            }
            this.getPageCache().put(AMOUNTRECORD, amountColumnValue);
        }
    }

    protected DynamicObject buildPerformBillEntry(DynamicObject performEntryObj, DynamicObjectType dt, DynamicObject proCurrency, String performAmtType) {
        DynamicObject budgetEntry = null;
        String billId = this.getPageCache().get(SELECTED_CONTRACTID);
        DynamicObject contract = performEntryObj.getDynamicObject("contract");
        String curPerformAmtType = performEntryObj.getString("performamttype");
        if (contract != null) {
            if (StringUtils.equals((CharSequence)contract.getString("id"), (CharSequence)billId) && (StringUtils.equals((CharSequence)"", (CharSequence)performAmtType) || StringUtils.equals((CharSequence)curPerformAmtType, (CharSequence)performAmtType))) {
                budgetEntry = OutBudgetReportHelper.buildBudgetEntry((DynamicObject)performEntryObj, (DynamicObjectType)dt, (DynamicObject)proCurrency);
            }
        } else {
            Long relateBillId = performEntryObj.getLong("billid");
            if (StringUtils.isNotEmpty((CharSequence)billId) && relateBillId.equals(Long.parseLong(billId)) && StringUtils.equalsIgnoreCase((CharSequence)performEntryObj.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) {
                budgetEntry = OutBudgetReportHelper.buildBudgetEntry((DynamicObject)performEntryObj, (DynamicObjectType)dt, (DynamicObject)proCurrency);
            }
        }
        return budgetEntry;
    }

    protected void checkBill(int rowIndex) {
        this.getModel().deleteEntryData(PERFORMBILLENTRY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(BUDGETENTRY, rowIndex);
        String checkBillId = this.getPageCache().get(CHECKBILLID);
        if (StringUtils.equals((CharSequence)checkBillId, (CharSequence)rowEntity.getPkValue().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PERFORMBILLENTRY});
            this.getPageCache().remove(CHECKBILLID);
        } else {
            DynamicObject budgetPerform;
            this.getView().setVisible(Boolean.TRUE, new String[]{PERFORMBILLENTRY});
            if (rowIndex != 0 && (budgetPerform = BusinessDataServiceHelper.loadSingle((Object)rowEntity.getPkValue(), (String)"pmas_projectbudgetperform")) != null) {
                DynamicObject currency = budgetPerform.getDynamicObject("currency");
                DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PERFORMBILLENTRY);
                if (entryEntity != null) {
                    for (DynamicObject performEntryObj : performEntry) {
                        DynamicObject performEntryObject = this.buildPerformEntry(performEntryObj, entryEntity.getDynamicObjectType(), currency);
                        if (performEntryObject == null) continue;
                        entryEntity.add((Object)performEntryObject);
                    }
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView(PERFORMBILLENTRY);
                }
            }
            this.getPageCache().put(CHECKBILLID, rowEntity.getPkValue().toString());
        }
    }

    protected void billNoHyperLinkClick(int rowIndex) {
        Object billId = this.getModel().getValue("billid", rowIndex);
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", rowIndex);
        String formId = billType.getString("number");
        BillShowParameter showParam = OpenPageUtils.buildBillShowParam((Object)billId, (String)formId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    protected void contBillNoHyperLinkClick(int rowIndex) {
        DynamicObject contBillType = (DynamicObject)this.getModel().getValue("contbilltype", rowIndex);
        Object contractId = this.getModel().getValue("contractid", rowIndex);
        BillShowParameter showParam = OpenPageUtils.buildBillShowParam((Object)contractId, (String)contBillType.getString("number"));
        this.getView().showForm((FormShowParameter)showParam);
    }
}

