/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import kd.pmgt.pmbs.common.utils.OpenPageUtils;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ContBudgetPerformMonitor
extends AbstractPmbsListPlugin
implements BeforeFilterF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ContBudgetPerformMonitor.class);
    private String[] contBudgetColumnKeys = new String[]{"contractNo", "contractName", "probudget", "pronumber", "project", "occupyamount", "contractsubmitamt", "settlesubmitamt", "applysubmitamt"};
    String[] contBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"ContBudgetPerformMonitor_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"ContBudgetPerformMonitor_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"ContBudgetPerformMonitor_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801", (String)"ContBudgetPerformMonitor_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"ContBudgetPerformMonitor_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u5408\u540c\u5df2\u5360\u7528\u9884\u7b97\u91d1\u989d", (String)"ContBudgetPerformMonitor_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContBudgetPerformMonitor_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContBudgetPerformMonitor_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContBudgetPerformMonitor_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private String[] budgetRecordColumnKeys = new String[]{"probudget", "billtype", "billno", "billname", "billproamt", "billcontamt", "billstatus", "billcreator", "billcreatedate", "billauditor", "billauditdate"};
    String[] budgetRecordHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879", (String)"ContBudgetPerformMonitor_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b", (String)"ContBudgetPerformMonitor_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"ContBudgetPerformMonitor_15", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"ContBudgetPerformMonitor_16", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\uff08\u9879\u76ee\u5e01\uff09", (String)"ContBudgetPerformMonitor_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\uff08\u5408\u540c\u7b7e\u7ea6\u5e01\uff09", (String)"ContBudgetPerformMonitor_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"ContBudgetPerformMonitor_19", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"ContBudgetPerformMonitor_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"ContBudgetPerformMonitor_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"ContBudgetPerformMonitor_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u65e5\u671f", (String)"ContBudgetPerformMonitor_23", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private static final String ORG_FIELD_ID = "org.id";
    private static final String ORG_FIELD_NAME = "org.name";
    private static final String PROJECT_FIELD_ID = "project.id";
    private static final String PROJECT_FIELD_NAME = "project.name";
    private static final String CONTRACT_FIELD_ID = "contract.id";
    private static final String CONTRACT_FIELD_NAME = "contract.billname";
    private static final String BOS_ORG = "bos_org";
    private static final String SELECTED_ORGID = "selectedorgid";
    private static final String SELECTED_PROJECTID = "selectedprojectid";
    private static final String SELECTED_CONTRACTID = "selectedcontractid";
    private static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    private static final String CACHEKEY_PROJECTCOMBOITEMS = "projectcomboitems";
    private static final String CACHEKEY_CONTCOMBOITEMS = "contractcomboitems";
    private static final String ALL_ORG_ID = "allorgid";
    private static final String ALL_PROJECT_ID = "allprojectid";
    private static final String CUR_ALL_PROJECT_ID = "curallprojectid";
    private static final String CUR_ALL_CONTRACT_ID = "curallcontractid";
    private static final String BUDGETPERFORM_ENTRY = "budgetperformentry";
    private static final String PERFORMBILL_ENTRY = "performbillentry";
    private static final String AMOUNTRECORD = "amountrecord";
    String[] sheets = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid budgetPerformEntryGrid = (EntryGrid)this.getView().getControl(BUDGETPERFORM_ENTRY);
        budgetPerformEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid performEntryGrid = (EntryGrid)this.getView().getControl(PERFORMBILL_ENTRY);
        performEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            String orgIdCache;
            String fieldName = filterColumn.getFieldName();
            if (StringUtils.equals((CharSequence)ORG_FIELD_NAME, (CharSequence)fieldName)) {
                CommonFilterColumn orgFilterColumn = (CommonFilterColumn)filterColumn;
                this.setOrgComboItems(orgFilterColumn);
                continue;
            }
            if (StringUtils.equals((CharSequence)PROJECT_FIELD_NAME, (CharSequence)fieldName)) {
                CommonFilterColumn projectFilterColumn = (CommonFilterColumn)filterColumn;
                orgIdCache = this.getPageCache().get(SELECTED_ORGID);
                if (StringUtils.isEmpty((CharSequence)orgIdCache)) {
                    this.setProjectComboItems(projectFilterColumn);
                    continue;
                }
                this.rebuildProjectComboItems(projectFilterColumn);
                continue;
            }
            if (!StringUtils.equals((CharSequence)CONTRACT_FIELD_NAME, (CharSequence)fieldName)) continue;
            CommonFilterColumn contractFilterColumn = (CommonFilterColumn)filterColumn;
            orgIdCache = this.getPageCache().get(SELECTED_ORGID);
            String proIdCache = this.getPageCache().get(SELECTED_PROJECTID);
            if (StringUtils.isEmpty((CharSequence)orgIdCache) && StringUtils.isEmpty((CharSequence)proIdCache)) {
                this.setContractComboItems(contractFilterColumn);
                continue;
            }
            this.rebuildContractComboItems(contractFilterColumn);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getSearchClickEvent().getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        List fieldNames = (List)currentCommonFilter.get("FieldName");
        if (fieldNames == null || fieldNames.isEmpty()) {
            return;
        }
        if (StringUtils.equals((CharSequence)ORG_FIELD_ID, (CharSequence)((String)fieldNames.get(0)))) {
            this.resetOrgFilterColumn(args, (List)currentCommonFilter.get("Value"));
        } else if (StringUtils.equals((CharSequence)PROJECT_FIELD_ID, (CharSequence)((String)fieldNames.get(0)))) {
            this.resetProjectFilterColumn(args, (List)currentCommonFilter.get("Value"));
        } else if (StringUtils.equals((CharSequence)CONTRACT_FIELD_ID, (CharSequence)((String)fieldNames.get(0)))) {
            this.resetContractFilterColumn(args, (List)currentCommonFilter.get("Value"));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (ORG_FIELD_ID.equals(fieldName) || ORG_FIELD_NAME.equals(fieldName)) {
            String allOrgIdStr = this.getPageCache().get(ALL_ORG_ID);
            Set orgIdSet = (Set)JSON.parseObject((String)allOrgIdStr, (TypeReference)new TypeReference<HashSet<Object>>(){}, (Feature[])new Feature[0]);
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgIdSet));
        } else if (PROJECT_FIELD_ID.equals(fieldName) || PROJECT_FIELD_NAME.equals(fieldName)) {
            String curAllProIdStr = this.getPageCache().get(CUR_ALL_PROJECT_ID);
            Set proIdSet = (Set)JSON.parseObject((String)curAllProIdStr, (TypeReference)new TypeReference<HashSet<Object>>(){}, (Feature[])new Feature[0]);
            args.addCustomQFilter(new QFilter("id", "in", (Object)proIdSet));
        } else if (CONTRACT_FIELD_ID.equals(fieldName) || "contract.name".equals(fieldName)) {
            String curAllContIdStr = this.getPageCache().get(CUR_ALL_CONTRACT_ID);
            Set contIdSet = (Set)JSON.parseObject((String)curAllContIdStr, (TypeReference)new TypeReference<HashSet<Object>>(){}, (Feature[])new Feature[0]);
            args.addCustomQFilter(new QFilter("id", "in", (Object)contIdSet));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rebuildContainerFilter(qFilters);
        this.loadData(qFilters);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"exportexcel")) {
            this.exportExcel();
        }
    }

    private String[] getSheets() {
        if (this.sheets == null) {
            this.sheets = new String[]{ResManager.loadKDString((String)"\u5408\u540c\u9884\u7b97\u9879\u6267\u884c\u76d1\u63a7", (String)"ContBudgetPerformMonitor_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u9879\u4f7f\u7528\u8bb0\u5f55", (String)"ContBudgetPerformMonitor_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
        }
        return this.sheets;
    }

    public void exportExcel() {
        Calendar cal = Calendar.getInstance();
        int y = cal.get(1);
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        String fileName = String.format(ResManager.loadKDString((String)"\u5408\u540c\u9884\u7b97\u9879\u6267\u884c\u76d1\u63a7\u5217\u8868_%1$s%2$s%3$s.xls", (String)"ContBudgetPerformMonitor_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), y, m, d);
        HSSFWorkbook wb = new HSSFWorkbook();
        String[] sheets = this.getSheets();
        ArrayList<String[]> headerList = new ArrayList<String[]>();
        ArrayList<String[]> columnList = new ArrayList<String[]>();
        ArrayList<JSONArray> jsonDataList = new ArrayList<JSONArray>();
        this.initContBudgetExcelData(headerList, columnList, jsonDataList);
        for (int i = 0; i < sheets.length; ++i) {
            if (headerList.isEmpty()) continue;
            ContBudgetPerformMonitor.fillSheet(sheets[i], (String[])headerList.get(i), (String[])columnList.get(i), (JSONArray)jsonDataList.get(i), wb);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        PermCheckParam permCheckParam = new PermCheckParam(url, "pmbs_contbudgetperform", formShowParameter.getAppId(), "47150e89000000ac");
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        this.getView().download(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ContBudgetPerformMonitor_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    private void initContBudgetExcelData(List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList) {
        DynamicObject[] budgetPerforms;
        DynamicObject proApproval;
        String contractId = this.getPageCache().get(SELECTED_CONTRACTID);
        if (StringUtils.isEmpty((CharSequence)contractId)) {
            return;
        }
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"billno,billname,project,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(contractId))});
        DynamicObject project = contract.getDynamicObject("project");
        DynamicObject proCurrency = null;
        if (project != null && (proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null) {
            proCurrency = proApproval.getDynamicObject("currencyfield");
        }
        int proPrecision = proCurrency == null ? 10 : proCurrency.getInt("amtprecision");
        DynamicObject contCurrency = contract.getDynamicObject("currency");
        int contPrecision = contCurrency == null ? 10 : contCurrency.getInt("amtprecision");
        JSONArray jsonArray = new JSONArray();
        DynamicObjectCollection budgetPerformEntry = this.getModel().getEntryEntity(BUDGETPERFORM_ENTRY);
        HashSet<Object> proBudgetSet = new HashSet<Object>(budgetPerformEntry.size());
        for (int i = 0; i < budgetPerformEntry.size(); ++i) {
            DynamicObject budgetPerformEntryRow = (DynamicObject)budgetPerformEntry.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(this.contBudgetColumnKeys[0], (Object)contract.getString("billno"));
            jsonObject.put(this.contBudgetColumnKeys[1], (Object)contract.getString("billname"));
            DynamicObject proBudget = budgetPerformEntryRow.getDynamicObject("probudget");
            if (proBudget != null) {
                jsonObject.put(this.contBudgetColumnKeys[2], (Object)proBudget.getString("name"));
                proBudgetSet.add(proBudget.getPkValue());
                if (QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)proBudget.getPkValue())) {
                    proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudget.getPkValue(), (String)"pmas_projectbudget");
                    DynamicObject budGetProject = proBudget.getDynamicObject("project");
                    jsonObject.put(this.contBudgetColumnKeys[3], (Object)budGetProject.getString("name"));
                    jsonObject.put(this.contBudgetColumnKeys[4], (Object)budGetProject.getString("number"));
                }
            }
            jsonObject.put(this.contBudgetColumnKeys[5], (Object)budgetPerformEntryRow.getBigDecimal("occupyamount").setScale(proPrecision, RoundingMode.HALF_UP));
            jsonObject.put(this.contBudgetColumnKeys[6], (Object)budgetPerformEntryRow.getBigDecimal("contractsubmitamt").setScale(proPrecision, RoundingMode.HALF_UP));
            jsonObject.put(this.contBudgetColumnKeys[7], (Object)budgetPerformEntryRow.getBigDecimal("settlesubmitamt").setScale(proPrecision, RoundingMode.HALF_UP));
            jsonObject.put(this.contBudgetColumnKeys[8], (Object)budgetPerformEntryRow.getBigDecimal("applysubmitamt").setScale(proPrecision, RoundingMode.HALF_UP));
            jsonArray.add((Object)jsonObject);
        }
        headerList.add(this.contBudgetHeaders);
        columnList.add(this.contBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        for (DynamicObject budgetPerform : budgetPerforms = BusinessDataServiceHelper.load((Object[])proBudgetSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudgetperform"))) {
            if (budgetPerform == null) continue;
            DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntryObj : performEntry) {
                if (contract == null || !StringUtils.equals((CharSequence)contract.getString("id"), (CharSequence)contractId)) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(this.budgetRecordColumnKeys[0], (Object)budgetPerform.getString("name"));
                if (performEntryObj.getDynamicObject("billtype") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[1], (Object)performEntryObj.getDynamicObject("billtype").getLocaleString("name").getLocaleValue());
                }
                jsonObject.put(this.budgetRecordColumnKeys[2], (Object)performEntryObj.getString("billno"));
                jsonObject.put(this.budgetRecordColumnKeys[3], (Object)performEntryObj.getString("billname"));
                jsonObject.put(this.budgetRecordColumnKeys[4], (Object)performEntryObj.getBigDecimal("billamt").setScale(proPrecision, RoundingMode.HALF_UP));
                jsonObject.put(this.budgetRecordColumnKeys[5], (Object)performEntryObj.getBigDecimal("billamtoncont").setScale(contPrecision, RoundingMode.HALF_UP));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)performEntryObj.getString("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[6], (Object)statusEnum.getName());
                }
                if (performEntryObj.getDynamicObject("billcreator") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[7], (Object)performEntryObj.getDynamicObject("billcreator").getLocaleString("name").getLocaleValue());
                }
                jsonObject.put(this.budgetRecordColumnKeys[8], (Object)performEntryObj.getDate("billcreatedate"));
                if (performEntryObj.getDynamicObject("billauditor") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[9], (Object)performEntryObj.getDynamicObject("billauditor").getLocaleString("name").getLocaleValue());
                }
                jsonObject.put(this.budgetRecordColumnKeys[10], (Object)performEntryObj.getDate("billauditdate"));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(this.budgetRecordHeaders);
        columnList.add(this.budgetRecordColumnKeys);
        jsonDataList.add(jsonArray);
    }

    private static void fillSheet(String sheetName, String[] header, String[] columnKey, JSONArray data, HSSFWorkbook wb) {
        HSSFSheet sheet = wb.createSheet(sheetName);
        Row valueRow = sheet.createRow(0);
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell valueCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            valueCell = valueRow.createCell(i);
            valueCell.setCellValue(header[i]);
            valueCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle contentCellStyle = wb.createCellStyle();
        contentCellStyle.setBorderTop(BorderStyle.THIN);
        contentCellStyle.setBorderLeft(BorderStyle.THIN);
        contentCellStyle.setBorderRight(BorderStyle.THIN);
        contentCellStyle.setBorderBottom(BorderStyle.THIN);
        HSSFDataFormat dataFormat = wb.createDataFormat();
        contentCellStyle.setDataFormat(dataFormat.getFormat("@"));
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                valueRow = sheet.createRow(i + 1);
                for (int j = 0; j < columnKey.length; ++j) {
                    valueCell = valueRow.createCell(j);
                    valueCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    valueCell.setCellStyle((CellStyle)contentCellStyle);
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "probudget": 
            case "contractsubmitamt": 
            case "settlesubmitamt": 
            case "applysubmitamt": {
                this.amountHyperLinkClick(rowIndex, fieldName);
                break;
            }
            case "billno": {
                this.billNoHyperLinkClick(rowIndex);
            }
        }
    }

    protected void amountHyperLinkClick(int rowIndex, String columnName) {
        this.getModel().deleteEntryData(PERFORMBILL_ENTRY);
        DynamicObject proBudget = (DynamicObject)this.getModel().getValue("probudget", rowIndex);
        String amountColumnRow = this.getPageCache().get(AMOUNTRECORD);
        String performAmtType = null;
        if (StringUtils.equals((CharSequence)columnName, (CharSequence)"contractsubmitamt")) {
            performAmtType = PerformAmountTypeEnum.CONTRACT.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"settlesubmitamt")) {
            performAmtType = PerformAmountTypeEnum.SETTLE.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"applysubmitamt")) {
            performAmtType = PerformAmountTypeEnum.PAY.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"probudget")) {
            performAmtType = "";
        }
        String amountColumnValue = String.format("%s%s", columnName, rowIndex);
        if (StringUtils.equals((CharSequence)amountColumnRow, (CharSequence)amountColumnValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PERFORMBILL_ENTRY});
            this.getPageCache().remove(AMOUNTRECORD);
        } else {
            DynamicObject budgetPerform;
            this.getView().setVisible(Boolean.TRUE, new String[]{PERFORMBILL_ENTRY});
            if (proBudget != null && (budgetPerform = BusinessDataServiceHelper.loadSingle((Object)proBudget.getPkValue(), (String)"pmas_projectbudgetperform")) != null) {
                DynamicObject proCurrency = budgetPerform.getDynamicObject("currency");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PERFORMBILL_ENTRY);
                DynamicObjectType dt = entryEntity.getDynamicObjectType();
                if (entryEntity != null) {
                    DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
                    for (DynamicObject performEntryObj : performEntry) {
                        DynamicObject performEntryObject = this.buildPerformBillEntry(performEntryObj, dt, proCurrency, performAmtType);
                        if (performEntryObject == null) continue;
                        entryEntity.add((Object)performEntryObject);
                    }
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView(PERFORMBILL_ENTRY);
                }
            }
            this.getPageCache().put(AMOUNTRECORD, amountColumnValue);
        }
    }

    protected DynamicObject buildPerformBillEntry(DynamicObject performEntryObj, DynamicObjectType dynamicObjectType, DynamicObject proCurrency, String performAmtType) {
        String contractId = this.getPageCache().get(SELECTED_CONTRACTID);
        DynamicObject contract = performEntryObj.getDynamicObject("contract");
        String curPerformAmtType = performEntryObj.getString("performamttype");
        if (contract != null && StringUtils.equals((CharSequence)contract.getString("id"), (CharSequence)contractId) && (StringUtils.equals((CharSequence)"", (CharSequence)performAmtType) || StringUtils.equals((CharSequence)curPerformAmtType, (CharSequence)performAmtType))) {
            DynamicObject budgetEntry = new DynamicObject(dynamicObjectType);
            budgetEntry.set("id", performEntryObj.getPkValue());
            budgetEntry.set("performtype", performEntryObj.get("performtype"));
            budgetEntry.set("billtype", (Object)performEntryObj.getDynamicObject("billtype"));
            budgetEntry.set("billno", (Object)performEntryObj.getString("billno"));
            budgetEntry.set("billname", (Object)performEntryObj.getString("billname"));
            budgetEntry.set("billproamt", (Object)performEntryObj.getBigDecimal("billamt"));
            budgetEntry.set("billcontamt", (Object)performEntryObj.getBigDecimal("billamtoncont"));
            budgetEntry.set("billstatus", (Object)performEntryObj.getString("billstatus"));
            budgetEntry.set("billcreator", (Object)performEntryObj.getDynamicObject("billcreator"));
            budgetEntry.set("billcreatedate", (Object)performEntryObj.getDate("billcreatedate"));
            budgetEntry.set("billauditor", (Object)performEntryObj.getDynamicObject("billauditor"));
            budgetEntry.set("billauditdate", (Object)performEntryObj.getDate("billauditdate"));
            budgetEntry.set("performamttype", (Object)performEntryObj.getString("performamttype"));
            budgetEntry.set("billid", (Object)performEntryObj.getLong("billid"));
            if (proCurrency != null) {
                budgetEntry.set("procurrency", (Object)proCurrency);
            }
            return budgetEntry;
        }
        return null;
    }

    protected void billNoHyperLinkClick(int rowIndex) {
        Object billId = this.getModel().getValue("billid", rowIndex);
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", rowIndex);
        String formId = billType.getString("number");
        BillShowParameter showParam = OpenPageUtils.buildBillShowParam((Object)billId, (String)formId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    protected void setOrgComboItems(CommonFilterColumn orgFilterColumn) {
        ORM orm;
        String orgsCombosCache = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)orgsCombosCache)) {
            List combos = SerializationUtils.fromJsonStringToList((String)orgsCombosCache, ComboItem.class);
            orgFilterColumn.setComboItems(combos);
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getAppId(), (String)"pmas_projectbudgetperform", (String)"47150e89000000ac");
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = permOrgResult.hasAllOrgPerm();
        DynamicObjectCollection orgColl = null;
        if (hasAllOrgPerm) {
            orm = ORM.create();
            orgColl = orm.query(BOS_ORG, "id,name", new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        } else if (!hasPermOrgs.isEmpty()) {
            orm = ORM.create();
            orgColl = orm.query(BOS_ORG, "id,name", new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)});
        }
        HashSet<Object> hasPermOrgSet = new HashSet<Object>();
        if (orgColl != null && !orgColl.isEmpty()) {
            for (DynamicObject org : orgColl) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getPkValue()));
                item.setCaption(new LocaleString(org.getString("name")));
                item.setValue(String.valueOf(org.getPkValue()));
                combos.add(item);
                hasPermOrgSet.add(org.getPkValue());
            }
        }
        orgFilterColumn.setComboItems(combos);
        orgsCombosCache = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, orgsCombosCache);
        this.getPageCache().put(ALL_ORG_ID, JSON.toJSONString(hasPermOrgSet));
    }

    protected String getAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return appId == null ? "pmsc" : appId;
    }

    protected void setProjectComboItems(CommonFilterColumn projectFilterColumn) {
        String proCombosCache = this.getPageCache().get(CACHEKEY_PROJECTCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)proCombosCache)) {
            List combos = SerializationUtils.fromJsonStringToList((String)proCombosCache, ComboItem.class);
            projectFilterColumn.setComboItems(combos);
            return;
        }
        Set<Long> projectIds = this.loadProjectPerm();
        QFilter qFilter = new QFilter("id", "in", projectIds);
        List projectComboItems = BuildCommonFilterList.buildComboItem((String)"bd_project", (QFilter)qFilter);
        projectFilterColumn.setComboItems(projectComboItems);
        String cacheString = SerializationUtils.toJsonString((Object)projectComboItems);
        this.getPageCache().put(CACHEKEY_PROJECTCOMBOITEMS, cacheString);
        this.getPageCache().put(ALL_PROJECT_ID, JSON.toJSONString(projectIds));
        this.getPageCache().put(CUR_ALL_PROJECT_ID, JSON.toJSONString(projectIds));
    }

    protected void rebuildProjectComboItems(CommonFilterColumn projectFilterColumn) {
        Set<Long> projectIds = this.loadProjectPerm();
        QFilter qFilter = new QFilter("id", "in", projectIds);
        List projectComboItems = BuildCommonFilterList.buildComboItem((String)"bd_project", (QFilter)qFilter);
        projectFilterColumn.setComboItems(projectComboItems);
        this.getPageCache().put(CUR_ALL_PROJECT_ID, JSON.toJSONString(projectIds));
    }

    protected Set<Long> loadProjectPerm() {
        long userId = RequestContext.get().getCurrUserId();
        String billFormId = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        String orgIds = this.getPageCache().get(SELECTED_ORGID);
        List<Long> orgIdList = this.getOrgsByCacheString(orgIds);
        Set projectIds = StringUtils.isBlank((CharSequence)orgIds) ? ProjectTeamPermissionHelper.loadHasPermProjects((QFilter)this.getProjectStatusFilter(), (boolean)isTeamPerm, (boolean)Boolean.TRUE, (Long)userId, orgIdList, (String)appId, (String)billFormId) : ProjectTeamPermissionHelper.loadHasPermProjects((QFilter)this.getProjectStatusFilter(), (boolean)isTeamPerm, (boolean)Boolean.FALSE, (Long)userId, orgIdList, (String)appId, (String)billFormId);
        Set otherCloudProjectIdList = ProjectF7FilterHelper.getOtherCloudProjectIdList(orgIdList);
        projectIds.addAll(otherCloudProjectIdList);
        return projectIds;
    }

    protected void setContractComboItems(CommonFilterColumn contractFilterColumn) {
        String contCombosCache = this.getPageCache().get(CACHEKEY_CONTCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)contCombosCache)) {
            List combos = SerializationUtils.fromJsonStringToList((String)contCombosCache, ComboItem.class);
            contractFilterColumn.setComboItems(combos);
            return;
        }
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"billno, billname,createtime", (QFilter[])new QFilter[]{this.getAllPermProjectFilter(), this.getContractStatusFilter()}, (String)"createtime desc");
        contracts = this.getMultiPartSettleConByOrgOrPro(contracts);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(contracts.length);
        HashSet<Object> contractIdSet = new HashSet<Object>(contracts.length);
        for (DynamicObject contract : contracts) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(contract.getPkValue()));
            item.setCaption(new LocaleString(contract.getString("billno")));
            item.setValue(String.valueOf(contract.getPkValue()));
            combos.add(item);
            contractIdSet.add(contract.getPkValue());
        }
        this.getPageCache().put(CUR_ALL_CONTRACT_ID, JSON.toJSONString(contractIdSet));
        contractFilterColumn.setComboItems(combos);
        if (!combos.isEmpty()) {
            contractFilterColumn.setDefaultValue(((ComboItem)combos.get(0)).getValue());
            this.getView().getPageCache().put(SELECTED_CONTRACTID, ((ComboItem)combos.get(0)).getValue());
        } else {
            contractFilterColumn.setDefaultValue(null);
            this.getView().getPageCache().put(SELECTED_CONTRACTID, null);
        }
    }

    protected void rebuildContractComboItems(CommonFilterColumn contractFilterColumn) {
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"billno, billname,createtime", (QFilter[])new QFilter[]{this.getProjectFilter(), this.getContractStatusFilter()}, (String)"createtime desc");
        contracts = this.getMultiPartSettleConByOrgOrPro(contracts);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(contracts.length);
        HashSet<Object> contractIdSet = new HashSet<Object>(contracts.length);
        for (DynamicObject contract : contracts) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(contract.getPkValue()));
            item.setCaption(new LocaleString(contract.getString("billno")));
            item.setValue(String.valueOf(contract.getPkValue()));
            contractIdSet.add(contract.getPkValue());
            combos.add(item);
        }
        contractFilterColumn.setComboItems(combos);
        this.getPageCache().put(CUR_ALL_CONTRACT_ID, JSON.toJSONString(contractIdSet));
    }

    protected QFilter getProjectStatusFilter() {
        return new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
    }

    protected QFilter getProjectFilter() {
        String projectId = this.getPageCache().get(SELECTED_PROJECTID);
        List<Long> projectIdList = this.getProjectByCacheString(projectId);
        return new QFilter("project", "in", projectIdList);
    }

    protected DynamicObject[] getMultiPartSettleConByOrgOrPro(DynamicObject[] contracts) {
        String proIds;
        List<Long> projectsByCacheString;
        DynamicObject[] contractsByMultiByPro;
        Set<Object> contractIds = new HashSet(16);
        if (contracts.length > 0) {
            contractIds = Arrays.stream(contracts).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
        }
        if ((contractsByMultiByPro = ContractHelper.getMultiPartSettleContracts(projectsByCacheString = this.getProjectByCacheString(proIds = this.getPageCache().get(SELECTED_PROJECTID)))) != null && contractsByMultiByPro.length > 0) {
            Set contractIdsByMulti = Arrays.stream(contractsByMultiByPro).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toSet());
            contractIds.addAll(contractIdsByMulti);
        }
        if (contractIds.size() > 0) {
            contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"billno, billname,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIds)}, (String)"createtime desc");
        }
        return contracts;
    }

    protected QFilter getAllPermProjectFilter() {
        ArrayList<Long> projectIdList = new ArrayList<Long>();
        String allProjectIds = this.getPageCache().get(ALL_PROJECT_ID);
        if (allProjectIds != null && allProjectIds.length() > 2) {
            String[] projects;
            String subAllProjectIds = allProjectIds.substring(1, allProjectIds.length() - 1);
            for (String project : projects = subAllProjectIds.split(",")) {
                projectIdList.add(Long.valueOf(project.trim()));
            }
        }
        return new QFilter("project", "in", projectIdList);
    }

    protected QFilter getContractStatusFilter() {
        HashSet<String> billStatusSet = new HashSet<String>(4);
        billStatusSet.add(StatusEnum.UNCHECKED.getValue());
        billStatusSet.add(StatusEnum.CHECKED.getValue());
        return new QFilter("billstatus", "in", billStatusSet);
    }

    protected List<Long> getOrgsByCacheString(String orgIds) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        String allOrgs = this.getPageCache().get(ALL_ORG_ID);
        if (StringUtils.isNotEmpty((CharSequence)orgIds)) {
            orgList.add(Long.valueOf(orgIds));
            return orgList;
        }
        if (StringUtils.isEmpty((CharSequence)orgIds) && allOrgs != null) {
            orgIds = allOrgs;
        }
        if (orgIds != null && orgIds.length() > 2) {
            String[] orgs;
            String substring = orgIds.substring(1, orgIds.length() - 1);
            for (String org : orgs = substring.split(",")) {
                orgList.add(Long.valueOf(org.trim()));
            }
        }
        return orgList;
    }

    protected List<Long> getProjectByCacheString(String projectId) {
        ArrayList<Long> projectList = new ArrayList<Long>();
        String allProjectIds = this.getPageCache().get(CUR_ALL_PROJECT_ID);
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            projectList.add(Long.parseLong(projectId));
            return projectList;
        }
        if (allProjectIds != null && allProjectIds.length() > 2) {
            String[] projects;
            String subAllProjectIds = allProjectIds.substring(1, allProjectIds.length() - 1);
            for (String project : projects = subAllProjectIds.split(",")) {
                projectList.add(Long.valueOf(project.trim()));
            }
        }
        return projectList;
    }

    protected void resetOrgFilterColumn(FilterContainerSearchClickArgs args, List<Object> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String orgIdCache = this.getPageCache().get(SELECTED_ORGID);
        if (!StringUtils.equals((CharSequence)orgIdCache, (CharSequence)ids.get(0).toString())) {
            this.getPageCache().put(SELECTED_ORGID, ids.get(0).toString());
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
            List items = filterGridView.getItems();
            CommonFilterColumn proFilterColumn = (CommonFilterColumn)items.get(1);
            this.rebuildProjectComboItems(proFilterColumn);
            this.setFilterColumnValue(args, proFilterColumn, SELECTED_PROJECTID, PROJECT_FIELD_ID);
            CommonFilterColumn contFilterColumn = (CommonFilterColumn)items.get(2);
            this.rebuildContractComboItems(contFilterColumn);
            this.setFilterColumnValue(args, contFilterColumn, SELECTED_CONTRACTID, CONTRACT_FIELD_ID);
        }
    }

    protected void resetProjectFilterColumn(FilterContainerSearchClickArgs args, List<Object> ids) {
        args.getSearchClickEvent().getFilterValue(PROJECT_FIELD_ID);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String projectIdCache = this.getPageCache().get(SELECTED_PROJECTID);
        if (!StringUtils.equals((CharSequence)projectIdCache, (CharSequence)ids.get(0).toString())) {
            this.getPageCache().put(SELECTED_PROJECTID, ids.get(0).toString());
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
            List items = filterGridView.getItems();
            CommonFilterColumn proFilterColumn = (CommonFilterColumn)items.get(1);
            this.rebuildProjectComboItems(proFilterColumn);
            CommonFilterColumn contractFilterColumn = (CommonFilterColumn)items.get(2);
            this.rebuildContractComboItems(contractFilterColumn);
            this.setFilterColumnValue(args, contractFilterColumn, SELECTED_CONTRACTID, CONTRACT_FIELD_ID);
        }
    }

    private void setFilterColumnValue(FilterContainerSearchClickArgs args, CommonFilterColumn filterColumn, String selectedField, String filterFieldName) {
        List comboItems = filterColumn.getComboItems();
        String selectFieldIdValue = this.getPageCache().get(selectedField);
        if (!comboItems.isEmpty() && StringUtils.isNotEmpty((CharSequence)selectFieldIdValue)) {
            String curSelectedId;
            ComboItem selectedComboItem = null;
            for (ComboItem comboItem : comboItems) {
                if (selectFieldIdValue == null || !comboItem.getValue().equals(selectFieldIdValue)) continue;
                selectedComboItem = comboItem;
                break;
            }
            if (selectedComboItem == null) {
                if (StringUtils.equals((CharSequence)filterFieldName, (CharSequence)CONTRACT_FIELD_ID)) {
                    curSelectedId = ((ComboItem)comboItems.get(0)).getValue();
                    this.getPageCache().put(selectedField, curSelectedId);
                    this.resetFilterFieldValue(args, filterFieldName, curSelectedId);
                    filterColumn.setDefaultValue(curSelectedId);
                } else if (StringUtils.equals((CharSequence)filterFieldName, (CharSequence)PROJECT_FIELD_ID)) {
                    this.getPageCache().put(selectedField, null);
                    this.resetFilterFieldValue(args, filterFieldName, "");
                    filterColumn.setDefaultValue(null);
                }
            } else {
                curSelectedId = ((ComboItem)comboItems.get(0)).getValue();
                this.getPageCache().put(selectedField, curSelectedId);
                this.resetFilterFieldValue(args, filterFieldName, curSelectedId);
                filterColumn.setDefaultValue(curSelectedId);
            }
        } else if (!comboItems.isEmpty() && StringUtils.isEmpty((CharSequence)selectFieldIdValue)) {
            if (StringUtils.equals((CharSequence)filterFieldName, (CharSequence)CONTRACT_FIELD_ID)) {
                String curSelectedId = ((ComboItem)comboItems.get(0)).getValue();
                this.getPageCache().put(selectedField, curSelectedId);
                this.resetFilterFieldValue(args, filterFieldName, curSelectedId);
                filterColumn.setDefaultValue(curSelectedId);
            } else if (StringUtils.equals((CharSequence)filterFieldName, (CharSequence)PROJECT_FIELD_ID)) {
                this.resetFilterFieldValue(args, filterFieldName, "");
                this.getPageCache().put(selectedField, selectFieldIdValue);
                filterColumn.setDefaultValue(null);
            }
        } else {
            this.getPageCache().remove(selectedField);
        }
    }

    private void resetFilterFieldValue(FilterContainerSearchClickArgs args, String columnName, String fieldValue) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        for (int i = 0; i < customFiterList.size(); ++i) {
            Map customFiter = (Map)customFiterList.get(i);
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)columnName, (CharSequence)((String)fieldNames.get(0)))) continue;
            List contractIdValues = (List)customFiter.get("Value");
            contractIdValues.clear();
            contractIdValues.add(fieldValue);
            return;
        }
    }

    protected void resetContractFilterColumn(FilterContainerSearchClickArgs args, List<Object> contractIds) {
        if (contractIds == null || contractIds.isEmpty()) {
            return;
        }
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        List items = filterGridView.getItems();
        CommonFilterColumn proFilterColumn = (CommonFilterColumn)items.get(1);
        this.rebuildProjectComboItems(proFilterColumn);
        CommonFilterColumn contractFilterColumn = (CommonFilterColumn)items.get(2);
        this.rebuildContractComboItems(contractFilterColumn);
        this.getPageCache().put(SELECTED_CONTRACTID, contractIds.get(0).toString());
    }

    private void rebuildContainerFilter(List<QFilter> qFilters) {
        Iterator<QFilter> iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter filter = iterator.next();
            String property = filter.getProperty();
            if (StringUtils.equals((CharSequence)ORG_FIELD_ID, (CharSequence)property)) {
                iterator.remove();
                continue;
            }
            if (!StringUtils.equals((CharSequence)PROJECT_FIELD_ID, (CharSequence)property)) continue;
            iterator.remove();
        }
    }

    protected void loadData(List<QFilter> qFilters) {
        this.getModel().deleteEntryData(PERFORMBILL_ENTRY);
        this.getView().setVisible(Boolean.FALSE, new String[]{PERFORMBILL_ENTRY});
        this.getModel().deleteEntryData(BUDGETPERFORM_ENTRY);
        if (!qFilters.isEmpty()) {
            DynamicObjectCollection budgetPerformEntry = this.getModel().getEntryEntity(BUDGETPERFORM_ENTRY);
            DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"budgetitem,budgetitem.project,budgetitem.currency,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"budgetitem.sequence asc");
            String contractId = this.getPageCache().get(SELECTED_CONTRACTID);
            if (StringUtils.isEmpty((CharSequence)contractId)) {
                return;
            }
            Set budgetItemIdSet = Arrays.stream(contractBudgets).map(obj -> obj.getDynamicObject("budgetitem").getPkValue()).collect(Collectors.toSet());
            DynamicObject[] budgetPerforms = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"performentry", (QFilter[])new QFilter[]{new QFilter("id", "in", budgetItemIdSet)});
            HashSet<Object> notDetailBudgetIdSet = new HashSet<Object>(budgetPerforms.length);
            for (DynamicObject budgetPerform : budgetPerforms) {
                DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
                if (!performEntry.isEmpty()) continue;
                notDetailBudgetIdSet.add(budgetPerform.getPkValue());
            }
            if (contractBudgets.length > 0) {
                for (DynamicObject contractBudget : contractBudgets) {
                    DynamicObject budgetItem = contractBudget.getDynamicObject("budgetitem");
                    if (notDetailBudgetIdSet.contains(budgetItem.getPkValue())) continue;
                    DynamicObject budgetPerformEntryObj = budgetPerformEntry.addNew();
                    budgetPerformEntryObj.set("id", contractBudget.getPkValue());
                    budgetPerformEntryObj.set("probudget", (Object)budgetItem);
                    budgetPerformEntryObj.set("project", (Object)budgetItem.getDynamicObject("project"));
                    budgetPerformEntryObj.set("occupyamount", contractBudget.get("occupyamt"));
                    budgetPerformEntryObj.set("contractsubmitamt", contractBudget.get("contractsubmitamt"));
                    budgetPerformEntryObj.set("contractauditamt", contractBudget.get("contractauditamt"));
                    budgetPerformEntryObj.set("settlesubmitamt", contractBudget.get("settlesubmitamt"));
                    budgetPerformEntryObj.set("settleauditamt", contractBudget.get("settleauditamt"));
                    budgetPerformEntryObj.set("applysubmitamt", contractBudget.get("payapplysubmitamt"));
                    budgetPerformEntryObj.set("applyauditamt", contractBudget.get("payapplyauditamt"));
                    DynamicObject currency = budgetItem.getDynamicObject("currency");
                    if (currency == null || !QueryServiceHelper.exists((String)"bd_currency", (Object)currency.getPkValue())) continue;
                    currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
                    budgetPerformEntryObj.set("budgetprocurrency", (Object)currency);
                }
            }
            this.getModel().updateEntryCache(budgetPerformEntry);
        }
        this.getView().updateView(BUDGETPERFORM_ENTRY);
    }
}

