/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.ContractPayFeqEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.CtrlStrategyEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.ComboItemHelper;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.formplugin.AbstractContractItemBookPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractColItemBookPlugin
extends AbstractContractItemBookPlugin {
    private static final String TASKCOMPLETESTATUS = "taskcompletestatus";
    private static final String ISCOMPLETEFULLAPPLY = "iscompletefullapply";
    private static final String ISCOLLECTIONOFF = "iscollectionoff";
    private static final String ORG = "org";
    private static final String LAUNCHINCOMEAPPLY = "launchincomeapply";
    private static final String PUSHINCOMEAPPLY = "pushincomeapply";
    private static final String TRACKDOWNDATA = "trackdowndata";
    private static final String TRACKDOWN = "trackdown";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
        this.setBillListSelectRows(selectContractPayItem);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)LAUNCHINCOMEAPPLY)) {
            String controlKey;
            if (selectContractPayItem == null || selectContractPayItem.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractColItemBookPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                args.setCancel(false);
                return;
            }
            HashMap selectRowCheckMessages = new HashMap(selectContractPayItem.length);
            Map taskCompileMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])selectContractPayItem);
            HashMap<Long, DynamicObject> contractColItemIdMap = new HashMap<Long, DynamicObject>(selectContractPayItem.length);
            boolean hasStrongMessage = false;
            boolean hasWeakMessage = false;
            String WEAK = CtrlStrategyEnum.WEAK.getValue();
            String STRONG = CtrlStrategyEnum.STRONG.getValue();
            Date currentDate = DateUtil.getCurrentDate();
            for (int i = 0; i < selectContractPayItem.length; ++i) {
                Date collectectTime;
                DynamicObject tempContractColItem = selectContractPayItem[i];
                Long tempContractColItemId = tempContractColItem.getLong("id");
                DynamicObject contract = tempContractColItem.getDynamicObject("contract");
                if (contract == null) continue;
                contractColItemIdMap.put(tempContractColItemId, tempContractColItem);
                HashMap<String, StringBuilder> tipMessageMap = new HashMap<String, StringBuilder>(8);
                selectRowCheckMessages.put(tempContractColItemId, tipMessageMap);
                boolean taskStatus = this.getTaskStatus(taskCompileMap, tempContractColItem);
                boolean hasStrongControl = false;
                StringBuilder strongInfo = tipMessageMap.getOrDefault(STRONG, new StringBuilder());
                tipMessageMap.put(STRONG, strongInfo);
                boolean hasWeakControl = false;
                StringBuilder weakInfo = tipMessageMap.getOrDefault(WEAK, new StringBuilder());
                tipMessageMap.put(WEAK, weakInfo);
                if (!taskStatus) {
                    String ctrlStrategy = tempContractColItem.getString("ctrlstrategy");
                    if (StringUtils.equals((CharSequence)ctrlStrategy, (CharSequence)CtrlStrategyEnum.STRONG.getValue())) {
                        strongInfo.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d1\u8d77\u8bf7\u6b3e\u3002", (String)"ContractColItemBookPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        hasStrongControl = true;
                    } else if (StringUtils.equals((CharSequence)ctrlStrategy, (CharSequence)CtrlStrategyEnum.WEAK.getValue())) {
                        weakInfo.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u662f\u5426\u53d1\u8d77\u8bf7\u6b3e\uff1f", (String)"ContractColItemBookPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        hasWeakControl = true;
                    }
                }
                if ((collectectTime = tempContractColItem.getDate("plancollecttime")) != null && !hasStrongControl && DateUtil.compareByDay((Date)currentDate, (Date)collectectTime) < 0) {
                    weakInfo.append(ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u76ee\u8fd8\u672a\u5230\u671f\uff0c\u662f\u5426\u53d1\u8d77\u8bf7\u6b3e\uff1f", (String)"ContractColItemBookPlugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    hasWeakControl = true;
                }
                if (hasStrongControl) {
                    hasStrongMessage = true;
                }
                if (!hasWeakControl) continue;
                hasWeakMessage = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (hasStrongMessage) {
                controlKey = STRONG;
            } else if (hasWeakMessage) {
                controlKey = WEAK;
            } else {
                args.setCancel(false);
                this.getView().invokeOperation(PUSHINCOMEAPPLY);
                return;
            }
            for (Map.Entry rowCheckMessageEntry : selectRowCheckMessages.entrySet()) {
                Long key = (Long)rowCheckMessageEntry.getKey();
                Map messageEntryValue = (Map)rowCheckMessageEntry.getValue();
                StringBuilder messageBuilder = (StringBuilder)messageEntryValue.get(controlKey);
                if (StringUtils.isEmpty((CharSequence)messageBuilder)) continue;
                DynamicObject contractColItem = (DynamicObject)contractColItemIdMap.get(key);
                String payItemName = contractColItem.getString("name");
                stringBuilder.append(payItemName);
                stringBuilder.append(':');
                stringBuilder.append((CharSequence)messageBuilder);
                stringBuilder.append("\r\n");
            }
            if (hasStrongMessage) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u65e0\u6cd5\u4e0b\u63a8", (String)"ContractColItemBookPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), stringBuilder.toString(), MessageTypes.Default);
            } else if (hasWeakMessage) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"ContractColItemBookPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), stringBuilder.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            }
        }
    }

    @Override
    protected String getAllProperty() {
        return "masterid, status, billno, enable, customer, collecttype, collectfeq, collectway, collectpercent, currency, collectamount, plancollecttime, remarks, collectedamt, collectedcomamt, uncollectedamt, contract, sourcebilltype, autogenerated, creator, createtime, modifier, modifytime, sourcebill, paydirection, name, ctrlstrategy, nodesettingsource, nodesetting, appliedamt, appliedcomamt, appliableamt, iscompletefullapply, iscollectionoff, taskcompletestatus, org,paidamount,unpayamount";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtils.equals((CharSequence)LAUNCHINCOMEAPPLY, (CharSequence)(key = messageBoxClosedEvent.getCallBackId()))) {
            DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
            this.setBillListSelectRows(selectContractPayItem);
            this.getView().invokeOperation(PUSHINCOMEAPPLY);
        }
    }

    @Override
    protected boolean putContractPayItemToJsonObject(DynamicObject contractColItemEntry, JSONObject jsonObject) {
        String collectType = contractColItemEntry.getString("collecttype");
        String payTypeName = ContractPayTypeEnum.PREPAYMENT.getValue().equals(collectType) ? ComboItemHelper.getName((String)"pmbs_contractcolitembook", null, null, (String)"collecttype", (String)ContractPayTypeEnum.PRECOLLECTMENT.getValue()) : ComboItemHelper.getName((String)"pmbs_contractcolitembook", null, null, (String)"collecttype", (String)collectType);
        jsonObject.put("collecttype", (Object)payTypeName);
        DynamicObject currency = contractColItemEntry.getDynamicObject("currency");
        jsonObject.put("currency", (Object)(currency != null ? currency.getString("name") : ""));
        int precision = currency == null ? 10 : currency.getInt("amtprecision");
        jsonObject.put("collectamount", (Object)contractColItemEntry.getBigDecimal("collectamount").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliedamt", (Object)contractColItemEntry.getBigDecimal("appliedamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliedcomamt", (Object)contractColItemEntry.getBigDecimal("appliedcomamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliableamt", (Object)contractColItemEntry.getBigDecimal("appliableamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("paidamount", (Object)contractColItemEntry.getBigDecimal("paidamount").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("unpayamount", (Object)contractColItemEntry.getBigDecimal("unpayamount").setScale(precision, RoundingMode.HALF_UP));
        String taskCompileStatus = contractColItemEntry.getString(TASKCOMPLETESTATUS);
        TaskCompleteStateEnum taskComplileEnumByValue = TaskCompleteStateEnum.getEnumByValue((Object)taskCompileStatus);
        jsonObject.put(TASKCOMPLETESTATUS, (Object)(taskComplileEnumByValue != null ? taskComplileEnumByValue.getName() : ""));
        Date planTime = contractColItemEntry.getDate("plancollecttime");
        jsonObject.put("plancollecttime", (Object)(planTime != null ? DateUtil.formatShortDate((Date)planTime) : ""));
        DynamicObject nodeSetting = contractColItemEntry.getDynamicObject("nodesetting");
        jsonObject.put("nodesetting", (Object)(nodeSetting != null ? nodeSetting.getString("name") : ""));
        String ctrlStrategy = contractColItemEntry.getString("ctrlstrategy");
        CtrlStrategyEnum ctrlStrategyEnum = CtrlStrategyEnum.getEnumByValue((String)ctrlStrategy);
        jsonObject.put("ctrlstrategy", (Object)(ctrlStrategyEnum != null ? ctrlStrategyEnum.getName() : ""));
        String itemName = contractColItemEntry.getString("name");
        jsonObject.put("name", (Object)(itemName != null ? itemName : ""));
        DynamicObject contract = contractColItemEntry.getDynamicObject("contract");
        if (contract == null) {
            return false;
        }
        jsonObject.put("contract", (Object)contract.getString("billname"));
        DynamicObject contractStatus = contract.getDynamicObject("contractstatus");
        jsonObject.put("contractstatus", (Object)(contractStatus != null ? contractStatus.getString("name") : ""));
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        jsonObject.put("contracttype", (Object)(contractType != null ? contractType.getString("name") : ""));
        DynamicObject project = contract.getDynamicObject("project");
        jsonObject.put("contractproject", (Object)(project != null ? project.getString("name") : ""));
        DynamicObject pro = contractColItemEntry.getDynamicObject("project");
        if (pro != null) {
            DynamicObject proStatus = pro.getDynamicObject("prostatus");
            jsonObject.put("projectstatus", (Object)(proStatus != null ? proStatus.getString("name") : ""));
        } else {
            jsonObject.put("projectstatus", (Object)"");
        }
        DynamicObject org = contract.getDynamicObject(ORG);
        jsonObject.put(ORG, (Object)(org != null ? org.getString("name") : ""));
        String payFeq = contractColItemEntry.getString("collectfeq");
        ContractPayFeqEnum payFeqEnum = ContractPayFeqEnum.getEnumByValue((Object)payFeq);
        jsonObject.put("collectfeq", (Object)(payFeqEnum != null ? payFeqEnum.getName() : ""));
        DynamicObject payWay = contractColItemEntry.getDynamicObject("collectway");
        jsonObject.put("collectway", (Object)(payWay != null ? payWay.getString("name") : ""));
        BigDecimal payPercent = contractColItemEntry.getBigDecimal("collectpercent");
        jsonObject.put("collectpercent", (Object)payPercent.setScale(4, RoundingMode.HALF_UP));
        String remarks = contractColItemEntry.getString("remarks");
        jsonObject.put("remarks", (Object)String.valueOf(remarks));
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)TRACKDOWNDATA, (CharSequence)key)) {
            DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
            if (selectContractPayItem == null || selectContractPayItem.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractColItemBookPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            } else {
                this.setBillListSelectRows(selectContractPayItem);
                this.getView().invokeOperation(TRACKDOWN);
            }
        }
    }

    @Override
    protected void removeCustomControlFilter(SetFilterEvent e) {
        this.getPageCache().remove(ORG);
        this.getPageCache().remove(TASKCOMPLETESTATUS);
        this.getPageCache().remove(ISCOMPLETEFULLAPPLY);
        this.getPageCache().remove(ISCOLLECTIONOFF);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            String property = filter.getProperty();
            Object value = filter.getValue();
            if (StringUtils.equals((CharSequence)property, (CharSequence)TASKCOMPLETESTATUS)) {
                String taskCompleteStatus = value != null ? (String)value : null;
                this.getPageCache().put(TASKCOMPLETESTATUS, taskCompleteStatus);
                iterator.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)property, (CharSequence)ISCOMPLETEFULLAPPLY)) {
                String isComPleterFullApply = value != null ? (String)value : null;
                this.getPageCache().put(ISCOMPLETEFULLAPPLY, isComPleterFullApply);
                iterator.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)property, (CharSequence)ISCOLLECTIONOFF)) {
                String isPayOff = value != null ? (String)value : null;
                this.getPageCache().put(ISCOLLECTIONOFF, isPayOff);
                iterator.remove();
                continue;
            }
            if (!StringUtils.equals((CharSequence)property, (CharSequence)"org.id")) continue;
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            if (value instanceof List) {
                orgIds.addAll((List)value);
            } else if (value instanceof Integer) {
                orgIds.add(((Integer)value).longValue());
            } else if (value instanceof Long) {
                orgIds.add((Long)value);
            }
            this.getPageCache().put(ORG, SerializationUtils.toJsonString(orgIds));
            iterator.remove();
        }
    }

    @Override
    protected void fillContractPayItemEntry(DynamicObject tempContractPayItem, Map<Long, DynamicObject> projectMap, Map<String, Map<Object, String>> taskCompileMap, DynamicObject queryResult) {
        String taskStatus;
        Long contractPayItemId = queryResult.getLong("id");
        tempContractPayItem.set("id", (Object)contractPayItemId);
        DynamicObject contract = queryResult.getDynamicObject("contract");
        tempContractPayItem.set("contract", (Object)contract);
        tempContractPayItem.set("collecttype", queryResult.get("collecttype"));
        DynamicObject tempCurrency = queryResult.getDynamicObject("currency");
        tempContractPayItem.set("currency", (Object)tempCurrency);
        BigDecimal exChangeRate = BigDecimal.ONE;
        tempContractPayItem.set("stdcurrency", (Object)tempCurrency);
        if (contract.getBoolean("ismulticurrency")) {
            BigDecimal contractExChangeRate = contract.getBigDecimal("exchangerate");
            if (contractExChangeRate != null && contractExChangeRate.compareTo(BigDecimal.ZERO) != 0) {
                exChangeRate = contractExChangeRate;
            }
            tempContractPayItem.set("stdcurrency", (Object)contract.getDynamicObject("stdcurrency"));
        }
        tempContractPayItem.set("collectamount", queryResult.get("collectamount"));
        tempContractPayItem.set("stdcollectamount", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("collectamount")));
        tempContractPayItem.set("appliedamt", queryResult.get("appliedamt"));
        tempContractPayItem.set("stdappliedamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("appliedamt")));
        tempContractPayItem.set("appliedcomamt", queryResult.get("appliedcomamt"));
        tempContractPayItem.set("stdappliedcomamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("appliedcomamt")));
        BigDecimal applyAbleAmt = NumberHelper.subtract((Object)queryResult.get("collectamount"), (Object)queryResult.get("appliedcomamt"));
        tempContractPayItem.set("appliableamt", (Object)applyAbleAmt);
        tempContractPayItem.set("stdappliableamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)applyAbleAmt));
        tempContractPayItem.set("collectedamt", queryResult.get("collectedamt"));
        tempContractPayItem.set("stdcollectedamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("collectedamt")));
        tempContractPayItem.set("collectedcomamt", queryResult.get("collectedcomamt"));
        tempContractPayItem.set("stdcollectedcomamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("collectedcomamt")));
        tempContractPayItem.set("uncollectedamt", queryResult.get("uncollectedamt"));
        tempContractPayItem.set("stduncollectedamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("uncollectedamt")));
        String nodeSettingSource = queryResult.getString("nodesettingsource");
        DynamicObject nodeSetting = queryResult.getDynamicObject("nodesetting");
        tempContractPayItem.set("nodesettingsource", (Object)nodeSettingSource);
        tempContractPayItem.set("nodesetting", (Object)nodeSetting);
        tempContractPayItem.set("paidamount", queryResult.get("paidamount"));
        BigDecimal payAmount = queryResult.getBigDecimal("collectamount") != null ? queryResult.getBigDecimal("collectamount") : BigDecimal.ZERO;
        BigDecimal paidAmount = queryResult.getBigDecimal("paidamount") != null ? queryResult.getBigDecimal("paidamount") : BigDecimal.ZERO;
        tempContractPayItem.set("unpayamount", (Object)payAmount.subtract(paidAmount));
        Map<Object, String> taskMessageMap = taskCompileMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        if (taskMessageMap != null && nodeSetting != null && StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue()) && StringUtils.isNotEmpty((CharSequence)(taskStatus = taskMessageMap.get(nodeSetting.getPkValue())))) {
            tempContractPayItem.set(TASKCOMPLETESTATUS, (Object)taskStatus);
        }
        tempContractPayItem.set("plancollecttime", queryResult.get("plancollecttime"));
        tempContractPayItem.set("ctrlstrategy", queryResult.get("ctrlstrategy"));
        tempContractPayItem.set("name", (Object)queryResult.getString("name"));
        DynamicObject project = contract.getDynamicObject("project");
        if (project != null) {
            DynamicObject projectApproval = projectMap.get((Long)project.getPkValue());
            tempContractPayItem.set("project", (Object)projectApproval);
        }
        tempContractPayItem.set("collectfeq", queryResult.get("collectfeq"));
        tempContractPayItem.set("collectway", queryResult.get("collectway"));
        tempContractPayItem.set("collectpercent", queryResult.get("collectpercent"));
        tempContractPayItem.set("remarks", queryResult.get("remarks"));
    }

    @Override
    protected String getTimePropertyName() {
        return "plancollecttime";
    }

    @Override
    protected boolean isCheckFitFilterCondition(DynamicObject queryResult, Map<String, Map<Object, String>> taskCompileMap) {
        boolean checkFitFilterCondition = super.isCheckFitFilterCondition(queryResult, taskCompileMap);
        if (!checkFitFilterCondition) {
            return false;
        }
        String isCompleteFullApply = this.getPageCache().get(ISCOMPLETEFULLAPPLY);
        if (StringUtils.isNotEmpty((CharSequence)isCompleteFullApply)) {
            BigDecimal applyAbleAmt = NumberHelper.subtract((Object)queryResult.get("collectamount"), (Object)queryResult.get("appliedcomamt"));
            if (Boolean.parseBoolean(isCompleteFullApply) ? NumberHelper.compareValue((Object)applyAbleAmt, (Object)BigDecimal.ZERO) > 0 : NumberHelper.compareValue((Object)applyAbleAmt, (Object)BigDecimal.ZERO) <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected List<QFilter> setCustomFilter(List<QFilter> qFilters) {
        String taskCompleteStatus;
        qFilters = super.setCustomFilter(qFilters);
        qFilters.stream().filter(e -> e.getProperty().equals("plancollecttime")).forEach(e -> e.or(new QFilter("plancollecttime", "is null", null)));
        qFilters.add(new QFilter("contract.paydirection", "=", (Object)PayDirectionEnum.IN.getValue()));
        String isCollectionOff = this.getPageCache().get(ISCOLLECTIONOFF);
        if (StringUtils.isNotEmpty((CharSequence)isCollectionOff)) {
            if (Boolean.parseBoolean(isCollectionOff)) {
                qFilters.add(new QFilter("uncollectedamt", "<=", (Object)BigDecimal.ZERO));
            } else {
                qFilters.add(new QFilter("uncollectedamt", ">", (Object)BigDecimal.ZERO));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskCompleteStatus = this.getPageCache().get(TASKCOMPLETESTATUS)))) {
            if (!StringUtils.equals((CharSequence)"incomplete", (CharSequence)taskCompleteStatus)) {
                qFilters.add(new QFilter(TASKCOMPLETESTATUS, "!=", (Object)"incomplete"));
            } else {
                qFilters.add(new QFilter(TASKCOMPLETESTATUS, "!=", (Object)"complete"));
            }
        }
        return qFilters;
    }

    @Override
    protected String getContractItemEntryEntityId() {
        return "contractcolentity";
    }

    @Override
    protected String getContractItemEntityId() {
        return "pmbs_contractcolitembook";
    }

    @Override
    protected String getContractItemEntityName() {
        return ResManager.loadKDString((String)"\u5408\u540c\u6536\u6b3e\u6761\u76ee\u53f0\u8d26", (String)"ContractColItemBookPlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected Map<String, String> getContractItemHeaderMap() {
        LinkedHashMap<String, String> contractColItemHeaderMap = new LinkedHashMap<String, String>(32);
        contractColItemHeaderMap.put("collecttype", ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b", (String)"ContractColItemBookPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("currency", ResManager.loadKDString((String)"\u5e01\u522b", (String)"ContractColItemBookPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("collectamount", ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"ContractColItemBookPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("appliedamt", ResManager.loadKDString((String)"\u5df2\u8bf7\u6b3e\u91d1\u989d", (String)"ContractColItemBookPlugin_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("appliedcomamt", ResManager.loadKDString((String)"\u5df2\u8bf7\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContractColItemBookPlugin_15", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("appliableamt", ResManager.loadKDString((String)"\u53ef\u8bf7\u6b3e\u91d1\u989d", (String)"ContractColItemBookPlugin_16", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("paidamount", ResManager.loadKDString((String)"\u5df2\u5b9e\u6536\u91d1\u989d", (String)"ContractColItemBookPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("unpayamount", ResManager.loadKDString((String)"\u672a\u5b9e\u6536\u91d1\u989d", (String)"ContractColItemBookPlugin_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put(TASKCOMPLETESTATUS, ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (String)"ContractColItemBookPlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("plancollecttime", ResManager.loadKDString((String)"\u8ba1\u5212\u6536\u6b3e\u65e5\u671f", (String)"ContractColItemBookPlugin_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("nodesetting", ResManager.loadKDString((String)"\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e", (String)"ContractColItemBookPlugin_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("ctrlstrategy", ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"ContractColItemBookPlugin_23", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("name", ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0", (String)"ContractColItemBookPlugin_24", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("contract", ResManager.loadKDString((String)"\u5408\u540c", (String)"ContractColItemBookPlugin_25", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("contractstatus", ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001", (String)"ContractColItemBookPlugin_26", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("contracttype", ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b", (String)"ContractColItemBookPlugin_27", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("contractproject", ResManager.loadKDString((String)"\u9879\u76ee", (String)"ContractColItemBookPlugin_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("projectstatus", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001", (String)"ContractColItemBookPlugin_29", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put(ORG, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"ContractColItemBookPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("collectfeq", ResManager.loadKDString((String)"\u6536\u6b3e\u9891\u6b21", (String)"ContractColItemBookPlugin_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("collectway", ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5f0f", (String)"ContractColItemBookPlugin_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("collectpercent", ResManager.loadKDString((String)"\u6536\u6b3e\u6bd4\u4f8b\uff08%\uff09", (String)"ContractColItemBookPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractColItemHeaderMap.put("remarks", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ContractColItemBookPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        return contractColItemHeaderMap;
    }
}

