/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.ContractPayFeqEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.CtrlStrategyEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.ComboItemHelper;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.formplugin.AbstractContractItemBookPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractPayItemBookPlugin
extends AbstractContractItemBookPlugin {
    private static final Log logger = LogFactory.getLog(ContractPayItemBookPlugin.class);
    private static final String ORG_FIELD_NAME = "org.id";
    private static final String CONTRACTPAYITEMENTITY = "contractpayitementity";
    private static final String LAUNCHPAYAPPLYSIGLECON = "launchpayapplysiglecon";
    private static final String LAUNCHPAYAPPLY = "launchpayapply";
    private static final String PUSHPAYAPPLYMULCON = "pushpayapplymulcon";
    private static final String PUSHPAYAPPLYSINGLECON = "pushpayapplysinglecon";
    private static final String TRACKDOWNDATA = "trackdowndata";
    private static final String PUSHANDSAVE = "pushandsave";
    private static final String TRACKDOWN = "trackdown";
    private static final String TASKCOMPLETESTATUS = "taskcompletestatus";
    private static final String ISCOMPLETEFULLAPPLY = "iscompletefullapply";
    private static final String ISPAYOFF = "ispayoff";
    private static final String ORG = "org";

    @Override
    protected void removeCustomControlFilter(SetFilterEvent e) {
        this.getPageCache().remove(ORG);
        this.getPageCache().remove(TASKCOMPLETESTATUS);
        this.getPageCache().remove(ISCOMPLETEFULLAPPLY);
        this.getPageCache().remove(ISPAYOFF);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            String property = filter.getProperty();
            Object value = filter.getValue();
            if (StringUtils.equals((CharSequence)property, (CharSequence)TASKCOMPLETESTATUS)) {
                String taskCompleteStatus = value != null ? (String)value : null;
                this.getPageCache().put(TASKCOMPLETESTATUS, taskCompleteStatus);
                iterator.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)property, (CharSequence)ISCOMPLETEFULLAPPLY)) {
                String isComPleterFullApply = value != null ? (String)value : null;
                this.getPageCache().put(ISCOMPLETEFULLAPPLY, isComPleterFullApply);
                iterator.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)property, (CharSequence)ISPAYOFF)) {
                String isPayOff = value != null ? (String)value : null;
                this.getPageCache().put(ISPAYOFF, isPayOff);
                iterator.remove();
                continue;
            }
            if (!StringUtils.equals((CharSequence)property, (CharSequence)ORG_FIELD_NAME)) continue;
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            if (value instanceof List) {
                orgIds.addAll((List)value);
            } else if (value instanceof Integer) {
                orgIds.add(((Integer)value).longValue());
            } else if (value instanceof Long) {
                orgIds.add((Long)value);
            }
            this.getPageCache().put(ORG, SerializationUtils.toJsonString(orgIds));
            iterator.remove();
        }
    }

    @Override
    protected List<QFilter> setCustomFilter(List<QFilter> qFilters) {
        String taskCompleteStatus;
        qFilters = super.setCustomFilter(qFilters);
        qFilters.stream().filter(e -> e.getProperty().equals("planpaytime")).forEach(e -> e.or(new QFilter("planpaytime", "is null", null)));
        qFilters.add(new QFilter("contract.paydirection", "=", (Object)PayDirectionEnum.OUT.getValue()));
        String isPayOff = this.getPageCache().get(ISPAYOFF);
        if (StringUtils.isNotEmpty((CharSequence)isPayOff)) {
            if (Boolean.parseBoolean(isPayOff)) {
                qFilters.add(new QFilter("unpaidamt", "<=", (Object)BigDecimal.ZERO));
            } else {
                qFilters.add(new QFilter("unpaidamt", ">", (Object)BigDecimal.ZERO));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskCompleteStatus = this.getPageCache().get(TASKCOMPLETESTATUS)))) {
            if (!StringUtils.equals((CharSequence)"incomplete", (CharSequence)taskCompleteStatus)) {
                qFilters.add(new QFilter(TASKCOMPLETESTATUS, "!=", (Object)"incomplete"));
            } else {
                qFilters.add(new QFilter(TASKCOMPLETESTATUS, "!=", (Object)"complete"));
            }
        }
        return qFilters;
    }

    @Override
    protected boolean isCheckFitFilterCondition(DynamicObject queryResult, Map<String, Map<Object, String>> taskCompileMap) {
        boolean checkFitFilterCondition = super.isCheckFitFilterCondition(queryResult, taskCompileMap);
        if (!checkFitFilterCondition) {
            return false;
        }
        String isCompleteFullApply = this.getPageCache().get(ISCOMPLETEFULLAPPLY);
        if (StringUtils.isNotEmpty((CharSequence)isCompleteFullApply)) {
            BigDecimal applyAbleAmt = NumberHelper.subtract((Object)queryResult.get("payamount"), (Object)queryResult.get("appliedcomamt"));
            if (Boolean.parseBoolean(isCompleteFullApply) ? NumberHelper.compareValue((Object)applyAbleAmt, (Object)BigDecimal.ZERO) > 0 : NumberHelper.compareValue((Object)applyAbleAmt, (Object)BigDecimal.ZERO) <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void fillContractPayItemEntry(DynamicObject tempContractPayItem, Map<Long, DynamicObject> projectMap, Map<String, Map<Object, String>> taskCompileMap, DynamicObject queryResult) {
        Long contractPayItemId = queryResult.getLong("id");
        tempContractPayItem.set("id", (Object)contractPayItemId);
        DynamicObject contract = queryResult.getDynamicObject("contract");
        tempContractPayItem.set("contract", (Object)contract);
        DynamicObject project = contract.getDynamicObject("project");
        if (project != null) {
            DynamicObject projectApproval = projectMap.get((Long)project.getPkValue());
            tempContractPayItem.set("project", (Object)projectApproval);
        }
        tempContractPayItem.set("paytype", queryResult.get("paytype"));
        tempContractPayItem.set("supplier", queryResult.get("supplier"));
        DynamicObject tempCurrency = queryResult.getDynamicObject("currency");
        tempContractPayItem.set("currency", (Object)tempCurrency);
        tempContractPayItem.set("payamount", queryResult.get("payamount"));
        tempContractPayItem.set("appliedamt", queryResult.get("appliedamt"));
        tempContractPayItem.set("appliedcomamt", queryResult.get("appliedcomamt"));
        BigDecimal applyAbleAmt = NumberHelper.subtract((Object)queryResult.get("payamount"), (Object)queryResult.get("appliedcomamt"));
        tempContractPayItem.set("appliableamt", (Object)applyAbleAmt);
        tempContractPayItem.set("reimbursedamt", queryResult.get("reimbursedamt"));
        tempContractPayItem.set("reimbursedcomamt", queryResult.get("reimbursedcomamt"));
        tempContractPayItem.set("reimbursableamt", queryResult.get("reimbursableamt"));
        tempContractPayItem.set("paidamt", queryResult.get("paidamt"));
        tempContractPayItem.set("paidcomamt", queryResult.get("paidcomamt"));
        tempContractPayItem.set("unpaidamt", queryResult.get("unpaidamt"));
        tempContractPayItem.set("planpaytime", queryResult.get("planpaytime"));
        tempContractPayItem.set("payway", queryResult.get("payway"));
        tempContractPayItem.set("paypercent", queryResult.get("paypercent"));
        tempContractPayItem.set("ctrlstrategy", queryResult.get("ctrlstrategy"));
        tempContractPayItem.set("name", (Object)queryResult.getString("name"));
        tempContractPayItem.set("payfeq", queryResult.get("payfeq"));
        String nodeSettingSource = queryResult.getString("nodesettingsource");
        tempContractPayItem.set("nodesettingsource", (Object)nodeSettingSource);
        DynamicObject nodeSetting = queryResult.getDynamicObject("nodesetting");
        tempContractPayItem.set("nodesetting", (Object)nodeSetting);
        tempContractPayItem.set("remarks", queryResult.get("remarks"));
        tempContractPayItem.set("paidamount", queryResult.get("paidamount"));
        BigDecimal payAmount = queryResult.getBigDecimal("payamount") != null ? queryResult.getBigDecimal("payamount") : BigDecimal.ZERO;
        BigDecimal paidAmount = queryResult.getBigDecimal("paidamount") != null ? queryResult.getBigDecimal("paidamount") : BigDecimal.ZERO;
        tempContractPayItem.set("unpayamount", (Object)payAmount.subtract(paidAmount));
        BigDecimal exChangeRate = BigDecimal.ONE;
        tempContractPayItem.set("stdcurrency", (Object)tempCurrency);
        if (contract.getBoolean("ismulticurrency")) {
            BigDecimal contractExChangeRate = contract.getBigDecimal("exchangerate");
            if (contractExChangeRate != null && contractExChangeRate.compareTo(BigDecimal.ZERO) != 0) {
                exChangeRate = contractExChangeRate;
            }
            tempContractPayItem.set("stdcurrency", (Object)contract.getDynamicObject("stdcurrency"));
        }
        tempContractPayItem.set("stdpayamount", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("payamount")));
        tempContractPayItem.set("stdappliedamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("appliedamt")));
        tempContractPayItem.set("stdappliedcomamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("appliedcomamt")));
        tempContractPayItem.set("stdappliableamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)applyAbleAmt));
        tempContractPayItem.set("stdreimbursedamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("reimbursedamt")));
        tempContractPayItem.set("stdreimbursedcomamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("reimbursedcomamt")));
        tempContractPayItem.set("stdreimbursableamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("reimbursableamt")));
        tempContractPayItem.set("stdpaidamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("paidamt")));
        tempContractPayItem.set("stdpaidcomamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("paidcomamt")));
        tempContractPayItem.set("stdunpaidamt", (Object)NumberHelper.multiply((Object)exChangeRate, (Object)queryResult.get("unpaidamt")));
        Map<Object, String> taskMessageMap = taskCompileMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        if (taskMessageMap != null && nodeSetting != null && StringUtils.equals((CharSequence)nodeSettingSource, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue())) {
            String taskStatus = taskMessageMap.get(nodeSetting.getPkValue());
            if (StringUtils.isNotEmpty((CharSequence)taskStatus)) {
                tempContractPayItem.set(TASKCOMPLETESTATUS, (Object)taskStatus);
            }
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)"pmpt_task");
            QFilter sourceFilter = new QFilter("sourcetask", "=", nodeSetting.getDynamicObject("sourcetask").getPkValue());
            QFilter isLatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
            DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"pmpt_task", (String)"percent", (QFilter[])new QFilter[]{sourceFilter, isLatestFilter});
            tempContractPayItem.set("taskpercent", (Object)task.getBigDecimal("percent"));
        }
    }

    @Override
    protected String getTimePropertyName() {
        return "planpaytime";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
        this.setBillListSelectRows(selectContractPayItem);
        if (LAUNCHPAYAPPLYSIGLECON.equals(operateKey) || LAUNCHPAYAPPLY.equals(operateKey)) {
            String controlKey;
            if (selectContractPayItem == null || selectContractPayItem.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractPayItemBookPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                args.setCancel(false);
                return;
            }
            HashMap selectRowCheckMessages = new HashMap(selectContractPayItem.length);
            HashMap<Long, DynamicObject> contractPayItemIdMap = new HashMap<Long, DynamicObject>(selectContractPayItem.length);
            boolean hasStrongMessage = false;
            boolean hasWeakMessage = false;
            Date currentDate = DateUtil.getCurrentDate();
            Map taskCompileMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])selectContractPayItem);
            String WEAK = CtrlStrategyEnum.WEAK.getValue();
            String STRONG = CtrlStrategyEnum.STRONG.getValue();
            Set<Long> contractIds = Arrays.stream(selectContractPayItem).filter(e -> e.getDynamicObject("contract") != null).map(e -> e.getDynamicObject("contract").getLong("id")).collect(Collectors.toSet());
            Map<Long, Map<String, DynamicObject>> checkContractInPayReqOnSumbitMap = this.checkContractInPayReqOnSumbit(contractIds);
            for (int i = 0; i < selectContractPayItem.length; ++i) {
                Date planPayTime;
                DynamicObject tempContractPayItem = selectContractPayItem[i];
                Long tempContractPayItemId = tempContractPayItem.getLong("id");
                DynamicObject contract = tempContractPayItem.getDynamicObject("contract");
                if (contract == null) continue;
                contractPayItemIdMap.put(tempContractPayItemId, tempContractPayItem);
                HashMap<String, StringBuilder> tipMessageMap = new HashMap<String, StringBuilder>(8);
                selectRowCheckMessages.put(tempContractPayItemId, tipMessageMap);
                boolean taskStatus = this.getTaskStatus(taskCompileMap, tempContractPayItem);
                boolean hasStrongControl = false;
                StringBuilder strongInfo = tipMessageMap.getOrDefault(STRONG, new StringBuilder());
                tipMessageMap.put(STRONG, strongInfo);
                boolean hasWeakControl = false;
                StringBuilder weakInfo = tipMessageMap.getOrDefault(WEAK, new StringBuilder());
                tipMessageMap.put(WEAK, weakInfo);
                if (!taskStatus) {
                    String ctrlStrategy = tempContractPayItem.getString("ctrlstrategy");
                    if (StringUtils.equals((CharSequence)ctrlStrategy, (CharSequence)"strong")) {
                        strongInfo.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\u3002", (String)"ContractPayItemBookPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        hasStrongControl = true;
                    } else if (StringUtils.equals((CharSequence)ctrlStrategy, (CharSequence)"weak")) {
                        weakInfo.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u662f\u5426\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\uff1f", (String)"ContractPayItemBookPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        hasWeakControl = true;
                    }
                }
                if ((planPayTime = tempContractPayItem.getDate("planpaytime")) != null && !hasStrongControl && DateUtil.compareByDay((Date)currentDate, (Date)planPayTime) < 0) {
                    weakInfo.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u76ee\u8fd8\u672a\u5230\u671f\uff0c\u662f\u5426\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\uff1f", (String)"ContractPayItemBookPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    hasWeakControl = true;
                }
                if (hasStrongControl) {
                    hasStrongMessage = true;
                }
                if (!hasWeakControl) continue;
                hasWeakMessage = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (hasStrongMessage) {
                controlKey = STRONG;
            } else if (hasWeakMessage) {
                controlKey = WEAK;
            } else {
                args.setCancel(false);
                if (LAUNCHPAYAPPLYSIGLECON.equals(operateKey)) {
                    this.getView().invokeOperation(PUSHPAYAPPLYSINGLECON);
                } else if (LAUNCHPAYAPPLY.equals(operateKey)) {
                    this.getView().invokeOperation(PUSHPAYAPPLYMULCON);
                }
                return;
            }
            for (Map.Entry rowCheckMessageEntry : selectRowCheckMessages.entrySet()) {
                Long key = (Long)rowCheckMessageEntry.getKey();
                Map messageEntryValue = (Map)rowCheckMessageEntry.getValue();
                StringBuilder messageBuilder = (StringBuilder)messageEntryValue.get(controlKey);
                if (StringUtils.isEmpty((CharSequence)messageBuilder)) continue;
                DynamicObject contractPayItem = (DynamicObject)contractPayItemIdMap.get(key);
                String payItemName = contractPayItem.getString("name");
                stringBuilder.append(payItemName);
                stringBuilder.append(':');
                stringBuilder.append((CharSequence)messageBuilder);
                stringBuilder.append("\r\n");
            }
            if (hasStrongMessage) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ContractPayItemBookPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), stringBuilder.toString(), MessageTypes.Default);
            } else if (hasWeakMessage) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"ContractPayItemBookPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), stringBuilder.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            }
        }
    }

    @Override
    protected boolean putContractPayItemToJsonObject(DynamicObject contractPayItemEntry, JSONObject jsonObject) {
        String payType = contractPayItemEntry.getString("paytype");
        String payTypeName = ContractPayTypeEnum.PRECOLLECTMENT.getValue().equals(payType) ? ComboItemHelper.getName((String)"pmbs_contractpayitembook", null, null, (String)"paytype", (String)ContractPayTypeEnum.PREPAYMENT.getValue()) : ComboItemHelper.getName((String)"pmbs_contractpayitembook", null, null, (String)"paytype", (String)payType);
        jsonObject.put("paytype", (Object)payTypeName);
        DynamicObject currency = contractPayItemEntry.getDynamicObject("currency");
        jsonObject.put("currency", (Object)(currency != null ? currency.getString("name") : ""));
        int precision = currency == null ? 10 : currency.getInt("amtprecision");
        jsonObject.put("payamount", (Object)contractPayItemEntry.getBigDecimal("payamount").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliedamt", (Object)contractPayItemEntry.getBigDecimal("appliedamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliedcomamt", (Object)contractPayItemEntry.getBigDecimal("appliedcomamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("appliableamt", (Object)contractPayItemEntry.getBigDecimal("appliableamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("reimbursedamt", (Object)contractPayItemEntry.getBigDecimal("reimbursedamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("reimbursedcomamt", (Object)contractPayItemEntry.getBigDecimal("reimbursedcomamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("reimbursableamt", (Object)contractPayItemEntry.getBigDecimal("reimbursableamt").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("paidamount", (Object)contractPayItemEntry.getBigDecimal("paidamount").setScale(precision, RoundingMode.HALF_UP));
        jsonObject.put("unpayamount", (Object)contractPayItemEntry.getBigDecimal("unpayamount").setScale(precision, RoundingMode.HALF_UP));
        String taskCompileStatus = contractPayItemEntry.getString(TASKCOMPLETESTATUS);
        TaskCompleteStateEnum taskComplileEnumByValue = TaskCompleteStateEnum.getEnumByValue((Object)taskCompileStatus);
        jsonObject.put(TASKCOMPLETESTATUS, (Object)(taskComplileEnumByValue != null ? taskComplileEnumByValue.getName() : ""));
        Date planTime = contractPayItemEntry.getDate("planpaytime");
        jsonObject.put("planpaytime", (Object)(planTime != null ? DateUtil.formatShortDate((Date)planTime) : ""));
        DynamicObject nodeSetting = contractPayItemEntry.getDynamicObject("nodesetting");
        if (nodeSetting != null) {
            String nodeSettingForm = nodeSetting.getDynamicObjectType().getName();
            if ("pmbs_workexecution".equals(nodeSettingForm)) {
                jsonObject.put("nodesetting", (Object)nodeSetting.getLocaleString("workitem"));
            } else {
                jsonObject.put("nodesetting", (Object)nodeSetting.getString("name"));
            }
        } else {
            jsonObject.put("nodesetting", (Object)"");
        }
        String ctrlStrategy = contractPayItemEntry.getString("ctrlstrategy");
        CtrlStrategyEnum ctrlStrategyEnum = CtrlStrategyEnum.getEnumByValue((String)ctrlStrategy);
        jsonObject.put("ctrlstrategy", (Object)(ctrlStrategyEnum != null ? ctrlStrategyEnum.getName() : ""));
        String itemName = contractPayItemEntry.getString("name");
        jsonObject.put("name", (Object)(itemName != null ? itemName : ""));
        DynamicObject contract = contractPayItemEntry.getDynamicObject("contract");
        if (contract == null) {
            return false;
        }
        jsonObject.put("contract", (Object)contract.getString("billname"));
        DynamicObject contractstatus = contract.getDynamicObject("contractstatus");
        jsonObject.put("contractstatus", (Object)(contractstatus != null ? contractstatus.getString("name") : ""));
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        jsonObject.put("contracttype", (Object)(contractType != null ? contractType.getString("name") : ""));
        DynamicObject project = contract.getDynamicObject("project");
        jsonObject.put("contractproject", (Object)(project != null ? project.getString("name") : ""));
        DynamicObject pro = contractPayItemEntry.getDynamicObject("project");
        if (pro != null) {
            DynamicObject proStatus = pro.getDynamicObject("prostatus");
            jsonObject.put("projectstatus", (Object)(proStatus != null ? proStatus.getString("name") : ""));
        } else {
            jsonObject.put("projectstatus", (Object)"");
        }
        DynamicObject org = contract.getDynamicObject(ORG);
        jsonObject.put(ORG, (Object)(org != null ? org.getString("name") : ""));
        String payFeq = contractPayItemEntry.getString("payfeq");
        ContractPayFeqEnum payFeqEnum = ContractPayFeqEnum.getEnumByValue((Object)payFeq);
        jsonObject.put("payfeq", (Object)(payFeqEnum != null ? payFeqEnum.getName() : ""));
        DynamicObject payWay = contractPayItemEntry.getDynamicObject("payway");
        jsonObject.put("payway", (Object)(payWay != null ? payWay.getString("name") : ""));
        BigDecimal payPercent = contractPayItemEntry.getBigDecimal("paypercent");
        jsonObject.put("paypercent", (Object)payPercent.setScale(4, RoundingMode.HALF_UP));
        String remarks = contractPayItemEntry.getString("remarks");
        jsonObject.put("remarks", (Object)String.valueOf(remarks));
        return true;
    }

    protected Map<Long, Map<String, DynamicObject>> checkContractInPayReqOnSumbit(Set<Long> contractIds) {
        DynamicObject[] payReqs;
        DynamicObject[] payReqSingleCons;
        if (contractIds == null) {
            return null;
        }
        HashMap<Long, Map<String, DynamicObject>> result = new HashMap<Long, Map<String, DynamicObject>>(contractIds.size());
        QFilter filter = new QFilter("billstatus", "=", (Object)"B");
        filter.and(new QFilter("contract.id", "in", contractIds));
        for (DynamicObject payReq : payReqSingleCons = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)String.join((CharSequence)",", "contract", "billno", "billname"), (QFilter[])new QFilter[]{filter})) {
            DynamicObject contract = payReq.getDynamicObject("contract");
            long contractId = contract.getLong("id");
            Map payReqSingleConMap = result.getOrDefault(contractId, new HashMap(4));
            payReqSingleConMap.put("pmct_applymentpay", payReq);
            result.put(contractId, payReqSingleConMap);
        }
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"B");
        filter1.and(new QFilter("entryentity.entrycontract.id", "in", contractIds));
        for (DynamicObject payReq : payReqs = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)String.join((CharSequence)",", "billno", "billname", "entryentity", "entrycontract"), (QFilter[])new QFilter[]{filter1})) {
            DynamicObjectCollection entryes = payReq.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryes) {
                DynamicObject contract = entry.getDynamicObject("entrycontract");
                long contractId = contract.getLong("id");
                Map payReqSingleConMap = result.getOrDefault(contractId, new HashMap(4));
                payReqSingleConMap.put("pmct_paymentapply", payReq);
                result.put(contractId, payReqSingleConMap);
            }
        }
        return result;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    @Override
    protected String getAllProperty() {
        return "masterid, status, enable, supplier, paytype, payfeq, payway, paypercent, payamount, planpaytime, remarks, reimbursedamt, reimbursedcomamt, reimbursableamt, paidamt, paidcomamt, unpaidamt, source, payplansource, contract, autogenerated, creator, createtime, modifier, modifytime, payplanentryid, performentryid, currency, billno, paydirection, nodesettingsource, nodesetting, name, ctrlstrategy, appliedamt, appliedcomamt, appliableamt, taskcompletestatus, org, iscompletefullapply, ispayoff,paidamount,unpayamount";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            DynamicObject[] selectContractPayItem;
            String key = messageBoxClosedEvent.getCallBackId();
            if (StringUtils.equals((CharSequence)LAUNCHPAYAPPLY, (CharSequence)key)) {
                selectContractPayItem = this.getSelectContractPayItem();
                this.setBillListSelectRows(selectContractPayItem);
                this.getView().invokeOperation(PUSHPAYAPPLYMULCON);
            }
            if (StringUtils.equals((CharSequence)LAUNCHPAYAPPLYSIGLECON, (CharSequence)key)) {
                selectContractPayItem = this.getSelectContractPayItem();
                this.setBillListSelectRows(selectContractPayItem);
                this.getView().invokeOperation(PUSHPAYAPPLYSINGLECON);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)TRACKDOWNDATA, (CharSequence)key)) {
            DynamicObject[] selectContractPayItem = this.getSelectContractPayItem();
            if (selectContractPayItem == null || selectContractPayItem.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ContractPayItemBookPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            } else {
                this.setBillListSelectRows(selectContractPayItem);
                this.getView().invokeOperation(TRACKDOWN);
            }
        }
    }

    @Override
    protected String getContractItemEntryEntityId() {
        return CONTRACTPAYITEMENTITY;
    }

    @Override
    protected String getContractItemEntityId() {
        return "pmbs_contractpayitembook";
    }

    @Override
    protected String getContractItemEntityName() {
        return ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u53f0\u8d26", (String)"ContractPayItemBookPlugin_44", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected Map<String, String> getContractItemHeaderMap() {
        LinkedHashMap<String, String> contractPayItemHeaderMap = new LinkedHashMap<String, String>(32);
        contractPayItemHeaderMap.put("paytype", ResManager.loadKDString((String)"\u652f\u51fa\u7c7b\u578b", (String)"ContractPayItemBookPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("currency", ResManager.loadKDString((String)"\u5e01\u522b", (String)"ContractPayItemBookPlugin_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("payamount", ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"ContractPayItemBookPlugin_19", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("appliedamt", ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u91d1\u989d", (String)"ContractPayItemBookPlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("appliedcomamt", ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContractPayItemBookPlugin_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("appliableamt", ResManager.loadKDString((String)"\u53ef\u7533\u8bf7\u91d1\u989d", (String)"ContractPayItemBookPlugin_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("reimbursedamt", ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d", (String)"ContractPayItemBookPlugin_23", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("reimbursedcomamt", ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"ContractPayItemBookPlugin_24", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("reimbursableamt", ResManager.loadKDString((String)"\u53ef\u62a5\u9500\u91d1\u989d", (String)"ContractPayItemBookPlugin_25", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("paidamount", ResManager.loadKDString((String)"\u5df2\u5b9e\u4ed8\u91d1\u989d", (String)"ContractPayItemBookPlugin_26", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("unpayamount", ResManager.loadKDString((String)"\u672a\u5b9e\u4ed8\u91d1\u989d", (String)"ContractPayItemBookPlugin_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put(TASKCOMPLETESTATUS, ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (String)"ContractPayItemBookPlugin_29", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("planpaytime", ResManager.loadKDString((String)"\u8ba1\u5212\u4ed8\u6b3e\u65e5\u671f", (String)"ContractPayItemBookPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("nodesetting", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8282\u70b9\u8bbe\u7f6e", (String)"ContractPayItemBookPlugin_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("ctrlstrategy", ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"ContractPayItemBookPlugin_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("name", ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0", (String)"ContractPayItemBookPlugin_33", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("contract", ResManager.loadKDString((String)"\u5408\u540c", (String)"ContractPayItemBookPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("contractstatus", ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001", (String)"ContractPayItemBookPlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("contracttype", ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b", (String)"ContractPayItemBookPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("contractproject", ResManager.loadKDString((String)"\u9879\u76ee", (String)"ContractPayItemBookPlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("projectstatus", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001", (String)"ContractPayItemBookPlugin_38", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put(ORG, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"ContractPayItemBookPlugin_39", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("payfeq", ResManager.loadKDString((String)"\u652f\u4ed8\u9891\u6b21", (String)"ContractPayItemBookPlugin_40", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("payway", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u5f0f", (String)"ContractPayItemBookPlugin_41", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("paypercent", ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\uff08%\uff09", (String)"ContractPayItemBookPlugin_45", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        contractPayItemHeaderMap.put("remarks", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ContractPayItemBookPlugin_43", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        return contractPayItemHeaderMap;
    }
}

