/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.formplugin.BudgetPerformMonitorFormPlugin;

public class InBudgetPerformMonitorFormPlugin
extends BudgetPerformMonitorFormPlugin {
    private String[] proBudgetColumnKeys = new String[]{"name", "budgetamount", "occupyamt", "incomeamount", "remainincomeamt", "actualinrate"};
    private String[] proBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u91d1\u989d", (String)"InBudgetPerformMonitorFormPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5360\u7528\u91d1\u989d", (String)"InBudgetPerformMonitorFormPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u4ed8\u6536\u91d1\u989d", (String)"InBudgetPerformMonitorFormPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5269\u4f59\u5e94\u6536\u91d1\u989d", (String)"InBudgetPerformMonitorFormPlugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u6536\u5360\u9884\u7b97\u6bd4\u4f8b\uff08%\uff09", (String)"InBudgetPerformMonitorFormPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private String[] contBudgetColumnKeys = new String[]{"name", "contbillno", "contbillname", "contbillstatus", "occupyamount", "contractsubmitamt", "settlesubmitamt", "reqfundsubmitamt", "actualinsubmitamt"};
    private String[] contBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"InBudgetPerformMonitorFormPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"InBudgetPerformMonitorFormPlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u5408\u540c\u5df2\u5360\u7528\u9884\u7b97\u91d1\u989d", (String)"InBudgetPerformMonitorFormPlugin_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2460", (String)"InBudgetPerformMonitorFormPlugin_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2461", (String)"InBudgetPerformMonitorFormPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u6b3e\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2462", (String)"InBudgetPerformMonitorFormPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u6536\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2463", (String)"InBudgetPerformMonitorFormPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
    private String[] budgetRecordColumnKeys = new String[]{"name", "contbillno", "contbillname", "billtype", "billno", "billname", "billamt", "billstatus", "billcreator", "billcreatedate", "billauditor", "billauditdate"};
    private String[] budgetRecordHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"InBudgetPerformMonitorFormPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b", (String)"InBudgetPerformMonitorFormPlugin_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"InBudgetPerformMonitorFormPlugin_15", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"InBudgetPerformMonitorFormPlugin_16", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\uff08\u9879\u76ee\u5e01\uff09", (String)"InBudgetPerformMonitorFormPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"InBudgetPerformMonitorFormPlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"InBudgetPerformMonitorFormPlugin_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"InBudgetPerformMonitorFormPlugin_19", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"InBudgetPerformMonitorFormPlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u65e5\u671f", (String)"InBudgetPerformMonitorFormPlugin_21", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};

    @Override
    protected void initProBudgetExcelData(List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList) {
        DynamicObject[] budgetPerforms;
        DynamicObject currency;
        DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity("budgetentry");
        JSONArray jsonArray = new JSONArray();
        HashSet<DynamicObject> detailBudgetRowSet = new HashSet<DynamicObject>(budgetEntryEntity.size());
        Tree tree = this.buildTree(budgetEntryEntity);
        List treeNodeList = tree.getList();
        BigDecimal oneHundred = new BigDecimal("100");
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TreeNode node = (TreeNode)treeNodeList.get(i);
            StringBuilder blank = new StringBuilder();
            int level = node.getLevel();
            while (--level > 0) {
                blank.append("    ");
            }
            DynamicObject budgetEntryRow = node.getData();
            JSONObject jsonObject = new JSONObject();
            currency = budgetEntryRow.getDynamicObject("budgetcurrency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            String checkBill = budgetEntryRow.getString("checkbill");
            if (StringUtils.isNotEmpty((CharSequence)checkBill)) {
                detailBudgetRowSet.add(budgetEntryRow);
            }
            jsonObject.put(this.proBudgetColumnKeys[0], (Object)String.format("%s%s", blank, budgetEntryRow.getString("name")));
            jsonObject.put(this.proBudgetColumnKeys[1], (Object)budgetEntryRow.getBigDecimal("budgetamount").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[2], (Object)budgetEntryRow.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[3], (Object)budgetEntryRow.getBigDecimal("incomeamount").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[4], (Object)budgetEntryRow.getBigDecimal("remainincomeamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put(this.proBudgetColumnKeys[5], (Object)budgetEntryRow.getBigDecimal("actualinrate").multiply(oneHundred).setScale(2, RoundingMode.HALF_UP));
            jsonArray.add((Object)jsonObject);
        }
        headerList.add(this.proBudgetHeaders);
        columnList.add(this.proBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        for (DynamicObject detailBudgetRow : detailBudgetRowSet) {
            DynamicObject currency2 = detailBudgetRow.getDynamicObject("budgetcurrency");
            int precision = currency2 == null ? 10 : currency2.getInt("amtprecision");
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", detailBudgetRow.getPkValue());
            DynamicObject[] contBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt,actualsubmitamt,actualauditamt,projectcurrency", (QFilter[])new QFilter[]{budgetItemFilter});
            HashSet<Object> contractIdSet = new HashSet<Object>(contBudgets.length);
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                contractIdSet.add(contract.getPkValue());
            }
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contracttpl"));
            HashMap<Object, Object> contractMap = new HashMap<Object, Object>(contracts.length);
            for (DynamicObject dynamicObject : contracts) {
                contractMap.put(dynamicObject.getPkValue(), dynamicObject);
            }
            for (DynamicObject dynamicObject : contBudgets) {
                DynamicObject contract = dynamicObject.getDynamicObject("contract");
                if (contract == null) continue;
                JSONObject jsonObject = new JSONObject();
                contract = (DynamicObject)contractMap.get(contract.getPkValue());
                jsonObject.put(this.contBudgetColumnKeys[0], (Object)detailBudgetRow.getString("name"));
                jsonObject.put(this.contBudgetColumnKeys[1], contract.get("billno"));
                jsonObject.put(this.contBudgetColumnKeys[2], contract.get("billname"));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)contract.get("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(this.contBudgetColumnKeys[3], (Object)statusEnum.getName());
                }
                jsonObject.put(this.contBudgetColumnKeys[4], (Object)dynamicObject.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[5], (Object)dynamicObject.getBigDecimal("contractsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[6], (Object)dynamicObject.getBigDecimal("settlesubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[7], (Object)dynamicObject.getBigDecimal("payapplysubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(this.contBudgetColumnKeys[8], (Object)dynamicObject.getBigDecimal("actualsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(this.contBudgetHeaders);
        columnList.add(this.contBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        Set detailBudgetRowIdSet = detailBudgetRowSet.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        for (DynamicObject budgetPerform : budgetPerforms = BusinessDataServiceHelper.load((Object[])detailBudgetRowIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudgetperform"))) {
            currency = budgetPerform.getDynamicObject("currency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntryObj : performEntry) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(this.budgetRecordColumnKeys[0], budgetPerform.get("name"));
                DynamicObject dynamicObject = performEntryObj.getDynamicObject("contract");
                if (dynamicObject != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[1], dynamicObject.get("billno"));
                    jsonObject.put(this.budgetRecordColumnKeys[2], dynamicObject.get("billname"));
                }
                if (performEntryObj.getDynamicObject("billtype") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[3], (Object)performEntryObj.getDynamicObject("billtype").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[4], (Object)performEntryObj.getString("billno"));
                jsonObject.put(this.budgetRecordColumnKeys[5], (Object)performEntryObj.getString("billname"));
                jsonObject.put(this.budgetRecordColumnKeys[6], (Object)performEntryObj.getBigDecimal("billamt").setScale(precision, RoundingMode.HALF_UP));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)performEntryObj.getString("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[7], (Object)statusEnum.getName());
                }
                if (performEntryObj.getDynamicObject("billcreator") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[8], (Object)performEntryObj.getDynamicObject("billcreator").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[9], (Object)performEntryObj.getDate("billcreatedate"));
                if (performEntryObj.getDynamicObject("billauditor") != null) {
                    jsonObject.put(this.budgetRecordColumnKeys[10], (Object)performEntryObj.getDynamicObject("billauditor").getLocaleString("name"));
                }
                jsonObject.put(this.budgetRecordColumnKeys[11], (Object)performEntryObj.getDate("billauditdate"));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(this.budgetRecordHeaders);
        columnList.add(this.budgetRecordColumnKeys);
        jsonDataList.add(jsonArray);
    }

    @Override
    public String getFormId() {
        return "pmas_projectinbudgetperf";
    }
}

