/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.report.OutBudgetReportHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.formplugin.BudgetPerformMonitorFormPlugin;

public class OutBudgetPerformMonitorFormPlugin
extends BudgetPerformMonitorFormPlugin {
    private static final String CACHE_CONT_TO_COST_AMT_MAP = "contToCostAmtMapString";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid budgetPerformBillEntry = (EntryGrid)this.getView().getControl("budgetperformbillentry");
        budgetPerformBillEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    protected void loadData(List<QFilter> qFilters) {
        this.getModel().deleteEntryData("performbillentry");
        this.getModel().deleteEntryData("budgetperformbillentry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"contperformentry", "performbillentry", "budgetperformbillentry"});
        this.getModel().deleteEntryData("budgetentry");
        String payDirection = (String)this.getView().getFormShowParameter().getCustomParam("paydirection");
        if (payDirection != null) {
            this.getPageCache().put("payDirection", payDirection);
        }
        if (!qFilters.isEmpty()) {
            Iterator<QFilter> iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter filter = iterator.next();
                String cp = filter.getCP();
                this.getPageCache().put("filftername", cp);
                String property = filter.getProperty();
                if (!StringUtils.equals((CharSequence)"org.id", (CharSequence)property)) continue;
                iterator.remove();
            }
            DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity("budgetentry");
            String cpName = this.getPageCache().get("filftername");
            if (cpName.equals("=")) {
                Object fpro = this.getView().getModel().getValue("fpro");
                String projectId = this.getPageCache().get("projectfilterid");
                if (StringUtils.isBlank((CharSequence)projectId) && fpro != null) {
                    DynamicObject pro = (DynamicObject)fpro;
                    projectId = pro.getPkValue().toString();
                }
                if (StringUtils.isEmpty((CharSequence)projectId)) {
                    this.getModel().setValue("fpro", null);
                    this.getModel().setValue("currencyfield", null);
                    this.getModel().setValue("totalbudgetamt", (Object)0);
                    this.getModel().setValue("totaloccupyamt", (Object)0);
                    this.getModel().setValue("totalbudgetusedamt", (Object)0);
                    this.getModel().setValue("totalperformamt", (Object)0);
                    this.getModel().setValue("totalactualpayamount", (Object)0);
                    this.getModel().setValue("totalcostamt", (Object)0);
                    this.getModel().setValue("fremainrate", null);
                    this.getView().updateView("fpro");
                    this.getView().updateView("currencyfield");
                    this.getView().updateView("totalbudgetamt");
                    this.getView().updateView("totaloccupyamt");
                    this.getView().updateView("totalbudgetusedamt");
                    this.getView().updateView("totalperformamt");
                    this.getView().updateView("totalactualpayamount");
                    this.getView().updateView("totalcostamt");
                    this.getView().updateView("fremainrate");
                    return;
                }
                DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))});
                this.getModel().setValue("fpro", (Object)project);
                this.getPageCache().put("projectfilterid", projectId);
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(projectId));
                this.getPageCache().put("isNew", String.valueOf(isNew));
                EntryGrid entryGrid = (EntryGrid)this.getControl("budgetentry");
                LocaleString columnName = new LocaleString(ResManager.loadKDString((String)"\u5e74\u5ea6\u9884\u7b97\u91d1\u989d", (String)"OutBudgetPerformMonitorFormPlugin_42", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                if (!isNew) {
                    columnName = new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u91d1\u989d", (String)"OutBudgetPerformMonitorFormPlugin_43", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                entryGrid.setColumnProperty("budgetamount", "header", (Object)columnName);
                qFilters.add(new QFilter("project", "=", (Object)Long.parseLong(projectId)));
                qFilters.add(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
                DynamicObject[] budgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"name, description, siamount, viamount, budgetamount, vichangeamount, budgetitem, sourcetype, project, parent, currency, sequence, remindrate, controlrate, remainrate, remindamt, controlamt, preoccupyamt, occupyamt, performamt, remainamt, contcurrency, org, contractcurrency,level,number,actualamt,procostamt,billtype,billamt,billstatus,performamttype", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"sequence asc");
                DynamicObject firstRow = this.buildTotalRow(budgetEntryEntity);
                budgetEntryEntity.add((Object)firstRow);
                if (budgets.length > 0) {
                    Map budgetCostAmtMap = OutBudgetReportHelper.getBudgetCostAmtByPro((DynamicObject)project);
                    DynamicObject[] totalBudgets = this.findAllBudgets(budgets, null);
                    Set<Long> parentIdSet = this.getAllParents(totalBudgets);
                    DynamicObjectType dt = budgetEntryEntity.getDynamicObjectType();
                    for (DynamicObject budget : budgets) {
                        DynamicObject budgetEntry = OutBudgetReportHelper.buildBudgetEntry((DynamicObject)budget, (DynamicObjectType)dt, parentIdSet, (Map)budgetCostAmtMap);
                        budgetEntryEntity.add((Object)budgetEntry);
                    }
                    if (isNew) {
                        ProBudgetCtrlEnums budgetControlType = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
                        OutBudgetReportHelper.buildNewBudgetEntry((DynamicObjectCollection)budgetEntryEntity, (DynamicObject)project, (DynamicObject[])budgets, (String)budgetControlType.getValue());
                        OutBudgetReportHelper.buildParentBudgetEntry(parentIdSet, (DynamicObjectCollection)budgetEntryEntity);
                    }
                    firstRow.set("budgetcurrency", ((DynamicObject)budgetEntryEntity.get(1)).get("budgetcurrency"));
                    this.mergeBudgetEntryDataToRow(budgetEntryEntity);
                    this.getPageCache().put("hasBudgets", "true");
                } else {
                    OutBudgetReportHelper.fillFirstEntryByNoBudget((DynamicObjectCollection)budgetEntryEntity, (DynamicObject)project);
                    Object budgetCurrency = ((DynamicObject)budgetEntryEntity.get(0)).get("budgetcurrency");
                    Object rowCurrency = budgetCurrency != null ? budgetCurrency : this.getModel().getValue("currencyfield");
                    firstRow.set("budgetcurrency", rowCurrency);
                    this.getPageCache().put("hasBudgets", "false");
                }
                if (!isNew) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap", "checkbill"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"number", "budgetsumamount", "sumbudamt", "actualpayamount"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"remindrate", "controlrate"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"remindamt", "controlamt"});
                    this.fillStatisticRegionValue();
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap", "checkbill"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"number", "budgetsumamount", "sumbudamt", "actualpayamount"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"remindrate", "controlrate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"remindamt", "controlamt"});
                }
                this.getModel().updateEntryCache(budgetEntryEntity);
            }
        }
        this.getView().updateView("budgetentry");
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid control = (TreeEntryGrid)this.getControl("budgetentry");
        control.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent event) {
        if (event.getSource() != null && event.getSource() instanceof TextEdit) {
            TextEdit field = (TextEdit)event.getSource();
            String fieldKey = field.getFieldKey();
            String isNew = this.getPageCache().get("isNew");
            String hasBudgets = this.getPageCache().get("hasBudgets");
            if (!StringUtils.isEmpty((CharSequence)hasBudgets) && !Boolean.parseBoolean(hasBudgets)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)isNew) || !Boolean.parseBoolean(isNew)) {
                switch (fieldKey) {
                    case "occupyamt": 
                    case "budgetusedamt": 
                    case "performamt": 
                    case "actualpayamount": 
                    case "costamt": {
                        event.getNoLinkKey().add(fieldKey);
                        break;
                    }
                }
                return;
            }
            DynamicObject rowData = event.getRowData();
            boolean isLeaf = rowData.getBoolean("isleaf");
            if (!isLeaf) {
                switch (fieldKey) {
                    case "occupyamt": 
                    case "budgetusedamt": 
                    case "performamt": 
                    case "actualpayamount": 
                    case "costamt": {
                        event.getNoLinkKey().add(fieldKey);
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected void mergeBudgetEntryDataToRow(DynamicObjectCollection budgetEntryEntity) {
        if (budgetEntryEntity.isEmpty()) {
            return;
        }
        OutBudgetReportHelper.mergeBudgetEntryDataToRow((DynamicObjectCollection)budgetEntryEntity);
    }

    protected void fillStatisticRegionValue() {
        Object fpro = this.getView().getModel().getValue("fpro");
        String projectId = this.getPageCache().get("projectfilterid");
        if (StringUtils.isBlank((CharSequence)projectId) && fpro != null) {
            DynamicObject pro = (DynamicObject)fpro;
            projectId = pro.getPkValue().toString();
        }
        if (StringUtils.isBlank((CharSequence)projectId)) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))});
        if (project != null) {
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp != null) {
                this.getModel().setValue("currencyfield", proApp.get("currencyfield"));
            }
            this.getModel().setValue("fpro", (Object)project);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter validFilter = new QFilter("isvalid", "=", (Object)DefaultEnum.YES.getValue());
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject[] outBudgetObjs = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"totalamount", (QFilter[])new QFilter[]{statusFilter, proFilter, validFilter, sourceTypeFilter});
            BigDecimal totalBudgetAmt = BigDecimal.ZERO;
            for (DynamicObject outBudgetObj : outBudgetObjs) {
                totalBudgetAmt = totalBudgetAmt.add(outBudgetObj.getBigDecimal("totalamount"));
            }
            this.getModel().setValue("totalbudgetamt", (Object)totalBudgetAmt);
            DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity("budgetentry");
            if (!budgetEntryEntity.isEmpty()) {
                DynamicObject budgetEntryTotalRow = (DynamicObject)budgetEntryEntity.get(0);
                this.getModel().setValue("totaloccupyamt", budgetEntryTotalRow.get("occupyamt"));
                this.getModel().setValue("totalbudgetusedamt", budgetEntryTotalRow.get("budgetusedamt"));
                this.getModel().setValue("totalperformamt", budgetEntryTotalRow.get("performamt"));
                this.getModel().setValue("totalactualpayamount", budgetEntryTotalRow.get("actualpayamount"));
                this.getModel().setValue("totalcostamt", budgetEntryTotalRow.get("costamt"));
                BigDecimal remainRate = budgetEntryTotalRow.getBigDecimal("remainrate").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                this.getModel().setValue("fremainrate", (Object)String.format("%s%s", remainRate, "%"));
            } else {
                this.getModel().setValue("totaloccupyamt", (Object)0);
                this.getModel().setValue("totalbudgetusedamt", (Object)0);
                this.getModel().setValue("totalperformamt", (Object)0);
                this.getModel().setValue("totalactualpayamount", (Object)0);
                this.getModel().setValue("totalcostamt", (Object)0);
                this.getModel().setValue("fremainrate", null);
            }
            this.getView().updateView("fpro");
            this.getView().updateView("currencyfield");
            this.getView().updateView("totalbudgetamt");
            this.getView().updateView("totaloccupyamt");
            this.getView().updateView("totalbudgetusedamt");
            this.getView().updateView("totalperformamt");
            this.getView().updateView("totalactualpayamount");
            this.getView().updateView("totalcostamt");
            this.getView().updateView("fremainrate");
        }
    }

    @Override
    protected void initProBudgetExcelData(List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList) {
        DynamicObjectCollection budgetEntryEntity = this.getModel().getEntryEntity("budgetentry");
        String isNew = this.getPageCache().get("isNew");
        String cache = this.getPageCache().get(CACHE_CONT_TO_COST_AMT_MAP);
        OutBudgetReportHelper.exportProBudgetExcelData((DynamicObjectCollection)budgetEntryEntity, headerList, columnList, jsonDataList, (String)isNew, (String)cache);
    }

    @Override
    protected void checkBillHyperLinkClick(int rowIndex) {
        this.getModel().deleteEntryData("contperformentry");
        this.getPageCache().remove("amountrecord");
        String projectId = this.getPageCache().get("projectfilterid");
        Object fpro = this.getView().getModel().getValue("fpro");
        if (StringUtils.isBlank((CharSequence)projectId) && fpro != null) {
            DynamicObject pro = (DynamicObject)fpro;
            projectId = pro.getPkValue().toString();
        }
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("budgetentry", rowIndex);
        String checkBillId = this.getPageCache().get("checkbillid");
        if (StringUtils.equals((CharSequence)checkBillId, (CharSequence)rowEntity.getPkValue().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contperformentry", "performbillentry"});
            this.getPageCache().remove("checkbillid");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contperformentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"performbillentry"});
            DynamicObjectCollection contPerformEntry = this.getModel().getEntryEntity("contperformentry");
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", rowEntity.getPkValue());
            DynamicObject[] contBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt,actualsubmitamt,actualauditamt,projectcurrency", (QFilter[])new QFilter[]{budgetItemFilter});
            HashSet<Object> contractIdSet = new HashSet<Object>(contBudgets.length);
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                contractIdSet.add(contract.getPkValue());
            }
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contracttpl"));
            HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(contracts.length);
            for (DynamicObject contract : contracts) {
                contractMap.put(contract.getPkValue(), contract);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"reqfundsubmitamt", "reqfundauditamt", "actualinsubmitamt", "actualinauditamt"});
            QFilter proFilter = new QFilter("project", "=", (Object)Long.parseLong(projectId));
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] costObjs = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)"entryentity,contract,subentryentity,budgetitem,amount,currency", (QFilter[])new QFilter[]{proFilter, statusFilter});
            HashMap<Long, BigDecimal> contToCostAmtMap = new HashMap<Long, BigDecimal>(costObjs.length);
            DynamicObject proCurrency = (DynamicObject)this.getModel().getValue("currencyfield");
            for (DynamicObject costObj : costObjs) {
                DynamicObject stdCurrency = costObj.getDynamicObject("currency");
                BigDecimal exchangeRate = OutBudgetReportHelper.getExchangeRate((DynamicObject)stdCurrency, (DynamicObject)proCurrency, (Long)Long.parseLong(projectId));
                DynamicObjectCollection contSettleEntry = costObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject contSettleEntryRow : contSettleEntry) {
                    long entryContId = contSettleEntryRow.getLong("contract.id");
                    if (!contractMap.containsKey(entryContId)) continue;
                    DynamicObjectCollection costSplitSubEntry = contSettleEntryRow.getDynamicObjectCollection("subentryentity");
                    BigDecimal costAmt = (BigDecimal)contToCostAmtMap.get(entryContId);
                    for (DynamicObject costSplitSubEntryRow : costSplitSubEntry) {
                        DynamicObject budgetItem = costSplitSubEntryRow.getDynamicObject("budgetitem");
                        if (budgetItem == null || budgetItem.getLong("id") != rowEntity.getLong("id")) continue;
                        costAmt = costAmt != null ? costAmt.add(costSplitSubEntryRow.getBigDecimal("amount").multiply(exchangeRate)) : costSplitSubEntryRow.getBigDecimal("amount").multiply(exchangeRate);
                        contToCostAmtMap.put(entryContId, costAmt);
                    }
                }
            }
            if (!contToCostAmtMap.isEmpty()) {
                this.getPageCache().put(CACHE_CONT_TO_COST_AMT_MAP, JSONObject.toJSONString(contToCostAmtMap));
            }
            for (DynamicObject contBudget : contBudgets) {
                DynamicObject contract = contBudget.getDynamicObject("contract");
                if (contract == null) continue;
                DynamicObject contPerformEntryObj = contPerformEntry.addNew();
                contract = (DynamicObject)contractMap.get(contract.getPkValue());
                contPerformEntryObj.set("id", contBudget.getPkValue());
                contPerformEntryObj.set("contbillno", contract.get("billno"));
                contPerformEntryObj.set("contbillname", contract.get("billname"));
                QFilter filter = new QFilter("number", "=", (Object)"pmct_outcontract");
                DynamicObject objectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"", (QFilter[])new QFilter[]{filter});
                contPerformEntryObj.set("contbilltype", (Object)objectType);
                contPerformEntryObj.set("contbillstatus", contract.get("billstatus"));
                contPerformEntryObj.set("occupyamount", contBudget.get("occupyamt"));
                contPerformEntryObj.set("contractsubmitamt", contBudget.get("contractsubmitamt"));
                contPerformEntryObj.set("contractauditamt", contBudget.get("contractauditamt"));
                contPerformEntryObj.set("settlesubmitamt", contBudget.get("settlesubmitamt"));
                contPerformEntryObj.set("settleauditamt", contBudget.get("settleauditamt"));
                contPerformEntryObj.set("applysubmitamt", contBudget.get("payapplysubmitamt"));
                contPerformEntryObj.set("applyauditamt", contBudget.get("payapplyauditamt"));
                contPerformEntryObj.set("paysubmitamt", contBudget.get("actualsubmitamt"));
                contPerformEntryObj.set("payauditamt", contBudget.get("actualauditamt"));
                BigDecimal costAmt = (BigDecimal)contToCostAmtMap.get(contract.getPkValue());
                if (costAmt != null) {
                    contPerformEntryObj.set("contcostsplitamt", (Object)costAmt);
                }
                contPerformEntryObj.set("procurrency", contBudget.get("projectcurrency"));
                contPerformEntryObj.set("contractid", (Object)contract.getPkValue().toString());
                contPerformEntryObj.set("probudgetid", (Object)rowEntity.getPkValue().toString());
            }
            budgetItemFilter = new QFilter("id", "=", rowEntity.getPkValue());
            DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"currency, , performentry.billid, performentry.billno, performentry.billname, performentry.billtype, performentry.billstatus, performentry.performamttype, performentry.billamtoncont", (QFilter[])new QFilter[]{budgetItemFilter});
            for (DynamicObject otherBillBudget : projectBudget.getDynamicObjectCollection("performentry")) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)otherBillBudget.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) continue;
                DynamicObject contPerformEntryObj = contPerformEntry.addNew();
                contPerformEntryObj.set("id", otherBillBudget.getPkValue());
                contPerformEntryObj.set("contractid", otherBillBudget.get("billid"));
                contPerformEntryObj.set("contbillno", otherBillBudget.get("billno"));
                contPerformEntryObj.set("contbillname", otherBillBudget.get("billname"));
                contPerformEntryObj.set("contbilltype", otherBillBudget.get("billtype"));
                contPerformEntryObj.set("contbillstatus", otherBillBudget.get("billstatus"));
                contPerformEntryObj.set("procurrency", projectBudget.get("currency"));
                contPerformEntryObj.set("occupyamount", otherBillBudget.get("billamtoncont"));
                contPerformEntryObj.set("probudgetid", (Object)rowEntity.getPkValue().toString());
            }
            this.getModel().updateEntryCache(contPerformEntry);
            this.getView().updateView("contperformentry");
            this.getPageCache().put("checkbillid", rowEntity.getPkValue().toString());
        }
    }

    @Override
    protected void amountHyperLinkClick(int rowIndex, String columnName) {
        this.getModel().deleteEntryData("performbillentry");
        String amountColumnRow = this.getPageCache().get("amountrecord");
        String amountColumnValue = String.format("%s%s", columnName, rowIndex);
        if (StringUtils.equals((CharSequence)amountColumnRow, (CharSequence)amountColumnValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"performbillentry"});
            this.getPageCache().remove("amountrecord");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"performbillentry"});
            String proBudgetId = (String)this.getModel().getValue("probudgetid", rowIndex);
            if (StringUtils.isEmpty((CharSequence)proBudgetId)) {
                return;
            }
            String contractId = (String)this.getModel().getValue("contractid", rowIndex);
            this.getPageCache().put("selectedcontractid", contractId);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("performbillentry");
            OutBudgetReportHelper.fillPerformBillEntry((Long)Long.parseLong(proBudgetId), (String)contractId, (DynamicObjectCollection)entryEntity, (String)columnName);
            this.getModel().updateEntryCache(entryEntity);
            this.getView().updateView("performbillentry");
            this.getPageCache().put("amountrecord", amountColumnValue);
        }
    }

    protected DynamicObjectCollection getTotalBudgetAmount(DynamicObject project) {
        QFilter qFilter = new QFilter("project", "=", project.getPkValue());
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        return QueryServiceHelper.query((String)"pmas_totalbudget", (String)String.join((CharSequence)",", "treeentryentity.budgetitemname", "treeentryentity.budgetamount"), (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        switch (fieldName) {
            case "occupyamt": 
            case "performamt": 
            case "budgetusedamt": 
            case "actualpayamount": 
            case "costamt": {
                this.budgetAmountHyperLinkClick(rowIndex, fieldName);
                break;
            }
            case "bizbillno": {
                this.hyperLinkToBill(rowIndex);
                break;
            }
        }
    }

    private void hyperLinkToBill(int rowIndex) {
        DynamicObject performBill = this.getModel().getEntryRowEntity("budgetperformbillentry", rowIndex);
        if (performBill != null) {
            String mainOrg;
            DynamicObject bill;
            DynamicObject org;
            String formId = performBill.getString("bizbillmark");
            String billId = performBill.getString("bizbillid");
            if (StringUtils.isEmpty((CharSequence)formId) || StringUtils.isEmpty((CharSequence)billId)) {
                return;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            String appId = dataEntityType.getAppId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)appId, (String)formId, (String)"47150e89000000ac");
            List hasPermOrg = result.getHasPermOrgs();
            if (!hasPermOrg.isEmpty() && (org = (bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)formId)).getDynamicObject(mainOrg = dataEntityType.getMainOrg())) != null && !hasPermOrg.contains(Long.parseLong(org.getPkValue().toString()))) {
                String errorTip = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OutBudgetPerformMonitorFormPlugin_44", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue());
                throw new KDBizException(errorTip);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("formId", formId);
            paramMap.put("pkId", billId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void budgetAmountHyperLinkClick(int rowIndex, String fieldName) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"budgetperformbillentry"});
        this.getModel().deleteEntryData("budgetperformbillentry");
        String projectId = this.getPageCache().get("projectfilterid");
        Object fPro = this.getView().getModel().getValue("fpro");
        if (StringUtils.isBlank((CharSequence)projectId) && fPro != null) {
            DynamicObject pro = (DynamicObject)fPro;
            projectId = pro.getPkValue().toString();
        }
        LocaleString oriAmountName = null;
        LocaleString amountName = null;
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("budgetentry", rowIndex);
        DynamicObjectCollection performBillEntry = this.getModel().getEntryEntity("budgetperformbillentry");
        switch (fieldName) {
            case "occupyamt": {
                oriAmountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5360\u7528\u91d1\u989d\uff08\u539f\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                amountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5360\u7528\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.fillOccupyOrUseAmt(projectId, rowEntity, performBillEntry, fieldName);
                break;
            }
            case "performamt": {
                oriAmountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u7533\u8bf7\u91d1\u989d\uff08\u539f\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                amountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u7533\u8bf7\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.fillApplyAmt(projectId, rowEntity, performBillEntry);
                break;
            }
            case "budgetusedamt": {
                oriAmountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u4f7f\u7528\u91d1\u989d\uff08\u539f\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_38", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                amountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u4f7f\u7528\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_39", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.fillOccupyOrUseAmt(projectId, rowEntity, performBillEntry, fieldName);
                break;
            }
            case "actualpayamount": 
            case "costamt": {
                oriAmountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d\uff08\u539f\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_40", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                amountName = new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09", (String)"OutBudgetPerformMonitorFormPlugin_41", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"actualpayamount")) {
                    this.fillActualPaidAmt(projectId, rowEntity, performBillEntry);
                    break;
                }
                this.fillCostAmt(projectId, rowEntity, performBillEntry);
                break;
            }
        }
        if (oriAmountName != null) {
            AmountEdit oriAmount = (AmountEdit)this.getControl("oriamount");
            oriAmount.setCaption(oriAmountName);
        }
        if (amountName != null) {
            AmountEdit amount = (AmountEdit)this.getControl("amount");
            amount.setCaption(amountName);
        }
        this.getModel().updateEntryCache(performBillEntry);
        this.getView().updateView("budgetperformbillentry");
    }

    private void fillOccupyOrUseAmt(String projectId, DynamicObject rowEntity, DynamicObjectCollection performBillEntry, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)projectId) || rowEntity == null) {
            return;
        }
        Object pkValue = rowEntity.getPkValue();
        if (pkValue == null) {
            return;
        }
        OutBudgetReportHelper.fillOccupyOrUseBill((Long)Long.parseLong(pkValue.toString()), (Long)Long.parseLong(projectId), (String)fieldName, (DynamicObjectCollection)performBillEntry);
    }

    private void fillApplyAmt(String projectId, DynamicObject rowEntity, DynamicObjectCollection performBillEntry) {
        if (StringUtils.isEmpty((CharSequence)projectId) || rowEntity == null) {
            return;
        }
        Object pkValue = rowEntity.getPkValue();
        if (pkValue == null) {
            return;
        }
        String budgetPk = rowEntity.getPkValue().toString();
        OutBudgetReportHelper.fillPaymentApply((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
        OutBudgetReportHelper.fillProCostSplit((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
    }

    private void fillActualPaidAmt(String projectId, DynamicObject rowEntity, DynamicObjectCollection performBillEntry) {
        if (StringUtils.isEmpty((CharSequence)projectId) || rowEntity == null) {
            return;
        }
        Object pkValue = rowEntity.getPkValue();
        if (pkValue == null) {
            return;
        }
        String budgetPk = rowEntity.getPkValue().toString();
        OutBudgetReportHelper.fillPayRegistration((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
        OutBudgetReportHelper.fillProCostSplit((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
    }

    private void fillCostAmt(String projectId, DynamicObject rowEntity, DynamicObjectCollection performBillEntry) {
        if (StringUtils.isEmpty((CharSequence)projectId) || rowEntity == null) {
            return;
        }
        Object pkValue = rowEntity.getPkValue();
        if (pkValue == null) {
            return;
        }
        String budgetPk = rowEntity.getPkValue().toString();
        OutBudgetReportHelper.fillPayApplyCostSplit((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
        OutBudgetReportHelper.fillContractCostSplit((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
        OutBudgetReportHelper.fillProCostSplit((Long)Long.parseLong(projectId), (String)budgetPk, (DynamicObjectCollection)performBillEntry);
    }
}

