/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.dataupgrade.DataUpgradeHelper;
import kd.pmgt.pmbs.business.helper.dataupgrade.ExcelUtil;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class PmgtDataUpgradePlugin
extends AbstractFormPlugin {
    public static final String OP_BUDGETRELATION_MAPPING = "budgetrelationmapping";
    public static final String OP_COSTITEM_UPGRADE = "costitemupgrade";
    public static final String OP_BUDGET_UPGRADE = "budgetupgrade";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_BUDGETRELATION_MAPPING, (CharSequence)operateKey)) {
            this.openBudgetMapping();
        } else if (StringUtils.equals((CharSequence)OP_COSTITEM_UPGRADE, (CharSequence)operateKey)) {
            this.openProjectF7(OP_COSTITEM_UPGRADE);
        } else if (StringUtils.equals((CharSequence)OP_BUDGET_UPGRADE, (CharSequence)operateKey)) {
            this.openProjectF7(OP_BUDGET_UPGRADE);
        }
    }

    private void openBudgetMapping() {
        ListShowParameter listShow = new ListShowParameter();
        listShow.setBillFormId("pmbs_budgetrelationmap");
        listShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShow.setShowTitle(true);
        this.getView().showForm((FormShowParameter)listShow);
    }

    private void openProjectF7(String callBackId) {
        String permItemId;
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true);
        lsp.setFormId("bd_projecttreelist");
        lsp.setLookUp(true);
        String permItemNum = "UPDATE_COST_ITEM";
        if (OP_BUDGET_UPGRADE.equals(callBackId)) {
            lsp.setCustomParam("parentview", (Object)"pmbs_dataupgrade");
            permItemNum = "UPDATE_BUDGET";
        }
        QFilter projectQFilter = ProjectF7FilterHelper.getProjectQFilter();
        lsp.getListFilterParameter().getQFilters().add(projectQFilter);
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!superUser && !adminUser && StringUtils.isNotEmpty((CharSequence)(permItemId = ProjectTeamPermissionHelper.getPermItemId((String)permItemNum)))) {
            List orgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)"pmbs", (String)"pmbs_dataupgrade", (String)permItemId);
            boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
            Set projectTeamProList = ProjectTeamPermissionHelper.loadHasPermProjects((QFilter)projectQFilter, (boolean)isTeamPerm, (boolean)Boolean.TRUE, (Long)RequestContext.get().getCurrUserId(), (List)orgList, (String)"pmbs", (String)"pmbs_dataupgrade");
            Set otherCloudProjectIdList = ProjectF7FilterHelper.getOtherCloudProjectIdList((List)orgList);
            projectTeamProList.addAll(otherCloudProjectIdList);
            if (projectTeamProList.size() > 0) {
                QFilter idFilter = new QFilter("id", "in", (Object)projectTeamProList);
                lsp.getListFilterParameter().getQFilters().add(idFilter);
            }
        }
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCaption(ResManager.loadKDString((String)"\u9879\u76ee", (String)"PmgtDataUpgradePlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        lsp.setShowTitle(true);
        StyleCss css = new StyleCss();
        css.setHeight("620");
        css.setWidth("1050");
        lsp.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (returnData != null && !returnData.isEmpty()) {
            Object[] projectIdArray = returnData.getPrimaryKeyValues();
            List projectIds = Arrays.stream(projectIdArray).filter(Long.class::isInstance).map(Long.class::cast).collect(Collectors.toList());
            List resultList = new ArrayList();
            if (OP_COSTITEM_UPGRADE.equals(event.getActionId())) {
                resultList = DataUpgradeHelper.updateCostItemData(projectIds);
            }
            if (OP_BUDGET_UPGRADE.equals(event.getActionId())) {
                resultList = DataUpgradeHelper.updateProBudgetData(projectIds);
            }
            if (resultList.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\uff0c\u6ca1\u6709\u6570\u636e\u9700\u8981\u5347\u7ea7\u3002", (String)"PmgtDataUpgradePlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u3002", (String)"PmgtDataUpgradePlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                ExcelUtil.exportExcel((IFormView)this.getView(), resultList);
            }
        }
    }
}

