/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProjectBudgetListPlugin
extends AbstractListPlugin
implements CellClickListener {
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String RETURN_DATA = "doreturndata";
    private static final String OPERATE_CLOSE = "close";
    private static final String NOTONLYLEAF_PARAM = "notonlyleaf";
    public static final String FIELD_CHECKBOX = "0";

    public void setFilter(SetFilterEvent setfilterevent) {
        super.setFilter(setfilterevent);
        List qFilters = setfilterevent.getQFilters();
        if (this.getPageCache().get("initfilter") == null) {
            this.getPageCache().put("initfilter", SerializationUtils.toJsonString((Object)qFilters));
        } else {
            qFilters.addAll(SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("initfilter"), QFilter.class));
        }
        this.initList(qFilters);
    }

    private void initList(List<QFilter> qFilters) {
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"name,number, description, siamount, viamount, budgetamount, vichangeamount, budgetitem, sourcetype, project, parent, currency, sequence", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"sequence asc");
        if (projectBudgets == null || projectBudgets.length == 0) {
            this.getView().updateView(KEY_TREEENTRYENTITY);
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = entries.getDynamicObjectType();
        HashMap<Long, ArrayList<DynamicObject>> childMap = new HashMap<Long, ArrayList<DynamicObject>>();
        ArrayList<DynamicObject> firstLevelList = new ArrayList<DynamicObject>();
        this.buildDataRelationship(projectBudgets, firstLevelList, childMap);
        for (DynamicObject firstLevelData : firstLevelList) {
            this.recursiveAddEntry(entries, dt, firstLevelData, childMap);
        }
        this.getModel().updateEntryCache(entries);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    private void buildDataRelationship(DynamicObject[] projectBudgets, ArrayList<DynamicObject> firstLevelList, HashMap<Long, ArrayList<DynamicObject>> childMap) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject projectBudget : projectBudgets) {
            dataMap.put(projectBudget.getLong("id"), projectBudget);
        }
        HashSet<Long> hasAddedSet = new HashSet<Long>();
        for (DynamicObject projectBudget : projectBudgets) {
            this.recursiveAddData(projectBudget, firstLevelList, childMap, hasAddedSet, dataMap);
        }
    }

    private void recursiveAddData(DynamicObject projectBudget, ArrayList<DynamicObject> firstLevelList, HashMap<Long, ArrayList<DynamicObject>> childMap, HashSet<Long> hasAddedSet, HashMap<Long, DynamicObject> dataMap) {
        long id = projectBudget.getLong("id");
        if (!hasAddedSet.contains(id)) {
            long parentId = projectBudget.getLong("parent");
            if (parentId == 0L) {
                firstLevelList.add(projectBudget);
            } else {
                ArrayList<Object> childList = childMap.get(parentId);
                if (childList == null) {
                    childList = new ArrayList();
                    childMap.put(parentId, childList);
                }
                childList.add(projectBudget);
                DynamicObject parent = dataMap.get(parentId);
                if (parent == null && QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)parentId)) {
                    parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"pmas_projectbudget");
                }
                this.recursiveAddData(parent, firstLevelList, childMap, hasAddedSet, dataMap);
            }
            hasAddedSet.add(projectBudget.getLong("id"));
        }
    }

    private void recursiveAddEntry(DynamicObjectCollection entries, DynamicObjectType dt, DynamicObject data, HashMap<Long, ArrayList<DynamicObject>> childMap) {
        this.addEntryData(entries, dt, data);
        ArrayList<DynamicObject> childList = childMap.get(data.getLong("id"));
        if (childList != null && childList.size() > 0) {
            for (DynamicObject child : childList) {
                this.recursiveAddEntry(entries, dt, child, childMap);
            }
        }
    }

    private void addEntryData(DynamicObjectCollection entries, DynamicObjectType dt, DynamicObject projectBudget) {
        DynamicObject entry = new DynamicObject(dt);
        entry.set("id", projectBudget.getPkValue());
        entry.set("name", projectBudget.get("name"));
        entry.set("budgetitem", (Object)projectBudget.getDynamicObject("budgetitem"));
        entry.set("project", (Object)projectBudget.getDynamicObject("project"));
        entry.set("desc", projectBudget.get("description"));
        entry.set("pid", (Object)projectBudget.getLong("parent"));
        entries.add((Object)entry);
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        grid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent cellclickevent) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isMultiSelect = listShowParameter.isMultiSelect();
        boolean notOnlyLeaf = listShowParameter.getCustomParam(NOTONLYLEAF_PARAM) != null;
        TreeEntryGrid grid = (TreeEntryGrid)cellclickevent.getSource();
        Object row = cellclickevent.getRow();
        int[] selectRows = grid.getSelectRows();
        int rowCount = this.getModel().getEntryRowCount(KEY_TREEENTRYENTITY);
        String fieldKey = cellclickevent.getFieldKey();
        if (!isMultiSelect && selectRows != null && selectRows.length > 0) {
            selectRows = new int[]{row};
        }
        HashSet<Integer> selectRowSet = new HashSet<Integer>(10);
        Set<Object> isLeafRowSet = new HashSet(0);
        if (selectRows != null && selectRows.length > 0) {
            isLeafRowSet = this.getIsLeafRowIndex();
            for (int index : selectRows) {
                boolean isLeaf = isLeafRowSet.contains(index);
                if (!isLeaf && !notOnlyLeaf) continue;
                selectRowSet.add(index);
            }
        }
        if (isMultiSelect && row != rowCount - 1) {
            boolean isAllSelectOrClear = false;
            if (selectRows == null || selectRows.length == 0 || selectRows.length == rowCount) {
                isAllSelectOrClear = true;
            }
            boolean isCancelSelect = false;
            HashSet<Integer> reduceRowSet = new HashSet<Integer>();
            if (!isAllSelectOrClear && FIELD_CHECKBOX.equals(fieldKey)) {
                String selectRowString = this.getPageCache().get("ProBudgetItemSelectRows");
                if (selectRowString != null) {
                    String[] rowStringArray = selectRowString.split(",");
                    if (rowStringArray.length > selectRows.length) {
                        isCancelSelect = true;
                    }
                    if (selectRows.length > 0) {
                        HashSet<Integer> selectRowStringSet = new HashSet<Integer>(rowStringArray.length);
                        for (String rowString : rowStringArray) {
                            Integer index = Integer.valueOf(rowString);
                            selectRowStringSet.add(index);
                        }
                        if (!isCancelSelect) {
                            for (Object i : (Iterator)selectRows) {
                                if (selectRowStringSet.contains((int)i)) continue;
                                row = i;
                            }
                        } else {
                            Iterator iterator = selectRowStringSet.iterator();
                            while (iterator.hasNext()) {
                                int rowIndex = (Integer)iterator.next();
                                if (selectRowSet.contains(rowIndex)) continue;
                                row = rowIndex;
                                break;
                            }
                        }
                    }
                } else if (!isLeafRowSet.contains(row)) {
                    isCancelSelect = true;
                }
            } else if (!isLeafRowSet.contains(row)) {
                isCancelSelect = true;
            }
            if (!isAllSelectOrClear) {
                if (isCancelSelect) {
                    reduceRowSet.add((Integer)row);
                    this.getSubRowIndex((int)row, rowCount, (Set<Integer>)reduceRowSet);
                    selectRowSet.removeAll(reduceRowSet);
                } else if (notOnlyLeaf) {
                    selectRowSet.add((Integer)row);
                    this.getSubRowIndex((int)row, rowCount, (Set<Integer>)selectRowSet);
                }
            }
        }
        int[] finalSelectRows = new int[selectRowSet.size()];
        int i = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer integer : selectRowSet) {
            finalSelectRows[i] = integer;
            stringBuilder.append(integer);
            stringBuilder.append(',');
            ++i;
        }
        grid.selectRows(finalSelectRows, row);
        this.getPageCache().put("ProBudgetItemSelectRows", stringBuilder.length() == 0 ? null : stringBuilder.substring(0, stringBuilder.length() - 1));
    }

    private int getSubRowIndex(int row, int rowCount, Set<Integer> selectRowSet) {
        Object pkValue = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, row).getPkValue();
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, i);
            if (!pkValue.toString().equals(rowEntity.getString("pid"))) {
                return i - 1;
            }
            selectRowSet.add(i);
            i = this.getSubRowIndex(i, rowCount, selectRowSet);
        }
        return rowCount;
    }

    private Set<Integer> getIsLeafRowIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        HashSet<Integer> rowSet = new HashSet<Integer>();
        if (entryEntity != null && entryEntity.size() > 0) {
            long previousRowId = 0L;
            int previousIndex = -1;
            for (DynamicObject entry : entryEntity) {
                long pid;
                if (previousIndex != -1 && (pid = entry.getLong("pid")) != previousRowId) {
                    rowSet.add(previousIndex);
                }
                previousRowId = entry.getLong("id");
                ++previousIndex;
            }
            rowSet.add(previousIndex);
        }
        return rowSet;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        switch (operateKey) {
            case "doreturndata": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ProjectBudgetListPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRowCollection returnData = new ListSelectedRowCollection();
                for (int index : selectRows) {
                    ListSelectedRow returnProjectKind = new ListSelectedRow(this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, index).getPkValue(), Boolean.TRUE);
                    returnData.add((Object)returnProjectKind);
                }
                this.getView().returnDataToParent((Object)returnData);
                this.getView().invokeOperation(OPERATE_CLOSE);
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

