/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.pmgt.pmbs.business.helper.ConstructorTreeDataHelper;
import kd.pmgt.pmbs.business.helper.ProjectKindHelper;
import kd.pmgt.pmbs.business.helper.TreeNodeSearchHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectKindSyncFormPlugin
extends AbstractTreeListPlugin
implements SearchEnterListener,
TreeNodeCheckListener {
    private static final String BD_PROJECTKIND = "bd_projectkind";
    private static final String PMBS_PROJECTKIND = "pmbs_projectkind";
    private static final String BD_TREE_PROJECTKIND = "bdtreeviewap";
    private static final String PMGT_TREE_PROJECTKIND = "pmgttreeviewap";
    private static final String OLD_PMGT_IDS = "old_pmgt_ids";
    private static final String NEW_PMGT_IDS = "new_pmgt_ids";
    private static final String BTN_DELNODE = "btn_delnode";
    private static final String BTN_ADDNODE = "btn_addnode";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String ids = this.initTree(false);
        this.getPageCache().put(OLD_PMGT_IDS, ids);
    }

    private String initTree(boolean showNumber) {
        ConstructorTreeDataHelper bdTree = new ConstructorTreeDataHelper(this.getView(), BD_TREE_PROJECTKIND, BD_PROJECTKIND, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter[] qFilters = new QFilter[]{enableFilter, statusFilter};
        bdTree.setQFilters(qFilters);
        bdTree.constructorTreeData(showNumber);
        String ids = ProjectKindHelper.buildProjectKindTree((IFormView)this.getView(), (String)PMGT_TREE_PROJECTKIND, (String)ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), null, (boolean)showNumber);
        this.getPageCache().put(NEW_PMGT_IDS, ids);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_DELNODE, BTN_ADDNODE});
        this.clearSearchText("bdsearch");
        this.clearSearchText("pmgtsearch");
        return ids;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "add": {
                Set bdSelectedNodeIds = ((TreeView)this.getView().getControl(BD_TREE_PROJECTKIND)).getTreeState().getSelectedNodeId().stream().map(id -> Long.parseLong(id)).collect(Collectors.toSet());
                String pmgtIds = this.getPageCache().get(NEW_PMGT_IDS);
                if (pmgtIds != null && !pmgtIds.isEmpty()) {
                    String[] idsArr;
                    for (String id2 : idsArr = pmgtIds.split(",")) {
                        bdSelectedNodeIds.add(Long.parseLong(id2));
                    }
                }
                DynamicObject[] allProjectKinds = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)"parent", (QFilter[])new QFilter[0]);
                DynamicObject[] selectedNodeProjectKinds = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", bdSelectedNodeIds)});
                HashSet<Long> allNodes = new HashSet<Long>(10);
                for (DynamicObject dynamicObject : selectedNodeProjectKinds) {
                    allNodes.add(Long.parseLong(dynamicObject.getPkValue().toString()));
                    List parentNodes = TreeNodeSearchHelper.findParentNode((DynamicObject[])allProjectKinds, (DynamicObject)dynamicObject);
                    for (DynamicObject parentNode : parentNodes) {
                        allNodes.add(Long.parseLong(parentNode.getPkValue().toString()));
                    }
                }
                QFilter idFilter = new QFilter("id", "in", allNodes);
                String ids = ProjectKindHelper.buildProjectKindTree((IFormView)this.getView(), (String)PMGT_TREE_PROJECTKIND, (String)ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), (QFilter)idFilter, (boolean)this.showNumber());
                this.getPageCache().put(NEW_PMGT_IDS, ids);
                this.clearSearchText("pmgtsearch");
                break;
            }
            case "delete": {
                String[] idsArr;
                Set pmgtSelectedNodeIds = ((TreeView)this.getView().getControl(PMGT_TREE_PROJECTKIND)).getTreeState().getSelectedNodeId().stream().map(id -> Long.parseLong(id)).collect(Collectors.toSet());
                String pmgtIds = this.getPageCache().get(NEW_PMGT_IDS);
                HashSet<Long> pmgtAllIds = new HashSet<Long>(10);
                if (pmgtIds == null || pmgtIds.isEmpty()) break;
                for (String id3 : idsArr = pmgtIds.split(",")) {
                    pmgtAllIds.add(Long.parseLong(id3));
                }
                Set releaseId = pmgtAllIds.stream().filter(id -> !pmgtSelectedNodeIds.contains(id)).collect(Collectors.toSet());
                ConstructorTreeDataHelper pmgtTree = new ConstructorTreeDataHelper(this.getView(), PMGT_TREE_PROJECTKIND, BD_PROJECTKIND, ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                pmgtTree.setQFilters(new QFilter[]{new QFilter("id", "in", releaseId)});
                String ids = pmgtTree.constructorTreeData(this.showNumber());
                this.getPageCache().put(NEW_PMGT_IDS, ids);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_DELNODE});
                this.clearSearchText("pmgtsearch");
                break;
            }
            case "save": {
                String oldIds = this.getPageCache().get(OLD_PMGT_IDS);
                String newIds = this.getPageCache().get(NEW_PMGT_IDS);
                HashSet<Long> pmgtOldIds = new HashSet<Long>(10);
                String[] oldIdsArr = oldIds.split(",");
                if (!oldIds.isEmpty()) {
                    for (String id4 : oldIdsArr) {
                        pmgtOldIds.add(Long.parseLong(id4));
                    }
                }
                HashSet<Long> pmgtNewIds = new HashSet<Long>(10);
                if (!newIds.isEmpty()) {
                    for (String id5 : newIds.split(",")) {
                        pmgtNewIds.add(Long.parseLong(id5));
                    }
                }
                Set<Long> deleteIds = pmgtOldIds.stream().filter(id -> !pmgtNewIds.contains(id)).collect(Collectors.toSet());
                int selectSize = deleteIds.size();
                StringBuilder tips = this.getRefTips(deleteIds, pmgtNewIds);
                int deleteSize = deleteIds.size();
                ProjectKindHelper.syncToPMGT(pmgtNewIds, deleteIds);
                ConstructorTreeDataHelper pmgtTree = new ConstructorTreeDataHelper(this.getView(), PMGT_TREE_PROJECTKIND, BD_PROJECTKIND, ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                pmgtTree.setQFilters(new QFilter[]{new QFilter("id", "in", pmgtNewIds)});
                String ids = pmgtTree.constructorTreeData(this.showNumber());
                this.getPageCache().put(NEW_PMGT_IDS, ids);
                this.getPageCache().put(OLD_PMGT_IDS, ids);
                if (selectSize == deleteSize || selectSize == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ProjectKindSyncFormPlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (selectSize <= deleteSize) break;
                if (deleteSize > 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u90e8\u5206\u6570\u636e\u65e0\u6cd5\u79fb\u9664\u3002", (String)"ProjectKindSyncFormPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), tips.toString(), MessageTypes.Default);
                    break;
                }
                this.getView().showMessage(tips.toString());
                break;
            }
        }
    }

    private StringBuilder getRefTips(Set<Long> deleteIds, Set<Long> pmgtNewIds) {
        DynamicObject[] allProjectKinds = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)"parent", (QFilter[])new QFilter[0]);
        HashSet<Long> refIds = new HashSet<Long>();
        StringBuilder tips = new StringBuilder();
        BaseDataCheckRefrence baseDataCheckRefrence = new BaseDataCheckRefrence();
        for (Long id : deleteIds) {
            Set ignore = baseDataCheckRefrence.getIgnoreRefEntityIds();
            ignore.add("pmbs_prokindctrlsetting");
            ignore.add("pmpt_tasksource");
            ignore.add(BD_PROJECTKIND);
            ignore.add("bd_project_base");
            ignore.add("bd_project_hr");
            ignore.add("bd_project");
            baseDataCheckRefrence.setDraftValidReference(true);
            Map map = BaseDataRefrenceHelper.checkRefrenced((String)BD_PROJECTKIND, (Object[])new Object[]{id}, (Collection)ignore, null, null);
            if (map.isEmpty()) continue;
            BaseDataCheckRefrenceResult referResult = (BaseDataCheckRefrenceResult)map.get(id);
            String refFormId = referResult.getRefenceKey().getRefEntityKey();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refFormId);
            String refBillName = refMainType.getDisplayName().toString();
            DynamicObject pmbsProjectKind = BusinessDataServiceHelper.loadSingle((String)PMBS_PROJECTKIND, (String)"name,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            String projectKindName = pmbsProjectKind.getString("name");
            String str = null;
            str = StringUtils.equals((CharSequence)refFormId, (CharSequence)"pmas_proappf7") ? String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u53ef\u79fb\u9664\uff0c\u201c\u9879\u76ee\u7acb\u9879\u201d\u7684\u5b57\u6bb5\u201c\u9879\u76ee\u5206\u7c7b\u201d\u5f15\u7528\u6b64\u57fa\u7840\u8d44\u6599\u3002", (String)"ProjectKindSyncFormPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKindName) : String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u53ef\u79fb\u9664\uff0c\u201c%2$s\u201d\u7684\u5b57\u6bb5\u201c\u9879\u76ee\u5206\u7c7b\u201d\u5f15\u7528\u6b64\u57fa\u7840\u8d44\u6599\u3002", (String)"ProjectKindSyncFormPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKindName, refBillName);
            tips.append(str);
            tips.append("\r\n");
            refIds.add(id);
            List parents = TreeNodeSearchHelper.findParentNode((DynamicObject[])allProjectKinds, (DynamicObject)pmbsProjectKind);
            for (DynamicObject parent : parents) {
                refIds.add(Long.parseLong(parent.getPkValue().toString()));
            }
        }
        deleteIds.removeAll(refIds);
        pmgtNewIds.addAll(refIds);
        return tips;
    }

    public void registerListener(EventObject e) {
        TreeView pmgtProKindTreeView;
        super.registerListener(e);
        Search bdsearch = (Search)this.getControl("bdsearch");
        bdsearch.addEnterListener((SearchEnterListener)this);
        Search pmgtsearch = (Search)this.getControl("pmgtsearch");
        pmgtsearch.addEnterListener((SearchEnterListener)this);
        TreeView bdProKindTreeview = (TreeView)this.getControl(BD_TREE_PROJECTKIND);
        if (bdProKindTreeview != null) {
            bdProKindTreeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        }
        if ((pmgtProKindTreeView = (TreeView)this.getControl(PMGT_TREE_PROJECTKIND)) != null) {
            pmgtProKindTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        }
    }

    public void search(SearchEnterEvent evt) {
        DynamicObject[] projectkinds;
        String treeKey;
        String rootNodeName;
        super.search(evt);
        Search search = (Search)evt.getSource();
        String key = search.getKey();
        String searchText = evt.getText();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if ("bdsearch".equals(key)) {
            rootNodeName = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
            treeKey = BD_TREE_PROJECTKIND;
            projectkinds = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)"parent", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        } else if ("pmgtsearch".equals(key)) {
            rootNodeName = ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u9879\u76ee\u5206\u7c7b", (String)"ProjectKindSyncFormPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
            treeKey = PMGT_TREE_PROJECTKIND;
            String newIds = this.getPageCache().get(NEW_PMGT_IDS);
            DynamicObject[] newIdSet = Arrays.asList(newIds.split(",")).stream().map(id -> Long.parseLong(id)).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", (Object)newIdSet);
            projectkinds = BusinessDataServiceHelper.load((String)BD_PROJECTKIND, (String)"parent", (QFilter[])new QFilter[]{idFilter, enableFilter, statusFilter});
        } else {
            return;
        }
        HashSet<Long> allNodes = new HashSet<Long>(10);
        for (DynamicObject projectKind : projectkinds) {
            String name = projectKind.getLocaleString("name").toString();
            String number = projectKind.getString("number");
            if (!searchText.isEmpty() && !name.contains(searchText) && (!this.showNumber() || !number.contains(searchText))) continue;
            allNodes.add(Long.parseLong(projectKind.getPkValue().toString()));
            List childTreeNodes = TreeNodeSearchHelper.findChildTreeNode((DynamicObject[])projectkinds, (DynamicObject)projectKind);
            for (DynamicObject childTreeNode : childTreeNodes) {
                allNodes.add(Long.parseLong(childTreeNode.getPkValue().toString()));
            }
            List parentNodes = TreeNodeSearchHelper.findParentNode((DynamicObject[])projectkinds, (DynamicObject)projectKind);
            for (DynamicObject parentNode : parentNodes) {
                allNodes.add(Long.parseLong(parentNode.getPkValue().toString()));
            }
        }
        ConstructorTreeDataHelper helper = new ConstructorTreeDataHelper(this.getView(), treeKey, BD_PROJECTKIND, rootNodeName);
        helper.setQFilters(new QFilter[]{new QFilter("id", "in", allNodes)});
        helper.constructorTreeData(this.showNumber(), searchText);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("shownumber".equals(name)) {
            Boolean showNumber = (Boolean)newValue;
            this.initTree(showNumber);
        }
    }

    private boolean showNumber() {
        return (Boolean)this.getModel().getValue("shownumber");
    }

    private void clearSearchText(String key) {
        Search search = (Search)this.getControl(key);
        search.setSearchKey("");
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        TreeView pmgtProKindTreeView;
        TreeView bdProKindTreeView = (TreeView)this.getView().getControl(BD_TREE_PROJECTKIND);
        if (bdProKindTreeView != null) {
            TreeView.TreeState bdProKindTreeState = bdProKindTreeView.getTreeState();
            List bdselectIds = bdProKindTreeState.getCheckedNodeIds();
            if (bdselectIds.size() == 1 && bdselectIds.contains("001")) {
                bdselectIds.remove("001");
            }
            this.getView().setEnable(Boolean.valueOf(!bdselectIds.isEmpty()), new String[]{BTN_ADDNODE});
        }
        if ((pmgtProKindTreeView = (TreeView)this.getView().getControl(PMGT_TREE_PROJECTKIND)) != null) {
            TreeView.TreeState pmgtProKindTreeState = pmgtProKindTreeView.getTreeState();
            List pmgtselectIds = pmgtProKindTreeState.getCheckedNodeIds();
            if (pmgtselectIds.size() == 1 && pmgtselectIds.contains("001")) {
                pmgtselectIds.remove("001");
            }
            this.getView().setEnable(Boolean.valueOf(!pmgtselectIds.isEmpty()), new String[]{BTN_DELNODE});
        }
    }
}

