/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.base;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.OrgUtil;

public class AbstractPmgtBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CREATE_ORG = "createorg";

    public String getOrgViewType() {
        return "15";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit createOrg = (BasedataEdit)this.getView().getControl(CREATE_ORG);
        if (createOrg != null) {
            createOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.needValidateGroupUserPermission() && !this.isGroupUser()) {
            this.groupUserPermisDeniedHandle();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getView().getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map fields = dataEntityType.getFields();
        boolean hasCreateOrg = fields.containsKey(CREATE_ORG);
        String billStatusName = null;
        if (dataEntityType instanceof BillEntityType) {
            billStatusName = ((BillEntityType)dataEntityType).getBillStatus();
        }
        if (hasCreateOrg && !StringUtils.isBlank((CharSequence)billStatusName)) {
            DynamicObject creator;
            DynamicObject createOrg = this.getModel().getDataEntity().getDynamicObject(CREATE_ORG);
            String status = (String)this.getModel().getValue(billStatusName);
            if (StatusEnum.TEMPSAVE.getValue().equals(status) && (creator = this.getModel().getDataEntity().getDynamicObject("creator")) != null) {
                long creatorId = creator.getLong("id");
                String queryUserDep = this.getPageCache().get("queryUserDep");
                if (StringUtils.isEmpty((CharSequence)queryUserDep) || createOrg == null) {
                    List userDepartment = UserServiceHelper.getUserDepartment((long)creatorId, (boolean)false);
                    if (userDepartment.size() == 1) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{CREATE_ORG});
                    }
                    this.getPageCache().put("queryUserDep", "1");
                    boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (!fromDatabase && createOrg == null) {
                        Long loginOrg = RequestContext.get().getOrgId();
                        if (userDepartment.contains(loginOrg)) {
                            this.getModel().setValue(CREATE_ORG, (Object)loginOrg);
                        } else {
                            long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)creatorId);
                            this.getModel().setValue(CREATE_ORG, (Object)userMainOrgId);
                        }
                    }
                }
            }
        }
    }

    protected boolean needValidateGroupUserPermission() {
        return false;
    }

    protected String getBillStatusName() {
        return "status";
    }

    protected boolean isGroupUser() {
        boolean isGroupUser;
        String isGroupUserStr = this.getPageCache().get("isGroupUserStr");
        if (StringUtils.isEmpty((CharSequence)isGroupUserStr)) {
            isGroupUser = OrgUtil.isGroupUser();
            this.getPageCache().put("isGroupUserStr", String.valueOf(isGroupUser));
        } else {
            isGroupUser = Boolean.parseBoolean(isGroupUserStr);
        }
        return isGroupUser;
    }

    protected void groupUserPermisDeniedHandle() {
        this.getModel().setValue(this.getBillStatusName(), (Object)StatusEnum.CHECKED.getValue());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "createorg": {
                this.beforeOpenCreateOrg(e);
                break;
            }
        }
    }

    private void beforeOpenCreateOrg(BeforeF7SelectEvent e) {
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        List departments = UserServiceHelper.getUserDepartment((long)RequestContext.get().getCurrUserId(), (boolean)false);
        if (departments.isEmpty()) {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        } else {
            qFilters.add(new QFilter("id", "in", (Object)departments));
            param.setF7ClickByFilter(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicProperty createOrgProperty = dataEntity.getDynamicObjectType().getProperty(CREATE_ORG);
        DynamicProperty createOrgIdProperty = dataEntity.getDynamicObjectType().getProperty("createorg_id");
        if (createOrgProperty != null && createOrgIdProperty != null) {
            dataEntity.getDataEntityState().setBizChanged(createOrgProperty.getOrdinal(), false);
            dataEntity.getDataEntityState().setBizChanged(createOrgIdProperty.getOrdinal(), false);
        }
    }
}

