/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class BudgetItemEditPlugin
extends AbstractPmbsBillPlugin {
    public static final String FIELD_ID = "id";
    public static final String FIELD_PARENT = "parent";
    private static final String OPERATE_NEW = "new";
    private static final String KEY_PROPARENTID = "budgetitem_parentid";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costItem = (BasedataEdit)this.getControl("costitem");
        costItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject parent;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OPERATE_NEW.equals(operateKey) && (parent = (DynamicObject)this.getModel().getValue(FIELD_PARENT)) != null) {
            this.getPageCache().put(KEY_PROPARENTID, parent.getString(FIELD_ID));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPERATE_NEW.equals(operateKey)) {
            String parentId = this.getPageCache().get(KEY_PROPARENTID);
            this.getPageCache().remove(KEY_PROPARENTID);
            if (parentId != null && !"".equals(parentId)) {
                this.getModel().setValue(FIELD_PARENT, (Object)parentId);
                this.getView().updateView(FIELD_PARENT);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String name = e.getProperty().getName();
        if ("costitem".equals(name)) {
            QFilter costItemLeafFilter = new QFilter("isleaf", "=", (Object)true);
            e.addCustomQFilter(costItemLeafFilter);
            List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"view");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)orgList, (boolean)true);
            DynamicObject[] costDimensionList = BusinessDataServiceHelper.load((String)"pmbs_cost_dimension", (String)FIELD_ID, (QFilter[])new QFilter[]{qFilter});
            List idList = Arrays.stream(costDimensionList).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter dimensionFilter = new QFilter("costdimension.id", "in", idList);
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(dimensionFilter);
            List costItemOrgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)"pmbs", (String)"pmbs_costitem", (String)"view");
            QFilter costItemFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_costitem", (List)costItemOrgList, (boolean)true);
            formShowParameter.getListFilterParameter().getQFilters().add(costItemFilter);
        }
    }
}

