/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;

public class BudgetItemListPlugin
extends AbstractPmbsListPlugin
implements HyperLinkClickListener,
CellClickListener {
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_PROJECTKINDNUMBER = "budgetitemnumber";
    public static final String FIELD_PROJECTKINDNUMBERID = "budgetitemnumber_id";
    public static final String KEY_TREEENTRYENTITY = "budgetitementity";
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_ID = "id";
    public static final String FIELD_ISLEAF = "isleaf";
    public static final String SELECTED_FIELDS = "id,number,name,isleaf,enable,parent,level";
    public static final String COST_ITEM = "costitem";
    private static final String OPERATE_NEW = "new";
    private static final String OPERATE_DELETE = "dodelete";
    private static final String OPERATE_ENABLE = "doenable";
    private static final String OPERATE_DISABLE = "dodisable";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String OPERATE_CLOSE = "close";
    private static final String RETURN_DATA = "doreturndata";
    private static final String CALLBACKKEY_ADDNEW = "projectkind_addnew";
    private static final String CALLBACKKEY_DISABLE = "projectkind_disable";
    private static final String CALLBACKKEY_DELETE = "projectkind_delete";
    private static final String CALLBACKKEY_EDIT = "budgetitem_edit";
    private static final String PMBS_BUDGETITEM = "pmbs_budgetitem";
    public static final String FIELD_CHECKBOX = "0";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        QFilter[] qFilters = new QFilter[filters.size()];
        int i = 0;
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter;
            qFilters[i] = qFilter = (QFilter)iterator.next();
            ++i;
        }
        this.initList(qFilters);
        this.setCollapseAndExpand();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List selectedItemIds = (List)this.getView().getFormShowParameter().getCustomParam("selectedItemIds");
        DynamicObjectCollection valueItems = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (selectedItemIds != null && selectedItemIds.size() > 0) {
            HashSet<Integer> seleteRows = new HashSet<Integer>();
            for (int i = 0; i < valueItems.size(); ++i) {
                DynamicObject rowEntity = (DynamicObject)valueItems.get(i);
                Long id = (Long)rowEntity.getDynamicObject(FIELD_PROJECTKINDNUMBER).getPkValue();
                if (!selectedItemIds.contains(id)) continue;
                seleteRows.add(i);
            }
            int[] rowIndexs = new int[seleteRows.size()];
            int n = 0;
            for (Integer seleteRow : seleteRows) {
                rowIndexs[n++] = seleteRow;
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
            treeEntryGrid.selectRows(rowIndexs, ((Integer)seleteRows.stream().findAny().get()).intValue());
        }
    }

    private void initList(QFilter[] qFilters) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        FormDataModel dataModel = (FormDataModel)grid.getModel();
        dataModel.deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])qFilters, (String)FIELD_NUMBER);
        int maxLevel = 0;
        for (DynamicObject budgetItem : projectKinds) {
            maxLevel = budgetItem.getInt(FIELD_LEVEL) > maxLevel ? budgetItem.getInt(FIELD_LEVEL) : maxLevel;
        }
        HashMap<Object, List<DynamicObject>> sonListMap = new HashMap<Object, List<DynamicObject>>();
        LinkedHashMap<Integer, List<DynamicObject>> dataMap = new LinkedHashMap<Integer, List<DynamicObject>>();
        if (projectKinds.length > 0) {
            for (DynamicObject projectKind : projectKinds) {
                int level = projectKind.getInt(FIELD_LEVEL);
                List xList = (List)dataMap.get(level);
                if (xList != null) {
                    xList.add(projectKind);
                } else {
                    dataMap.put(level, new LinkedList());
                    ((List)dataMap.get(level)).add(projectKind);
                }
                DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
                if (parent == null) continue;
                ArrayList<DynamicObject> sonList = (ArrayList<DynamicObject>)sonListMap.get(parent.getPkValue());
                if (sonList != null) {
                    sonList.add(projectKind);
                    continue;
                }
                sonList = new ArrayList<DynamicObject>();
                sonList.add(projectKind);
                sonListMap.put(parent.getPkValue(), sonList);
            }
            for (int i = 1; i <= maxLevel; ++i) {
                this.fillTreeList(dataMap, sonListMap, i);
            }
        }
    }

    private void fillTreeList(Map<Integer, List<DynamicObject>> dataMap, Map<Object, List<DynamicObject>> sonListMap, int level) {
        this.fillTreeList(dataMap, sonListMap, false, 0, dataMap.get(level), false);
    }

    private void fillTreeList(Map<Integer, List<DynamicObject>> dataMap, Map<Object, List<DynamicObject>> sonListMap, boolean isSon, int rowIndex, List<DynamicObject> dataList, boolean needToReverse) {
        if (dataList == null) {
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        FormDataModel model = (FormDataModel)grid.getModel();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            List<DynamicObject> sonList;
            DynamicObject data = dataList.get(i);
            int rIndex = 0;
            rIndex = isSon ? model.insertEntryRow(KEY_TREEENTRYENTITY, rowIndex) : model.createNewEntryRow(KEY_TREEENTRYENTITY);
            grid.setCollapse(false);
            model.setValue(FIELD_PROJECTKINDNUMBER, data.get(FIELD_ID), rIndex);
            if (isSon) {
                dataMap.get(data.getInt(FIELD_LEVEL)).remove(data);
            }
            if ((sonList = sonListMap.get(data.getPkValue())) == null || sonList.size() <= 0) continue;
            this.fillTreeList(dataMap, sonListMap, true, rIndex, sonList, !needToReverse);
        }
    }

    private void setCollapseAndExpand() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        ArrayList<Integer> collapseRowList = new ArrayList<Integer>(10);
        int rowIndex = 0;
        for (DynamicObject entry : entries) {
            Integer level = entry.getDynamicObject(FIELD_PROJECTKINDNUMBER).getInt(FIELD_LEVEL);
            if (level > 1) {
                collapseRowList.add(rowIndex);
            }
            ++rowIndex;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        int[] collapseRowArray = new int[collapseRowList.size()];
        for (int i = 0; i < collapseRowList.size(); ++i) {
            collapseRowArray[i] = (Integer)collapseRowList.get(i);
        }
        grid.collapse(collapseRowArray);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        if (selectRows != null && (selectRows.length != 1 || selectRows[0] != -1)) {
            for (int rowIndex : selectRows) {
                pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
            }
        }
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        boolean showConfirm = false;
        HashSet<Object> deleteIds = new HashSet<Object>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        switch (operateKey) {
            case "new": {
                if (selectRows != null && selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u4e2d\u591a\u884c\u65b0\u589e\u3002", (String)"BudgetItemListPlugin_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectRows == null || selectRows.length != 1) break;
                DynamicObject dynamicObject = (DynamicObject)gridRows.get(selectRows[0]);
                DynamicObject projectKind = dynamicObject.getDynamicObject(FIELD_PROJECTKINDNUMBER);
                String isEnable = projectKind.getString(FIELD_ENABLE);
                if (FIELD_CHECKBOX.equals(isEnable)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"BudgetItemListPlugin_29", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject parent = dynamicObject.getDynamicObject(FIELD_PROJECTKINDNUMBER);
                if (parent == null) break;
                DynamicObjectCollection costItemList = parent.getDynamicObjectCollection(COST_ITEM);
                if (!costItemList.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7 %s \u9884\u7b97\u9879\u5df2\u7ecf\u6620\u5c04\u8fc7\u6210\u672c\u9879\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"BudgetItemListPlugin_26", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), parent.getLocaleString("name").getLocaleValue()));
                    args.setCancel(true);
                    return;
                }
                List allRefs = BaseDataRefrenceHelper.getAllRefs((String)PMBS_BUDGETITEM, (Object)parent.getPkValue());
                Optional<BaseDataRefenceKey> refOptional = allRefs.stream().filter(ref -> !PMBS_BUDGETITEM.equals(ref.getRefEntityKey())).findFirst();
                if (!refOptional.isPresent()) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7 %s \u9884\u7b97\u9879\u5df2\u88ab\u4e1a\u52a1\u6570\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"BudgetItemListPlugin_27", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), parent.getLocaleString("name").getLocaleValue()));
                args.setCancel(true);
                return;
            }
            case "doenable": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BudgetItemListPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject projectKind : projectKinds) {
                    String isEnable = projectKind.getString(FIELD_ENABLE);
                    if ("1".equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"BudgetItemListPlugin_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        ++failCount;
                        continue;
                    }
                    DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
                    if (parent != null && FIELD_CHECKBOX.equals(parent.getString(FIELD_ENABLE))) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u7236\u8282\u70b9\u672a\u542f\u7528\u3002", (String)"BudgetItemListPlugin_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        ++failCount;
                        continue;
                    }
                    projectKind.set(FIELD_ENABLE, (Object)"1");
                    updateList.add(projectKind);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(failMessage.toString());
                    } else {
                        String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u542f\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"BudgetItemListPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), selectRows.length, selectRows.length, failCount);
                        this.getView().showConfirm(string, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BudgetItemListPlugin_6", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
            case "dodisable": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BudgetItemListPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject projectKind : projectKinds) {
                    boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
                    if (isLeaf) continue;
                    showConfirm = true;
                    break;
                }
                if (showConfirm) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"BudgetItemListPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u4e2d\u9879\u76ee\u5206\u7c7b\u6709\u4e0b\u7ea7\u9879\u76ee\u5206\u7c7b\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u5176\u6240\u6709\u4e0b\u7ea7\u9879\u76ee\u5206\u7c7b\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetItemListPlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKKEY_DISABLE, (IFormPlugin)this));
                    break;
                }
                for (DynamicObject projectKind : projectKinds) {
                    String isEnable = projectKind.getString(FIELD_ENABLE);
                    if (FIELD_CHECKBOX.equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"BudgetItemListPlugin_33", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        ++failCount;
                        continue;
                    }
                    projectKind.set(FIELD_ENABLE, (Object)FIELD_CHECKBOX);
                    updateList.add(projectKind);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(failMessage.toString());
                    } else {
                        String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"BudgetItemListPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), selectRows.length, updateList.size(), failCount);
                        this.getView().showConfirm(string, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BudgetItemListPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
            case "dodelete": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BudgetItemListPlugin_30", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject projectKind : projectKinds) {
                    boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
                    if (isLeaf) continue;
                    showConfirm = true;
                    break;
                }
                if (showConfirm) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"BudgetItemListPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u4e2d\u9884\u7b97\u9879\u6709\u4e0b\u7ea7\u9884\u7b97\u9879\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u5176\u6240\u6709\u4e0b\u7ea7\u9884\u7b97\u9879\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetItemListPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
                    break;
                }
                LinkedList<Object> linkedList = new LinkedList<Object>();
                for (DynamicObject projectKind : projectKinds) {
                    String isEnable = projectKind.getString(FIELD_ENABLE);
                    if (FIELD_CHECKBOX.equals(isEnable)) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BudgetItemListPlugin_38", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        failMessage.append("\r\n");
                        ++failCount;
                        continue;
                    }
                    if (BaseDataRefrenceHelper.isRefrenced((String)PMBS_BUDGETITEM, (Object)projectKind.getPkValue())) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u3002", (String)"BudgetItemListPlugin_39", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        failMessage.append("\r\n");
                        ++failCount;
                        continue;
                    }
                    deleteIds.add(projectKind.getPkValue());
                    DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
                    if (parent == null) continue;
                    linkedList.add(parent.getPkValue());
                }
                QFilter qFilter = new QFilter(FIELD_ID, "in", linkedList);
                DynamicObject[] parents = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
                this.deleteProjectKind(deleteIds, parents);
                if (failCount > 0) {
                    if (selectRows.length == 1) {
                        this.getView().showTipNotification(failMessage.toString());
                    } else {
                        String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u5220\u9664%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"BudgetItemListPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), selectRows.length, deleteIds.size(), failCount);
                        this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    }
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BudgetItemListPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
            case "doreturndata": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"BudgetItemListPlugin_18", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                boolean multiSelect = listShowParameter.isMultiSelect();
                if (!multiSelect && selectRows.length > 1) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u53ea\u80fd\u9009\u4e2d1\u884c\u3002", (String)"BudgetItemListPlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRowCollection returnData = new ListSelectedRowCollection();
                for (DynamicObject row : projectKinds) {
                    ListSelectedRow returnProjectKind = new ListSelectedRow(row.getPkValue(), Boolean.TRUE);
                    returnData.add((Object)returnProjectKind);
                }
                this.getView().returnDataToParent((Object)returnData);
                this.getView().invokeOperation(OPERATE_CLOSE);
                break;
            }
        }
    }

    private void addAllSons(Set<Object> ids, Set<Object> parentIds) {
        DynamicObject[] sons = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_PARENT, "in", parentIds)});
        HashSet<Object> parentPkList = new HashSet<Object>();
        if (sons != null && sons.length > 0) {
            for (DynamicObject son : sons) {
                if (!son.getBoolean(FIELD_ISLEAF)) {
                    parentPkList.add(son.getPkValue());
                }
                ids.add(son.getPkValue());
            }
            this.addAllSons(ids, parentPkList);
        }
    }

    private void deleteProjectKind(Set<Object> deleteIds, DynamicObject[] parents) {
        this.addAllSons(deleteIds, deleteIds);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)PMBS_BUDGETITEM), (Object[])deleteIds.toArray(new Object[deleteIds.size()]));
        LinkedList<DynamicObject> updateList = new LinkedList<DynamicObject>();
        ORM orm = ORM.create();
        for (DynamicObject parent : parents) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "=", parent.getPkValue());
            boolean isExist = orm.exists(PMBS_BUDGETITEM, new QFilter[]{qFilter});
            if (isExist) continue;
            parent.set(FIELD_ISLEAF, (Object)Boolean.TRUE);
            updateList.add(parent);
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        grid.addCellClickListener((CellClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if (FIELD_PROJECTKINDNUMBER.equals(fieldName)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
            showParameter.setFormId(PMBS_BUDGETITEM);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if ("pmbs_budgetitemf7".equals(this.getView().getEntityId())) {
                showParameter.setStatus(OperationStatus.VIEW);
            } else {
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKKEY_EDIT));
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void addAllEnableSons(Set<DynamicObject> enableSonList, List<Object> parentIds) {
        if (parentIds.size() > 0) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            qFilter.and(new QFilter(FIELD_ENABLE, "=", (Object)"1"));
            DynamicObject[] enableSons = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (enableSons != null && enableSons.length > 0) {
                for (DynamicObject son : enableSons) {
                    son.set(FIELD_ENABLE, (Object)FIELD_CHECKBOX);
                    enableSonList.add(son);
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(enableSonList, parentPkList);
        }
    }

    private void getAllLeafSons(Set<DynamicObject> leafSons, List<Object> parentIds) {
        if (parentIds.size() > 0) {
            QFilter qFilter = new QFilter(FIELD_PARENT, "in", parentIds);
            DynamicObject[] sons = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> parentPkList = new ArrayList<Object>();
            if (sons != null && sons.length > 0) {
                for (DynamicObject son : sons) {
                    if (son.getBoolean(FIELD_ISLEAF)) {
                        leafSons.add(son);
                        continue;
                    }
                    parentPkList.add(son.getPkValue());
                }
            }
            this.addAllEnableSons(leafSons, parentPkList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (int rowIndex : selectRows) {
            pkList.add(((DynamicObject)gridRows.get(rowIndex)).get(FIELD_PROJECTKINDNUMBERID));
        }
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", pkList)});
        int failCount = 0;
        StringBuilder failMessage = new StringBuilder();
        HashSet<DynamicObject> updateList = new HashSet<DynamicObject>();
        HashSet<Object> deleteIds = new HashSet<Object>();
        if (CALLBACKKEY_DISABLE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            ArrayList<Object> parentIds = new ArrayList<Object>();
            for (DynamicObject projectKind : projectKinds) {
                String isEnable = projectKind.getString(FIELD_ENABLE);
                if (FIELD_CHECKBOX.equals(isEnable)) {
                    failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"BudgetItemListPlugin_33", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                    ++failCount;
                    continue;
                }
                boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
                if (!isLeaf) {
                    parentIds.add(projectKind.getPkValue());
                }
                projectKind.set(FIELD_ENABLE, (Object)FIELD_CHECKBOX);
                updateList.add(projectKind);
            }
            this.addAllEnableSons(updateList, parentIds);
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
            if (failCount > 0) {
                if (selectRows.length == 1) {
                    this.getView().showTipNotification(failMessage.toString());
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7981\u7528%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"BudgetItemListPlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), updateList.size() + failCount, updateList.size(), failCount);
                    this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BudgetItemListPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation(OPERATE_REFRESH);
        } else if (CALLBACKKEY_DELETE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            LinkedList<Object> parentIdList = new LinkedList<Object>();
            for (DynamicObject projectKind : projectKinds) {
                String isEnable = projectKind.getString(FIELD_ENABLE);
                if (FIELD_CHECKBOX.equals(isEnable)) {
                    failMessage.append(projectKind.getString(FIELD_NUMBER));
                    failMessage.append(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BudgetItemListPlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    failMessage.append("\r\n");
                    ++failCount;
                    continue;
                }
                if (BaseDataRefrenceHelper.isRefrenced((String)PMBS_BUDGETITEM, (Object)projectKind.getPkValue())) {
                    failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u3002", (String)"BudgetItemListPlugin_39", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                    failMessage.append("\r\n");
                    ++failCount;
                    continue;
                }
                boolean isLeaf = projectKind.getBoolean(FIELD_ISLEAF);
                if (!isLeaf) {
                    DynamicObject leaf;
                    HashSet<DynamicObject> leafSons = new HashSet<DynamicObject>();
                    ArrayList<Object> queryParentList = new ArrayList<Object>();
                    queryParentList.add(projectKind.getPkValue());
                    this.getAllLeafSons(leafSons, queryParentList);
                    boolean isRefrenced = false;
                    Iterator<DynamicObject> iterator = leafSons.iterator();
                    while (iterator.hasNext() && !(isRefrenced = BaseDataRefrenceHelper.isRefrenced((String)PMBS_BUDGETITEM, (Object)(leaf = iterator.next()).getPkValue()))) {
                    }
                    if (isRefrenced) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5176\u4e0b\u6e38\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u3002", (String)"BudgetItemListPlugin_40", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), projectKind.getString(FIELD_NUMBER)));
                        failMessage.append("\r\n");
                        ++failCount;
                        continue;
                    }
                }
                deleteIds.add(projectKind.getPkValue());
                DynamicObject parent = projectKind.getDynamicObject(FIELD_PARENT);
                if (parent == null) continue;
                parentIdList.add(parent.getPkValue());
            }
            QFilter qFilter = new QFilter(FIELD_ID, "in", parentIdList);
            DynamicObject[] parents = BusinessDataServiceHelper.load((String)PMBS_BUDGETITEM, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{qFilter});
            this.deleteProjectKind(deleteIds, parents);
            if (failCount > 0) {
                if (selectRows.length == 1) {
                    this.getView().showTipNotification(failMessage.toString());
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u5220\u9664%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"BudgetItemListPlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), selectRows.length, deleteIds.size(), failCount);
                    this.getView().showConfirm(msg, failMessage.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BudgetItemListPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation(OPERATE_REFRESH);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        DynamicObjectCollection gridRows = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW && selectRows != null && selectRows.length == 1) {
            HashMap<String, Object> parentInfo = new HashMap<String, Object>();
            parentInfo.put("key", FIELD_PARENT);
            parentInfo.put("value", ((DynamicObject)gridRows.get(selectRows[0])).getDynamicObject(FIELD_PROJECTKINDNUMBER).getPkValue());
            e.getParameter().setCustomParam("tree_parent_id", parentInfo);
            e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKKEY_ADDNEW));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "projectkind_addnew": {
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
            case "budgetitem_edit": {
                this.getView().invokeOperation(OPERATE_REFRESH);
                break;
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
        String fieldKey = arg0.getFieldKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isMultiSelect = listShowParameter.isMultiSelect();
        TreeEntryGrid grid = (TreeEntryGrid)arg0.getSource();
        Object row = arg0.getRow();
        int[] selectRows = grid.getSelectRows();
        int rowCount = this.getModel().getEntryRowCount(KEY_TREEENTRYENTITY);
        if (!isMultiSelect && selectRows != null && selectRows.length > 0) {
            grid.selectRows(new int[]{row}, row);
        }
        if (isMultiSelect && row != rowCount - 1 && "pmbs_budgetitemf7".equals(formId)) {
            String selectRowString;
            HashSet<Integer> selectRowSet = new HashSet<Integer>();
            boolean isAllSelectOrClear = false;
            if (selectRows == null || selectRows.length == 0 || selectRows.length == rowCount) {
                isAllSelectOrClear = true;
            }
            if (selectRows != null && selectRows.length > 0) {
                for (int i : selectRows) {
                    selectRowSet.add(i);
                }
            }
            boolean isCancelSelect = false;
            HashSet<Integer> reduceRowSet = new HashSet<Integer>();
            if (!isAllSelectOrClear && FIELD_CHECKBOX.equals(fieldKey) && (selectRowString = this.getPageCache().get("BudgetItemSelectRows")) != null) {
                String[] rowStringArray = selectRowString.split(",");
                if (rowStringArray.length > selectRows.length) {
                    isCancelSelect = true;
                }
                if (selectRows.length > 0) {
                    HashSet<Integer> selectRowStringSet = new HashSet<Integer>();
                    for (String rowString : rowStringArray) {
                        Integer index = Integer.valueOf(rowString);
                        selectRowStringSet.add(index);
                    }
                    if (!isCancelSelect) {
                        for (Object i : (Iterator)selectRows) {
                            if (selectRowStringSet.contains((int)i)) continue;
                            row = i;
                        }
                    } else {
                        Iterator iterator = selectRowStringSet.iterator();
                        while (iterator.hasNext()) {
                            int rowIndex = (Integer)iterator.next();
                            if (selectRowSet.contains(rowIndex)) continue;
                            row = rowIndex;
                            break;
                        }
                    }
                }
            }
            if (!isAllSelectOrClear) {
                if (!isCancelSelect) {
                    selectRowSet.add((Integer)row);
                    this.getSubRowIndex((int)row, rowCount, (Set<Integer>)selectRowSet);
                } else {
                    reduceRowSet.add((Integer)row);
                    this.getSubRowIndex((int)row, rowCount, (Set<Integer>)reduceRowSet);
                    selectRowSet.removeAll(reduceRowSet);
                }
            }
            int[] finalSelectRows = new int[selectRowSet.size()];
            int i = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer integer : selectRowSet) {
                finalSelectRows[i] = integer;
                stringBuilder.append(integer);
                stringBuilder.append(',');
                ++i;
            }
            grid.selectRows(finalSelectRows, row);
            this.getPageCache().put("BudgetItemSelectRows", stringBuilder.length() == 0 ? null : stringBuilder.substring(0, stringBuilder.length() - 1));
        }
    }

    private int getSubRowIndex(int row, int rowCount, Set<Integer> selectRowSet) {
        Object pkValue = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, row).getPkValue();
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, i);
            if (!pkValue.toString().equals(rowEntity.getString("pid"))) {
                return i - 1;
            }
            selectRowSet.add(i);
            i = this.getSubRowIndex(i, rowCount, selectRowSet);
        }
        return rowCount;
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

