/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.common.utils.BudgetEntryOperateHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class BudgetTemplateBillPlugin
extends AbstractPmbsBillPlugin
implements UploadListener {
    private static final String ADDROW = "addrow";
    private static final String ADDSUBORDINATE = "addsubordinate";
    private static final String DELETEROW = "deleterow";
    private static final String ADDBUDGET = "addbudget";
    private static final String MOVEENTRYUP = "moveentryup";
    private static final String MOVEENTRYDOWN = "moveentrydown";
    private static final String IMPORTEXCEL = "importexcel";
    private static final String EXPORTEXCEL = "exportexcel";
    private static final String IMPORTBUDGETITEM = "importbudgetitem";
    private static final String UPGRADE = "upgrade";
    private static final String DOWNGRADE = "downgrade";
    private static final String SAVE = "save";
    private static final String NAME = "name";
    private String[] title = null;

    private String[] getTitle() {
        if (this.title == null) {
            this.title = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u7f16\u7801", (String)"BudgetTemplateBillPlugin_17", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"BudgetTemplateBillPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"BudgetTemplateBillPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u51c6\u9884\u7b97\u9879", (String)"BudgetTemplateBillPlugin_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BudgetTemplateBillPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])};
        }
        return this.title;
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
        this.getModel().updateCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "budgetitem": {
                DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem", rowIndex);
                String budgetItemName = (String)this.getModel().getValue("budgetitemname", rowIndex);
                if (!StringUtils.isEmpty((CharSequence)budgetItemName) || budgetItem == null) break;
                this.getModel().setValue("budgetitemname", (Object)budgetItem.getString(NAME), rowIndex);
                break;
            }
            case "budgetitemname": {
                boolean isRepeat = BudgetEntryOperateHelper.checkNameIsRepeat((int)rowIndex, (String)"treeentryentity", (String)"budgetitemname", (IFormView)this.getView());
                if (!isRepeat) break;
                this.getModel().setValue("budgetitemname", changeData.getOldValue(), rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        Object templateName = this.getModel().getValue(NAME);
        String name = "";
        if (templateName != null && ((OrmLocaleValue)templateName).getLocaleValue_zh_CN() != null) {
            name = ((OrmLocaleValue)templateName).getLocaleValue_zh_CN();
        }
        switch (operateKey) {
            case "addrow": {
                BudgetEntryOperateHelper.addRow((IFormView)this.getView(), (String)"treeentryentity", null, (boolean)false, (String)ADDROW);
                break;
            }
            case "addsubordinate": {
                BudgetEntryOperateHelper.addRow((IFormView)this.getView(), (String)"treeentryentity", null, (boolean)false, (String)ADDSUBORDINATE);
                break;
            }
            case "deleterow": {
                BudgetEntryOperateHelper.deleteRow((AbstractBillPlugIn)this, (String)"treeentryentity", null, null, (String)DELETEROW, (boolean)false);
                break;
            }
            case "addbudget": {
                if (selectRows != null && selectRows.length > 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u540c\u65f6\u4e3a\u591a\u4e2a\u9884\u7b97\u9879\u6dfb\u52a0\u5b50\u7ea7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetTemplateBillPlugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ADDBUDGET, (IFormPlugin)this));
                    return;
                }
                BudgetEntryOperateHelper.importBudgetItem((AbstractBillPlugIn)this, (String)IMPORTBUDGETITEM);
                break;
            }
            case "moveentryup": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"BudgetTemplateBillPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u79fb\u64cd\u4f5c\u4ec5\u652f\u6301\u5355\u9009\u3002", (String)"BudgetTemplateBillPlugin_15", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (BudgetEntryOperateHelper.isAllowMoveUp((IDataModel)this.getModel(), (int[])selectRows, (String)"treeentryentity")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0a\u79fb\u9996\u884c\u6570\u636e\u3002", (String)"BudgetTemplateBillPlugin_7", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "moveentrydown": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"BudgetTemplateBillPlugin_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u79fb\u64cd\u4f5c\u4ec5\u652f\u6301\u5355\u9009\u3002", (String)"BudgetTemplateBillPlugin_16", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (BudgetEntryOperateHelper.isAllowMoveDown((IDataModel)this.getModel(), (int[])selectRows, (String)"treeentryentity")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0b\u79fb\u672b\u884c\u6570\u636e\u3002", (String)"BudgetTemplateBillPlugin_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "importexcel": {
                String tplSheetName = name;
                if ("".equals(name.trim())) {
                    tplSheetName = ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5bfc\u5165\u6a21\u677f", (String)"BudgetTemplateBillPlugin_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
                }
                BudgetEntryOperateHelper.importExcel((AbstractBillPlugIn)this, (String)tplSheetName, (String[])this.getTitle(), (String)IMPORTEXCEL);
                break;
            }
            case "exportexcel": {
                String sheetName = name;
                if ("".equals(name.trim())) {
                    sheetName = ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"BudgetTemplateBillPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
                }
                BudgetEntryOperateHelper.exportExcel((IFormView)this.getView(), (String)"treeentryentity", (String)sheetName, (String)"budgetitemname", null, (String)"budgetitem", (String)"budgetitemnum", (String)"descriptionentry", (String[])this.getTitle(), (boolean)false, (boolean)false);
                break;
            }
            case "upgrade": {
                BudgetEntryOperateHelper.upgrade((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", null, null, (String)"budgetitemnum", (String)"descriptionentry", (boolean)false);
                break;
            }
            case "downgrade": {
                BudgetEntryOperateHelper.downgrade((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", null, null, (String)"budgetitemnum", (String)"descriptionentry", (boolean)false);
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "deleterow": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
                int[] selectRows = treeEntryGrid.getSelectRows();
                Set allChildRowIndex = BudgetEntryOperateHelper.getAllChildRowIndex((int[])selectRows, (DynamicObjectCollection)this.getModel().getEntryEntity("treeentryentity"));
                IDataModel entryOperate = this.getModel();
                int i = 0;
                int[] deleteRows = new int[allChildRowIndex.size()];
                Iterator iterator = allChildRowIndex.iterator();
                while (iterator.hasNext()) {
                    deleteRows[i] = (Integer)iterator.next();
                    ++i;
                }
                entryOperate.deleteEntryRows("treeentryentity", deleteRows);
                break;
            }
            case "addbudget": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                BudgetEntryOperateHelper.importBudgetItem((AbstractBillPlugIn)this, (String)IMPORTBUDGETITEM);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (IMPORTBUDGETITEM.equals(actionId)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
            int[] selectRows = treeEntryGrid.getSelectRows();
            ArrayList<Object> selectRowIds = new ArrayList<Object>();
            ArrayList<DynamicObject> selectRowObjects = new ArrayList<DynamicObject>();
            for (int index : selectRows) {
                selectRowIds.add(this.getModel().getEntryRowEntity("treeentryentity", index).getPkValue());
                selectRowObjects.add(this.getModel().getEntryRowEntity("treeentryentity", index));
            }
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
            if (listSelectedRowCollection == null) {
                return;
            }
            Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
            Tree budgetItemTree = BudgetEntryOperateHelper.buildBudgetItemTree((Object[])primaryKeyValues);
            if (selectRows.length == 0) {
                List allRootNode = budgetItemTree.getAllRootNode();
                if (allRootNode != null) {
                    for (TreeNode rootNode : budgetItemTree.getAllRootNode()) {
                        BudgetEntryOperateHelper.fillRootNode((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (TreeNode)rootNode);
                    }
                }
            } else {
                for (Object e2 : selectRowIds) {
                    int row = BudgetEntryOperateHelper.findRowIndexById(e2, (DynamicObjectCollection)this.getModel().getEntryEntity("treeentryentity"));
                    if (row == -1) continue;
                    BudgetEntryOperateHelper.insertBudgetItemTree((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (Tree)budgetItemTree, (int)row);
                    treeEntryGrid.expand(row);
                }
            }
        } else if (IMPORTEXCEL.equals(actionId)) {
            String url = (String)e.getReturnData();
            if (url == null || "".equals(url.trim())) {
                return;
            }
            List title = BudgetEntryOperateHelper.getHeadByExcel((String)url);
            boolean flag = BudgetEntryOperateHelper.checkTitle((List)title, (String[])this.getTitle());
            if (flag) {
                Tree tree = BudgetEntryOperateHelper.buildTreeFromExcel((String)url, (IFormView)this.getView(), (String)"template");
                if (tree != null && tree.getList().size() > 0) {
                    BudgetEntryOperateHelper.fillEntryData((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (Tree)tree, (String)"template");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u6a21\u677f\u4e0d\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"BudgetTemplateBillPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f\u3002", (String)"BudgetTemplateBillPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

