/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.service.BudgetPrePayService;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;

public class PrePaySplitBudgetListPlugin
extends AbstractPmbsListPlugin {
    private static final String KEY_TREEENTRYENTITY = "treeentryentity";
    private static final String RETURN_DATA = "doreturndata";
    private static final String OPERATE_CLOSE = "close";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.initList(e.getQFilters());
    }

    private void initList(List<QFilter> filterList) {
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object orgId = showParameter.getCustomParam("org");
        Object projectId = showParameter.getCustomParam("contpro");
        Object contractId = showParameter.getCustomParam("entrycontract");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"pmct_outcontract");
        BudgetPrePayService prePayService = new BudgetPrePayService();
        Map prePaySplitBudgetData = prePayService.getPrePaySplitBudgetData(contract, projectId, orgId);
        for (Map.Entry entry : prePaySplitBudgetData.entrySet()) {
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size() + 1]);
            filters[filterList.size()] = new QFilter("id", "=", entry.getKey());
            if (!filterList.isEmpty() && !QueryServiceHelper.exists((String)"pmas_projectbudget", (QFilter[])filters)) continue;
            int row = this.getModel().createNewEntryRow(KEY_TREEENTRYENTITY);
            if (!entry.getKey().equals(0L)) {
                this.getModel().setValue("treeentryentity.id", entry.getKey(), row);
            }
            this.getModel().setValue("name", ((Map)entry.getValue()).get("name"), row);
            this.getModel().setValue("budgetitem", ((Map)entry.getValue()).get("budgetitem"), row);
            this.getModel().setValue("project", ((Map)entry.getValue()).get("project"), row);
            BigDecimal prePayAmount = ((Map)entry.getValue()).get("prepayamount") == null ? BigDecimal.ZERO : (BigDecimal)((Map)entry.getValue()).get("prepayamount");
            BigDecimal prePayDeduction = ((Map)entry.getValue()).get("prepaydeduction") == null ? BigDecimal.ZERO : (BigDecimal)((Map)entry.getValue()).get("prepaydeduction");
            this.getModel().setValue("prepayamount", (Object)prePayAmount, row);
            this.getModel().setValue("prepaydeduction", (Object)prePayDeduction, row);
            this.getModel().setValue("deductibleamount", (Object)prePayAmount.subtract(prePayDeduction), row);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("currency", showParameter.getCustomParam("contcurrency"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        switch (operateKey) {
            case "doreturndata": {
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"PrePaySplitBudgetListPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                LinkedHashMap<Object, BigDecimal> deductibleAmountByBudgetItem = new LinkedHashMap<Object, BigDecimal>(16);
                for (int index : selectRows) {
                    DynamicObject entryRow = this.getModel().getEntryRowEntity(KEY_TREEENTRYENTITY, index);
                    deductibleAmountByBudgetItem.put(entryRow.getPkValue(), entryRow.getBigDecimal("deductibleamount"));
                }
                this.getView().returnDataToParent(deductibleAmountByBudgetItem);
                this.getView().invokeOperation(OPERATE_CLOSE);
                break;
            }
        }
    }
}

