/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.dataupgrade.DataUpgradeHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class ProBudgetRelationMappingEditPlugin
extends AbstractPmbsBillPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit proBudget = (BasedataEdit)this.getControl("probudget");
        proBudget.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object projectObj;
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)name)) {
            Set proIds = DataUpgradeHelper.getUpdatedProject();
            if (proIds.size() > 0) {
                QFilter idFilter = new QFilter("id", "not in", (Object)proIds);
                param.getListFilterParameter().getQFilters().add(idFilter);
            }
        } else if (StringUtils.equals((CharSequence)"probudget", (CharSequence)name) && (projectObj = this.getModel().getValue("project")) != null) {
            DynamicObject project = (DynamicObject)projectObj;
            QFilter proQFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            proQFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            param.getListFilterParameter().getQFilters().add(proQFilter);
            param.setCustomParam("notonlyleaf", (Object)"1");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (StringUtils.equals((CharSequence)"project", (CharSequence)name)) {
            int rowCount = this.getModel().getEntryRowCount("budgetmappingdetail");
            if (rowCount > 0) {
                DynamicObject pro;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5c06\u6e05\u7a7a\u73b0\u6709\u6570\u636e\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProBudgetRelationMappingEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("projectConfirm", (IFormPlugin)this));
                String newProject = null;
                String oldProject = null;
                if (newValue != null) {
                    pro = (DynamicObject)newValue;
                    newProject = pro.getPkValue().toString();
                }
                if (oldValue != null) {
                    pro = (DynamicObject)oldValue;
                    oldProject = pro.getPkValue().toString();
                }
                this.getPageCache().put("newproject", newProject);
                this.getPageCache().put("oldproject", oldProject);
            } else {
                this.changeProject(newValue);
            }
        }
    }

    private void changeProject(Object newValue) {
        this.getModel().deleteEntryData("budgetmappingdetail");
        this.getModel().setValue("controltype", null);
        if (newValue != null) {
            DynamicObjectCollection budgetDetails;
            boolean exists;
            DynamicObject projectObj = (DynamicObject)newValue;
            QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
            String billId = this.getModel().getDataEntity().getPkValue().toString();
            if (StringUtils.isNotEmpty((CharSequence)billId)) {
                qFilter.and("id", "!=", (Object)Long.parseLong(billId));
            }
            if (exists = QueryServiceHelper.exists((String)"pmbs_budgetrelationmap", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u5df2\u5b58\u5728\u9879\u76ee\u9884\u7b97\u9879\u5173\u7cfb\u6620\u5c04\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6620\u5c04\u3002", (String)"ProBudgetRelationMappingEditPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue("project", null);
                this.getModel().endInit();
                this.getView().updateView("project");
                return;
            }
            ProBudgetCtrlEnums projectBudgetControlType = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)projectObj);
            if (projectBudgetControlType == null) {
                return;
            }
            this.getView().getModel().setValue("controltype", (Object)projectBudgetControlType.getValue());
            qFilter = new QFilter("project", "=", projectObj.getPkValue());
            qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            qFilter.and("isvalid", "=", (Object)true);
            DynamicObject outBudgetBill = null;
            if (StringUtils.equals((CharSequence)projectBudgetControlType.getValue(), (CharSequence)ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue())) {
                qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                DynamicObject[] outBudgetBills = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)" year desc");
                if (outBudgetBills.length > 0) {
                    outBudgetBill = BusinessDataServiceHelper.loadSingle((Object)outBudgetBills[0].getPkValue(), (String)"pmas_outbudget");
                }
                this.getModel().setValue("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
            } else {
                qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
                outBudgetBill = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudget", (QFilter[])new QFilter[]{qFilter});
                this.getModel().setValue("budgettype", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
            }
            if (outBudgetBill != null && (budgetDetails = outBudgetBill.getDynamicObjectCollection("treeentryentity")).size() > 0) {
                DataUpgradeHelper.fillTreeEntryByEntryEntity((DynamicObjectCollection)budgetDetails, (IFormView)this.getView());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"projectConfirm")) {
            String newProject = this.getPageCache().get("newproject");
            String oldProject = this.getPageCache().get("oldproject");
            if (MessageBoxResult.Yes.equals((Object)result)) {
                DynamicObject project = StringUtils.isBlank((CharSequence)newProject) ? null : BusinessDataServiceHelper.loadSingle((Object)newProject, (String)"bd_project");
                this.changeProject(project);
            } else {
                this.getModel().beginInit();
                DynamicObject project = StringUtils.isBlank((CharSequence)oldProject) ? null : BusinessDataServiceHelper.loadSingle((Object)oldProject, (String)"bd_project");
                this.getModel().setValue("project", (Object)project);
                this.getModel().endInit();
                this.getView().updateView("project");
            }
        }
    }
}

