/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.budget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.business.helper.AuthProjectKindHelper;
import kd.pmgt.pmbs.business.helper.TreeNodeSearchHelper;
import kd.pmgt.pmbs.business.support.LeftTreeRightGridBillSupport;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;
import org.jetbrains.annotations.NotNull;

public class ReportOrgSettingPlugin
extends AbstractPmbsFormPlugin
implements BeforeF7SelectListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(ReportOrgSettingPlugin.class);
    private static final String CONTROL_PROJECT_KIND_TREE_VIEW = "projectkindtreeview";
    private static final String CONTROL_PROJECT_KIND_SEARCH = "projectkindsearch";
    private static final String OPERATION_NEW_ENTRY = "newentry";
    private static final String OPERATION_DELETE_ENTRY = "deleteentry";
    private static final String PAGE_CACHE_PARENT_TREE_NODE_ID = "parenttreenodeid";
    private static final String PAGE_CACHE_CURRENT_TREE_NODE_ID = "currentnodeid";
    private static final String PAGE_CACHE_CURRENT_GRID_ROW_NO = "currentgridrowno";
    private static final String CALL_BACK_DECLARE_ORG = "callbackdeclareorg";
    private static final String CALL_BACK_REPORT_ORG = "callbackreportorg";
    private static final List<String> NON_PROJECT_KIND_BILLS = Arrays.asList("pmim_investbugetplan");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit fieldEdit = (MulBasedataEdit)this.getView().getControl("declarateorg");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reportOrgEdit = (BasedataEdit)this.getView().getControl("reportorg");
        reportOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billEdit = (BasedataEdit)this.getView().getControl("billcode");
        billEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search projectKindSearch = (Search)this.getView().getControl(CONTROL_PROJECT_KIND_SEARCH);
        projectKindSearch.addEnterListener((SearchEnterListener)this);
        TreeView projectKindTreeView = (TreeView)this.getControl(CONTROL_PROJECT_KIND_TREE_VIEW);
        projectKindTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)CONTROL_PROJECT_KIND_TREE_VIEW, (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportOrgSettingPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)RequestContext.get().getOrgId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AuthProjectKindHelper.buildCloudProjectKindTree((IFormView)this.getView(), (String)CONTROL_PROJECT_KIND_TREE_VIEW, (String)ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportOrgSettingPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), null, (boolean)false, (Long)RequestContext.get().getOrgId());
        this.nonProjectKindBills();
        this.sortReqOrgSetting();
        this.getView().updateView("entryentity");
        this.getPageCache().put(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID, "001");
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)CALL_BACK_DECLARE_ORG, (CharSequence)actionId)) {
            String currentTreeNodeId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID);
            this.fillBackOrg(returnData, "declarateorg");
            this.treeDataUpdateView(currentTreeNodeId);
        } else if (StringUtils.equals((CharSequence)CALL_BACK_REPORT_ORG, (CharSequence)actionId)) {
            String currentTreeNodeId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID);
            this.fillBackOrg(returnData, "reportorg");
            this.treeDataUpdateView(currentTreeNodeId);
        }
    }

    private String fillBackOrg(ListSelectedRowCollection returnData, String orgMetaDataCode) {
        String currentTreeNodeId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID);
        String currentGridRowId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_GRID_ROW_NO);
        LeftTreeRightGridBillSupport leftTreeRightGridBillSupport = new LeftTreeRightGridBillSupport("projectkind", this.buildRootNode(), Integer.parseInt(currentGridRowId), this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"), currentTreeNodeId, ((Boolean)this.getModel().getValue("iscontainlower")).booleanValue());
        int clickRowIndex = leftTreeRightGridBillSupport.switchCurrentViewIndex2GridIndex();
        DynamicObject clickRowData = this.getModel().getEntryRowEntity("entryentity", clickRowIndex);
        if (StringUtils.equals((CharSequence)orgMetaDataCode, (CharSequence)"declarateorg")) {
            DynamicObjectType orgDt = this.getModel().getEntryEntity("declarateorg").getDynamicObjectType();
            DynamicObjectCollection declareOrgObject = new DynamicObjectCollection();
            returnData.forEach(data -> {
                DynamicObject org = new DynamicObject(orgDt);
                DynamicObject adminorg = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)"bos_adminorg");
                org.set("fbasedataid", (Object)adminorg);
                org.set("fbasedataid_id", (Object)Long.valueOf(data.getPrimaryKeyValue().toString()));
                declareOrgObject.add((Object)org);
            });
            DynamicObject projectKind = clickRowData.getDynamicObject("projectkind");
            if (projectKind != null) {
                List<Long> orgIdList = declareOrgObject.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList());
                Boolean result = this.validateProjectKindCtrl(projectKind.getLong("id"), orgIdList);
                if (Boolean.FALSE.equals(result)) {
                    return currentTreeNodeId;
                }
            }
            clickRowData.set(orgMetaDataCode, (Object)declareOrgObject);
        } else {
            Boolean result;
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)returnData.get(0).getPrimaryKeyValue(), (String)"bos_adminorg");
            DynamicObject dynamicObject = clickRowData.getDynamicObject("projectkind");
            if (dynamicObject != null && Boolean.FALSE.equals(result = this.validateProjectKindCtrl(dynamicObject.getLong("id"), Collections.singletonList(org.getLong("id"))))) {
                return currentTreeNodeId;
            }
            clickRowData.set(orgMetaDataCode, (Object)org);
        }
        return currentTreeNodeId;
    }

    private Boolean validateProjectKindCtrl(Long projectKindId, List<Long> orgList) {
        ArrayList<Long> failOrgList = new ArrayList<Long>();
        boolean validateResult = true;
        for (Long orgId : orgList) {
            QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)orgId);
            HashSet hasPermList = (HashSet)ctrlStrategyFilter.getValue();
            if (hasPermList.contains(projectKindId)) continue;
            validateResult = false;
            failOrgList.add(orgId);
        }
        if (!validateResult) {
            QFilter orgFilter = new QFilter("id", "in", failOrgList);
            DynamicObject[] adminorgs = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id,name", (QFilter[])new QFilter[]{orgFilter});
            String nameList = Arrays.stream(adminorgs).map(dyn -> dyn.getString("name")).collect(Collectors.joining(","));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u65e0\u6743\u4f7f\u7528\u6b64\u9879\u76ee\u5206\u7c7b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u7ed9\u5f53\u524d\u7ec4\u7ec7\u5206\u914d\u7ba1\u63a7\u7b56\u7565\u83b7\u5f97\u4f7f\u7528\u6743\u3002", (String)"ReportOrgSettingPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), nameList), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(null, (IFormPlugin)this));
        }
        return validateResult;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "billcode": {
                DynamicObject[] billObjectS = BusinessDataServiceHelper.load((String)"pmbs_reqorgconf", (String)String.join((CharSequence)",", "number", "name", "description", "billcode"), (QFilter[])new QFilter[0]);
                HashSet<Object> billObjectLevelIdSet = new HashSet<Object>();
                for (DynamicObject billObject : billObjectS) {
                    DynamicObject billCode = billObject.getDynamicObject("billcode");
                    if (billCode == null) continue;
                    billObjectLevelIdSet.add(billCode.getPkValue());
                }
                QFilter bizAppQFilter = null;
                QFilter qFilter = new QFilter("number", "=", (Object)"PMGT");
                DynamicObject bizCloud = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizcloud", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (bizCloud != null) {
                    qFilter = new QFilter("bizcloud", "=", (Object)bizCloud.getPkValue().toString());
                    DynamicObject[] bizApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (bizApps.length > 0) {
                        List bizAppIds = Arrays.stream(bizApps).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
                        bizAppQFilter = new QFilter("bizappid", "in", bizAppIds);
                    }
                }
                QFilter billObjectIdFilter = new QFilter("id", "not in", (Object)billObjectLevelIdSet.toArray());
                if (bizAppQFilter != null) {
                    billObjectIdFilter.and(bizAppQFilter);
                }
                e.addCustomQFilter(billObjectIdFilter);
                break;
            }
            case "declarateorg": {
                this.buildAndUseOwnOrgList(e, e.getRow(), "declarateorg", CALL_BACK_DECLARE_ORG, true);
                break;
            }
            case "reportorg": {
                this.buildAndUseOwnOrgList(e, e.getRow(), "reportorg", CALL_BACK_REPORT_ORG, false);
                break;
            }
        }
    }

    private void buildAndUseOwnOrgList(BeforeF7SelectEvent e, int currentViewGridRowNo, String orgMetaDataCode, String closeCallBackId, Boolean isMultiSelect) {
        this.getPageCache().put(this.getView().getPageId() + PAGE_CACHE_CURRENT_GRID_ROW_NO, String.valueOf(currentViewGridRowNo));
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        parameter.setMultiSelect(isMultiSelect.booleanValue());
        LeftTreeRightGridBillSupport leftTreeRightGridBillSupport = new LeftTreeRightGridBillSupport("projectkind", this.buildRootNode(), currentViewGridRowNo, this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"), this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID), ((Boolean)this.getModel().getValue("iscontainlower")).booleanValue());
        int gridIndex = leftTreeRightGridBillSupport.switchCurrentViewIndex2GridIndex();
        DynamicObject gridEntry = this.getModel().getEntryRowEntity("entryentity", gridIndex);
        if (StringUtils.equals((CharSequence)orgMetaDataCode, (CharSequence)"declarateorg")) {
            Object[] selectedOrgIds = gridEntry.getDynamicObjectCollection(orgMetaDataCode).stream().map(entry -> entry.get("fbasedataid_id")).toArray();
            QFilter orgIdFilter = this.buildDeclareOrgFilter(gridIndex);
            parameter.getListFilterParameter().getQFilters().add(orgIdFilter);
            parameter.setSelectedRows(selectedOrgIds);
            parameter.setF7ClickByFilter(true);
        } else {
            DynamicObject reportOrg = gridEntry.getDynamicObject(orgMetaDataCode);
            if (reportOrg != null) {
                parameter.setSelectedRow(reportOrg.getPkValue());
            }
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            List<Long> hasPermAdminOrgList = this.getHasPermAdminOrgList();
            if (!hasPermAdminOrgList.isEmpty()) {
                qFilter = new QFilter("id", "in", hasPermAdminOrgList);
            }
            parameter.getListFilterParameter().getQFilters().add(qFilter);
            parameter.setF7ClickByFilter(true);
        }
    }

    private List<Long> getHasPermAdminOrgList() {
        ArrayList<Long> accountPermOrgs = new ArrayList<Long>(16);
        accountPermOrgs.add(RequestContext.get().getOrgId());
        String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
        List accountOrgs = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, accountPermOrgs, (String)"01");
        ArrayList<Long> allOrgIds = new ArrayList<Long>();
        if (!accountOrgs.isEmpty()) {
            List orgList = OrgTreeUtils.getParentByOrgIds((List)accountOrgs, (String)"01");
            allOrgIds.addAll(orgList);
            return allOrgIds;
        }
        return allOrgIds;
    }

    @NotNull
    private QFilter buildDeclareOrgFilter(int rowIndex) {
        DynamicObject currentReportOrgSetting = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject currentProjectKind = currentReportOrgSetting.getDynamicObject("projectkind");
        DynamicObjectCollection declareOrgs = currentReportOrgSetting.getDynamicObjectCollection("declarateorg");
        DynamicObjectCollection reportOrgSettingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Set declareOrgIdSet = reportOrgSettingEntries.stream().filter(reportOrgSetting -> {
            DynamicObject otherProjectKind = reportOrgSetting.getDynamicObject("projectkind");
            return currentProjectKind == null && otherProjectKind == null || currentProjectKind != null && otherProjectKind != null && currentProjectKind.getPkValue() == otherProjectKind.getPkValue();
        }).map(reportOrgSetting -> reportOrgSetting.getDynamicObjectCollection("declarateorg")).flatMap(Collection::stream).filter(Objects::nonNull).filter(org -> org.getDynamicObject("fbasedataid") != null).map(org -> org.get("fbasedataid_id")).filter(orgId -> declareOrgs.stream().noneMatch(declareOrg -> StringUtils.equals((CharSequence)orgId.toString(), (CharSequence)declareOrg.get("fbasedataid_id").toString()))).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "not in", declareOrgIdSet);
        List<Long> hasPermAdminOrgList = this.getHasPermAdminOrgList();
        if (!hasPermAdminOrgList.isEmpty()) {
            qFilter.and(new QFilter("id", "in", hasPermAdminOrgList));
        } else {
            qFilter.and(new QFilter("id", "=", (Object)0L));
        }
        return qFilter;
    }

    public void search(SearchEnterEvent arg0) {
        String searchText = arg0.getText();
        TreeView treeView = (TreeView)this.getControl(CONTROL_PROJECT_KIND_TREE_VIEW);
        TreeNode rootNode = this.buildRootNode();
        TreeNode treeNode = TreeNodeSearchHelper.searchTreeNode((IFormView)this.getView(), (TreeView)treeView, (TreeNode)rootNode, (String)searchText);
        if (treeNode != null) {
            this.treeDataUpdateView(treeNode.getId());
        }
    }

    private TreeNode buildRootNode() {
        TreeNode rootNode = new TreeNode("", "001", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportOrgSettingPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        String childJson = this.getPageCache().get("PROJECT_KIND_LIST_CACHE_KEY");
        if (StringUtils.isBlank((CharSequence)childJson)) {
            return rootNode;
        }
        List newChildren = SerializationUtils.fromJsonStringToList((String)childJson, TreeNode.class);
        newChildren.forEach(arg_0 -> ((TreeNode)rootNode).addChild(arg_0));
        return rootNode;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID, nodeId);
        this.treeDataUpdateView(nodeId);
    }

    private void treeDataUpdateView(String nodeId) {
        DynamicObjectCollection reportOrgSettingEntries = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection viewEntries = (DynamicObjectCollection)reportOrgSettingEntries.clone();
        this.getEntriesByProjectKind(nodeId, reportOrgSettingEntries);
        if (viewEntries == null || viewEntries.isEmpty()) {
            return;
        }
        this.getModel().getDataEntity(true).set("entryentity", (Object)reportOrgSettingEntries);
        this.getView().updateView("entryentity");
        this.getModel().getDataEntity(true).set("entryentity", (Object)viewEntries);
    }

    private void getEntriesByProjectKind(String nodeId, DynamicObjectCollection reportOrgSettingEntries) {
        Map<Long, DynamicObject> projectKindMap = this.getProjectKindMap();
        Iterator iterator = reportOrgSettingEntries.iterator();
        while (iterator.hasNext()) {
            DynamicObject viewEntry = (DynamicObject)iterator.next();
            DynamicObject projectKind = viewEntry.getDynamicObject("projectkind");
            if (this.checkIsShow2Panel(nodeId, projectKind, projectKindMap)) continue;
            iterator.remove();
        }
    }

    private Map<Long, DynamicObject> getProjectKindMap() {
        Long orgId = RequestContext.get().getOrgId();
        QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)orgId);
        DynamicObject[] projectKindCol = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)String.join((CharSequence)",", "number", "name", "parent"), (QFilter[])new QFilter[]{ctrlStrategyFilter});
        HashMap<Long, DynamicObject> projectKindMap = new HashMap<Long, DynamicObject>(projectKindCol.length);
        for (DynamicObject projectKind : projectKindCol) {
            projectKindMap.put((Long)projectKind.getPkValue(), projectKind);
        }
        return projectKindMap;
    }

    private boolean checkIsShow2Panel(String nodeId, DynamicObject projectKind, Map<Long, DynamicObject> projectKindMap) {
        boolean isContainLower = (Boolean)this.getModel().getValue("iscontainlower");
        if (projectKind == null) {
            return StringUtils.equals((CharSequence)"001", (CharSequence)nodeId);
        }
        if (StringUtils.equals((CharSequence)"001", (CharSequence)nodeId)) {
            return isContainLower;
        }
        if (StringUtils.equals((CharSequence)nodeId, (CharSequence)projectKind.getPkValue().toString())) {
            return true;
        }
        if ((projectKind = projectKindMap.get(Long.parseLong(projectKind.getPkValue().toString()))).get("parent") == null) {
            return false;
        }
        DynamicObject parent = projectKind.getDynamicObject("parent");
        if (isContainLower) {
            return this.checkIsShow2Panel(nodeId, projectKindMap.get(Long.parseLong(parent.getPkValue().toString())), projectKindMap);
        }
        return false;
    }

    private void changeEntryColumnIndex() {
        EntryGrid reqOrgEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
        LeftTreeRightGridBillSupport leftTreeRightGridBillSupport = new LeftTreeRightGridBillSupport("projectkind", this.buildRootNode(), ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows(), this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"), this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID), ((Boolean)this.getModel().getValue("iscontainlower")).booleanValue());
        int[] newSelectedRows = leftTreeRightGridBillSupport.switchSelectedViewIndex2GridIndex();
        if (newSelectedRows.length > 0) {
            reqOrgEntryGrid.getEntryState().selectRow(newSelectedRows);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_DELETE_ENTRY)) {
            this.changeEntryColumnIndex();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        String parentTreeNodeId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_PARENT_TREE_NODE_ID);
        String currentTreeNodeId = this.getPageCache().get(this.getView().getPageId() + PAGE_CACHE_CURRENT_TREE_NODE_ID);
        logger.info("ReportOrgSettingPlugin#afterDoOperation currentTreeNodeId: {}", (Object)currentTreeNodeId);
        TreeView treeView = (TreeView)this.getView().getControl(CONTROL_PROJECT_KIND_TREE_VIEW);
        switch (key) {
            case "newentry": {
                DynamicObjectCollection reqOrgConfSettings = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObjectType dt = reqOrgConfSettings.getDynamicObjectType();
                DynamicObject reqOrgConfSetting = new DynamicObject(dt);
                reqOrgConfSetting.set("seq", (Object)reqOrgConfSettings.size());
                reqOrgConfSetting.set("id", (Object)ORM.create().genLongId((IDataEntityType)reqOrgConfSetting.getDynamicObjectType()));
                if (!StringUtils.equals((CharSequence)currentTreeNodeId, (CharSequence)"001")) {
                    DynamicObject projectKind = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(currentTreeNodeId), (String)"bd_projectkind");
                    reqOrgConfSetting.set("projectkind", (Object)projectKind);
                }
                reqOrgConfSettings.add((Object)reqOrgConfSetting);
                this.getModel().updateEntryCache(reqOrgConfSettings);
                this.sortReqOrgSetting();
                treeView.treeNodeClick(parentTreeNodeId, currentTreeNodeId);
                break;
            }
            case "deleteentry": {
                treeView.treeNodeClick(parentTreeNodeId, currentTreeNodeId);
                break;
            }
        }
    }

    protected void sortReqOrgSetting() {
        TreeNode rootNode = this.buildRootNode();
        DynamicObjectCollection reqOrgSettings = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> sortedProjectKindIds = new ArrayList<String>();
        DynamicObjectCollection cloneReqOrgSettings = (DynamicObjectCollection)reqOrgSettings.clone();
        reqOrgSettings.clear();
        this.sort(rootNode, sortedProjectKindIds);
        DynamicObjectCollection sortedReqOrgSettings = new DynamicObjectCollection();
        sortedProjectKindIds.forEach(projectKindId -> cloneReqOrgSettings.stream().filter(reqOrgSetting -> {
            DynamicObject projectKind = reqOrgSetting.getDynamicObject("projectkind");
            String confProjectKindId = projectKind == null ? "" : projectKind.getPkValue().toString();
            return StringUtils.equals((CharSequence)projectKindId, (CharSequence)confProjectKindId);
        }).forEach(arg_0 -> ((DynamicObjectCollection)sortedReqOrgSettings).add(arg_0)));
        reqOrgSettings.addAll((Collection)sortedReqOrgSettings);
    }

    private void sort(TreeNode treeNode, List<String> sortedProjectKindIds) {
        if (treeNode == null) {
            return;
        }
        List children = treeNode.getChildren();
        sortedProjectKindIds.add(StringUtils.equals((CharSequence)treeNode.getId(), (CharSequence)"001") ? "" : treeNode.getId());
        if (children == null || children.isEmpty()) {
            return;
        }
        for (TreeNode child : children) {
            this.sort(child, sortedProjectKindIds);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"iscontainlower")) {
            TreeView projectKindTreeView = (TreeView)this.getControl(CONTROL_PROJECT_KIND_TREE_VIEW);
            Map focusNodeMap = projectKindTreeView.getTreeState().getFocusNode();
            String nodeParentId = focusNodeMap.get("parentid").toString();
            String nodeId = focusNodeMap.get("id").toString();
            String nodeText = focusNodeMap.get("text").toString();
            projectKindTreeView.focusNode(new TreeNode(nodeParentId, nodeId, nodeText));
            this.treeDataUpdateView(nodeId);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"billcode")) {
            this.nonProjectKindBills();
        }
    }

    private void nonProjectKindBills() {
        DynamicObject billCode = (DynamicObject)this.getModel().getValue("billcode");
        if (billCode == null) {
            return;
        }
        if (NON_PROJECT_KIND_BILLS.contains(billCode.getString("id"))) {
            TreeNode rootNode = new TreeNode("", "001", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportOrgSettingPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            TreeView treeView = (TreeView)this.getView().getControl(CONTROL_PROJECT_KIND_TREE_VIEW);
            treeView.focusNode(rootNode);
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_PROJECT_KIND_TREE_VIEW, CONTROL_PROJECT_KIND_SEARCH, "iscontainlower", "projectkind"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_PROJECT_KIND_TREE_VIEW, CONTROL_PROJECT_KIND_SEARCH, "iscontainlower"});
        }
    }
}

