/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.contract;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class ContractAttrEditPlugin
extends AbstractPmbsBillPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit listModel = (BasedataEdit)this.getControl("listmodel");
        listModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"listmodel")) {
            this.beforeListModelSelected(arg0);
        }
    }

    protected void beforeListModelSelected(BeforeF7SelectEvent arg0) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("listconfigentry");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            HashSet<Object> listModelIds = new HashSet<Object>();
            for (DynamicObject entry : entryEntity) {
                DynamicObject listModel = entry.getDynamicObject("listmodel");
                if (listModel == null) continue;
                listModelIds.add(listModel.getPkValue());
            }
            if (!listModelIds.isEmpty()) {
                ListShowParameter parameter = (ListShowParameter)arg0.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", listModelIds));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        DynamicObject contractAttribute = this.getModel().getDataEntity(true);
        DynamicObject[] contractTypes = BusinessDataServiceHelper.load((String)"pmct_conttype", (String)"isonlist", (QFilter[])new QFilter[]{new QFilter("contattr", "=", contractAttribute.getPkValue())});
        if (contractTypes != null && contractTypes.length > 0) {
            DynamicObjectCollection listConfigEntry = contractAttribute.getDynamicObjectCollection("listconfigentry");
            if (listConfigEntry != null && listConfigEntry.size() > 0) {
                for (DynamicObject contractType : contractTypes) {
                    contractType.set("isonlist", (Object)Boolean.TRUE);
                }
            } else if (listConfigEntry != null) {
                for (DynamicObject contractType : contractTypes) {
                    contractType.set("isonlist", (Object)Boolean.FALSE);
                }
            }
            SaveServiceHelper.save((DynamicObject[])contractTypes);
        }
    }
}

