/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.contract;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.pmgt.pmbs.common.enums.ContractControlEnum;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class ContractTypeEditPlugin
extends AbstractPmbsBillPlugin {
    private static final Log logger = LogFactory.getLog(ContractTypeEditPlugin.class);
    private static final String CONTATTR_LISTCONFIGENTRY = "listconfigentry";
    private static final String CONTROL_CONTATTR = "contattr";
    private static final String CONTROL_ISONLIST = "isonlist";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean openedcontractparam = Boolean.parseBoolean(SystemParamHelper.getAppParameter((String)"openedcontractparam", (String)"pmct").toString());
        logger.info(String.format("afterCreateNewData openedcontractparam value: %s", openedcontractparam));
        if (openedcontractparam.booleanValue()) {
            this.getModel().setValue("openedcontract", (Object)Boolean.TRUE);
            this.getModel().setValue("ammountcontrolapply", (Object)ContractControlEnum.NOTCONTROL.getValue());
            this.getModel().setValue("ammountcontrolsettle", (Object)ContractControlEnum.NOTCONTROL.getValue());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contTpl = (BasedataEdit)this.getView().getControl("conttemplate");
        contTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "isonlist": {
                boolean isOpen = (Boolean)newValue;
                if (isOpen || this.getModel().getEntryRowCount(CONTATTR_LISTCONFIGENTRY) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6e05\u5355\u9875\u7b7e\uff0c\u8bf7\u5148\u5220\u9664\u3002", (String)"ContractTypeEditPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(CONTROL_ISONLIST, (Object)Boolean.TRUE);
                break;
            }
            case "conttemplate": {
                if (newValue != null) {
                    DynamicObject contTpl = (DynamicObject)newValue;
                    this.getModel().setValue("contplversion", (Object)contTpl.getBigDecimal("version"), rowIndex);
                    break;
                }
                this.getModel().setValue("contplversion", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initContAttrEntry();
    }

    protected void initContAttrEntry() {
        DynamicObjectCollection listConfigs = this.getModel().getEntryEntity(CONTATTR_LISTCONFIGENTRY);
        Set tabNameSet = listConfigs.stream().map(obj -> obj.getString("tabname")).collect(Collectors.toSet());
        DynamicObject contAttr = (DynamicObject)this.getModel().getValue(CONTROL_CONTATTR);
        boolean isOnList = (Boolean)this.getModel().getValue(CONTROL_ISONLIST);
        if (contAttr != null && isOnList) {
            DynamicObjectCollection attrListConfigs = (contAttr = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contAttr.get("id").toString()), (String)"pmct_contattr")).getDynamicObjectCollection(CONTATTR_LISTCONFIGENTRY);
            if (attrListConfigs.size() > 0) {
                for (DynamicObject listConfig : attrListConfigs) {
                    if (tabNameSet.contains(listConfig.getString("tabname"))) continue;
                    DynamicObject newConfig = listConfigs.addNew();
                    if (listConfig.getDynamicObject("listmodel") != null) {
                        newConfig.set("id", listConfig.getDynamicObject("listmodel").getPkValue());
                    }
                    newConfig.set("tabname", listConfig.get("tabname"));
                    newConfig.set("computerule", listConfig.get("computerule"));
                    newConfig.set("listdesc", listConfig.get("listdesc"));
                }
            }
            this.getModel().updateEntryCache(listConfigs);
            this.getView().updateView(CONTATTR_LISTCONFIGENTRY);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean openedcontractparam = Boolean.parseBoolean(SystemParamHelper.getAppParameter((String)"openedcontractparam", (String)"pmct").toString());
        logger.info(String.format("afterBindData openedcontractparam value: %s", openedcontractparam));
        if (openedcontractparam.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"openedcontract"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openedcontract"});
        }
        this.initContTplEntry();
    }

    protected void initContTplEntry() {
        DynamicObjectCollection contTplEntry = this.getModel().getEntryEntity("conttplentry");
        for (DynamicObject entry : contTplEntry) {
            DynamicObject conTpl = entry.getDynamicObject("conttemplate");
            if (conTpl == null) continue;
            entry.set("contplversion", (Object)conTpl.getBigDecimal("version"));
        }
        if (contTplEntry.size() > 0) {
            this.getModel().updateEntryCache(contTplEntry);
            this.getView().updateView("conttplentry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        block4 : switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                boolean isOnList = (Boolean)this.getModel().getValue(CONTROL_ISONLIST);
                if (!isOnList) break;
                int rowCount = this.getModel().getEntryEntity(CONTATTR_LISTCONFIGENTRY).size();
                if (rowCount == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u6e05\u5355\u540e\uff0c\u8bf7\u586b\u5165\u81f3\u5c11\u4e00\u884c\u6e05\u5355\u6a21\u677f\u3002", (String)"ContractTypeEditPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObjectCollection rows = this.getModel().getEntryEntity(CONTATTR_LISTCONFIGENTRY);
                for (DynamicObject row : rows) {
                    if (!StringUtils.isEmpty((CharSequence)row.getString("tabname"))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u5355\u5206\u5f55\u884c\u4e2d\u5b58\u5728\u6e05\u5355\u6807\u9898\u4e3a\u7a7a\u7684\u5206\u5f55\u3002", (String)"ContractTypeEditPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break block4;
                }
                break;
            }
            case "deleteentry": {
                DynamicObject dataEntity;
                List refList;
                boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                if (!fromDatabase || (refList = BaseDataRefrenceHelper.getAllRefs((String)"pmct_conttype", (Object)(dataEntity = this.getModel().getDataEntity()).getPkValue())).size() <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u7c7b\u578b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u6e05\u5355\u6a21\u677f\u5206\u5f55\u884c\u3002", (String)"ContractTypeEditPlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String propName = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (propName) {
            case "conttemplate": {
                DynamicObjectCollection contTplEntry = this.getModel().getEntryEntity("conttplentry");
                Set idSet = contTplEntry.stream().map(obj -> {
                    DynamicObject tpl = obj.getDynamicObject("conttemplate");
                    if (tpl != null) {
                        return tpl.getPkValue();
                    }
                    return 0;
                }).collect(Collectors.toSet());
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", idSet));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.initContAttrEntry();
                break;
            }
        }
    }
}

