/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.convert;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.formplugin.AbstractPmbsConvertPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractColItemToInComeApplyConvertPlugin
extends AbstractPmbsConvertPlugin {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet extendedDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtTypeName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = extendedDataEntitySet.FindByEntityKey(tgtTypeName)) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            dataEntity.set("bizdate", (Object)new Date());
            DynamicObject person = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            dataEntity.set("person", (Object)person);
            DynamicObject period = EcPeriodUtils.getCurrentPeriod();
            if (period != null) {
                dataEntity.set("period", (Object)period);
            }
            DynamicObjectCollection contractInComeApplyEntries = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject onlyProject = null;
            boolean isOnlyValidProject = true;
            for (DynamicObject contractInComeApplyEntry : contractInComeApplyEntries) {
                DynamicObject contract = contractInComeApplyEntry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                DynamicObject tempProject = contract.getDynamicObject("project");
                if (tempProject == null) {
                    isOnlyValidProject = false;
                } else if (onlyProject == null) {
                    onlyProject = tempProject;
                } else if (!onlyProject.getPkValue().equals(tempProject.getPkValue())) {
                    isOnlyValidProject = false;
                }
                if (tempProject == null) continue;
                contractInComeApplyEntry.set("contpro", (Object)tempProject);
            }
            if (isOnlyValidProject) {
                dataEntity.set("project", onlyProject);
            }
            DynamicObject org = (DynamicObject)dataEntity.get("org");
            DynamicObject project = (DynamicObject)dataEntity.get("project");
            for (DynamicObject contractInComeApplyEntry : contractInComeApplyEntries) {
                DynamicObject contract = contractInComeApplyEntry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
                contractInComeApplyEntry.set("totaloftaxamount", contract.get("totaloftaxamount"));
                BigDecimal totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
                BigDecimal totalRealOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
                contractInComeApplyEntry.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                contractInComeApplyEntry.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                contractInComeApplyEntry.set("totalunreceiptamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
                BigDecimal amount = BigDecimal.ZERO;
                DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, org, project);
                if (fundPlanBill != null) {
                    DynamicObjectCollection entries = fundPlanBill.getDynamicObjectCollection("incontractplanentity");
                    DynamicObject[] targetEntry = null;
                    for (DynamicObject[] entry : entries) {
                        if (!StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entry.getDynamicObject("incontract").getPkValue().toString())) continue;
                        targetEntry = entry;
                        break;
                    }
                    if (targetEntry != null) {
                        amount = targetEntry.getBigDecimal("inperiodplanamt");
                        contractInComeApplyEntry.set("fundplan", targetEntry);
                    }
                }
                contractInComeApplyEntry.set("amount", (Object)amount);
                if (!contract.getBoolean("ismulticontract")) {
                    contractInComeApplyEntry.set("totaluninvoicetaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount));
                    contractInComeApplyEntry.set("totalinvoiceoftaxamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"));
                } else {
                    QFilter filter = new QFilter("contract", "=", contract.getPkValue());
                    filter.and(new QFilter("billstatus", "=", (Object)"C"));
                    filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
                    BigDecimal invoiceOftaxamount = BigDecimal.ZERO;
                    if (invoices.length > 0) {
                        for (DynamicObject invo : invoices) {
                            invoiceOftaxamount = invoiceOftaxamount.add(invo.getBigDecimal("totaloftaxamount"));
                        }
                    }
                    contractInComeApplyEntry.set("totaluninvoicetaxamount", (Object)invoiceOftaxamount.subtract(totalRealOfTaxAmount));
                    contractInComeApplyEntry.set("totalinvoiceoftaxamt", (Object)invoiceOftaxamount);
                }
                if (!contract.getBoolean("ismultirate")) {
                    DynamicObject taxRate = contract.getDynamicObject("taxrate");
                    if (taxRate != null) {
                        contractInComeApplyEntry.set("conttaxrate", (Object)taxRate.getBigDecimal("taxrate"));
                    }
                } else {
                    contractInComeApplyEntry.set("conttaxrate", (Object)contract.getBigDecimal("avgtaxrate"));
                }
                contractInComeApplyEntry.set("applyoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
                DynamicObject customer = contract.getDynamicObject("parta");
                if (customer != null) {
                    String entity = customer.getDataEntityType().getName();
                    customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)entity);
                    DynamicObjectCollection bankColls = customer.getDynamicObjectCollection("entry_bank");
                    DynamicObject defaultBankAccountInfo = null;
                    for (int i = 0; i < bankColls.size(); ++i) {
                        if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
                        defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
                    }
                    if (defaultBankAccountInfo != null) {
                        contractInComeApplyEntry.set("bankaccount", (Object)defaultBankAccountInfo.getString("bankaccount"));
                        if (defaultBankAccountInfo.getDynamicObject("bank") != null) {
                            contractInComeApplyEntry.set("bankname", (Object)defaultBankAccountInfo.getDynamicObject("bank").getString("name"));
                        }
                    }
                }
                QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                if (project != null) {
                    contractFilter.and(new QFilter("budgetitem.project", "=", project.getPkValue()));
                }
                DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_incontractbudgetperf", (String)"id", (QFilter[])new QFilter[]{contractFilter});
                DynamicObjectCollection payApplySplitEntry = contractInComeApplyEntry.getDynamicObjectCollection("inapplysplitentry");
                for (DynamicObject contractBudget : contractBudgets) {
                    contractBudget = BusinessDataServiceHelper.loadSingle((Object)contractBudget.getPkValue(), (String)"pmbs_contractbudget");
                    DynamicObject payApplay = payApplySplitEntry.addNew();
                    payApplay.set("budgetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
                    payApplay.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                    payApplay.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                    payApplay.set("appliedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                    payApplay.set("incomecurrency", (Object)contractBudget.getDynamicObject("contractcurrency"));
                }
            }
        }
    }
}

