/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmbs.business.manage.MultiSettleAmtService;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.common.utils.contract.TotalSettleAndRealAmountUtils;
import kd.pmgt.pmbs.formplugin.AbstractPmbsConvertPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractPayItemToPayReqConvertPlugin
extends AbstractPmbsConvertPlugin {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet extendedDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtTypeName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = extendedDataEntitySet.FindByEntityKey(tgtTypeName)) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long paymentApplyId = dataEntity.getLong("id");
            DynamicObjectCollection contractPayInfoEntries = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject onlyProject = null;
            boolean isOnlyValidProject = true;
            for (DynamicObject contractPayInfoEntry : contractPayInfoEntries) {
                DynamicObject supplier;
                DynamicObject contract = contractPayInfoEntry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                DynamicObject tempProject = contract.getDynamicObject("project");
                if (tempProject == null) {
                    isOnlyValidProject = false;
                } else if (onlyProject == null) {
                    onlyProject = tempProject;
                } else if (!onlyProject.getPkValue().equals(tempProject.getPkValue())) {
                    isOnlyValidProject = false;
                }
                if (tempProject != null) {
                    contractPayInfoEntry.set("contpro", (Object)tempProject);
                }
                if ((supplier = contractPayInfoEntry.getDynamicObject("contpartb")) == null) continue;
                String entity = supplier.getDataEntityType().getName();
                supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)entity);
                DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
                DynamicObject defaultBankAccountInfo = null;
                for (int i = 0; i < bankColls.size(); ++i) {
                    if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
                    defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
                }
                if (defaultBankAccountInfo == null) continue;
                if (defaultBankAccountInfo.getDynamicObject("bank") != null) {
                    contractPayInfoEntry.set("bankname", (Object)defaultBankAccountInfo.getDynamicObject("bank").getString("name"));
                    contractPayInfoEntry.set("bebank", defaultBankAccountInfo.getDynamicObject("bank").getPkValue());
                }
                contractPayInfoEntry.set("bankaccount", (Object)defaultBankAccountInfo.getString("bankaccount"));
                contractPayInfoEntry.set("accountname", (Object)defaultBankAccountInfo.getLocaleString("accountname").getLocaleValue());
            }
            if (isOnlyValidProject) {
                dataEntity.set("project", onlyProject);
            }
            dataEntity.set("bizdate", (Object)new Date());
            DynamicObject person = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            dataEntity.set("person", (Object)person);
            DynamicObject period = EcPeriodUtils.getCurrentPeriod();
            if (period != null) {
                dataEntity.set("period", (Object)period);
            }
            DynamicObject org = (DynamicObject)dataEntity.get("org");
            DynamicObject project = (DynamicObject)dataEntity.get("project");
            for (DynamicObject contractPayInfoEntry : contractPayInfoEntries) {
                BigDecimal totalRealOfTaxAmount;
                BigDecimal totalSettleOfTaxAmount;
                DynamicObject contract = contractPayInfoEntry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
                BigDecimal applyOfTaxAmount = (BigDecimal)contractPayInfoEntry.get("applyoftaxamount");
                contractPayInfoEntry.set("totaloftaxamount", contract.get("totaloftaxamount"));
                boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
                String multiPayType = contract.getString("multipaytype");
                if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
                    MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
                    totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
                    totalRealOfTaxAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
                } else {
                    TotalSettleAndRealAmountUtils totalSettleAndRealAmountUtils = new TotalSettleAndRealAmountUtils();
                    DynamicObject supplier = contractPayInfoEntry.getDynamicObject("contpartb");
                    QFilter supplierFilter = new QFilter("contpartb", "=", supplier.getPkValue());
                    QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    supplierFilter.and(billStatusFilter).and(contractFilter);
                    if (project != null) {
                        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                        supplierFilter.and(projectFilter);
                    }
                    DynamicObject[] contractSettleBills = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)String.join((CharSequence)",", "id", "settleoftaxamount"), (QFilter[])new QFilter[]{supplierFilter});
                    totalSettleOfTaxAmount = Arrays.stream(contractSettleBills).map(bill -> bill.getBigDecimal("settleoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    totalRealOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
                }
                contractPayInfoEntry.set("totalsettleoftaxamount", (Object)totalSettleOfTaxAmount);
                contractPayInfoEntry.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount);
                BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount);
                contractPayInfoEntry.set("totalunpaidoftaxamount", (Object)totalSettleAndUnRealPayAmount);
                MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
                BigDecimal amount = BigDecimal.ZERO;
                DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, org, project);
                if (fundPlanBill != null) {
                    DynamicObjectCollection entryEntity = fundPlanBill.getDynamicObjectCollection("outcontractplanentity");
                    DynamicObject[] targetEntry = null;
                    for (DynamicObject[] entry : entryEntity) {
                        if (!StringUtils.equals((CharSequence)contract.getPkValue().toString(), (CharSequence)entry.getDynamicObject("outcontract").getPkValue().toString())) continue;
                        targetEntry = entry;
                        break;
                    }
                    if (targetEntry != null) {
                        amount = targetEntry.getBigDecimal("outperiodplanamt");
                        contractPayInfoEntry.set("fundplan", targetEntry.getPkValue());
                    }
                }
                contractPayInfoEntry.set("amount", (Object)amount);
                if (!contract.getBoolean("ismulticontract")) {
                    contractPayInfoEntry.set("totaluninvoicetaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalRealOfTaxAmount));
                    contractPayInfoEntry.set("totalinvoiceoftaxamount", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"));
                } else {
                    QFilter filter = new QFilter("contract", "=", contract.getPkValue());
                    filter.and(new QFilter("billstatus", "=", (Object)"C"));
                    filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
                    filter.and(new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue()));
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
                    BigDecimal invoiceOftaxamount = BigDecimal.ZERO;
                    if (invoices.length > 0) {
                        for (DynamicObject invo : invoices) {
                            invoiceOftaxamount = invoiceOftaxamount.add(invo.getBigDecimal("totaloftaxamount"));
                        }
                    }
                    contractPayInfoEntry.set("totaluninvoicetaxamount", (Object)invoiceOftaxamount.subtract(totalRealOfTaxAmount));
                    contractPayInfoEntry.set("totalinvoiceoftaxamount", (Object)invoiceOftaxamount);
                }
                contractPayInfoEntry.set("controlrate", (Object)contract.getBigDecimal("payrate"));
                if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                    contractPayInfoEntry.set("endpaymentrate", (Object)totalRealOfTaxAmount.add(applyOfTaxAmount).divide(totalSettleOfTaxAmount, 5, 6).multiply(BigDecimal.valueOf(100L)));
                }
                if (!contract.getBoolean("ismultirate")) {
                    DynamicObject taxRate = contract.getDynamicObject("taxrate");
                    if (taxRate != null) {
                        contractPayInfoEntry.set("conttaxrate", (Object)taxRate.getBigDecimal("taxrate"));
                    }
                } else {
                    contractPayInfoEntry.set("conttaxrate", (Object)contract.getBigDecimal("avgtaxrate"));
                }
                QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                DynamicObject[] contractBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"id", (QFilter[])new QFilter[]{contractFilter});
                DynamicObjectCollection payApplySplitEntry = contractPayInfoEntry.getDynamicObjectCollection("payapplysplitentry");
                int index = 1;
                for (DynamicObject contractBudget : contractBudgets) {
                    contractBudget = BusinessDataServiceHelper.loadSingle((Object)contractBudget.getPkValue(), (String)"pmbs_contractbudget");
                    DynamicObject payApplay = payApplySplitEntry.addNew();
                    payApplay.set("seq", (Object)index++);
                    payApplay.set("bugdetitem", (Object)contractBudget.getDynamicObject("budgetitem"));
                    payApplay.set("contractamount", (Object)contractBudget.getBigDecimal("contractauditamtex"));
                    payApplay.set("settledamount", (Object)contractBudget.getBigDecimal("settleauditamtex"));
                    payApplay.set("payedamount", (Object)contractBudget.getBigDecimal("payapplyauditamtex"));
                }
            }
        }
    }
}

