/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.manage.MonthlyFundPlanEditService;
import kd.pmgt.pmbs.business.manage.MultiSettleAmtService;
import kd.pmgt.pmbs.common.utils.EcPeriodUtils;
import kd.pmgt.pmbs.formplugin.AbstractPmbsConvertPlugin;

public class ContractPayItemToPayReqSingleContractConvertPlugin
extends AbstractPmbsConvertPlugin {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        ExtendedDataEntitySet extendedDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtTypeName = this.getTgtMainType().getName();
        String srcTypeName = this.getSrcMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = extendedDataEntitySet.FindByEntityKey(tgtTypeName)) {
            DynamicObject bankInfo;
            DynamicObject supplier;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject contract = dataEntity.getDynamicObject("contract");
            if (contract == null) continue;
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject project = dataEntity.getDynamicObject("project");
            DynamicObject period = EcPeriodUtils.getCurrentPeriod();
            if (period != null) {
                dataEntity.set("period", (Object)period);
            }
            if ((supplier = dataEntity.getDynamicObject("supplier")) != null && (bankInfo = this.getBankInfo(supplier.getPkValue())) != null) {
                dataEntity.set("account", (Object)bankInfo.getString("bankaccount"));
                dataEntity.set("bank", (Object)bankInfo.getDynamicObject("bank").getString("name"));
            }
            this.setSplitEntry(dataEntity, contract);
            MonthlyFundPlanEditService monthlyFundPlanEditService = new MonthlyFundPlanEditService();
            BigDecimal amount = BigDecimal.ZERO;
            DynamicObject fundPlanBill = monthlyFundPlanEditService.getPeriodFundPlanAmount(period, contract, org, project);
            if (fundPlanBill != null) {
                DynamicObjectCollection entryEntity = fundPlanBill.getDynamicObjectCollection("outcontractplanentity");
                DynamicObject targetEntry = null;
                for (DynamicObject entry : entryEntity) {
                    if (!StringUtils.equals((CharSequence)String.valueOf(contract.getPkValue()), (CharSequence)String.valueOf(entry.getDynamicObject("outcontract").getPkValue()))) continue;
                    targetEntry = entry;
                    break;
                }
                if (targetEntry != null) {
                    amount = targetEntry.getBigDecimal("outperiodplanamt");
                    dataEntity.set("fundplan", targetEntry.getPkValue());
                }
            }
            dataEntity.set("periodplanamt", (Object)amount);
            this.setProjectContractInfo(dataEntity, contract, org, project);
            boolean isMultiRate = contract.getBoolean("ismultirate");
            DynamicObject taxRate = contract.getDynamicObject("taxrate");
            if (taxRate == null) continue;
            DynamicObject taxRateObj = BusinessDataServiceHelper.loadSingle((Object)taxRate.getPkValue(), (String)"bd_taxrate");
            DynamicObjectCollection payDetailEntries = dataEntity.getDynamicObjectCollection("paydetailentry");
            for (DynamicObject payDetailEntry : payDetailEntries) {
                if (isMultiRate) {
                    payDetailEntry.set("rateval", contract.get("avgtaxrate"));
                    continue;
                }
                payDetailEntry.set("rate", (Object)taxRate);
                payDetailEntry.set("rateval", taxRateObj.get("taxrate"));
            }
        }
    }

    protected void setSplitEntry(DynamicObject dataEntity, DynamicObject contract) {
        DynamicObjectCollection splitEntries = dataEntity.getDynamicObjectCollection("splitentry");
        splitEntries.clear();
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject[] contBudgetInfo = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract, projectcurrency, contractcurrency, budgetitem, occupyamt, performamt, contractsubmitamt, contractauditamt, settlesubmitamt, settleauditamt, payapplysubmitamt, payapplyauditamt, actualsubmitamt, actualauditamt, occupyamtex, performamtex, contractsubmitamtex, contractauditamtex, settlesubmitamtex, settleauditamtex, payapplysubmitamtex, payapplyauditamtex, actualsubmitamtex, actualauditamtex", (QFilter[])new QFilter[]{filter});
        if (contBudgetInfo.length > 0) {
            long[] splitEntryIds = ORM.create().genLongIds((IDataEntityType)splitEntries.getDynamicObjectType(), contBudgetInfo.length);
            for (int i = 0; i < contBudgetInfo.length; ++i) {
                DynamicObject budgetInfo = contBudgetInfo[i];
                BigDecimal contractAuditAmtEx = budgetInfo.getBigDecimal("contractauditamtex");
                BigDecimal settleAuditAmtEx = budgetInfo.getBigDecimal("settleauditamtex");
                BigDecimal payApplyAuditAmtEx = budgetInfo.getBigDecimal("payapplyauditamtex");
                BigDecimal payApplySubmitAmtEx = budgetInfo.getBigDecimal("payapplysubmitamtex");
                if (contractAuditAmtEx.compareTo(BigDecimal.ZERO) == 0 && settleAuditAmtEx.compareTo(BigDecimal.ZERO) == 0 && payApplyAuditAmtEx.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject splitEntry = splitEntries.addNew();
                splitEntry.set("seq", (Object)i);
                splitEntry.set("id", (Object)splitEntryIds[i]);
                splitEntry.set("pid", (Object)0);
                splitEntry.set("bugdetitem", (Object)budgetInfo.getDynamicObject("budgetitem"));
                splitEntry.set("contractmoney", (Object)contractAuditAmtEx);
                splitEntry.set("settledamount", (Object)settleAuditAmtEx);
                splitEntry.set("payedamount", (Object)payApplyAuditAmtEx);
                splitEntry.set("cursplitamt", (Object)BigDecimal.ZERO);
            }
        }
    }

    protected void setProjectContractInfo(DynamicObject dataEntity, DynamicObject contract, DynamicObject org, DynamicObject project) {
        BigDecimal totalApplyAmount;
        BigDecimal totalPayAmount;
        BigDecimal totalSettleOfTaxAmount;
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
            totalPayAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
            totalApplyAmount = multiSettleAmtService.getMultiTotalApplyOfTaxAmount(org, project, contract);
        } else {
            totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
            totalPayAmount = contract.getBigDecimal("totalrealoftaxamount");
            totalApplyAmount = contract.getBigDecimal("totalapplyoftaxamount");
        }
        BigDecimal totalSettleAndUnRealPayAmount = totalSettleOfTaxAmount.subtract(totalPayAmount);
        dataEntity.set("contractamount", contract.get("totaloftaxamount"));
        dataEntity.set("totalsettleamt", (Object)totalSettleOfTaxAmount);
        dataEntity.set("totalpayamount", (Object)totalPayAmount);
        dataEntity.set("settleunpayamt", (Object)totalSettleAndUnRealPayAmount);
        dataEntity.set("totalapplyoftaxamount", (Object)totalApplyAmount);
        if (!contract.getBoolean("ismulticontract")) {
            dataEntity.set("invoiceunpayamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalPayAmount));
            dataEntity.set("totalinvoiceamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"));
        } else {
            QFilter filter = new QFilter("contract", "=", contract.getPkValue());
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("isclaimed", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("contpartb", "=", contract.getDynamicObject("partb").getPkValue()));
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)"contract,contpartb,totaloftaxamount", (QFilter[])new QFilter[]{filter});
            BigDecimal invoiceOfTaxAmount = BigDecimal.ZERO;
            if (invoices.length > 0) {
                for (DynamicObject invo : invoices) {
                    invoiceOfTaxAmount = invoiceOfTaxAmount.add(invo.getBigDecimal("totaloftaxamount"));
                }
            }
            dataEntity.set("invoiceunpayamt", (Object)invoiceOfTaxAmount.subtract(totalPayAmount));
            dataEntity.set("totalinvoiceamt", (Object)invoiceOfTaxAmount);
        }
    }

    public DynamicObject getBankInfo(Object pk) {
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"entry_bank.bankaccount, entry_bank.accountname, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (customerOrSupplier != null) {
            DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
            for (DynamicObject row : entryBanks) {
                if (!row.getBoolean("isdefault_bank")) continue;
                return row;
            }
        }
        return null;
    }
}

