/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.costitem;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class CostItemEditPlugin
extends AbstractPmbsBillPlugin {
    private static final String OPERATE_NEW = "new";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costDimensionEdit = (BasedataEdit)this.getControl("costdimension");
        costDimensionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentCostItem = (BasedataEdit)this.getControl("parent");
        parentCostItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object costDimensionId;
        super.afterCreateNewData(e);
        Object costDimension = this.getModel().getValue("costdimension");
        if (costDimension == null && (costDimensionId = this.getView().getFormShowParameter().getCustomParam("costdimension")) != null) {
            this.getModel().setValue("costdimension", costDimensionId);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String name = e.getProperty().getName();
        if (name.equals("costdimension")) {
            List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"view");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)orgList, (boolean)true);
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        } else if (name.equals("parent")) {
            List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)"pmbs", (String)"pmbs_cost_dimension", (String)"view");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_cost_dimension", (List)orgList, (boolean)true);
            DynamicObject[] costDimensionList = BusinessDataServiceHelper.load((String)"pmbs_cost_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
            List idList = Arrays.stream(costDimensionList).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            QFilter dimensionFilter = new QFilter("costdimension.id", "in", idList);
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(dimensionFilter);
            long costItemUseOrgId = this.getModel().getDataEntity().getDynamicObject("useorg").getLong("id");
            QFilter costItemUseOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmbs_costitem", (Long)costItemUseOrgId);
            formShowParameter.getListFilterParameter().getQFilters().add(costItemUseOrgFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OPERATE_NEW.equals(operateKey)) {
            DynamicObject costDimension;
            DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
            if (parent != null) {
                this.getPageCache().put("parent", parent.getString("id"));
            }
            if ((costDimension = (DynamicObject)this.getModel().getValue("costdimension")) != null) {
                this.getPageCache().put("costdimension", costDimension.getString("id"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPERATE_NEW.equals(operateKey)) {
            String parentId = this.getPageCache().get("parent");
            this.getPageCache().remove("parent");
            if (parentId != null && !"".equals(parentId)) {
                this.getModel().setValue("parent", (Object)parentId);
                this.getView().updateView("parent");
            }
            String costDimensionId = this.getPageCache().get("costdimension");
            this.getPageCache().remove("costdimension");
            if (costDimensionId != null && !"".equals(costDimensionId)) {
                this.getModel().setValue("costdimension", (Object)costDimensionId);
                this.getView().updateView("costdimension");
            }
        }
    }
}

