/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.event;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class BudgetMappingEditPlugin
extends AbstractPmbsBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BudgetMappingEditPlugin.class);
    private static final String PAGE_CACHE_MAPPING_DIM_ID = "mappingdimid";

    @Override
    public void registerListener(EventObject e) {
        ItemClassEdit itemClassEdit;
        BasedataEdit budgetItemEdit;
        super.registerListener(e);
        BasedataEdit mappingDimEdit = (BasedataEdit)this.getControl("mappingdim");
        if (mappingDimEdit != null) {
            mappingDimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((budgetItemEdit = (BasedataEdit)this.getControl("budgetitem")) != null) {
            budgetItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((itemClassEdit = (ItemClassEdit)this.getControl("mappingvalue")) != null) {
            itemClassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject newMappingDim = (DynamicObject)this.getModel().getValue("mappingdim");
        this.setBudgetMappingType(newMappingDim);
        this.getView().updateView("mappingdimtype");
        DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetmappingentry");
        for (DynamicObject budgetMappingEntity : budgetMappingEntities) {
            DynamicObject mappingValue = budgetMappingEntity.getDynamicObject("mappingvalue");
            if (mappingValue == null) {
                long mappingValueId = budgetMappingEntity.getLong("mappingvalue_id");
                DynamicObject mappingValueObject = BusinessDataServiceHelper.loadSingle((Object)mappingValueId, (String)newMappingDim.getString("number"));
                budgetMappingEntity.set("mappingvalue", (Object)mappingValueObject);
                continue;
            }
            budgetMappingEntity.set("mappingname", mappingValue.get(((BasedataEntityType)mappingValue.getDynamicObjectType()).getNameProperty()));
        }
        this.getView().updateView("budgetmappingentry");
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (isFromDb) {
            long pk = this.getModel().getDataEntity().getLong("id");
            QFilter mappingFilter = new QFilter("budgetmapping", "=", (Object)pk);
            DynamicObject[] proBudgetMappingList = BusinessDataServiceHelper.load((String)"pmco_probudgetmapping", (String)"id", (QFilter[])new QFilter[]{mappingFilter});
            if (proBudgetMappingList.length > 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mappingdim"});
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillShowParameter billShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        int billStatus = billShowParameter.getBillStatus().getValue();
        if (billStatus == BillOperationStatus.VIEW.getValue() || billStatus == BillOperationStatus.SUBMIT.getValue() || billStatus == BillOperationStatus.AUDIT.getValue()) {
            e.setCheckDataChange(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "mappingdim": {
                if (oldValue != null) {
                    DynamicObject oldMappingDim = (DynamicObject)oldValue;
                    this.getPageCache().put(PAGE_CACHE_MAPPING_DIM_ID, oldMappingDim.getPkValue().toString());
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6620\u5c04\u7ef4\u5ea6\u4f1a\u6e05\u7a7a\u9884\u7b97\u9879\u6620\u5c04\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetMappingEditPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("mappingdim", (IFormPlugin)this));
                    break;
                }
                DynamicObject newMappingDim = (DynamicObject)newValue;
                this.changeMappingDim(newMappingDim);
                break;
            }
            case "mappingvalue": {
                EntryGrid grid = (EntryGrid)this.getControl("budgetmappingentry");
                int[] selRows = grid.getSelectRows();
                if (newValue != null) {
                    DynamicObject baseData = (DynamicObject)newValue;
                    this.getModel().setValue("mappingname", (Object)baseData.getString(((BasedataEntityType)baseData.getDynamicObjectType()).getNameProperty()), selRows[0]);
                    break;
                }
                this.getModel().setValue("mappingvalue", null, selRows[0]);
                this.getModel().setValue("mappingname", null, selRows[0]);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("mappingvalue".equals(e.getActionId())) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("budgetmappingentry");
            ListSelectedRowCollection list = (ListSelectedRowCollection)e.getReturnData();
            if (list == null || list.isEmpty()) {
                return;
            }
            try {
                this.getModel().beginInit();
                this.getModel().setValue("mappingvalue", list.get(0).getPrimaryKeyValue(), currentRowIndex);
                this.getModel().setValue("mappingname", (Object)list.get(0).getName(), currentRowIndex);
                this.getModel().endInit();
            }
            catch (NullPointerException exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u5728\u201c\u6620\u5c04\u7ef4\u5ea6\u7c7b\u578b\u201d\u5b57\u6bb5\u4e0b\u4e3b\u52a8\u914d\u7f6e\u201c\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u3002", (String)"BudgetMappingEditPlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                logger.error((Throwable)exception);
                return;
            }
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("budgetmappingentry", currentRowIndex);
            DynamicObject budgetItem = rowEntity.getDynamicObject("budgetitem");
            this.getModel().beginInit();
            if (list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    int insertIndex = this.getModel().insertEntryRow("budgetmappingentry", currentRowIndex + i);
                    this.getModel().setValue("mappingvalue", list.get(i).getPrimaryKeyValue(), insertIndex);
                    this.getModel().setValue("mappingname", (Object)list.get(i).getName(), insertIndex);
                    if (budgetItem == null) continue;
                    this.getModel().setValue("budgetitem", (Object)budgetItem, insertIndex);
                }
            }
            this.getModel().endInit();
            this.getView().updateView("budgetmappingentry");
        } else if ("mappingdim".equals(e.getActionId()) && e.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            ListSelectedRow selectedRow = returnData.get(0);
            QFilter qFilter = new QFilter("mappingdim", "=", selectedRow.getPrimaryKeyValue());
            DynamicObject auditBill = BusinessDataServiceHelper.loadSingle((String)"pmbs_budgetmapping", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (auditBill != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6620\u5c04\u7ef4\u5ea6\u5df2\u5b58\u5728\u4e0e\u6807\u51c6\u9884\u7b97\u9879\u7684\u6620\u5c04\u6570\u636e\uff0c\u8bf7\u5728\u5df2\u6709\u8bb0\u5f55\u4e0a\u7f16\u8f91\u3002", (String)"BudgetMappingEditPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("mappingdim", selectedRow.getPrimaryKeyValue());
        } else if ("budgetitem".equals(e.getActionId()) && e.getReturnData() != null) {
            ListSelectedRowCollection list = (ListSelectedRowCollection)e.getReturnData();
            if (list == null || list.isEmpty()) {
                return;
            }
            DynamicObject[] budgetItemList = BusinessDataServiceHelper.load((Object[])list.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_budgetitem"));
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(budgetItemList));
            dynamicObjectList.sort((o1, o2) -> {
                Collator instance = Collator.getInstance();
                String source = o1.getString("number");
                String target = o2.getString("number");
                return instance.compare(source, target);
            });
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("budgetmappingentry");
            this.getModel().setValue("budgetitem", ((DynamicObject)dynamicObjectList.get(0)).getPkValue(), currentRowIndex);
            for (int i = 1; i < dynamicObjectList.size(); ++i) {
                int insertIndex = this.getModel().insertEntryRow("budgetmappingentry", currentRowIndex + i);
                this.getModel().setValue("budgetitem", ((DynamicObject)dynamicObjectList.get(i)).getPkValue(), insertIndex);
            }
        }
    }

    private void changeMappingDim(DynamicObject mappingDim) {
        if (mappingDim != null) {
            this.setBudgetMappingType(mappingDim);
        } else {
            ((ItemClassTypeEdit)this.getView().getControl("mappingdimtype")).setComboItems(null);
            this.getModel().setValue("mappingdimtype", null);
        }
        DynamicObjectCollection budgetMappingEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetmappingentry");
        budgetMappingEntities.clear();
        this.getView().updateView("mappingdimtype");
        this.getView().updateView("budgetmappingentry");
    }

    private void setBudgetMappingType(DynamicObject mappingDim) {
        if (mappingDim != null) {
            ComboItem item = new ComboItem();
            String baseDataValue = String.valueOf(mappingDim.getPkValue());
            item.setId(baseDataValue);
            item.setCaption(new LocaleString(mappingDim.getString("name")));
            item.setValue(baseDataValue);
            ((ItemClassTypeEdit)this.getView().getControl("mappingdimtype")).setComboItems(Collections.singletonList(item));
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)mappingDim.getPkValue().toString());
            ((ItemClassTypeProp)this.getModel().getProperty("mappingdimtype")).setItemType((DynamicObjectType)dt);
            this.getModel().setValue("mappingdimtype", (Object)baseDataValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "mappingdim": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject mappingDim = (DynamicObject)this.getModel().getValue("mappingdim");
                    this.changeMappingDim(mappingDim);
                    break;
                }
                String mappingDimId = this.getPageCache().get(PAGE_CACHE_MAPPING_DIM_ID);
                this.getModel().beginInit();
                this.getModel().setValue("mappingdim", (Object)mappingDimId);
                this.getView().updateView("mappingdim");
                this.getModel().endInit();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "mappingdim": {
                QFilter modelTypeFilter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
                ListShowParameter parameter = (ListShowParameter)args.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(modelTypeFilter);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mappingdim"));
                break;
            }
            case "mappingvalue": {
                DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("budgetmappingentry");
                Set mappingValueIdSet = mappingEntry.stream().filter(dyn -> dyn.getDynamicObject("mappingvalue") != null).map(dyn -> dyn.getDynamicObject("mappingvalue").getLong("id")).collect(Collectors.toSet());
                ((ListShowParameter)args.getFormShowParameter()).setMultiSelect(true);
                QFilter selectedFilter = new QFilter("id", "not in", mappingValueIdSet);
                ListShowParameter parameter = (ListShowParameter)args.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(selectedFilter);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mappingvalue"));
                break;
            }
            case "budgetitem": {
                ListShowParameter parameter = (ListShowParameter)args.getFormShowParameter();
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "budgetitem"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            OperationServiceHelper.executeOperate((String)"submit", (String)this.getModel().getDataEntityType().getName(), (Object[])new Object[]{this.getModel().getDataEntity(true).getPkValue()}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"audit", (String)this.getModel().getDataEntityType().getName(), (Object[])new Object[]{this.getModel().getDataEntity(true).getPkValue()}, (OperateOption)OperateOption.create());
        }
    }
}

