/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.tree.TreeSearchUtil;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class EventBillFieldAddPlugin
extends AbstractPmbsBillPlugin
implements ClickListener,
TreeNodeClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(EventBillFieldAddPlugin.class);
    private static final String CACHE_NUMBER_AND_NAME = "cacheLeftTreeNumberAndName";
    public static final String rightTreeNodeNumbers = "rightTreeNodeNumbers";
    public static final String rightCurrentNode = "rightCurrentNode";
    protected static final String treeLeft = "treeleft";
    protected static final String treeRight = "treeright";
    protected static final String LList = "llist";
    protected static final String LFocus = "lfocus";
    protected static final String RList = "rlist";
    protected static final String RFocus = "rfocus";
    private static final String beginTreeRight = "beginTreeRight";
    private static final String formtype = "formtype";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeRight = (TreeView)this.getView().getControl(treeRight);
        BasedataEdit application = (BasedataEdit)this.getView().getControl("application");
        BasedataEdit bill = (BasedataEdit)this.getView().getControl("bill");
        application.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        treeRight.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                String nodeId = evt.getNodeId().toString();
                EventBillFieldAddPlugin.this.cacheCurrentNodeId(EventBillFieldAddPlugin.rightCurrentNode, nodeId);
            }
        });
        this.addClickListeners(new String[]{"baradd", "barconfirm", "baritemaddlevel"});
        this.addClickListeners(new String[]{"btngo", "btnallgo", "btnback", "btnallback"});
        this.addClickListeners(new String[]{"allchoose", "allclear", "allexpand", "allshrink"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "searchbefore1", "searchnext1"});
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(event -> TreeSearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (IFormView)this.getView(), (IPageCache)this.getPageCache(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left")));
        Search s2 = (Search)this.getControl("searchapright");
        s2.addEnterListener(event -> TreeSearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (IFormView)this.getView(), (IPageCache)this.getPageCache(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right")));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("application") != null) {
            this.getModel().setValue("application", customParams.get("application"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"application"});
        }
        if (customParams.get("bill") != null) {
            this.getModel().setValue("bill", customParams.get("bill"));
            this.billPropertyChange();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bill"});
            this.billPropertyChange();
        }
    }

    private void billPropertyChange() {
        this.initTreeLeft();
        this.cacheDeleteNodeNumbers(null);
    }

    @Deprecated
    public void checkRegedDataIsChanged() {
    }

    public Map<String, String> getLeftNodeNumAndNameMap() {
        Map<String, String> nodeNumberAndNameMap = new HashMap<String, String>(16);
        String str = this.getPageCache().get(CACHE_NUMBER_AND_NAME);
        if (str != null) {
            nodeNumberAndNameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_NUMBER_AND_NAME), Map.class);
        }
        return nodeNumberAndNameMap;
    }

    @Deprecated
    public void cacheLeftNodeNumAndNameMap(Map<String, String> nodeNumberAndNameMap) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List<QFilter> billQfilters;
        ListShowParameter showParameter;
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("application")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            billQfilters = ((BasedataEdit)this.getControl("application")).getQFilters();
            if (billQfilters == null) {
                billQfilters = new ArrayList<QFilter>(16);
            }
            billQfilters.addAll(this.getModelIdQfilter(EventBillTreeTypeEnum.APPLICATION.getNumber()));
            billQfilters.add(this.getOuterFilter());
            showParameter.setListFilterParameter(new ListFilterParameter(billQfilters, null));
        }
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("bill")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            billQfilters = ((BasedataEdit)this.getControl("bill")).getQFilters();
            DynamicObject application = (DynamicObject)this.getModel().getValue("application");
            if (application == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528\u3002", (String)"EventBillFieldAddPlugin_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long parent = application.getLong("id");
            if (billQfilters == null) {
                billQfilters = new ArrayList(16);
            }
            billQfilters.add(new QFilter("parent", "=", (Object)parent));
            billQfilters.addAll(this.getModelIdQfilter(EventBillTreeTypeEnum.BILL.getNumber()));
            showParameter.setListFilterParameter(new ListFilterParameter(billQfilters, null));
        }
    }

    private QFilter getOuterFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String actionType = (String)formShowParameter.getCustomParam(formtype);
        QFilter qf = null;
        if ("operation".equals(actionType)) {
            qf = new QFilter("isfromouter", "=", (Object)false);
        }
        return qf;
    }

    private Collection<? extends QFilter> getModelIdQfilter(String billTreeType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("billtype", "=", (Object)billTreeType));
        return qFilters;
    }

    private void initTreeLeft() {
        String operation;
        String number;
        String name;
        String id;
        TreeView treeLeft = (TreeView)this.getView().getControl(treeLeft);
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (bill == null) {
            Object sourceFormIdDataId = customParams.get("sourceformiddataid");
            if (sourceFormIdDataId == null) {
                return;
            }
            bill = BusinessDataServiceHelper.loadSingle(sourceFormIdDataId, (String)"pmdc_originaldoclibdir");
            id = bill.getPkValue().toString();
            name = bill.getLocaleString("name").getLocaleValue();
            number = bill.getString("number");
            operation = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        } else {
            id = bill.getString("id");
            name = bill.getLocaleString("name").getLocaleValue();
            number = bill.getString("number");
            operation = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        }
        TreeNode root = "operation".equals(operation) ? this.initOperationLeftTree() : this.initFieldLeftTree();
        if (root == null) {
            return;
        }
        root.setId(id);
        root.setText(name);
        root.setLongNumber(number);
        root.setData(new HashMap(16));
        treeLeft.deleteAllNodes();
        this.cacheLeftRoot(root);
        treeLeft.addNode(root);
        treeLeft.updateNode(root);
        treeLeft.expand(root.getId());
    }

    private void inittreeLeft(String showType) {
        TreeView treeLeft = (TreeView)this.getView().getControl(treeLeft);
        TreeNode rootLeft = this.getCacheLeftRoot();
        if (rootLeft != null) {
            this.dealNode(rootLeft, showType);
            this.cacheLeftRoot(rootLeft);
            List checkedNodeIds = treeLeft.getTreeState().getCheckedNodeIds();
            treeLeft.updateNode(rootLeft);
            for (String id : checkedNodeIds) {
                TreeNode treeNode = rootLeft.getTreeNode(id, 20);
                treeLeft.checkNode(treeNode);
            }
            treeLeft.expand(rootLeft.getId());
        }
    }

    private void dealNode(TreeNode node, String showType) {
        if (node.getData() != null && ((Map)node.getData()).get("name") != null && ((Map)node.getData()).get("number") != null) {
            String text;
            switch (showType) {
                case "1": {
                    text = (String)((Map)node.getData()).get("number");
                    break;
                }
                case "2": {
                    text = ((Map)node.getData()).get("number") + " " + ((Map)node.getData()).get("name");
                    break;
                }
                default: {
                    text = (String)((Map)node.getData()).get("name");
                }
            }
            node.setText(text);
        }
        if (node.getChildren() != null) {
            for (TreeNode treeNode : node.getChildren()) {
                this.dealNode(treeNode, showType);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if ("bill".equals(name)) {
            if (newVal == null) {
                this.getModel().getDataEntity().set("bill", e.getChangeSet()[0].getOldValue());
            } else {
                this.billPropertyChange();
            }
        } else if ("showtype".equals(name)) {
            String newBillId = (String)newVal;
            this.changeShowType(newBillId);
        } else if ("application".equals(name)) {
            String newBillId = null;
            if (newVal != null) {
                Long parentId = ((DynamicObject)newVal).getLong("id");
                QFilter parentFilter = new QFilter("parent", "=", (Object)parentId);
                DynamicObject bill = QueryServiceHelper.queryOne((String)"pmbs_structofbill", (String)"id", (QFilter[])new QFilter[]{parentFilter});
                if (bill != null) {
                    newBillId = bill.getString("id");
                }
                this.getModel().setValue("bill", (Object)newBillId);
            } else {
                this.getModel().getDataEntity().set("application", e.getChangeSet()[0].getOldValue());
            }
        }
    }

    private void changeShowType(String showType) {
        this.getPageCache().put(showType, showType);
        this.inittreeLeft(showType);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        this.getPageCache().put("currentNodeId", nodeId.toString());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "barconfirm": {
                TreeView treeLeft = (TreeView)this.getView().getControl(treeLeft);
                TreeNode leftRoot = this.getCacheLeftRoot();
                Map checkedNode = treeLeft.getTreeState().getFocusNode();
                if (checkedNode == null) {
                    this.getView().close();
                    break;
                }
                String id = (String)checkedNode.get("id");
                TreeNode node = leftRoot.getTreeNode(id, 10);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Map<String, String> leftNodeNumAndNameMap = this.getLeftNodeNumAndNameMap();
                DynamicObject application = (DynamicObject)this.getModel().getValue("application");
                DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
                this.checkApplicationAndBill(application, bill);
                String type = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Object sourceFormIdDataId = customParams.get("sourceformiddataid");
                if (sourceFormIdDataId != null && StringUtils.isNotEmpty((CharSequence)sourceFormIdDataId.toString())) {
                    map.put("name", leftNodeNumAndNameMap.get(node.getLongNumber()));
                    map.put("longnumber", node.getLongNumber());
                } else {
                    map.put("longnumber", node.getLongNumber());
                    map.put("name", leftNodeNumAndNameMap.get(node.getLongNumber()));
                    map.put("application", application.getPkValue());
                    map.put("bill", bill.getPkValue());
                    map.put("isentryfield", this.getNodeProperty("isentryfield", node));
                    map.put(formtype, type);
                }
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
            case "allexpand": {
                this.spreadAll();
                break;
            }
            case "allshrink": {
                this.collapseAll();
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "searchbefore1": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext1": {
                TreeSearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (TreeSearchUtil.TreeSearchParam)new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    public void checkApplicationAndBill(DynamicObject application, DynamicObject bill) {
        if (application == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u4e0e\u5355\u636e\u3002", (String)"EventBillFieldAddPlugin_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        } else if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"EventBillFieldAddPlugin_12", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection getLatestData(String type) {
        QFilter qFilter = new QFilter("bizunitid", "=", (Object)((DynamicObject)this.getModel().getValue("bill")).getLong("id"));
        List nodeNumbers = BillFieldTypeEnum.getFieldNumByType((String)type);
        qFilter.and("type", "in", (Object)nodeNumbers);
        return QueryServiceHelper.query((String)"pmbs_bgcontrolbizreg", (String)"id,name,number,type,typename", (QFilter[])new QFilter[]{qFilter});
    }

    private void cacheDeleteNodeNumbers(List<String> deleteNumbers) {
        this.getPageCache().put("deletenodes", SerializationUtils.toJsonString(deleteNumbers));
    }

    private TreeNode initOperationLeftTree() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        String fieldTable = bill.getString("fieldtable");
        TreeNode root = new TreeNode();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        root.setChildren(nodes);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)fieldTable, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntity = entityMeta.getRootEntity();
        List operations = rootEntity.getOperations();
        this.getOperationField(operations, nodes);
        return root;
    }

    private TreeNode initFieldLeftTree() {
        EntityMetadata entityMeta;
        String fieldTable;
        String isFromOuter;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sourceFormIdDataId = customParams.get("sourceformiddataid");
        if (sourceFormIdDataId != null && StringUtils.isNotEmpty((CharSequence)sourceFormIdDataId.toString())) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle(sourceFormIdDataId, (String)"pmdc_originaldoclibdir");
            isFromOuter = null;
            fieldTable = bill.getString("number");
        } else {
            DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
            isFromOuter = bill.getString("isfromouter");
            fieldTable = bill.getString("fieldtable");
        }
        TreeNode root = new TreeNode();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        root.setChildren(nodes);
        if (isFromOuter != null && isFromOuter.equals("true")) {
            return null;
        }
        try {
            entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)fieldTable, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        }
        catch (Exception var10) {
            throw new KDBizException(var10.getMessage());
        }
        log.info("\u5f53\u524d\u6ce8\u518c\u5355\u636e\u6807\u8bc6\u4e3a: {}", (Object)fieldTable);
        if (entityMeta == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u539f\u5355\u8fdb\u884c\u6ce8\u518c\u3002", (String)"EventBillFieldAddPlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        MainEntity rootEntity = entityMeta.getRootEntity();
        List items = rootEntity.getItems();
        HashMap<String, String> nodeNumberAndNameMap = new HashMap<String, String>(16);
        this.getField(items, nodes, root, false, nodeNumberAndNameMap);
        this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(nodeNumberAndNameMap));
        return root;
    }

    private void getOperationField(List<Operation> operations, List<TreeNode> nodes) {
        HashMap<String, String> numberAndNameMap = new HashMap<String, String>(16);
        for (Operation operation : operations) {
            String cnName = operation.getName().getLocaleValue();
            String key = operation.getKey();
            TreeNode childNode = this.createOperationNode(key, cnName, numberAndNameMap);
            nodes.add(childNode);
        }
        this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(numberAndNameMap));
    }

    private TreeNode createOperationNode(String number, String cnName, Map<String, String> numberAndNameMap) {
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        node.setText(cnName);
        node.setLongNumber(number);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("fieldAlias", number);
        data.put("number", number);
        data.put("isentryfield", false);
        data.put("name", cnName);
        node.setData(data);
        numberAndNameMap.put(number, cnName);
        return node;
    }

    private void getField(List<EntityItem<?>> properties, List<TreeNode> nodes, TreeNode parentNode, boolean isEntryField, Map<String, String> nodeNumberAndNameMap) {
        for (EntityItem<?> property : properties) {
            String number = property.getKey();
            LocaleString displayName = property.getName();
            if (number == null || displayName == null) continue;
            TreeNode childNode = this.createChildNode(number, displayName.getLocaleValue(), null, null, parentNode, isEntryField, nodeNumberAndNameMap);
            nodes.add(childNode);
            if (property instanceof EntryEntity) {
                EntryEntity propertyEntry = (EntryEntity)property;
                List items = propertyEntry.getItems();
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                childNode.setChildren(treeNodes);
                this.getField(items, treeNodes, childNode, true, nodeNumberAndNameMap);
                continue;
            }
            if (!(property instanceof FlexField)) continue;
            int flexTypeId = ((FlexField)property).getFlexType();
            FlexType ft = FlexEntityMetaUtils.getFlexType((int)flexTypeId);
            List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexTypeId);
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
            childNode.setChildren(treeNodes);
            String flexDataTable = ft.getFlexDataTable();
            this.getFlexField(flexProperties, flexDataTable, treeNodes, childNode, nodeNumberAndNameMap);
        }
    }

    private void getFlexField(List<FlexProperty> properties, String flexDataTable, List<TreeNode> nodes, TreeNode parentNode, Map<String, String> nodeNumberAndNameMap) {
        String sourceNumber = parentNode.getLongNumber();
        Iterator<FlexProperty> var7 = properties.iterator();
        while (true) {
            String glName;
            String flexField;
            String valueSource;
            String number;
            if (var7.hasNext()) {
                FlexProperty property = var7.next();
                number = property.getNumber();
                valueSource = property.getValueSource();
                flexField = property.getFlexField();
                String string = glName = property.getName() != null && property.getName().getLocaleValue_zh_CN() != null ? property.getName().getLocaleValue_zh_CN() : property.getGLName();
                if (number == null || glName == null) {
                    log.info("billfieldadd_flex number or name is null,number:{},name:{}", (Object)number, (Object)glName);
                    continue;
                }
            } else {
                return;
            }
            TreeNode childNode = this.createChildNode(number, glName, null, null, parentNode, true, nodeNumberAndNameMap);
            HashMap data = (HashMap)childNode.getData();
            data.put("flexDataTable", flexDataTable);
            data.put("sourceNumber", sourceNumber);
            data.put("flexField", flexField);
            data.put("valueSource", valueSource);
            data.put("fieldType", "flex");
            nodes.add(childNode);
            if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
            List<IDataEntityProperty> propertyValue = this.getPropertyValue(valueSource);
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
            for (IDataEntityProperty childProperty : propertyValue) {
                String number2 = childProperty.getName();
                LocaleString displayName = childProperty.getDisplayName();
                if (number2 == null || displayName == null) continue;
                String name = displayName.getLocaleValue();
                TreeNode childNode2 = this.createChildNode(number2, name, null, null, childNode, true, nodeNumberAndNameMap);
                children.add(childNode2);
            }
            if (children.isEmpty()) continue;
            childNode.setChildren(children);
        }
    }

    private List<IDataEntityProperty> getPropertyValue(String fieldTable) {
        Collection values;
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)fieldTable);
            values = mainType.getAllFields().values();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return new ArrayList<IDataEntityProperty>(values);
    }

    private TreeNode createChildNode(String number, String displayName, String fieldType, String fieldTable, TreeNode parentNode, boolean isEntryField, Map<String, String> nodeNumberAndNameMap) {
        String realNumber;
        String realName;
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        node.setParentid(parentNode.getId());
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        if (isEntryField) {
            HashMap data1 = (HashMap)parentNode.getData();
            String parentName = (String)data1.get("name");
            realName = parentName + "." + displayName;
            realNumber = parentNode.getLongNumber() + "." + number;
        } else {
            realName = displayName;
            realNumber = number;
        }
        nodeNumberAndNameMap.put(realNumber, realName);
        data.put("name", realName);
        data.put("number", realNumber);
        data.put("fieldType", fieldType);
        data.put("fieldTable", fieldTable);
        data.put("fieldAlias", realNumber);
        data.put("isentryfield", isEntryField);
        node.setData(data);
        node.setLongNumber(realNumber);
        node.setText(realName);
        return node;
    }

    public boolean checkCurrentDataIsNew(String type) {
        TreeNode beginRoot = this.getBeginRightRoot();
        ArrayList<String> nodeIds = new ArrayList<String>(16);
        this.getLeftTreeFieldNodeIds(beginRoot, nodeIds);
        DynamicObjectCollection newData = this.getLatestData(type);
        if (newData.size() != nodeIds.size()) {
            return false;
        }
        for (DynamicObject data : newData) {
            String id = data.getString("id");
            nodeIds.remove(id);
        }
        return nodeIds.isEmpty();
    }

    public void getLeftTreeFieldNodeIds(TreeNode root, List<String> nodeIds) {
        List children = root.getChildren();
        Map nodeData = (Map)root.getData();
        if (children != null && !children.isEmpty()) {
            for (TreeNode child : children) {
                this.getLeftTreeFieldNodeIds(child, nodeIds);
            }
        } else if (nodeData.get("nodeType") != null) {
            String id = root.getId();
            nodeIds.add(id);
        }
    }

    private void cacheCurrentNodeId(String cacheKey, String nodeId) {
        this.getPageCache().put(cacheKey, nodeId);
    }

    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot != null) {
            TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
            if (leftRoot.getChildren() != null) {
                this.collapseChild(leftRoot, treeleft);
            }
            treeleft.deleteAllNodes();
            treeleft.addNode(leftRoot);
        }
    }

    protected void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot != null) {
            TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
            if (leftRoot.getChildren() != null) {
                leftRoot.setIsOpened(true);
                this.spreadChild(leftRoot, treeleft);
            }
            treeleft.deleteAllNodes();
            treeleft.addNode(leftRoot);
        }
    }

    protected void collapseChild(TreeNode leftRoot, TreeView treeleft) {
        leftRoot.getChildren().forEach(t -> {
            if (t.getChildren() != null) {
                t.setIsOpened(false);
                this.collapseChild((TreeNode)t, treeleft);
            }
        });
    }

    protected void spreadChild(TreeNode leftRoot, TreeView treeleft) {
        leftRoot.getChildren().forEach(t -> {
            if (t.getChildren() != null) {
                t.setIsOpened(true);
                this.spreadChild((TreeNode)t, treeleft);
            }
        });
    }

    protected void setTreeFocus(TreeView tree, TreeNode node) {
        tree.focusNode(node);
    }

    /*
     * Unable to fully structure code
     */
    protected void cacheLeftRoot(TreeNode rootleft) {
        if (rootleft != null) {
            queue = TreeSearchUtil.getQueue((TreeNode)rootleft);
            while (true) {
                if (queue.isEmpty()) {
                    this.getPageCache().put("treeleft", SerializationUtils.toJsonString((Object)rootleft));
                    return;
                }
                node = (TreeNode)queue.poll();
                children = node.getChildren();
                if (children == null) continue;
                var5_5 = children.iterator();
                while (true) {
                    if (!var5_5.hasNext()) ** break;
                    o = var5_5.next();
                    child = (TreeNode)o;
                    child.setParentid(node.getId());
                }
                break;
            }
        }
        this.getPageCache().put("treeleft", null);
    }

    protected TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(treeLeft))) {
            return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeLeft), TreeNode.class);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void cacheRightRoot(TreeNode rootRight) {
        if (rootRight != null) {
            queue = TreeSearchUtil.getQueue((TreeNode)rootRight);
            while (true) {
                if (queue.isEmpty()) {
                    this.getPageCache().put("treeright", SerializationUtils.toJsonString((Object)rootRight));
                    return;
                }
                node = (TreeNode)queue.poll();
                children = node.getChildren();
                if (children == null) continue;
                var5_5 = children.iterator();
                while (true) {
                    if (!var5_5.hasNext()) ** break;
                    child = (TreeNode)var5_5.next();
                    child.setParentid(node.getId());
                }
                break;
            }
        }
        this.getPageCache().put("treeright", null);
    }

    protected TreeNode getBeginRightRoot() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(beginTreeRight), TreeNode.class);
    }

    protected TreeNode getCacheRightRoot() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRight), TreeNode.class);
    }

    protected void cacheRightNumbers(List<String> rightNodeMumbers) {
        this.getPageCache().put(rightTreeNodeNumbers, SerializationUtils.toJsonString(rightNodeMumbers));
    }

    protected List<String> getCacheRightNumbers() {
        return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTreeNodeNumbers), List.class);
    }

    protected Object getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        return nodeData.get(key) != null ? nodeData.get(key) : nodeData.get(key.toUpperCase());
    }

    @Deprecated
    public List<String> checkRefBeforeSave(List<TreeNode> newNodes, Long billId, Long appId) {
        return null;
    }

    @Deprecated
    public void getNodeIdsByNodeNums(TreeNode node, List<String> nums, List<Long> ids) {
    }

    @Deprecated
    protected TreeNode getRigthRoot() {
        return null;
    }

    @Deprecated
    protected TreeNode isMatch(TreeNode rightFocusNode, TreeNode copy) {
        return null;
    }

    @Deprecated
    public void allClear(TreeNode leftRoot, TreeView treeLeft) {
    }

    @Deprecated
    protected void allChoose(TreeView treeLeft, TreeNode leftRoot) {
    }
}

