/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.event;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.plugin.ConvertRuleSetPlugInProxy;
import kd.bos.entity.botp.plugin.args.LoadFuncTypesEventArgs;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.service.bizrule.OpBizRuleSupport;
import kd.pmgt.pmbs.business.service.budgetreg.OuterBillRegisterService;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.IdentifyValueEnum;
import kd.pmgt.pmbs.common.tree.BillListUtil;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;
import kd.pmgt.pmbs.formplugin.event.botp.BillTreeBuildParameter;
import kd.pmgt.pmbs.formplugin.event.botp.EntityParseHelper;
import org.apache.commons.collections4.CollectionUtils;

public class FieldRegisterList
extends AbstractPmbsFormPlugin
implements TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(FieldRegisterList.class);
    private static final String leftTree = "lefttree";
    public static final String BILLLISTAP = "billlistap";
    public static final String BILLLISTAP1 = "billlistap1";
    private static final String treeviewap = "treeviewap";
    private static final String formtype = "formtype";
    protected BillListUtil billListUtil = new BillListUtil();
    private String billType_application = EventBillTreeTypeEnum.APPLICATION.getNumber();
    private String billType_bill = EventBillTreeTypeEnum.BILL.getNumber();
    private String billType_cloud = EventBillTreeTypeEnum.CLOUD.getNumber();
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_DELETE = "btndelete";
    private static final String BAR_ADD = "baradd";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_DELETE = "bardelete";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_REFRESH = "barrefresh";
    private static final String BAR_EXIT = "barexit";
    private static final String CACHE_CURRENT_LOCKED_SYMBOL = "currentlockedsymbol";
    private ConvertRuleSetPlugInProxy ruleSetPlugInProxy;

    public void initialize() {
        super.initialize();
        TreeView leftTree = (TreeView)this.getView().getControl(treeviewap);
        leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BTN_ADD, BTN_DELETE});
    }

    public void registerListener(EventObject e) {
        TextEdit defaultEdit;
        TextEdit fieldFormulaTranslationEdit;
        TextEdit formulaTranslationEdit;
        TextEdit bizOpNameEdit;
        super.registerListener(e);
        TextEdit sourceFieldNameEdit = (TextEdit)this.getView().getControl("sourcefieldname");
        if (sourceFieldNameEdit != null) {
            sourceFieldNameEdit.addButtonClickListener((ClickListener)this);
        }
        if ((bizOpNameEdit = (TextEdit)this.getView().getControl("bizopname")) != null) {
            bizOpNameEdit.addButtonClickListener((ClickListener)this);
        }
        if ((formulaTranslationEdit = (TextEdit)this.getView().getControl("formulatranslation")) != null) {
            formulaTranslationEdit.addButtonClickListener((ClickListener)this);
        }
        if ((fieldFormulaTranslationEdit = (TextEdit)this.getView().getControl("fieldformulatranslation")) != null) {
            fieldFormulaTranslationEdit.addButtonClickListener((ClickListener)this);
        }
        if ((defaultEdit = (TextEdit)this.getView().getControl("defaultvaluetranslation")) != null) {
            defaultEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree(null);
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)leftNode);
        if (firstNode == null) {
            return;
        }
        this.initRightTable(firstNode.getId());
        this.editRightTable(Boolean.FALSE);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baradd": {
                this.updateSourceFieldName();
                break;
            }
            case "bardelete": {
                Tab tab = (Tab)this.getControl("tabap");
                String currentTab = tab.getCurrentTab();
                String entrySymbol = "field".equals(currentTab) ? "budgetcontrolentry" : BILLLISTAP1;
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entrySymbol);
                TreeNode currentLeftNode = this.getCurrentLefTreeNode();
                int[] selectRows = entryGrid.getSelectRows();
                if (currentLeftNode == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"FieldRegisterList_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"FieldRegisterList_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener callBack = new ConfirmCallBackListener(BAR_DELETE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u5355\u636e\u6ce8\u518c\u5b57\u6bb5\u6216\u8005\u64cd\u4f5c\uff1f", (String)"FieldRegisterList_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
                break;
            }
            case "barrefresh": {
                this.barRefresh();
                break;
            }
            case "barexit": {
                this.getView().close();
                break;
            }
            case "barsave": {
                Object controlTarget = this.getModel().getValue("controltarget");
                if (controlTarget == null || StringUtils.isEmpty((CharSequence)((String)controlTarget))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a7\u5236\u76ee\u6807\u3002", (String)"FieldRegisterList_60", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                this.editRightTable(Boolean.FALSE);
                this.barSave();
                this.initLeftTree(this.getCurrentLefTreeNode());
                this.clickLeftTreeNode(this.getCurrentLefTreeNode());
                break;
            }
            case "baredit": {
                this.editRightTable(Boolean.TRUE);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requireLock(String billFormId) {
        if (StringUtils.isEmpty((CharSequence)billFormId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9501\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldRegisterList_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        String groupId = "pmbs";
        String entityNumber = "pmbs_structofbill";
        try (DataMutex dataMutex = DataMutex.create();){
            boolean require = dataMutex.require(billFormId, groupId, entityNumber, BAR_EDIT, false);
            if (!require) {
                String errMessage;
                Map lockInfo = dataMutex.getLockInfo(billFormId, groupId, entityNumber);
                if (lockInfo != null) {
                    long userId = Long.parseLong((String)lockInfo.get("userid"));
                    String client = (String)lockInfo.get("client");
                    String user = null;
                    if (userId == -1L) {
                        user = "guest";
                    } else {
                        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
                        if (userObj != null) {
                            user = userObj.getString("name");
                        }
                    }
                    errMessage = StringUtils.isNotBlank((CharSequence)client) ? this.getClientDescription(user, client) : String.format(ResManager.loadKDStringExt((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_50", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), user);
                } else {
                    errMessage = ResManager.loadKDStringExt((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]);
                }
                this.getView().showErrorNotification(errMessage);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FieldRegisterList_43", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        this.getPageCache().put(CACHE_CURRENT_LOCKED_SYMBOL, billFormId);
        return true;
    }

    private void releaseLock() {
        String lockedNodeId = this.getPageCache().get(CACHE_CURRENT_LOCKED_SYMBOL);
        if (StringUtils.isEmpty((CharSequence)lockedNodeId)) {
            return;
        }
        String groupId = "pmbs";
        String entityNumber = "pmbs_structofbill";
        try (DataMutex dataMutex = DataMutex.create();){
            boolean require = dataMutex.require(lockedNodeId, groupId, entityNumber, BAR_EDIT, false);
            if (require) {
                dataMutex.release(lockedNodeId, entityNumber, BAR_EDIT);
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FieldRegisterList_44", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    private String getClientDescription(String user, String clientType) {
        if ("web".equals(clientType)) {
            return String.format(ResManager.loadKDStringExt((String)"%s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_51", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), user);
        }
        if ("mobile".equals(clientType)) {
            return String.format(ResManager.loadKDStringExt((String)"%s\u6b63\u5728\u79fb\u52a8\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_52", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), user);
        }
        if ("batch".equals(clientType) || "MQ".equals(clientType)) {
            return String.format(ResManager.loadKDStringExt((String)"%s\u6b63\u5728\u540e\u53f0\u4efb\u52a1\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_53", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), user);
        }
        return String.format(ResManager.loadKDStringExt((String)"%s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FieldRegisterList_51", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), user);
    }

    private void editRightTable(boolean enable) {
        TreeNode currentLefTreeNode = this.getCurrentLefTreeNode();
        if (currentLefTreeNode == null) {
            return;
        }
        if (enable && this.requireLock(currentLefTreeNode.getId())) {
            this.doEditRightTable(true);
        }
        if (!enable) {
            this.releaseLock();
            this.doEditRightTable(false);
        }
    }

    private void doEditRightTable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{"budgetcontrolentry", "budgetopentity", "formulatranslation", "controltarget", "initstatus"});
        this.getView().setEnable(enable, new String[]{BAR_SAVE});
        this.getView().setEnable(Boolean.valueOf(enable == false), new String[]{BAR_EDIT});
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseLock();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "sourcefieldname": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                EntryGrid grid = (EntryGrid)this.getView().getControl("budgetcontrolentry");
                int[] selectRows = grid.getSelectRows();
                this.getModel().setValue("sourcefieldnumber", null, selectRows[0]);
                this.getModel().setValue("isentryfield", null, selectRows[0]);
                break;
            }
            case "bizopname": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                EntryGrid grid = (EntryGrid)this.getView().getControl("budgetopentity");
                int[] selectRows = grid.getSelectRows();
                this.getModel().setValue("bizopnumber", null, selectRows[0]);
                break;
            }
            case "budgetmapping": {
                DynamicObjectCollection budgetControlEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry");
                DynamicObject budgetControlEntity = (DynamicObject)budgetControlEntities.get(rowIndex);
                String budgetControlDimNum = budgetControlEntity.getString("budgetcontroldimnum");
                if (StringUtils.equals((CharSequence)budgetControlDimNum, (CharSequence)BillFieldTypeEnum.BUDGET.getNumber())) break;
                this.getModel().setValue("budgetmapping", null, rowIndex);
                break;
            }
            case "defaultvaluetranslation": {
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                String dimnum = this.getModel().getValue("budgetcontroldimnum", row).toString();
                if (dimnum.equals(BillFieldTypeEnum.AMOUNT.getNumber())) {
                    CRFormula formula = new CRFormula();
                    String amount = newValue == null ? BigDecimal.ZERO.toString() : newValue.toString();
                    formula.setExpression(amount);
                    formula.setExprTran(amount);
                    String json = SerializationUtils.toJsonString((Object)formula);
                    this.getModel().setValue("defaultvalue", (Object)json, row);
                }
                if (!dimnum.equals(BillFieldTypeEnum.PERIOD.getNumber()) || newValue != null && !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("defaultvalue", null, row);
                break;
            }
            case "controltarget": {
                if (newValue == null) break;
                DynamicObjectCollection budgetFieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry");
                for (DynamicObject budgetField : budgetFieldEntries) {
                    BillFieldTypeEnum type = BillFieldTypeEnum.getEnumByNumber((String)budgetField.getString("budgetcontroldimnum"));
                    if (!StringUtils.equals((CharSequence)type.getNumber(), (CharSequence)BillFieldTypeEnum.PERIOD.getNumber())) continue;
                    String billFieldTypeEnumName = budgetField.getString("budgetcontroldimname");
                    if (StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)BudgetControlTargetEnum.BUDGETUSE.getValue()) || StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue())) {
                        if (!billFieldTypeEnumName.contains("*")) {
                            billFieldTypeEnumName = billFieldTypeEnumName + "*";
                        }
                    } else {
                        billFieldTypeEnumName = billFieldTypeEnumName.replace("*", "");
                    }
                    budgetField.set("budgetcontroldimname", (Object)billFieldTypeEnumName);
                }
                this.getView().updateView("budgetcontrolentry");
                break;
            }
        }
    }

    private void barSave() {
        try (TXHandle h = TX.required();){
            try {
                this.checkBudgetOperation();
                this.updateCondition();
                this.updateBudgetField();
                this.updateBudgetOperation();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        h = TX.required();
        var2_2 = null;
        try {
            try {
                this.updateOpBizRuleSet();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (var2_2 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FieldRegisterList_22", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
    }

    private void clickLeftTreeNode(TreeNode node) {
        TreeView treeView = (TreeView)this.getControl(treeviewap);
        if (node != null) {
            treeView.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    private void updateOpBizRuleSet() {
        DynamicObject budgetOperation;
        DynamicObject opBill;
        DynamicObjectCollection budgetOperationEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity");
        String bizBillNumber = "";
        String bizBillId = "";
        if (budgetOperationEntries.size() > 0 && (opBill = (budgetOperation = (DynamicObject)budgetOperationEntries.get(0)).getDynamicObject("opbill")) != null) {
            bizBillNumber = opBill.getString("number");
            bizBillId = opBill.getPkValue().toString();
        }
        if (StringUtils.isNotBlank((CharSequence)bizBillNumber) && StringUtils.isNotBlank((CharSequence)bizBillId)) {
            ArrayList<String> opList = new ArrayList<String>(6);
            opList.add(BillFieldTypeEnum.TAKE_OPERATION.getNumber());
            opList.add(BillFieldTypeEnum.EXEC_OPERATION.getNumber());
            opList.add(BillFieldTypeEnum.RETURN_OPERATION.getNumber());
            opList.add(BillFieldTypeEnum.CLEAR_OPERATION.getNumber());
            opList.add(BillFieldTypeEnum.TAKEANDEXEC_OPERATION.getNumber());
            opList.add(BillFieldTypeEnum.RETURNANDCLEAR_OPERATION.getNumber());
            QFilter qFilter = new QFilter("fieldtable", "=", (Object)bizBillNumber);
            qFilter.and("bizunitid", "!=", (Object)Long.parseLong(bizBillId));
            qFilter.and("type", "in", opList);
            DynamicObject[] BgControlBizRegs = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (BgControlBizRegs.length > 0) {
                List controlIds = Arrays.stream(BgControlBizRegs).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                BgControlBizRegs = BusinessDataServiceHelper.load((Object[])controlIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"));
            }
            DynamicObject structOfBill = BusinessDataServiceHelper.loadSingle((Object)bizBillId, (String)"pmbs_structofbill");
            DynamicObjectType dt = budgetOperationEntries.getDynamicObjectType();
            for (DynamicObject BgControlBizReg : BgControlBizRegs) {
                DynamicObject budgetOperation2 = new DynamicObject(dt);
                budgetOperation2.set("opbill", (Object)structOfBill);
                if (StringUtils.isNotBlank((CharSequence)BgControlBizReg.getString("number"))) {
                    budgetOperation2.set("bizopnumber", (Object)BgControlBizReg.getString("number"));
                }
                if (StringUtils.isNotBlank((CharSequence)BgControlBizReg.getString("type"))) {
                    budgetOperation2.set("budgetopactionnum", (Object)BgControlBizReg.getString("type"));
                }
                budgetOperationEntries.add((Object)budgetOperation2);
            }
        }
        OpBizRuleSupport opBizRuleSupport = new OpBizRuleSupport(budgetOperationEntries);
        opBizRuleSupport.updateOpBizRule();
    }

    private void deleteOpBizRuleSet() {
        Object data;
        DynamicObjectCollection budgetOperationEntries = this.getModel().getEntryEntity("budgetopentity");
        OpBizRuleSupport opBizRuleSupport = new OpBizRuleSupport(budgetOperationEntries);
        TreeNode treeNode = this.getCurrentLefTreeNode();
        if (treeNode != null && (data = treeNode.getData()) != null) {
            String entityNumber = ((HashMap)data).get("number").toString();
            Set opKeySet = budgetOperationEntries.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("budgetopactionnum"))).map(o -> o.getString("budgetopactionnum")).collect(Collectors.toSet());
            opBizRuleSupport.deleteOpBizRule(entityNumber, opKeySet);
        }
    }

    private void checkBudgetOperation() {
        HashMap<String, HashSet> budgetOperationMap = new HashMap<String, HashSet>();
        DynamicObjectCollection budgetOperationEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity");
        if (budgetOperationEntries.size() == 0) {
            return;
        }
        String bizBillNumber = "";
        String bizBillId = "";
        String bizBillName = "";
        DynamicObject budgetOperation = (DynamicObject)budgetOperationEntries.get(0);
        DynamicObject opBill = budgetOperation.getDynamicObject("opbill");
        if (opBill != null) {
            bizBillNumber = opBill.getString("number");
            bizBillId = opBill.getPkValue().toString();
            bizBillName = opBill.getString("name");
        }
        ArrayList<String> opList = new ArrayList<String>(6);
        opList.add(BillFieldTypeEnum.TAKE_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.EXEC_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.CLEAR_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.TAKEANDEXEC_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.RETURNANDCLEAR_OPERATION.getNumber());
        if (StringUtils.isNotBlank((CharSequence)bizBillNumber) && StringUtils.isNotBlank((CharSequence)bizBillId)) {
            QFilter qFilter = new QFilter("fieldtable", "=", (Object)bizBillNumber);
            qFilter.and("bizunitid", "!=", (Object)Long.parseLong(bizBillId));
            qFilter.and("type", "in", opList);
            DynamicObject[] BgControlBizRegs = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (BgControlBizRegs.length > 0) {
                List controlIds = Arrays.stream(BgControlBizRegs).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                BgControlBizRegs = BusinessDataServiceHelper.load((Object[])controlIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"));
            }
            for (DynamicObject BgControlBizReg : BgControlBizRegs) {
                String opNumber = BgControlBizReg.getString("number");
                String opType = BgControlBizReg.getString("type");
                if (!StringUtils.isNotBlank((CharSequence)opNumber) || !StringUtils.isNotBlank((CharSequence)opType)) continue;
                HashSet<String> budgetOperationSet = (HashSet<String>)budgetOperationMap.get(opNumber);
                if (budgetOperationSet == null) {
                    budgetOperationSet = new HashSet<String>();
                }
                budgetOperationSet.add(opType);
                budgetOperationMap.put(opNumber, budgetOperationSet);
            }
        }
        for (DynamicObject budgetOperationEntry : budgetOperationEntries) {
            String bizOpNumber = budgetOperationEntry.getString("bizopnumber");
            String bizOpName = budgetOperationEntry.getString("bizopname");
            String budgetOpNumber = budgetOperationEntry.getString("budgetopactionnum");
            if (!StringUtils.isNotBlank((CharSequence)budgetOpNumber) || !StringUtils.isNotBlank((CharSequence)bizOpNumber)) continue;
            BillFieldTypeEnum type = BillFieldTypeEnum.getEnumByNumber((String)budgetOpNumber);
            Set budgetOperationSet = (Set)budgetOperationMap.get(bizOpNumber);
            if (budgetOperationSet != null) {
                if (!StringUtils.isNotBlank((CharSequence)type.getNumber()) || budgetOperationSet.contains(type.getNumber())) continue;
                String errorTip = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u201c%2$s\u201d\u64cd\u4f5c\u5b58\u5728\u591a\u4e2a\u6620\u5c04\u4e0d\u540c\u201c\u9884\u7b97\u6263\u51cf\u52a8\u4f5c\u201d\u7684\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FieldRegisterList_59", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), bizBillName, bizOpName);
                throw new KDBizException(errorTip);
            }
            budgetOperationMap.put(bizOpNumber, Sets.newHashSet((Object[])new String[]{type.getNumber()}));
        }
    }

    private void updateBudgetOperation() {
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection budgetOperationEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity");
        for (DynamicObject budgetOperationEntry : budgetOperationEntries) {
            long budgetControlPk = budgetOperationEntry.getLong("budgetoppk");
            DynamicObject controlBizReg = budgetControlPk == 0L ? BusinessDataServiceHelper.newDynamicObject((String)"pmbs_bgcontrolbizreg") : BusinessDataServiceHelper.loadSingle((Object)budgetControlPk, (String)"pmbs_bgcontrolbizreg");
            BillFieldTypeEnum type = BillFieldTypeEnum.getEnumByNumber((String)budgetOperationEntry.getString("budgetopactionnum"));
            controlBizReg.set("type", (Object)type.getNumber());
            controlBizReg.set("typename", (Object)type.getName());
            Long userId = RequestContext.get().getCurrUserId();
            controlBizReg.set("creator", (Object)userId);
            controlBizReg.set("modifier", (Object)userId);
            LocalDateTime localDateTime = LocalDateTime.now();
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDateTime.atZone(zone).toInstant();
            Date createTime = Date.from(instant);
            controlBizReg.set("createtime", (Object)createTime);
            controlBizReg.set("modifytime", (Object)createTime);
            controlBizReg.set("name", (Object)budgetOperationEntry.getString("bizopname"));
            String fieldAlias = budgetOperationEntry.getString("bizopnumber");
            controlBizReg.set("fieldalias", (Object)fieldAlias);
            controlBizReg.set("number", (Object)fieldAlias);
            controlBizReg.set("isflex", (Object)false);
            controlBizReg.set("isprefab", (Object)"0");
            controlBizReg.set("isdefault", (Object)"0");
            DynamicObject application = budgetOperationEntry.getDynamicObject("opapplication");
            DynamicObject bill = budgetOperationEntry.getDynamicObject("opbill");
            String bizSystemAlias = application.getString("name");
            Long bizSystemId = application.getLong("id");
            String bizUnitAlias = bill.getString("name");
            Long bizUnitId = bill.getLong("id");
            String fieldTable = bill.getString("fieldtable");
            controlBizReg.set("bizunitalias", (Object)bizUnitAlias);
            controlBizReg.set("bizunitid", (Object)bizUnitId);
            controlBizReg.set("bizsystemalias", (Object)bizSystemAlias);
            controlBizReg.set("bizsystemid", (Object)bizSystemId);
            controlBizReg.set("isentryfield", (Object)0);
            controlBizReg.set("fieldtable", (Object)fieldTable);
            if (StringUtils.isEmpty((CharSequence)fieldAlias)) {
                deleteList.add(controlBizReg);
                continue;
            }
            if (budgetControlPk == 0L) {
                addList.add(controlBizReg);
                continue;
            }
            updateList.add(controlBizReg);
        }
        try (TXHandle h = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(updateList)) {
                    SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(addList)) {
                    SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(deleteList)) {
                    QFilter idFilter = new QFilter("id", "in", deleteList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                    DeleteServiceHelper.delete((String)"pmbs_bgcontrolbizreg", (QFilter[])idFilter.toArray());
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void updateCondition() {
        Object formulaJsonValue = this.getModel().getValue("formulajson");
        Object controlTarget = this.getModel().getValue("controltarget");
        Object controlInitStatus = this.getModel().getValue("initstatus");
        TreeNode currentLefTreeNode = this.getCurrentLefTreeNode();
        if (currentLefTreeNode == null) {
            return;
        }
        DynamicObject structOfBill = BusinessDataServiceHelper.loadSingle((Object)currentLefTreeNode.getId(), (String)"pmbs_structofbill");
        structOfBill.set("formulajson", formulaJsonValue);
        structOfBill.set("controltarget", controlTarget);
        structOfBill.set("initstatus", controlInitStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{structOfBill});
    }

    private void updateBudgetField() {
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>(16);
        String ControlTarget = this.getModel().getDataEntity(true).getString("controltarget");
        DynamicObjectCollection budgetFieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry");
        StringBuilder errorMsgBuilder = new StringBuilder(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\uff1a", (String)"FieldRegisterList_23", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        StringBuilder budgetRegErrorBuilder = new StringBuilder();
        for (DynamicObject budgetFieldEntry : budgetFieldEntries) {
            boolean unSetting;
            DynamicObject controlBizReg = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_bgcontrolbizreg");
            BillFieldTypeEnum type = BillFieldTypeEnum.getEnumByNumber((String)budgetFieldEntry.getString("budgetcontroldimnum"));
            String fieldAlias = budgetFieldEntry.getString("sourcefieldnumber");
            String sourceFieldName = budgetFieldEntry.getString("sourcefieldname");
            String identify = budgetFieldEntry.getString("identify");
            String valueModel = budgetFieldEntry.getString("valuemodel");
            String fieldFormula = budgetFieldEntry.getString("fieldformula");
            String defaultValue = budgetFieldEntry.getString("defaultvalue");
            CRFormula formula = new CRFormula();
            if (!StringUtils.isEmpty((CharSequence)defaultValue)) {
                formula = (CRFormula)SerializationUtils.fromJsonString((String)defaultValue, CRFormula.class);
            }
            String defaultExpressionValue = formula.getExpression();
            boolean bl = unSetting = IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify) && StringUtils.isEmpty((CharSequence)fieldAlias) && StringUtils.isEmpty((CharSequence)defaultExpressionValue) || IdentifyValueEnum.FORMULA.getValue().equals(identify) && StringUtils.isEmpty((CharSequence)fieldFormula) && StringUtils.isEmpty((CharSequence)defaultExpressionValue) || IdentifyValueEnum.CONSTANT.getValue().equals(identify) && StringUtils.isEmpty((CharSequence)defaultExpressionValue);
            if ((StringUtils.equals((CharSequence)ControlTarget, (CharSequence)BudgetControlTargetEnum.BUDGETUSE.getValue()) || StringUtils.equals((CharSequence)ControlTarget, (CharSequence)BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue())) && StringUtils.equals((CharSequence)type.getNumber(), (CharSequence)BillFieldTypeEnum.PERIOD.getNumber()) && unSetting) {
                budgetRegErrorBuilder.append(type.getName());
                budgetRegErrorBuilder.append("\u3001");
                continue;
            }
            if (type.isNecessary() && unSetting) {
                budgetRegErrorBuilder.append(type.getName());
                budgetRegErrorBuilder.append("\u3001");
                continue;
            }
            long budgetControlPk = budgetFieldEntry.getLong("budgetcontrolpk");
            controlBizReg.set("id", (Object)budgetControlPk);
            controlBizReg.set("type", (Object)type.getNumber());
            controlBizReg.set("typename", (Object)type.getName());
            controlBizReg.set("fieldalias", (Object)fieldAlias);
            controlBizReg.set("number", (Object)fieldAlias);
            controlBizReg.set("name", (Object)new LocaleString(sourceFieldName));
            controlBizReg.set("isflex", (Object)false);
            controlBizReg.set("isprefab", (Object)"0");
            controlBizReg.set("isdefault", (Object)"0");
            controlBizReg.set("version", budgetFieldEntry.get("version"));
            DynamicObject application = budgetFieldEntry.getDynamicObject("application");
            DynamicObject bill = budgetFieldEntry.getDynamicObject("bill");
            String bizSystemAlias = application.getString("name");
            Long bizSystemId = application.getLong("id");
            String bizUnitAlias = bill.getString("name");
            Long bizUnitId = bill.getLong("id");
            String fieldTable = bill.getString("fieldtable");
            this.checkType(budgetFieldEntry, fieldTable);
            controlBizReg.set("bizunitalias", (Object)bizUnitAlias);
            controlBizReg.set("bizunitid", (Object)bizUnitId);
            controlBizReg.set("bizsystemalias", (Object)bizSystemAlias);
            controlBizReg.set("bizsystemid", (Object)bizSystemId);
            controlBizReg.set("fieldtable", (Object)fieldTable);
            controlBizReg.set("name", (Object)budgetFieldEntry.getString("sourcefieldname"));
            controlBizReg.set("isentryfield", (Object)budgetFieldEntry.getString("isentryfield"));
            DynamicObject budgetMapping = budgetFieldEntry.getDynamicObject("budgetmapping");
            controlBizReg.set("budgetmapping", (Object)(budgetMapping == null ? Long.valueOf(0L) : budgetMapping));
            controlBizReg.set("identify", (Object)identify);
            controlBizReg.set("fieldformula", (Object)fieldFormula);
            controlBizReg.set("defaultvalue", (Object)defaultValue);
            controlBizReg.set("valuemodel", (Object)valueModel);
            if (unSetting) {
                deleteList.add(controlBizReg);
                continue;
            }
            if (budgetControlPk == 0L) {
                addList.add(controlBizReg);
                continue;
            }
            updateList.add(controlBizReg);
        }
        if (StringUtils.isNotEmpty((CharSequence)budgetRegErrorBuilder.toString())) {
            budgetRegErrorBuilder.deleteCharAt(budgetRegErrorBuilder.length() - 1);
            errorMsgBuilder.append((CharSequence)budgetRegErrorBuilder);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u914d\u7f6e\u5bf9\u5e94\u5b57\u6bb5\u3002", (String)"FieldRegisterList_54", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), errorMsgBuilder));
        }
        try (TXHandle h = TX.required();){
            try {
                QFilter idFilter;
                if (!CollectionUtils.isEmpty(deleteList)) {
                    idFilter = new QFilter("id", "in", deleteList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                    DeleteServiceHelper.delete((String)"pmbs_bgcontrolbizreg", (QFilter[])idFilter.toArray());
                }
                if (!CollectionUtils.isEmpty(addList)) {
                    SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    idFilter = new QFilter("id", "in", updateList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                    DeleteServiceHelper.delete((String)"pmbs_bgcontrolbizreg", (QFilter[])idFilter.toArray());
                    SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    protected void checkType(DynamicObject budgetFieldEntry, String fieldTable) {
        DynamicObject budgetMapping;
        IDataEntityProperty property;
        BillFieldTypeEnum type = BillFieldTypeEnum.getEnumByNumber((String)budgetFieldEntry.getString("budgetcontroldimnum"));
        String fieldNumber = budgetFieldEntry.getString("sourcefieldnumber");
        if (StringUtils.isEmpty((CharSequence)fieldNumber)) {
            return;
        }
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)fieldTable).getProperties();
        if (!(type != BillFieldTypeEnum.BUDGET || (property = this.findProperty(properties, fieldNumber)) instanceof BasedataProp && StringUtils.equals((CharSequence)((BasedataProp)property).getBaseEntityId(), (CharSequence)"pmas_projectbudget") || (budgetMapping = budgetFieldEntry.getDynamicObject("budgetmapping")) != null)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u9884\u7b97\u9879\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662f\u9879\u76ee\u9884\u7b97\u9879\u65f6\uff0c\u9700\u586b\u5199\u9884\u7b97\u6620\u5c04\u7ef4\u5ea6\u3002", (String)"FieldRegisterList_25", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        if (!(type != BillFieldTypeEnum.PROJECT || (property = this.findProperty(properties, fieldNumber)) instanceof BasedataProp && StringUtils.equals((CharSequence)((BasedataProp)property).getBaseEntityId(), (CharSequence)"bd_project"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u9879\u76ee\u7ef4\u5ea6\u4e0d\u662f\u9879\u76ee\u53f7\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FieldRegisterList_26", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        if (type == BillFieldTypeEnum.CURRENCY && !((property = this.findProperty(properties, fieldNumber)) instanceof CurrencyProp)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u5e01\u522b\u7ef4\u5ea6\u4e0d\u662f\u5e01\u522b\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FieldRegisterList_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        if (type == BillFieldTypeEnum.AMOUNT && !((property = this.findProperty(properties, fieldNumber)) instanceof AmountProp)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u91d1\u989d\u7ef4\u5ea6\u4e0d\u662f\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FieldRegisterList_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
    }

    private IDataEntityProperty findProperty(DataEntityPropertyCollection properties, String fieldNumber) {
        if (StringUtils.isEmpty((CharSequence)fieldNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3010%s\u3011\u5b57\u6bb5\u3002", (String)"FieldRegisterList_27", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), fieldNumber));
        }
        String[] splits = fieldNumber.split("\\.");
        for (IDataEntityProperty billProperty : properties) {
            if (splits.length == 1 && StringUtils.equals((CharSequence)billProperty.getName(), (CharSequence)splits[0])) {
                return billProperty;
            }
            if (splits.length == 2 && StringUtils.equals((CharSequence)billProperty.getName(), (CharSequence)splits[0]) && billProperty instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)billProperty).getDynamicCollectionItemPropertyType().getProperties();
                return this.findProperty(entryProperties, splits[1]);
            }
            if (splits.length != 3 || !StringUtils.equals((CharSequence)billProperty.getName(), (CharSequence)splits[0]) || !(billProperty instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)billProperty).getDynamicCollectionItemPropertyType().getProperties();
            DataEntityPropertyCollection subEntryProperties = ((EntryProp)this.findProperty(entryProperties, splits[1])).getDynamicCollectionItemPropertyType().getProperties();
            return this.findProperty(subEntryProperties, splits[2]);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3010%s\u3011\u5b57\u6bb5\u3002", (String)"FieldRegisterList_27", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), fieldNumber));
    }

    protected Object getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        return nodeData.get(key) != null ? nodeData.get(key) : nodeData.get(key.toUpperCase());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object currentNodeId = evt.getNodeId();
        TreeNode currentLefTreeNode = this.getCurrentLefTreeNode();
        if (currentLefTreeNode == null) {
            return;
        }
        Map nodeData = (Map)currentLefTreeNode.getData();
        if (StringUtils.equals((CharSequence)((CharSequence)nodeData.get("billType")), (CharSequence)this.billType_bill)) {
            this.initRightTable(currentNodeId.toString());
            this.getView().getControl(BAR_SAVE);
        } else {
            this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry").clear();
            this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity").clear();
            this.getView().updateView("budgetcontrolentry");
            this.getView().updateView("budgetopentity");
        }
    }

    private void initRightTable(String treeNodeId) {
        ArrayList<String> filedList = new ArrayList<String>(6);
        filedList.add(BillFieldTypeEnum.PROJECT.getNumber());
        filedList.add(BillFieldTypeEnum.BUDGETTYPE.getNumber());
        filedList.add(BillFieldTypeEnum.BUDGET.getNumber());
        filedList.add(BillFieldTypeEnum.PERIOD.getNumber());
        filedList.add(BillFieldTypeEnum.CURRENCY.getNumber());
        filedList.add(BillFieldTypeEnum.AMOUNT.getNumber());
        QFilter fieldFilter = new QFilter("bizunitid", "=", (Object)Long.parseLong(treeNodeId));
        fieldFilter.and("type", "in", filedList);
        DynamicObject[] fieldRegData = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"", (QFilter[])fieldFilter.toArray());
        Object[] fieldObjects = Arrays.stream(fieldRegData).map(DataEntityBase::getPkValue).toArray();
        fieldRegData = BusinessDataServiceHelper.load((Object[])fieldObjects, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"));
        ArrayList<String> opList = new ArrayList<String>(6);
        opList.add(BillFieldTypeEnum.TAKE_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.EXEC_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.CLEAR_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.TAKEANDEXEC_OPERATION.getNumber());
        opList.add(BillFieldTypeEnum.RETURNANDCLEAR_OPERATION.getNumber());
        Long id = Long.parseLong(treeNodeId);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_structofbill"));
        QFilter opFilter = new QFilter("fieldtable", "=", (Object)bill.getString("number"));
        opFilter.and("type", "in", opList);
        opFilter.and("bizunitid", "=", (Object)id);
        DynamicObject[] opRegData = BusinessDataServiceHelper.load((String)"pmbs_bgcontrolbizreg", (String)"", (QFilter[])opFilter.toArray());
        Object[] opObjects = Arrays.stream(opRegData).map(DataEntityBase::getPkValue).toArray();
        opRegData = BusinessDataServiceHelper.load((Object[])opObjects, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_bgcontrolbizreg"));
        this.initCondition();
        this.initBudgetFieldTable(fieldRegData);
        this.initBudgetOperationTable(opRegData);
    }

    private void initCondition() {
        TreeNode currentLefTreeNode = this.getCurrentLefTreeNode();
        if (currentLefTreeNode == null) {
            return;
        }
        Object formulaJson = this.getNodeProperty("formulajson", currentLefTreeNode);
        this.receiveFormula(formulaJson.toString(), "formulatranslation");
        Object controlTarget = this.getNodeProperty("controltarget", currentLefTreeNode);
        Object initStatus = this.getNodeProperty("initstatus", currentLefTreeNode);
        this.getModel().setValue("controltarget", controlTarget);
        this.getModel().setValue("initstatus", initStatus);
        this.getView().updateView("controltarget");
        this.getView().updateView("initstatus");
    }

    private void initBudgetOperationTable(DynamicObject[] bdControlBizRegData) {
        DynamicObjectCollection bgOperationEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity");
        bgOperationEntries.clear();
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            return;
        }
        Map nodeData = (Map)currentNode.getData();
        String bizUnitId = (String)nodeData.get("id");
        String bizSystemId = currentNode.getParentid();
        DynamicObject application = BusinessDataServiceHelper.loadSingle((Object)bizSystemId, (String)"pmbs_structofbill");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)bizUnitId, (String)"pmbs_structofbill");
        block0: for (BillFieldTypeEnum billFieldTypeEnum : BillFieldTypeEnum.getEnumsByType((String)"operation")) {
            DynamicObject bgOperationEntry = bgOperationEntries.addNew();
            bgOperationEntry.set("budgetopaction", (Object)billFieldTypeEnum.getName());
            bgOperationEntry.set("budgetopactionnum", (Object)billFieldTypeEnum.getNumber());
            bgOperationEntry.set("opapplication", (Object)application);
            bgOperationEntry.set("opbill", (Object)bill);
            for (DynamicObject bdControlBizReg : bdControlBizRegData) {
                if (!StringUtils.equals((CharSequence)bdControlBizReg.getString("type"), (CharSequence)billFieldTypeEnum.getNumber())) continue;
                bgOperationEntry.set("budgetoppk", bdControlBizReg.getPkValue());
                bgOperationEntry.set("bizopname", (Object)bdControlBizReg.getString("name"));
                bgOperationEntry.set("bizopnumber", (Object)bdControlBizReg.getString("number"));
                continue block0;
            }
        }
        this.getView().updateView("budgetopentity");
    }

    private void initBudgetFieldTable(DynamicObject[] bdControlBizRegData) {
        DynamicObjectCollection bgFieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry");
        bgFieldEntries.clear();
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            return;
        }
        Map nodeData = (Map)currentNode.getData();
        String bizUnitId = (String)nodeData.get("id");
        String bizSystemId = currentNode.getParentid();
        DynamicObject application = BusinessDataServiceHelper.loadSingle((Object)bizSystemId, (String)"pmbs_structofbill");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)bizUnitId, (String)"pmbs_structofbill");
        String controlTarget = this.getModel().getDataEntity().getString("controltarget");
        for (BillFieldTypeEnum billFieldTypeEnum : BillFieldTypeEnum.getEnumsByType((String)"field")) {
            if (this.ignoreFieldType(billFieldTypeEnum)) continue;
            DynamicObject bgFieldEntry = bgFieldEntries.addNew();
            String billFieldTypeEnumName = billFieldTypeEnum.getName();
            if (billFieldTypeEnum.isNecessary()) {
                billFieldTypeEnumName = billFieldTypeEnum.getName() + "*";
            }
            if ((StringUtils.equals((CharSequence)controlTarget, (CharSequence)BudgetControlTargetEnum.BUDGETUSE.getValue()) || StringUtils.equals((CharSequence)controlTarget, (CharSequence)BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue())) && StringUtils.equals((CharSequence)billFieldTypeEnum.getNumber(), (CharSequence)BillFieldTypeEnum.PERIOD.getNumber())) {
                billFieldTypeEnumName = billFieldTypeEnum.getName() + "*";
            }
            bgFieldEntry.set("budgetcontroldimname", (Object)billFieldTypeEnumName);
            bgFieldEntry.set("budgetcontroldimnum", (Object)billFieldTypeEnum.getNumber());
            bgFieldEntry.set("application", (Object)application);
            bgFieldEntry.set("bill", (Object)bill);
            bgFieldEntry.set("version", (Object)BigDecimal.valueOf(2L));
            String defaultIdentify = IdentifyValueEnum.SOURCEBILLFIELD.getValue();
            if (billFieldTypeEnum.getNumber().equalsIgnoreCase(BillFieldTypeEnum.BUDGETTYPE.getNumber())) {
                defaultIdentify = IdentifyValueEnum.CONSTANT.getValue();
            }
            bgFieldEntry.set("identify", (Object)defaultIdentify);
            for (DynamicObject bdControlBizReg : bdControlBizRegData) {
                DynamicObject budgetItem;
                String name;
                String defaultValueJson;
                if (!StringUtils.equals((CharSequence)bdControlBizReg.getString("type"), (CharSequence)billFieldTypeEnum.getNumber())) continue;
                bgFieldEntry.set("budgetcontrolpk", bdControlBizReg.getPkValue());
                bgFieldEntry.set("sourcefieldname", (Object)bdControlBizReg.getString("name"));
                bgFieldEntry.set("sourcefieldnumber", (Object)bdControlBizReg.getString("number"));
                bgFieldEntry.set("budgetmapping", (Object)bdControlBizReg.getDynamicObject("budgetmapping"));
                bgFieldEntry.set("isentryfield", (Object)bdControlBizReg.getBoolean("isentryfield"));
                bgFieldEntry.set("version", (Object)bdControlBizReg.getBigDecimal("version"));
                bgFieldEntry.set("valuemodel", (Object)bdControlBizReg.getString("valuemodel"));
                String identity = bdControlBizReg.getString("identify");
                bgFieldEntry.set("identify", (Object)(StringUtils.isBlank((CharSequence)identity) ? IdentifyValueEnum.SOURCEBILLFIELD.getValue() : identity));
                String formulaJson = bdControlBizReg.getString("fieldformula");
                if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
                    CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
                    bgFieldEntry.set("fieldformula", (Object)formulaJson);
                    String exprTran = this.tranExpression(formula.getExpression(), "fieldformulatranslation");
                    bgFieldEntry.set("fieldformulatranslation", (Object)exprTran);
                }
                if (!StringUtils.isNotBlank((CharSequence)(defaultValueJson = bdControlBizReg.getString("defaultvalue")))) break;
                CRFormula defaultValueFormula = (CRFormula)SerializationUtils.fromJsonString((String)defaultValueJson, CRFormula.class);
                bgFieldEntry.set("defaultvalue", (Object)defaultValueJson);
                bgFieldEntry.set("defaultvaluetranslation", (Object)defaultValueFormula.getExprTran());
                String expression = defaultValueFormula.getExpression();
                if (expression == null) break;
                if ("IN".equals(expression)) {
                    bgFieldEntry.set("defaultvaluetranslation", (Object)ResManager.loadKDString((String)"\u6536\u5165", (String)"FieldRegisterList_56", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if ("OUT".equals(expression)) {
                    bgFieldEntry.set("defaultvaluetranslation", (Object)ResManager.loadKDString((String)"\u652f\u51fa", (String)"FieldRegisterList_55", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if ("CURRENCY".equals(billFieldTypeEnum.getNumber())) {
                    DynamicObject currency;
                    if (!QueryServiceHelper.exists((String)"bd_currency", (Object)Long.parseLong(expression)) || (currency = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(expression), (String)"bd_currency")) == null || !StringUtils.isNotEmpty((CharSequence)(name = ((OrmLocaleValue)currency.get("name")).getLocaleValue()))) break;
                    bgFieldEntry.set("defaultvaluetranslation", (Object)name);
                    break;
                }
                if (!"BUDGET".equals(billFieldTypeEnum.getNumber()) || !QueryServiceHelper.exists((String)"pmbs_budgetitem", (Object)Long.parseLong(expression)) || (budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(expression), (String)"pmbs_budgetitem")) == null || !StringUtils.isNotEmpty((CharSequence)(name = ((OrmLocaleValue)budgetItem.get("name")).getLocaleValue()))) break;
                bgFieldEntry.set("defaultvaluetranslation", (Object)name);
                break;
            }
            if (bdControlBizRegData.length <= 0 || bgFieldEntry.getBigDecimal("version") != null) continue;
            bgFieldEntry.set("version", (Object)BigDecimal.valueOf(0L));
        }
        this.getView().updateView("budgetcontrolentry");
    }

    protected boolean ignoreFieldType(BillFieldTypeEnum billFieldTypeEnum) {
        return Arrays.asList(BillFieldTypeEnum.BILL_NO, BillFieldTypeEnum.BILL_NAME, BillFieldTypeEnum.CREATOR, BillFieldTypeEnum.CREATE_TIME, BillFieldTypeEnum.AUDITOR, BillFieldTypeEnum.AUDIT_TIME, BillFieldTypeEnum.CONTRACT, BillFieldTypeEnum.ENTRYID).contains(billFieldTypeEnum);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnadd": {
                this.btnAdd();
                break;
            }
            case "btndelete": {
                TreeNode currentNode = this.getCurrentLefTreeNode();
                if (currentNode == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u8282\u70b9\u3002", (String)"FieldRegisterList_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u5355\u636e\u6ce8\u518c\u4fe1\u606f\uff1f", (String)"FieldRegisterList_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
                break;
            }
            case "sourcefieldname": {
                this.updateSourceFieldName();
                break;
            }
            case "bizopname": {
                this.updateBizOperation();
                break;
            }
            case "formulatranslation": {
                String formula = (String)this.getModel().getValue("formulajson");
                if (StringUtils.isBlank((CharSequence)formula)) {
                    CRFormula crFormula = new CRFormula();
                    formula = SerializationUtils.toJsonString((Object)crFormula);
                }
                MainEntityType sourceMainType = this.getSrcMainType();
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
                parameter.setIncludePKField(true);
                TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter, "formulatranslation");
                String billNodeJson = SerializationUtils.toJsonString((Object)billTreeNode);
                this.showFormulaForm(formula, sourceMainType.getName(), billNodeJson, "formulatranslation");
                break;
            }
            case "fieldformulatranslation": {
                String formula = (String)this.getModel().getValue("fieldformula");
                if (StringUtils.isBlank((CharSequence)formula)) {
                    CRFormula crFormula = new CRFormula();
                    formula = SerializationUtils.toJsonString((Object)crFormula);
                }
                MainEntityType sourceMainType = this.getSrcMainType();
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
                parameter.setIncludePKField(true);
                TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter, "fieldformulatranslation");
                String billNodeJson = SerializationUtils.toJsonString((Object)billTreeNode);
                this.showFormulaForm(formula, sourceMainType.getName(), billNodeJson, "fieldformulatranslation");
                break;
            }
            case "defaultvaluetranslation": {
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                Object value = this.getModel().getValue("budgetcontroldimnum", row);
                if (BillFieldTypeEnum.BUDGETTYPE.getNumber().equals(value.toString())) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("pmbs_budgettype");
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue_budgettype"));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                    break;
                }
                if (BillFieldTypeEnum.PROJECT.getNumber().equals(value.toString())) {
                    BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_project");
                    ListShowParameter para = ShowFormHelper.createShowListForm((String)dt.getName(), (boolean)false);
                    para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue_project"));
                    QFilter filter = new QFilter("enable", "=", (Object)"1");
                    para.getListFilterParameter().getQFilters().add(filter);
                    this.getView().showForm((FormShowParameter)para);
                    break;
                }
                if (BillFieldTypeEnum.BUDGET.getNumber().equals(value.toString())) {
                    BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_budgetitem");
                    ListShowParameter para = ShowFormHelper.createShowListForm((String)dt.getName(), (boolean)false);
                    para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue_budget"));
                    QFilter filter = new QFilter("enable", "=", (Object)"1");
                    para.getListFilterParameter().getQFilters().add(filter);
                    this.getView().showForm((FormShowParameter)para);
                    break;
                }
                if (BillFieldTypeEnum.PERIOD.getNumber().equals(value.toString())) {
                    BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_period");
                    ListShowParameter para = ShowFormHelper.createShowListForm((String)dt.getName(), (boolean)false);
                    para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue_period"));
                    this.getView().showForm((FormShowParameter)para);
                    break;
                }
                if (!BillFieldTypeEnum.CURRENCY.getNumber().equals(value.toString())) break;
                BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_currency");
                ListShowParameter para = ShowFormHelper.createShowListForm((String)dt.getName(), (boolean)false);
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue_currency"));
                this.getView().showForm((FormShowParameter)para);
                break;
            }
        }
    }

    public MainEntityType getSrcMainType() {
        TreeNode currentLefTreeNode = this.getCurrentLefTreeNode();
        String srcEntityNumber = (String)this.getNodeProperty("number", currentLefTreeNode);
        boolean isMeta = MetadataDao.checkNumber((String)srcEntityNumber);
        if (!isMeta) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%1$s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"FieldRegisterList_57", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), srcEntityNumber));
        }
        return EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = this.getFuncsXML(this, sourceCtrlKey);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public String getFuncsXML(AbstractFormPlugin plugin, String sourceCtrlKey) {
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        if (StringUtils.equals((CharSequence)"formulatranslation", (CharSequence)sourceCtrlKey)) {
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            List functionTypesList = cloudFunc.getFunctionTypes();
            if (!functionTypesList.isEmpty()) {
                Optional<FunctionType> first = functionTypesList.stream().filter(o -> StringUtils.equals((CharSequence)o.getId(), (CharSequence)"GetSrcEntityNumber")).findFirst();
                first.ifPresent(functionType -> functionTypes.getFunctionTypes().add(functionType));
            }
        }
        LoadFuncTypesEventArgs args = new LoadFuncTypesEventArgs(functionTypes);
        this.getRuleSetPlugInProxy().fireLoadFuncTypes(args);
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)args.getFuncTypes());
        plugin.getPageCache().put("functiontypes", funcsXML);
        return funcsXML;
    }

    public ConvertRuleSetPlugInProxy getRuleSetPlugInProxy() {
        String tgtEntityNumber;
        if (this.ruleSetPlugInProxy != null) {
            return this.ruleSetPlugInProxy;
        }
        BillEntityType srcMainType = null;
        BillEntityType tgtMainType = null;
        ArrayList plugins = new ArrayList();
        String srcEntityNumber = this.getSrcMainType().getName();
        if (StringUtils.isNotBlank((CharSequence)srcEntityNumber)) {
            srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            LinkSetElement srcLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)srcEntityNumber);
            if (srcLinkSet != null && srcLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(srcLinkSet.getConvRulePlugIns());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tgtEntityNumber = this.getSrcMainType().getName()))) {
            tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)tgtEntityNumber);
            LinkSetElement tgtLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)tgtEntityNumber);
            if (tgtLinkSet != null && tgtLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(tgtLinkSet.getConvRulePlugIns());
            }
        }
        this.ruleSetPlugInProxy = new ConvertRuleSetPlugInProxy(plugins);
        this.ruleSetPlugInProxy.setContext(srcMainType, tgtMainType);
        return this.ruleSetPlugInProxy;
    }

    private void updateBizOperation() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmbs_eventfield");
        TreeNode leftClickNode = this.getCurrentLefTreeNode();
        if (leftClickNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u8282\u70b9\u3002", (String)"FieldRegisterList_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> customs = new HashMap<String, String>(16);
        String bizSystemId = null;
        String bizUnitId = null;
        DynamicObject biz = this.billListUtil.queryFieldTableByID(Long.valueOf(leftClickNode.getId()));
        String billType = biz.getString("billtype");
        if (this.billType_application.equals(billType)) {
            bizSystemId = biz.getString("id");
        } else if (this.billType_bill.equals(billType)) {
            bizUnitId = biz.getString("id");
            bizSystemId = biz.getString("parent");
        }
        customs.put("application", bizSystemId);
        customs.put("bill", bizUnitId);
        customs.put(formtype, "operation");
        showParameter.setCustomParams(customs);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "operation");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u6ce8\u518c", (String)"FieldRegisterList_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private TreeNode getCurrentLefTreeNode() {
        TreeView treeView = (TreeView)this.getControl(treeviewap);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (nodeId != null) {
            TreeNode leftTree = this.getCacheLeftRoot();
            return leftTree.getTreeNode(nodeId, 10);
        }
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        if (leftNode == null) {
            return null;
        }
        return BillListUtil.getFirstBillNode((TreeNode)leftNode);
    }

    private void btnAdd() {
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u8282\u70b9\u3002", (String)"FieldRegisterList_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        } else {
            Map nodeData = (Map)currentNode.getData();
            if (nodeData.get("isFromOuter") == null || ((String)nodeData.get("isFromOuter")).equals("false")) {
                this.showAddInsideBillForm();
            }
        }
    }

    private boolean checkNodeIsBill(TreeNode node) {
        if (node != null && node.getData() != null) {
            Map nodeData = (Map)node.getData();
            String billType = (String)nodeData.get("billType");
            return billType != null && billType.equals(this.billType_bill);
        }
        return false;
    }

    private void showAddInsideBillForm() {
        ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"pmbs_addinsidebill", (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addInsideBill");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u63a7\u5236\u5355\u636e\u6ce8\u518c", (String)"FieldRegisterList_5", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("650");
        css.setWidth("1200");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        HashMap<String, String> customParams = new HashMap<String, String>(10);
        customParams.put("showExt", "false");
        customParams.put("showFormBillByMenuOrder", "false");
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void btnDelete() {
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u8282\u70b9\u3002", (String)"FieldRegisterList_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        } else {
            String currentNodeId = currentNode.getId();
            String billTreeType = this.getBillTypeOfNode(currentNode);
            List<String> deleteIds = new ArrayList<String>(16);
            if (this.billType_application.equals(billTreeType)) {
                deleteIds.add(currentNodeId);
                deleteIds = this.getBillIdByApplication(deleteIds);
                String parentId = currentNode.getParentid();
                TreeNode root = this.getCacheLeftRoot();
                TreeNode parentNode = root.getTreeNode(parentId, 4);
                if (parentNode != null && this.checkParentHaveOneChild(parentNode.getId(), currentNodeId) && !EventBillTreeTypeEnum.ROOT.getNumber().equals(this.getBillTypeOfNode(parentNode))) {
                    deleteIds.add(parentNode.getId());
                }
                deleteIds.add(currentNodeId);
            } else if (this.billType_bill.equals(billTreeType)) {
                String parentId;
                QFilter isPreFab;
                Object number = ((HashMap)currentNode.getData()).get("number");
                QFilter qFilter = new QFilter("bizunitid", "=", (Object)Long.parseLong(currentNodeId));
                DynamicObjectCollection fields = QueryServiceHelper.query((String)"pmbs_bgcontrolbizreg", (String)"id", (QFilter[])new QFilter[]{qFilter, isPreFab = new QFilter("isprefab", "=", (Object)"1")});
                if (!fields.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e3a\u9884\u5236\u6570\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"FieldRegisterList_48", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.ownUnitField(currentNodeId)) {
                    QFilter numberFilter = new QFilter("fieldtable", "=", number);
                    DeleteServiceHelper.delete((String)"pmbs_bgcontrolbizreg", (QFilter[])numberFilter.toArray());
                }
                if (this.checkParentHaveOneChild(parentId = currentNode.getParentid(), currentNodeId)) {
                    deleteIds.add(parentId);
                    TreeNode root = this.getCacheLeftRoot();
                    TreeNode parentNode = root.getTreeNode(parentId, 4);
                    TreeNode pParentNode = root.getTreeNode(parentNode.getParentid(), 4);
                    if (pParentNode != null && this.checkParentHaveOneChild(pParentNode.getId(), parentId) && !EventBillTreeTypeEnum.ROOT.getNumber().equals(this.getBillTypeOfNode(pParentNode))) {
                        deleteIds.add(pParentNode.getId());
                    }
                }
                deleteIds.add(currentNodeId);
            } else if (EventBillTreeTypeEnum.ROOT.getNumber().equals(billTreeType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"FieldRegisterList_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            } else if (this.billType_cloud.equals(billTreeType)) {
                List<String> applicationIds = this.getApplicationByCloud(currentNode.getId());
                if (this.checkCloudFields(applicationIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u4e0b\u5355\u636e\u62e5\u6709\u5b57\u6bb5\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"FieldRegisterList_11", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<String> billIds = this.getBillIdByApplication(applicationIds);
                applicationIds.add(currentNode.getId());
                applicationIds.addAll(billIds);
                deleteIds.addAll(applicationIds);
            }
            if (!deleteIds.isEmpty()) {
                try (TXHandle th = TX.required();){
                    try {
                        List collect = deleteIds.stream().map(Long::parseLong).collect(Collectors.toList());
                        DeleteServiceHelper.delete((String)"pmbs_structofbill", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FieldRegisterList_46", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                        this.initLeftTree(null);
                    }
                    catch (Exception e) {
                        th.markRollback();
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%s\u3002", (String)"FieldRegisterList_47", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), e.getMessage()));
                    }
                }
            }
        }
    }

    private boolean ownUnitField(String bizUnitId) {
        QFilter qFilter = new QFilter("bizunitid", "=", (Object)Long.parseLong(bizUnitId));
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"pmbs_bgcontrolbizreg", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return fields != null && !fields.isEmpty();
    }

    private String getBillTypeOfNode(TreeNode node) {
        String billType = null;
        Map nodeData = (Map)node.getData();
        if (nodeData != null) {
            billType = (String)nodeData.get("billType");
        }
        return billType;
    }

    private boolean checkParentHaveOneChild(String parentId, String childId) {
        ArrayList<String> childIds = new ArrayList<String>(16);
        QFilter parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkParentHaveOneChild", (String)"pmbs_structofbill", (String)"id", (QFilter[])new QFilter[]{parentFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                childIds.add(id);
                if (childIds.size() <= 2) continue;
                break;
            }
            dataSet.close();
            if (childIds.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (childIds.size() == 1 && childId.equals(childIds.get(0))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private List<String> getApplicationByCloud(String cloudId) {
        ArrayList<String> applicationIds = new ArrayList<String>(16);
        QFilter parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(cloudId));
        DataSet applications = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmbs_structofbill", (String)"id", (QFilter[])new QFilter[]{parentFilter}, null);
        while (applications.hasNext()) {
            Row row = applications.next();
            applicationIds.add(row.getString("id"));
        }
        applications.close();
        return applicationIds;
    }

    private List<String> getBillIdByApplication(List<String> applicationIds) {
        ArrayList<String> billIds = new ArrayList<String>(16);
        QFilter parentFilter = new QFilter("parent", "in", (Object)applicationIds.stream().map(Long::parseLong).toArray());
        DataSet bills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmbs_structofbill", (String)"id", (QFilter[])new QFilter[]{parentFilter}, null);
        while (bills.hasNext()) {
            Row row = bills.next();
            billIds.add(row.getString("id"));
        }
        bills.close();
        return billIds;
    }

    private boolean checkCloudFields(List<String> applicationIds) {
        if (!applicationIds.isEmpty()) {
            QFilter bizSystemIdFilter = new QFilter("bizsystemid", "in", (Object)applicationIds.stream().map(Long::parseLong).toArray());
            return QueryServiceHelper.exists((String)"pmbs_bgcontrolbizreg", (QFilter[])new QFilter[]{bizSystemIdFilter});
        }
        return false;
    }

    private void updateSourceFieldName() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmbs_eventfield");
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode != null && this.checkNodeIsBill(currentNode)) {
            HashMap<String, String> customs = new HashMap<String, String>(16);
            Map nodeData = (Map)currentNode.getData();
            String isFromOuter = (String)nodeData.get("isFromOuter");
            String bizUnitId = (String)nodeData.get("id");
            String bizSystemId = currentNode.getParentid();
            customs.put("application", bizSystemId);
            customs.put("bill", bizUnitId);
            customs.put("isFromOuter", isFromOuter);
            customs.put(formtype, "field");
            showParameter.setCustomParams(customs);
            CloseCallBack fieldCloseCallBack = new CloseCallBack((IFormPlugin)this, "field");
            showParameter.setCloseCallBack(fieldCloseCallBack);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5355\u636e\u3002", (String)"FieldRegisterList_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void barRefresh() {
        this.initLeftTree(null);
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)leftNode);
        if (firstNode == null) {
            return;
        }
        this.initRightTable(firstNode.getId());
        this.editRightTable(Boolean.FALSE);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "addInsideBill": {
                Object backData = closedCallBackEvent.getReturnData();
                if (backData != null && backData.getClass().equals(ListSelectedRowCollection.class)) {
                    this.addInsideBill((ListSelectedRowCollection)backData);
                }
                this.clickLeftTreeNode(this.getCurrentLefTreeNode());
                break;
            }
            case "field": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData != null && returnData.get("opennewpage") != null && ((Boolean)returnData.get("opennewpage")).booleanValue()) {
                    this.openNewPage(returnData);
                }
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("field");
                this.buildRightTable(returnData);
                break;
            }
            case "operation": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData != null && returnData.get("opennewpage") != null && ((Boolean)returnData.get("opennewpage")).booleanValue()) {
                    this.openNewPage(returnData);
                }
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("operation");
                this.buildRightTable(returnData);
                break;
            }
            case "formulatranslation": {
                this.receiveFormula(closedCallBackEvent.getReturnData(), actionId);
                break;
            }
            case "fieldformulatranslation": {
                this.receiveFormula(closedCallBackEvent.getReturnData(), actionId);
                break;
            }
            case "defaultvalue_budgettype": {
                Object backData = closedCallBackEvent.getReturnData();
                if (!(backData instanceof String)) break;
                String budgetType = backData.toString();
                CRFormula formula = new CRFormula();
                formula.setExpression(budgetType);
                if ("OUT".equals(backData.toString())) {
                    formula.setExprTran(ResManager.loadKDString((String)"\u652f\u51fa", (String)"FieldRegisterList_55", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                } else if ("IN".equals(backData.toString())) {
                    formula.setExprTran(ResManager.loadKDString((String)"\u6536\u5165", (String)"FieldRegisterList_56", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                }
                String json = SerializationUtils.toJsonString((Object)formula);
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                this.getModel().setValue("defaultvalue", (Object)json, row);
                if ("OUT".equals(backData.toString())) {
                    this.getModel().setValue("defaultvaluetranslation", (Object)ResManager.loadKDString((String)"\u652f\u51fa", (String)"FieldRegisterList_55", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), row);
                    break;
                }
                if (!"IN".equals(backData.toString())) break;
                this.getModel().setValue("defaultvaluetranslation", (Object)ResManager.loadKDString((String)"\u6536\u5165", (String)"FieldRegisterList_56", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), row);
                break;
            }
            case "defaultvalue_project": {
                Object backData = closedCallBackEvent.getReturnData();
                if (!(backData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection rData = (ListSelectedRowCollection)backData;
                if (StringUtils.isBlank((Object)backData) || rData.size() == 0) break;
                Long pkId = (Long)rData.get(0).getPrimaryKeyValue();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_project");
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dt);
                CRFormula formula = new CRFormula();
                formula.setExprTran(project.getString("name"));
                formula.setExpression(pkId.toString());
                String json = SerializationUtils.toJsonString((Object)formula);
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                this.getModel().setValue("defaultvalue", (Object)json, row);
                this.getModel().setValue("defaultvaluetranslation", (Object)formula.getExprTran(), row);
                break;
            }
            case "defaultvalue_budget": {
                Object backData = closedCallBackEvent.getReturnData();
                if (!(backData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection rData = (ListSelectedRowCollection)backData;
                if (StringUtils.isBlank((Object)backData) || rData.size() == 0) break;
                Long pkId = (Long)rData.get(0).getPrimaryKeyValue();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_budgetitem");
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dt);
                CRFormula formula = new CRFormula();
                formula.setExprTran(budget.getString("name"));
                formula.setExpression(pkId.toString());
                String json = SerializationUtils.toJsonString((Object)formula);
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                this.getModel().setValue("defaultvalue", (Object)json, row);
                this.getModel().setValue("defaultvaluetranslation", (Object)formula.getExprTran(), row);
                break;
            }
            case "defaultvalue_period": {
                Object backData = closedCallBackEvent.getReturnData();
                if (!(backData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection rData = (ListSelectedRowCollection)backData;
                if (StringUtils.isBlank((Object)backData) || rData.size() == 0) break;
                Long pkId = (Long)rData.get(0).getPrimaryKeyValue();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_period");
                DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dt);
                CRFormula formula = new CRFormula();
                formula.setExprTran(period.getString("name"));
                formula.setExpression(pkId.toString());
                String json = SerializationUtils.toJsonString((Object)formula);
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                this.getModel().setValue("defaultvalue", (Object)json, row);
                this.getModel().setValue("defaultvaluetranslation", (Object)formula.getExprTran(), row);
                break;
            }
            case "defaultvalue_currency": {
                Object backData = closedCallBackEvent.getReturnData();
                if (!(backData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection rData = (ListSelectedRowCollection)backData;
                if (StringUtils.isBlank((Object)backData) || rData.size() == 0) break;
                Long pkId = (Long)rData.get(0).getPrimaryKeyValue();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_currency");
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dt);
                CRFormula formula = new CRFormula();
                formula.setExprTran(currency.getString("name"));
                formula.setExpression(pkId.toString());
                String json = SerializationUtils.toJsonString((Object)formula);
                int row = this.getModel().getEntryCurrentRowIndex("budgetcontrolentry");
                this.getModel().setValue("defaultvalue", (Object)json, row);
                this.getModel().setValue("defaultvaluetranslation", (Object)formula.getExprTran(), row);
                break;
            }
        }
    }

    private void receiveFormula(Object formulaJson, String callbackKey) {
        if (StringUtils.isNotBlank((Object)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson.toString(), CRFormula.class);
            String conditionFormula = formula.getExpression();
            String conditionTran = this.tranExpression(conditionFormula, "formulatranslation");
            String conditionDesc = formula.getExprDesc();
            if ("formulatranslation".equalsIgnoreCase(callbackKey)) {
                this.getModel().setValue("formulajson", formulaJson);
                this.getModel().setValue("formulatranslation", (Object)conditionTran);
                this.getModel().setValue("conditiondesc", (Object)conditionDesc);
                this.getModel().setValue("conditionformula", (Object)conditionFormula);
            } else if ("fieldformulatranslation".equalsIgnoreCase(callbackKey)) {
                this.getModel().setValue("fieldformula", formulaJson);
                this.getModel().setValue("fieldformulatranslation", (Object)conditionDesc);
            }
        } else {
            this.getModel().setValue("formulajson", null);
            this.getModel().setValue("formulatranslation", null);
            this.getModel().setValue("conditiondesc", null);
            this.getModel().setValue("conditionformula", null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            switch (e.getCallBackId()) {
                case "btndelete": {
                    this.deleteOpBizRuleSet();
                    this.btnDelete();
                    this.clickLeftTreeNode(this.getCurrentLefTreeNode());
                    break;
                }
            }
        }
    }

    private void addInsideBill(ListSelectedRowCollection rowDatas) {
        ArrayList<String> returnBillNums = new ArrayList<String>(16);
        for (ListSelectedRow row : rowDatas) {
            String number = String.valueOf(row.getNumber());
            log.info("\u5f53\u524d\u6ce8\u518c\u5355\u636e\u6807\u8bc6\u4e3a: {}", (Object)number);
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
            if (entityMeta == null || entityMeta.getDevType().equals("2")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u539f\u5355\u8fdb\u884c\u6ce8\u518c\u3002", (String)"FieldRegisterList_49", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
            returnBillNums.add(number);
        }
        if (!returnBillNums.isEmpty()) {
            new OuterBillRegisterService().dealOuterBill(returnBillNums, this.getPageCache().get("INSIDE_NODE_ID"));
            this.initLeftTree(null);
        }
    }

    private void append2DB(String insideNodeId, DynamicObjectCollection appInfos, Map<String, String> app2Cloud, Set<String> numbers) {
        String appNumber;
        HashSet<String> strings1 = new HashSet<String>(16);
        strings1.addAll(app2Cloud.values());
        strings1.removeAll(numbers);
        if (!strings1.isEmpty()) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(strings1.size());
            for (DynamicObject appInfo : appInfos) {
                String cloudNumber = appInfo.getString("bizcloud.number");
                if (strings1.remove(cloudNumber)) {
                    appNumber = appInfo.getString("bizcloud.name");
                    DynamicObject node = this.createNode(appNumber, cloudNumber, insideNodeId, null, null, this.billType_cloud, false);
                    dynamicObjects.add(node);
                }
                if (!strings1.isEmpty()) continue;
                break;
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
        HashSet<String> appNumberSet = new HashSet<String>(16);
        appNumberSet.addAll(app2Cloud.keySet());
        appNumberSet.removeAll(numbers);
        if (!appNumberSet.isEmpty()) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(appNumberSet.size());
            for (DynamicObject appInfo : appInfos) {
                appNumber = appInfo.getString("number");
                if (appNumberSet.contains(appNumber)) {
                    String appName = appInfo.getString("name");
                    String cloudNumber = appInfo.getString("bizcloud.number");
                    QFilter qFilter = new QFilter("number", "=", (Object)cloudNumber);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmbs_structofbill", (String)"id,number", (QFilter[])qFilter.toArray());
                    DynamicObject node = this.createNode(appName, appNumber, dynamicObject.getString("id"), null, null, this.billType_bill, false);
                    dynamicObjects.add(node);
                    appNumberSet.remove(cloudNumber);
                }
                if (!appNumberSet.isEmpty()) continue;
                break;
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    private void openNewPage(Map<String, Object> returnData) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmbs_eventfield");
        showParameter.setCustomParams(returnData);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, (String)returnData.get(formtype));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void initLeftTree(TreeNode curNode) {
        TreeView treeLeft = (TreeView)this.getView().getControl(treeviewap);
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)leftNode);
        this.cacheTopNodeId(leftNode);
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(leftNode);
        this.cacheLeftRoot(leftNode);
        treeLeft.addNode(leftNode);
        if (curNode != null) {
            treeLeft.focusNode(curNode);
        } else if (firstNode != null) {
            treeLeft.focusNode(firstNode);
        }
        this.spreadAllNode(leftNode);
    }

    private void spreadAllNode(TreeNode treenode) {
        if (treenode != null) {
            treenode.setIsOpened(true);
            if (null != treenode.getChildren()) {
                List nodes = treenode.getChildren();
                for (TreeNode t : nodes) {
                    this.spreadAllNode(t);
                }
            }
        }
    }

    private void cacheTopNodeId(TreeNode leftNode) {
        if (leftNode.getChildren() != null) {
            leftNode.getChildren().forEach(node -> {
                Map data = (Map)node.getData();
                if (data.get("number") != null && ((String)data.get("number")).equals("INSIDE_NODE")) {
                    this.getPageCache().put("INSIDE_NODE_ID", node.getId());
                } else if (data.get("number") != null && ((String)data.get("number")).equals("OUTER_NODE")) {
                    this.getPageCache().put("OUTER_NODE_ID", node.getId());
                }
            });
        }
    }

    private void buildRightTable(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        Object formType = returnData.get(formtype);
        if (StringUtils.equals((CharSequence)formType.toString(), (CharSequence)"operation")) {
            this.buildBudgetOperationTable(returnData);
        } else {
            this.buildBudgetFieldTable(returnData);
        }
    }

    private void buildBudgetOperationTable(Map<String, Object> returnData) {
        Object name = returnData.get("name");
        Object longNumber = returnData.get("longnumber");
        Object applicationString = returnData.get("application");
        Object billString = returnData.get("bill");
        EntryGrid budgetOperationEntryGrid = (EntryGrid)this.getView().getControl("budgetopentity");
        int[] selectRows = budgetOperationEntryGrid.getSelectRows();
        DynamicObjectCollection budgetOperationEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetopentity");
        DynamicObject currentEntry = (DynamicObject)budgetOperationEntries.get(selectRows[0]);
        DynamicObject application = BusinessDataServiceHelper.loadSingle((Object)applicationString, (String)"pmbs_structofbill");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billString, (String)"pmbs_structofbill");
        currentEntry.set("bizopname", name);
        currentEntry.set("bizopnumber", longNumber);
        currentEntry.set("opapplication", (Object)application);
        currentEntry.set("opbill", (Object)bill);
        this.getView().updateView("budgetopentity");
    }

    private void buildBudgetFieldTable(Map<String, Object> returnData) {
        Object name = returnData.get("name");
        Object longNumber = returnData.get("longnumber");
        Object applicationString = returnData.get("application");
        Object billString = returnData.get("bill");
        EntryGrid budgetFieldEntryGrid = (EntryGrid)this.getView().getControl("budgetcontrolentry");
        int[] selectRows = budgetFieldEntryGrid.getSelectRows();
        DynamicObjectCollection budgetFieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("budgetcontrolentry");
        DynamicObject currentEntry = (DynamicObject)budgetFieldEntries.get(selectRows[0]);
        currentEntry.set("sourcefieldname", name);
        currentEntry.set("sourcefieldnumber", longNumber);
        DynamicObject application = BusinessDataServiceHelper.loadSingle((Object)applicationString, (String)"pmbs_structofbill");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billString, (String)"pmbs_structofbill");
        currentEntry.set("application", (Object)application);
        currentEntry.set("bill", (Object)bill);
        currentEntry.set("isentryfield", returnData.get("isentryfield"));
        this.getView().updateView("budgetcontrolentry");
        this.editRightTable(Boolean.TRUE);
    }

    private QFilter getBillListQFilter(String type) {
        TreeNode cacheLeftClickTree = this.getCurrentLefTreeNode();
        if (cacheLeftClickTree != null) {
            List names = BillFieldTypeEnum.getFieldNameByType((String)type);
            QFilter qFilter = new QFilter("bill.id", "=", (Object)Long.parseLong(cacheLeftClickTree.getId()));
            qFilter.and("fielddimension", "in", (Object)names);
            return qFilter;
        }
        return new QFilter("1", "=", (Object)2);
    }

    protected TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(leftTree))) {
            return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(leftTree), TreeNode.class);
        }
        return null;
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(leftTree, SerializationUtils.toJsonString((Object)rootleft));
    }

    private DynamicObject createNode(String name, String number, String parentId, String longNumber, String longName, String billType, boolean isFromOter) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject structOfBill = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_structofbill");
        structOfBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
        structOfBill.set("name", (Object)new LocaleString(name));
        structOfBill.set("number", (Object)number);
        structOfBill.set("creator", (Object)userId);
        Date createTime = new Date();
        structOfBill.set("createtime", (Object)createTime);
        structOfBill.set("enable", (Object)EnableEnum.ENABLE.getValue());
        structOfBill.set("status", (Object)StatusEnum.CHECKED.getValue());
        structOfBill.set("modifytime", (Object)createTime);
        structOfBill.set("isleaf", (Object)0);
        structOfBill.set("longnumber", (Object)longNumber);
        structOfBill.set("billtype", (Object)billType);
        structOfBill.set("parent", (Object)parentId);
        structOfBill.set("isfromouter", (Object)isFromOter);
        structOfBill.set("fullname", (Object)longName);
        if (billType != null && billType.equals(this.billType_bill)) {
            structOfBill.set("fieldtable", (Object)number);
            structOfBill.set("isleaf", (Object)1);
        }
        return structOfBill;
    }

    protected String tranExpression(String expression, String TreeNodeSourceStr) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        MainEntityType sourceMainType = this.getSrcMainType();
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
        parameter.setIncludePKField(true);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter, TreeNodeSourceStr);
        ArrayList orderVars = new ArrayList(10);
        Collections.addAll(orderVars, vars);
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = billTreeNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }
}

