/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class InsideBillInputPlugin
extends StandardTreeListPlugin
implements FilterContainerInitListener,
SearchClickListener {
    public static final String SHOW_FORM_BILL_BY_MENU_ORDER = "showFormBillByMenuOrder";
    public static final String SHOW_EXT = "showExt";

    public void initialize() {
        super.initialize();
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        container.setEntityId("bos_formmeta");
        container.addFilterContainerInitListener((FilterContainerInitListener)this);
        container.addClickListener((ClickListener)this);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.addCloudAppNode(this.getTreeModel().getRoot());
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        FilterColumn filterColumn = new FilterColumn();
        filterColumn.setFieldName("number");
        filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"InsideBillInputPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])));
        filterContainerInitEvent.getFastFilterColumns().add(filterColumn);
        filterColumn = new FilterColumn();
        filterColumn.setFieldName("name");
        filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"InsideBillInputPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0])));
        filterContainerInitEvent.getFastFilterColumns().add(filterColumn);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (CollectionUtils.isEmpty((Collection)evt.getListSelectedRowCollection())) {
            this.getTreeListView().focusRootNode();
            return;
        }
        Object primaryKeyValue = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bos_formmeta");
        Map allAppMenus = AppMetadataCache.getAllAppMenus();
        String bizAppId = null;
        for (Map.Entry entry : allAppMenus.entrySet()) {
            List appMenuInfos = (List)entry.getValue();
            boolean contain = appMenuInfos.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getFormId())).anyMatch(it -> it.getFormId().equals(entity.getString("number")));
            if (!contain) continue;
            bizAppId = (String)entry.getKey();
            break;
        }
        if (StringUtils.isEmpty(bizAppId)) {
            DynamicObject app = apps.stream().filter(it -> it.getString("id").equals(entity.getString("bizappid"))).findFirst().orElse(null);
            String string = bizAppId = app != null ? app.getString("number") : null;
        }
        if (StringUtils.isEmpty(bizAppId)) {
            return;
        }
        String finalBizAppId = bizAppId;
        DynamicObject app = apps.stream().filter(it -> it.getString("number").equals(finalBizAppId)).findFirst().orElse(null);
        List treeNodeChildren = this.getTreeModel().getRoot().getChildren();
        if (app == null) {
            this.getTreeListView().focusRootNode();
            return;
        }
        TreeNode treeNode = null;
        for (TreeNode treeNodeChild : treeNodeChildren) {
            for (TreeNode child : treeNodeChild.getChildren()) {
                if (child == null || !child.getId().equals(app.getString("id"))) continue;
                treeNode = child;
                break;
            }
            if (treeNode == null) continue;
            break;
        }
        if (treeNode != null) {
            this.getTreeListView().getTreeView().focusNode(treeNode);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        Object showFormBillByMenuOrder = this.getView().getFormShowParameter().getCustomParam(SHOW_FORM_BILL_BY_MENU_ORDER);
        Object showExt = this.getView().getFormShowParameter().getCustomParam(SHOW_EXT);
        if ("false".equals(showExt)) {
            e.getQFilters().add(new QFilter("type", "!=", (Object)"2"));
        }
        if ("true".equals(showFormBillByMenuOrder)) {
            QFilter bizAppIdFilter = e.getQFilters().stream().filter(it -> it.getProperty().equals("bizappid")).findFirst().orElse(null);
            ArrayList<String> bizAppIds = new ArrayList<String>();
            if (bizAppIdFilter != null) {
                if (bizAppIdFilter.getCP().equals("=")) {
                    bizAppIds.add((String)bizAppIdFilter.getValue());
                }
                if (bizAppIdFilter.getCP().equals("in")) {
                    bizAppIds.addAll((Collection)bizAppIdFilter.getValue());
                }
                e.getQFilters().remove(bizAppIdFilter);
            }
            Map allAppMenus = AppMetadataCache.getAllAppMenus();
            DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
            List filterAppNums = apps.stream().filter(it -> bizAppIds.contains(it.getString("id"))).map(it -> it.getString("number")).collect(Collectors.toList());
            HashSet appMenuNum = new HashSet();
            if (CollectionUtils.isNotEmpty(filterAppNums)) {
                for (Map.Entry entry : allAppMenus.entrySet()) {
                    if (!filterAppNums.contains(entry.getKey())) continue;
                    appMenuNum.addAll(((List)entry.getValue()).stream().map(AppMenuInfo::getFormId).collect(Collectors.toSet()));
                }
            }
            if (!this.getTreeModel().getRoot().getId().equals(this.getTreeModel().getCurrentNodeId())) {
                e.getQFilters().add(new QFilter("number", "in", appMenuNum));
            }
            DynamicObject[] entityMeta = BusinessDataServiceHelper.load((String)"bos_entitymeta", (String)"id", (QFilter[])new QFilter[0]);
            e.getQFilters().add(new QFilter("number", "in", Arrays.stream(entityMeta).map(it -> it.getString("number")).collect(Collectors.toSet())));
        }
    }

    public void addCloudAppNode(TreeNode root) {
        TreeNode childNode = null;
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        Object showExt = this.getView().getFormShowParameter().getCustomParam(SHOW_EXT);
        QFilter formTypeQfilter = this.getFormTypeQfilter();
        if ("false".equals(showExt)) {
            QFilter typeFilter = new QFilter("type", "!=", (Object)"2");
            formTypeQfilter.and(typeFilter);
        }
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
        if (!clouds.isEmpty()) {
            String rootId = root.getId();
            for (DynamicObject cloud : clouds) {
                String id = cloud.getString("id");
                String name = cloud.getString("name") + String.format("(%s)", cloud.getString("number"));
                childNode = new TreeNode();
                childNode.setText(name);
                childNode.setId(id);
                childNode.setParentid(rootId);
                childNode.setData((Object)EventBillTreeTypeEnum.CLOUD.getNumber());
                cloudNodes.put(id, childNode);
            }
            if (!apps.isEmpty()) {
                TreeNode parentNode = null;
                for (DynamicObject app : apps) {
                    if ("false".equals(showExt) && app.getString("type").equals("2")) continue;
                    String id = app.getString("id");
                    String name = app.getString("name") + String.format("(%s)", app.getString("number"));
                    String parentId = app.getString("bizcloud");
                    parentNode = (TreeNode)cloudNodes.get(parentId);
                    if (parentNode == null) continue;
                    childNode = new TreeNode();
                    childNode.setText(name);
                    childNode.setId(id);
                    childNode.setParentid(parentId);
                    childNode.setData((Object)EventBillTreeTypeEnum.APPLICATION.getNumber());
                    parentNode.addChild(childNode);
                }
            }
            root.addChildren(new ArrayList(cloudNodes.values()));
            this.removeNullCloudNode(root);
            root.setData((Object)EventBillTreeTypeEnum.ALL.getNumber());
        }
    }

    public void removeNullCloudNode(TreeNode root) {
        List children = root.getChildren();
        if (children != null) {
            Iterator iterator = children.iterator();
            TreeNode treeNode = null;
            while (iterator.hasNext()) {
                treeNode = (TreeNode)iterator.next();
                if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    protected QFilter nodeClickFilter() {
        QFilter qf = null;
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        String currentId = String.valueOf(treeModel.getCurrentNodeId());
        if (!currentId.equals("null")) {
            TreeNode root = treeModel.getRoot();
            TreeNode currentNode = root.getTreeNode(currentId, 3);
            String nodeType = String.valueOf(currentNode.getData());
            if (nodeType.equals(EventBillTreeTypeEnum.ALL.getNumber())) {
                qf = new QFilter("id", "!=", (Object)"1");
            } else if (nodeType.equals(EventBillTreeTypeEnum.CLOUD.getNumber())) {
                List children = currentNode.getChildren();
                ArrayList<String> appIds = new ArrayList<String>(16);
                if (children != null) {
                    for (TreeNode child : children) {
                        String appId = child.getId();
                        appIds.add(appId);
                    }
                }
                qf = new QFilter("bizappid", "in", appIds);
            } else if (nodeType.equals(EventBillTreeTypeEnum.APPLICATION.getNumber())) {
                qf = new QFilter("bizappid", "=", (Object)currentId);
            }
        }
        return qf;
    }

    public QFilter getFormTypeQfilter() {
        return new QFilter("modeltype", "=", (Object)"BillFormModel");
    }

    public void click(SearchClickEvent searchClickEvent) {
    }
}

