/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.invoicecloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.business.helper.InvoiceImportHelper;
import kd.pmgt.pmbs.business.helper.MetaDataParseServiceHelper;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceVO;
import kd.pmgt.pmbs.common.enums.InvoiceInterfaceEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.InvoiceCloudConfigHelper;

public abstract class AbstractImportInvoicePlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(AbstractImportInvoicePlugin.class);
    private static final String INVOICECLOUD_CONTAINER = "pmbs_invoicecloudpage";
    private static final String InterfaceVO = "invoiceinterface";
    private static final String EntityId = "entityid";
    private static final String BillId = "billid";
    private static final String BillNo = "billno";
    private static final String CompanyId = "companyid";
    private static final String InvoiceSellerParam = "invoicesellerparam";
    private static final String conImportInvoice_op = "conimportInvoice";
    private static final String payImportInvoice_op = "payimportInvoice";
    private static final String Invoice_Data = "invoiceData";
    private static final String Invoice_error = "errorSerialNos";

    protected void showSelectedInvoicePage() {
        String companyId;
        String billNo;
        String billId;
        String formId = this.getPageCache().get("curformid");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = this.getView().getEntityId();
        }
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract")) {
            billId = this.getPageCache().get(BillId);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmct_outcontract");
            billNo = contract.getString(BillNo);
            companyId = contract.getDynamicObject("fiaccountorg").getPkValue().toString();
        } else {
            companyId = this.getCostCompanyDO().getPkValue().toString();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            billNo = dataEntity.getString(BillNo);
            billId = dataEntity.getPkValue().toString();
        }
        this.getPageCache().put(EntityId, formId);
        this.getPageCache().put(BillId, billId);
        this.getPageCache().put(BillNo, billNo);
        this.getPageCache().put(CompanyId, companyId);
        if (StringUtils.isNotBlank((CharSequence)companyId)) {
            this.getPageCache().put(InvoiceSellerParam, ContractHelper.getInvoiceSellerParam());
            String invoiceInterface = SystemParamHelper.getSystemParameter((String)InterfaceVO, (String)"pmct", (Long)Long.parseLong(companyId)).toString();
            this.getPageCache().put(InterfaceVO, invoiceInterface);
            if (InvoiceInterfaceEnum.AWS.getValue().equals(invoiceInterface)) {
                this.openAWSInvoicePage();
            } else {
                this.openInvoiceCloudPage();
            }
        }
    }

    private void openAWSInvoicePage() {
        HashMap<String, String> data = new HashMap<String, String>(10);
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(BillNo))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5355\u636e\u7f16\u53f7\u201d\u3002", (String)"AbstractImportInvoicePlugin_35", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        data.put("formId", INVOICECLOUD_CONTAINER);
        data.put("billNo", this.getPageCache().get(BillNo));
        data.put("billId", this.getPageCache().get(BillId));
        data.put("companyId", this.getPageCache().get(CompanyId));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(data);
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("968px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getCloseCallBackKey()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(data);
        this.getView().showForm(showParameter);
    }

    private void openInvoiceCloudPage() {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("billType", this.getPageCache().get(EntityId));
        customParams.put("billNo", this.getPageCache().get(BillNo));
        customParams.put("billId", this.getPageCache().get(BillId));
        customParams.put("entityId", this.getPageCache().get(EntityId));
        customParams.put("viewPage", this.getView().getPageId());
        String orgId = this.getPageCache().get(CompanyId);
        if (StringUtils.isNotBlank((CharSequence)orgId) && QueryServiceHelper.exists((String)"bos_org", (Object)orgId)) {
            customParams.put("orgId", orgId);
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            if (org != null) {
                List companyInfo = InvoiceCloudConfigHelper.getConfigByInvoiceCloud((DynamicObject)org);
                customParams.put("companyInfo", companyInfo);
            }
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_fpzs_main");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_main");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AbstractImportInvoicePlugin_14", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put(CompanyId, this.getPageCache().get(CompanyId));
        paramsMap.put("returnData", returnData);
        paramsMap.put(InterfaceVO, this.getPageCache().get(InterfaceVO));
        List invoiceVOS = new InvoiceImportHelper().analysisInvoiceData(paramsMap);
        this.processInvoiceVO(invoiceVOS);
    }

    public void processInvoiceVO(List<InvoiceVO> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String formId = this.getPageCache().get("curformid");
        List invoiceVOS = new InvoiceImportHelper().checkInvoice(list, this.getView());
        this.getPageCache().put(Invoice_Data, JSON.toJSONString((Object)invoiceVOS));
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract")) {
            this.checkInvoiceSeller(invoiceVOS);
        } else {
            this.handleDownStrBus(list);
        }
    }

    protected void checkInvoiceSeller(List<InvoiceVO> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String invoiceSellerParam = this.getPageCache().get(InvoiceSellerParam);
        if (StringUtils.isNotBlank((CharSequence)invoiceSellerParam) && !invoiceSellerParam.equals(InvoiceSellerParamEnum.UNCTRL.getValue())) {
            HashSet supplierSet = new HashSet(16);
            HashSet supplierTaxNoSet = new HashSet(16);
            HashSet noTexNoSupplier = new HashSet(16);
            String billId = this.getPageCache().get(BillId);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmct_outcontract");
            if (contract != null) {
                QFilter qFilter;
                DynamicObject[] suppliers;
                DynamicObjectCollection otherParts;
                HashSet<Long> supplierIds = new HashSet<Long>(16);
                supplierIds.add(Long.parseLong(contract.getDynamicObject("partb").getPkValue().toString()));
                if (contract.getBoolean("ismulticontract") && (otherParts = contract.getDynamicObjectCollection("otherpart")).size() > 0) {
                    supplierIds.addAll(otherParts.stream().map(other -> other.getLong("fbasedataid_id")).collect(Collectors.toSet()));
                }
                if (supplierIds.size() > 0 && (suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name,tx_register_no", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "in", (Object)supplierIds.toArray())})).length > 0) {
                    Arrays.stream(suppliers).forEach(supplier -> {
                        supplierSet.add(supplier.getString("name"));
                        if (StringUtils.isBlank((CharSequence)supplier.getString("tx_register_no"))) {
                            noTexNoSupplier.add(supplier.getString("name"));
                        }
                        supplierTaxNoSet.add(supplier.getString("tx_register_no"));
                    });
                }
            }
            StringBuffer errorTip = new StringBuffer();
            if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam) || InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                if (!noTexNoSupplier.isEmpty()) {
                    String noTexNoSupplierStr = ((Object)noTexNoSupplier).toString().replace("[", " ").replace("]", " ");
                    errorTip.append(String.format(ResManager.loadKDStringExt((String)"\u5408\u540c\u4e59\u65b9\u6216\u5176\u4ed6\u65b9\uff1a%1$s\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u4e3b\u6570\u636e-\u4f9b\u5e94\u5546\u4e2d\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"AbstractImportInvoicePlugin_32", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), noTexNoSupplierStr));
                }
                if (contract != null && contract.getDynamicObject("org") != null) {
                    for (InvoiceVO invoice : list) {
                        this.checkBizPartner(errorTip, invoice, contract.getDynamicObject("org"));
                    }
                }
                if (!errorTip.toString().isEmpty()) {
                    this.getView().showErrorNotification(errorTip.toString());
                    List invoiceSerials = list.stream().map(InvoiceVO::getSerialNo).collect(Collectors.toList());
                    JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{invoiceSerials});
                    if (!"0000".equals(result.getString("errcode"))) {
                        log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
                    }
                    return;
                }
            }
            errorTip = new StringBuffer();
            ArrayList<String> errorSerialNos = new ArrayList<String>(16);
            ArrayList<String> delInvoices = new ArrayList<String>(16);
            Iterator<InvoiceVO> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (contract == null || contract.getDynamicObject("org") == null) continue;
                InvoiceVO invoice = iterator.next();
                DynamicObject supplier2 = this.checkBizPartner(new StringBuffer(), invoice, contract.getDynamicObject("org"));
                String supplierName = supplier2.getString("name");
                String tx_register_no = supplier2.getString("tx_register_no");
                if (!supplierSet.contains(supplierName) || !supplierTaxNoSet.contains(tx_register_no)) {
                    errorTip.append(String.format(ResManager.loadKDString((String)"\u5408\u540c\u4e59\u65b9\u6216\u5176\u4ed6\u65b9\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u7684\u9500\u552e\u65b9\u7684\u540d\u79f0\u6216\u7eb3\u7a0e\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_28", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoice.getInvoiceCode(), invoice.getInvoiceNo()));
                }
                if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                    if (!StringUtils.isNotBlank((CharSequence)errorTip)) continue;
                    delInvoices.add(invoice.getSerialNo());
                    iterator.remove();
                    continue;
                }
                if (!InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam) || !StringUtils.isNotBlank((CharSequence)errorTip)) continue;
                errorSerialNos.add(invoice.getSerialNo());
            }
            if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                if (delInvoices.size() > 0 && !errorTip.toString().isEmpty()) {
                    this.getView().showErrorNotification(errorTip.toString());
                    JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{delInvoices});
                    if (!"0000".equals(result.getString(""))) {
                        log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
                    }
                }
                this.handleDownStrBus(list);
            } else if (InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                if (errorSerialNos.size() > 0 && !errorTip.toString().isEmpty()) {
                    String serialNosJson = JSON.toJSONString(errorSerialNos);
                    this.getPageCache().put(Invoice_error, serialNosJson);
                    errorTip.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractImportInvoicePlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(errorTip.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(conImportInvoice_op, (IFormPlugin)this));
                } else {
                    this.handleDownStrBus(list);
                }
            }
        } else {
            this.handleDownStrBus(list);
        }
    }

    protected DynamicObject checkBizPartner(StringBuffer errorTip, InvoiceVO invoice, DynamicObject org) {
        DynamicObject supplier = null;
        String sellerName = invoice.getSalerName();
        String sellerTaxNo = invoice.getSalerTaxNo();
        QFilter qFilter = new QFilter("name", "=", (Object)sellerName);
        qFilter.and("tx_register_no", "=", (Object)sellerTaxNo);
        DynamicObject[] bizPartners = BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (bizPartners.length == 0) {
            if (!errorTip.toString().isEmpty()) {
                errorTip.append("\r\n");
            }
            errorTip.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a[%1$s],\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a[%2$s]\u7684\u5546\u52a1\u4f19\u4f34\uff0c\u8bf7\u5728\u4e3b\u6570\u636e-\u5546\u52a1\u4f19\u4f34\u4e2d\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\u3002", (String)"AbstractImportInvoicePlugin_33", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), sellerName, sellerTaxNo));
        } else {
            DynamicObject[] suppliers = ContractHelper.getSuppliers((Object)bizPartners[0].getPkValue(), (Long)Long.parseLong(org.getPkValue().toString()));
            if (suppliers != null && suppliers.length > 0) {
                supplier = suppliers[0];
            } else {
                if (!errorTip.toString().isEmpty()) {
                    errorTip.append("\r\n");
                }
                errorTip.append(String.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a[%1$s],\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a[%2$s]\u7684\u5546\u52a1\u4f19\u4f34\u4e0d\u5b58\u5728\u521b\u5efa\u7ec4\u7ec7[%3$s]\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u5728\u4e3b\u6570\u636e-\u5546\u52a1\u4f19\u4f34\u4e2d\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\u3002", (String)"AbstractImportInvoicePlugin_34", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), sellerName, sellerTaxNo, org.getString("name")));
            }
        }
        return supplier;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (payImportInvoice_op.equals(callBackId)) {
            String errorVOJson = this.getPageCache().get(Invoice_error);
            if (StringUtils.isBlank((CharSequence)errorVOJson)) {
                return;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice");
            Object[] jsonToObjects = DynamicObjectSerializeUtil.deserialize((String)errorVOJson, (DynamicObjectType)dt);
            if (jsonToObjects.length == 0) {
                return;
            }
            List<DynamicObject> errorInvoices = Arrays.stream(jsonToObjects).map(item -> (DynamicObject)item).collect(Collectors.toList());
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                this.synDownBillData(errorInvoices);
            } else {
                List invoiceIds = errorInvoices.stream().map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"pmct_ininvoice", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
                List errorSerialNos = errorInvoices.stream().map(invoice -> invoice.getString("serialno")).collect(Collectors.toList());
                JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{errorSerialNos});
                if (!"0000".equals(result.getString("errcode"))) {
                    log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
                }
            }
            return;
        }
        if (conImportInvoice_op.equals(callBackId)) {
            String invoiceJson = this.getPageCache().get(Invoice_Data);
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                if (StringUtils.isNotBlank((CharSequence)invoiceJson)) {
                    List invoiceObj = JSON.parseArray((String)invoiceJson, InvoiceVO.class);
                    this.handleDownStrBus(invoiceObj);
                }
            } else {
                String errorVOJson = this.getPageCache().get(Invoice_error);
                if (StringUtils.isNotBlank((CharSequence)errorVOJson)) {
                    List errorVO = JSON.parseArray((String)errorVOJson, String.class);
                    if (!invoiceJson.isEmpty() && !errorVO.isEmpty()) {
                        List invoiceObj = JSON.parseArray((String)invoiceJson, InvoiceVO.class);
                        invoiceObj.removeIf(invoice -> errorVO.contains(invoice.getSerialNo()));
                        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{errorVO});
                        if (!"0000".equals(result.getString("errcode"))) {
                            log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
                        }
                        this.handleDownStrBus(invoiceObj);
                    }
                }
            }
        }
    }

    private void handleDownStrBus(List<InvoiceVO> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        DynamicObject[] invoices = new InvoiceImportHelper().syncIntoInvoicePool(list, this.getPageCache().get(CompanyId));
        if (invoices == null || invoices.length == 0) {
            return;
        }
        String formId = this.getPageCache().get("curformid");
        for (DynamicObject invoice : invoices) {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract")) {
                String billId = this.getPageCache().get(BillId);
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmct_outcontract");
                invoice.set("org", (Object)contract.getDynamicObject("org"));
                invoice.set("project", (Object)contract.getDynamicObject("project"));
                invoice.set("contract", (Object)contract);
                invoice.set("invoicesourceid", (Object)contract.getPkValue().toString());
                invoice.set("isclaimed", (Object)true);
                invoice.set("connecttype", (Object)"contract");
            } else {
                DynamicObject contract;
                IDataEntityProperty project;
                DynamicObject invoiceOrg;
                IDataEntityProperty org = this.getModel().getDataEntityType().findProperty("org");
                DynamicObject curOrg = (DynamicObject)this.getModel().getValue("org");
                if (org != null && curOrg != null && !StringUtils.equals((CharSequence)(invoiceOrg = invoice.getDynamicObject("org")).getPkValue().toString(), (CharSequence)curOrg.getPkValue().toString())) {
                    invoice.set("org", this.getModel().getValue("org"));
                    String orgId = invoice.getDynamicObject("org").getPkValue().toString();
                    boolean existCodeRule = CodeRuleServiceHelper.isExist((String)"pmct_ininvoice", (DynamicObject)invoice, (String)orgId);
                    if (existCodeRule) {
                        String number = CodeRuleServiceHelper.getNumber((String)"pmct_ininvoice", (DynamicObject)invoice, (String)orgId);
                        invoice.set(BillNo, (Object)number);
                    }
                }
                if ((project = this.getModel().getDataEntityType().findProperty("project")) != null) {
                    invoice.set("project", this.getModel().getValue("project"));
                }
                if ((contract = this.getContract()) != null) {
                    invoice.set("contract", (Object)contract);
                    invoice.set("isclaimed", (Object)true);
                    invoice.set("connecttype", (Object)"contract");
                }
                invoice.set("createorg", this.getModel().getValue("createorg"));
                invoice.set("invoicesourceid", (Object)this.getModel().getDataEntity().getPkValue().toString());
            }
            DynamicObject contract = invoice.getDynamicObject("contract");
            if (contract == null) continue;
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            invoice.set("contpartb", (Object)contract.getDynamicObject("partb"));
            if (contract.getDynamicObject("project") == null) continue;
            invoice.set("project", (Object)contract.getDynamicObject("project"));
        }
        SaveServiceHelper.update((DynamicObject[])invoices);
        List<DynamicObject> invoiceList = Arrays.stream(invoices).collect(Collectors.toList());
        if (!StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract")) {
            this.checkInvoiceSellerWithParB(invoiceList);
        }
        this.synDownBillData(invoiceList);
    }

    public void checkInvoiceSellerWithParB(List<DynamicObject> invoices) {
        String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
        if (StringUtils.isEmpty((CharSequence)invoiceSellerParam) || InvoiceSellerParamEnum.UNCTRL.getValue().equals(invoiceSellerParam)) {
            return;
        }
        StringBuffer errorTip = new StringBuffer();
        ArrayList<String> errorSerialNos = new ArrayList<String>(16);
        ArrayList<DynamicObject> errorInvoices = new ArrayList<DynamicObject>();
        Iterator<DynamicObject> iterator = invoices.iterator();
        while (iterator.hasNext()) {
            DynamicObject invoice = iterator.next();
            String invoiceNo = invoice.getString("invoiceno");
            String invoiceCode = invoice.getString("invoicecode");
            DynamicObject contPartB = invoice.getDynamicObject("contpartb");
            DynamicObject seller = invoice.getDynamicObject("seller");
            if (contPartB == null && seller != null || contPartB != null && seller == null) {
                String error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceNo);
                if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                }
                if (StringUtils.isNotEmpty((CharSequence)errorTip)) {
                    errorTip.append("\r\n");
                }
                errorTip.append(error);
            }
            if (contPartB != null && seller != null) {
                DynamicObject bizPartner = (contPartB = BusinessDataServiceHelper.loadSingle((Object)contPartB.getPkValue(), (String)"bd_supplier")).getDynamicObject("bizpartner");
                if (bizPartner == null) {
                    String error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceNo);
                    if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                        error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)errorTip)) {
                        errorTip.append("\r\n");
                    }
                    errorTip.append(error);
                } else {
                    long bizPartnerId;
                    long sellerId = Long.parseLong(seller.getPkValue().toString());
                    if (sellerId != (bizPartnerId = Long.parseLong(bizPartner.getPkValue().toString()))) {
                        String error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_36", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceNo);
                        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                            error = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s\uff0c\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoicePlugin_37", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), invoiceCode, invoiceNo);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)errorTip)) {
                            errorTip.append("\r\n");
                        }
                        errorTip.append(error);
                    }
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)errorTip.toString())) continue;
            errorSerialNos.add(invoice.getString("serialno"));
            errorInvoices.add(invoice);
            iterator.remove();
        }
        if (StringUtils.isNotEmpty((CharSequence)errorTip.toString())) {
            if (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam)) {
                this.getView().showErrorNotification(errorTip.toString());
                List invoiceIds = errorInvoices.stream().map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"pmct_ininvoice", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
                JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{errorSerialNos});
                if (!"0000".equals(result.getString(""))) {
                    log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
                }
            } else if (InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam)) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice");
                String errorInvoiceJson = DynamicObjectSerializeUtil.serialize((Object[])errorInvoices.toArray(new DynamicObject[errorInvoices.size()]), (DynamicObjectType)dt);
                this.getPageCache().put(Invoice_error, errorInvoiceJson);
                errorTip.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractImportInvoicePlugin_20", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(errorTip.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(payImportInvoice_op, (IFormPlugin)this));
            }
        }
    }

    public void synDownBillData(List<DynamicObject> invoiceList) {
        if (invoiceList.size() == 0) {
            return;
        }
        DynamicObject[] invoices = new DynamicObject[invoiceList.size()];
        for (int i = 0; i < invoiceList.size(); ++i) {
            DynamicObject invoice = invoiceList.get(i);
            invoices[i] = invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_ininvoice");
        }
        new InvoiceImportHelper().doAuditInvoice(invoices);
        String formId = this.getPageCache().get("curformid");
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract")) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("billId", this.getPageCache().get(BillId));
            map.put("billNo", this.getPageCache().get(BillNo));
            map.put("billType", "pmct_outcontract");
            map.put("entityId", "pmct_outcontract");
            map.put("appId", "pmct");
            ArrayList invoiceListMap = new ArrayList(16);
            for (DynamicObject invoice : invoices) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>(16);
                invoiceMap.put("serialNo", invoice.getString("serialno"));
                invoiceListMap.add(invoiceMap);
            }
            map.put(Invoice_Data, invoiceListMap);
            log.info("\u66f4\u65b0\u53d1\u7968" + ((Object)map).toString());
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{map});
            if (!"0000".equals(result.getString("errcode"))) {
                log.error("---\u66f4\u65b0\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)result.getString("description"));
            }
            return;
        }
        formId = this.getView().getFormShowParameter().getFormId();
        this.synPaymentApplyInfo(formId, invoices);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6210\u529f\u5bfc\u5165\u3002", (String)"AbstractImportInvoicePlugin_31", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
    }

    private void synPaymentApplyInfo(String formId, DynamicObject[] dataEntities) {
        if ("pmct_applymentpay".equals(formId) || MetaDataParseServiceHelper.checkInheritPath((String)formId, (String)"pmct_applymentpay")) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("invoiceentry");
            for (DynamicObject invoice : dataEntities) {
                DynamicObject entry = new DynamicObject(entries.getDynamicObjectType());
                entry.set("invoice", (Object)invoice);
                entry.set("invoicetotalamount", (Object)invoice.getBigDecimal("totalamount"));
                entry.set("invoicetotaltax", (Object)invoice.getBigDecimal("totaltax"));
                entry.set("invoicetotaloftaxamount", (Object)invoice.getBigDecimal("totaloftaxamount"));
                entry.set("invoicecurrency", (Object)invoice.getDynamicObject("currency"));
                entry.set("isupdateinvoice", (Object)false);
                entries.add((Object)entry);
            }
            this.getModel().updateCache();
            this.getModel().updateEntryCache(entries);
            this.getView().updateView("invoiceentry");
            this.getView().invokeOperation(OperationEnum.SAVE.getValue());
        } else if ("pmct_paymentapply".equals(formId) || MetaDataParseServiceHelper.checkInheritPath((String)formId, (String)"pmct_paymentapply")) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
            DynamicObjectCollection entries = rowEntity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject invoice : dataEntities) {
                DynamicObject entry = new DynamicObject(entries.getDynamicObjectType());
                entry.set("invoice", (Object)invoice);
                entry.set("invoiceamount", (Object)invoice.getBigDecimal("totalamount"));
                entry.set("invoicetax", (Object)invoice.getBigDecimal("totaltax"));
                entry.set("oftaxinvoiceamount", (Object)invoice.getBigDecimal("totaloftaxamount"));
                entry.set("invoicecurrency", (Object)invoice.getDynamicObject("currency"));
                entry.set("applyoftaxamtvo", (Object)invoice.getBigDecimal("totaloftaxamount"));
                entry.set("isupdateinvoice", (Object)false);
                entries.add((Object)entry);
            }
            BigDecimal totalApplyOfAmt = BigDecimal.ZERO;
            if (entries.size() > 0) {
                for (DynamicObject invoice : entries) {
                    BigDecimal subApplyOfTaxAmt = invoice.getBigDecimal("applyoftaxamtvo");
                    totalApplyOfAmt = totalApplyOfAmt.add(subApplyOfTaxAmt);
                }
            }
            rowEntity.set("applyoftaxamount", (Object)totalApplyOfAmt);
            this.getModel().updateCache();
            this.getModel().updateEntryCache(entries);
            this.getView().updateView("subentryentity");
            this.getView().updateView("applyoftaxamount", rows[0]);
            ContractHelper.applyOfTaxAmountChanged((IDataModel)this.getModel(), (IFormView)this.getView(), (BigDecimal)totalApplyOfAmt, (int)rows[0]);
            this.getView().invokeOperation(OperationEnum.SAVE.getValue());
            this.getView().invokeOperation("refresh");
        }
    }

    protected abstract String getCloseCallBackKey();

    protected DynamicObject getCostCompanyDO() {
        DynamicObject costCompanyDO = null;
        String curFormId = this.getPageCache().get("curformid");
        if (StringUtils.equals((CharSequence)curFormId, (CharSequence)"pmct_outcontract") || MetaDataParseServiceHelper.checkInheritPath((String)curFormId, (String)"pmct_outcontract")) {
            String billId = this.getPageCache().get(BillId);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pmct_outcontract");
            costCompanyDO = contract.getDynamicObject("fiaccountorg");
        } else {
            curFormId = this.getView().getFormShowParameter().getFormId();
            if ("pmct_paymentapply".equals(curFormId) || MetaDataParseServiceHelper.checkInheritPath((String)curFormId, (String)"pmct_paymentapply")) {
                costCompanyDO = (DynamicObject)this.getModel().getValue("accountorg");
            } else if ("pmct_applymentpay".equals(curFormId) || MetaDataParseServiceHelper.checkInheritPath((String)curFormId, (String)"pmct_applymentpay")) {
                costCompanyDO = (DynamicObject)this.getModel().getValue("costorg");
            }
        }
        if (costCompanyDO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u7684\u8d22\u52a1\u6838\u7b97\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"AbstractImportInvoicePlugin_13", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        return costCompanyDO;
    }

    private DynamicObject getContract() {
        DynamicObject contract = null;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("pmct_paymentapply".equals(formId) || MetaDataParseServiceHelper.checkInheritPath((String)formId, (String)"pmct_paymentapply")) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = grid.getEntryState().getSelectedRows();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rows[0]);
            contract = rowEntity.getDynamicObject("entrycontract");
        } else if ("pmct_applymentpay".equals(formId) || MetaDataParseServiceHelper.checkInheritPath((String)formId, (String)"pmct_applymentpay")) {
            contract = (DynamicObject)this.getModel().getValue("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        } else if ("pmct_outcontract".equals(formId) || MetaDataParseServiceHelper.checkInheritPath((String)formId, (String)"pmct_outcontract")) {
            contract = BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(BillId), (String)"pmct_outcontract");
        }
        return contract;
    }
}

