/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.invoicecloud;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.invoicecloud.IFrameParam;
import kd.pmgt.pmbs.business.invoicecloud.ImportInvoiceParam;
import kd.pmgt.pmbs.business.invoicecloud.exception.InvoiceCloudException;
import kd.pmgt.pmbs.common.utils.invoicecloud.InvoiceCloudConfigHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.MD5;
import kd.pmgt.pmbs.mservice.impl.invoicecloud.InvoiceForPCServiceImpl;
import net.sf.json.JSONObject;

public class InvoiceCloudPagePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(InvoiceCloudPagePlugin.class);
    private static final String IFRAME_WEB_SOCKET = "iframewebsocket";
    private InvoiceForPCServiceImpl invoiceForPCService = new InvoiceForPCServiceImpl();
    private static final String SELECT_INVOICE = "selectInvoice";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.selectInvoice(this.getView());
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String msg = e.getEventArgs();
        if (SELECT_INVOICE.equalsIgnoreCase(eventName)) {
            JSONObject msgData = JSONObject.fromObject((Object)msg);
            Boolean isSuccess = (Boolean)msgData.opt("success");
            if (isSuccess.booleanValue()) {
                this.getView().returnDataToParent((Object)msg);
                this.getView().close();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u5bfc\u5165\u5931\u8d25\u3002", (String)"InvoiceCloudPagePlugin_8", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void selectInvoice(IFormView view) {
        IFrameParam frameParam;
        String billId;
        long userId = RequestContext.get().getCurrUserId();
        String companyId = this.getParam("companyId");
        if (StringUtils.isBlank((CharSequence)companyId)) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u53d1\u7968\u524d\u9700\u8981\u5148\u9009\u62e9\u6240\u5c5e\u7684\u516c\u53f8\u3002", (String)"InvoiceCloudPagePlugin_9", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getParam("billNo"))) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceCloudPagePlugin_10", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject company = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(companyId), (String)"bos_org");
        DynamicObject cfg = InvoiceCloudConfigHelper.getConfigByAws((DynamicObject)company);
        String billNo = this.getParam("billNo");
        String userKey = this.getUserKey(String.valueOf(userId), billNo, cfg);
        if (userKey == null || userKey.endsWith("error")) {
            log.error("selectInvoice: [userKey]:{}", (Object)userKey);
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u6c42\u53d1\u7968\u4e91\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudPagePlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            return;
        }
        ImportInvoiceParam params = new ImportInvoiceParam();
        params.setOrg(company);
        params.setInvoiceCloudConfig(cfg);
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            params.setBillNo(billNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(billId = this.getParam("billId")))) {
            params.setBillId(billId);
        }
        params.setUserKey(userKey);
        try {
            frameParam = this.invoiceForPCService.getFrameParam(params, view);
        }
        catch (InvoiceCloudException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u53d1\u7968\u4e91\u5bfc\u5165\u754c\u9762\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudPagePlugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        IFrame socketIFrame = (IFrame)this.getControl(IFRAME_WEB_SOCKET);
        socketIFrame.setSrc(frameParam.getSocketUrl());
        this.showURL(frameParam.getUrl());
    }

    private void showURL(String url) {
        Html htmlAp = (Html)this.getControl("htmlap");
        String htmlContent = "<iframe id='invoicepageframe' style='width:100%;border:0px;' src='" + url + "' ></iframe>";
        htmlAp.setConent(htmlContent);
    }

    private String getUserKey(String userId, String billNo, DynamicObject cfg) {
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String firmName = cfg.getString("firmname");
        String tin = cfg.getString("taxregnum");
        String clientId = cfg.getString("client_id");
        String clientSecret = cfg.getString("client_secret");
        String rawSign = clientId + clientSecret + timestamp;
        String sign = MD5.md5crypt((String)rawSign);
        param.put("timestamp", timestamp);
        param.put("client_id", clientId);
        param.put("tin", tin);
        param.put("ghf_mc", firmName);
        param.put("eid", userId);
        param.put("sign", sign);
        param.put("billNumber", StringUtils.defaultIfBlank((CharSequence)billNo, (CharSequence)"0"));
        param.put("bxd_key", StringUtils.defaultIfBlank((CharSequence)billNo, (CharSequence)"0"));
        param.put("random", System.nanoTime());
        param.put("ticketParam", "11111");
        param.put("billType", "");
        log.error("getUserKey\uff0cticketParam:{}", (Object)param.get("ticketParam").toString());
        return InvoiceCloudConfigHelper.getUserKey(param);
    }

    private String getParam(String key) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.isEmpty() || !customParams.containsKey(key)) {
            return "";
        }
        Object object = customParams.get(key);
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

