/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.InitOperateOptionEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectPermEditPlugin
extends AbstractPmbsBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ProjectPermEditPlugin.class);
    private static final String BD_PROJECT_KEY = "bdProjectKey";

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit contract;
        super.registerListener(e);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getView().getFormShowParameter().getFormId());
        Map propertyMap = dataEntityType.getAllFields();
        ArrayList<String> bdProjectKey = new ArrayList<String>(10);
        for (Map.Entry propertyEntry : propertyMap.entrySet()) {
            BasedataEdit project;
            String baseEntityId = null;
            if (propertyEntry.getValue() instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)propertyEntry.getValue()).getBaseEntityId();
            } else if (propertyEntry.getValue() instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)propertyEntry.getValue()).getBaseEntityId();
            }
            if (baseEntityId == null || !StringUtils.equals((CharSequence)baseEntityId, (CharSequence)"bd_project") || (project = (BasedataEdit)this.getControl(((IDataEntityProperty)propertyEntry.getValue()).getName())) == null) continue;
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            String entryName = ((IDataEntityProperty)propertyEntry.getValue()).getName();
            if (StringUtils.equals((CharSequence)"multisettlepro", (CharSequence)entryName)) continue;
            bdProjectKey.add(((IDataEntityProperty)propertyEntry.getValue()).getName());
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List bdProjectPageCache = (List)formShowParameter.getCustomParam(BD_PROJECT_KEY);
        if (bdProjectPageCache == null && !bdProjectKey.isEmpty()) {
            formShowParameter.setCustomParam(BD_PROJECT_KEY, bdProjectKey);
        }
        if ((contract = (BasedataEdit)this.getControl(this.getContractName())) != null) {
            contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.enableOrgField();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        List bdProjectKey = (List)formShowParameter.getCustomParam(BD_PROJECT_KEY);
        if (bdProjectKey != null && bdProjectKey.contains(key)) {
            listShowParameter.getListFilterParameter().getQFilters().add(ProjectF7FilterHelper.getProjectQFilter());
            boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            if (superUser) {
                return;
            }
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
            if (adminUser) {
                return;
            }
            ArrayList<Long> orgList = new ArrayList<Long>(1);
            orgList.add(Long.parseLong(this.getOrg().getPkValue().toString()));
            Set projectIdList = ProjectF7FilterHelper.loadHasPermProjectList((IFormView)this.getView(), orgList);
            QFilter idFilter = new QFilter("id", "in", (Object)projectIdList);
            listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)this.getContractName())) {
            QFilter qFilter;
            String projectKey = ProjectPermFilterHelper.getProjectKey((String)this.getView().getEntityId());
            DynamicObject project = (DynamicObject)this.getModel().getValue(projectKey);
            if (project != null) {
                Long projectId = (Long)project.getPkValue();
                qFilter = new QFilter("project", "=", (Object)projectId);
            } else {
                boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
                if (superUser) {
                    return;
                }
                boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
                if (adminUser) {
                    return;
                }
                long orgId = this.getOrg() != null ? ((Long)this.getOrg().getPkValue()).longValue() : RequestContext.get().getOrgId();
                ArrayList<Long> orgList = new ArrayList<Long>(1);
                orgList.add(orgId);
                Set projectIds = ProjectF7FilterHelper.loadHasPermProjectList((IFormView)this.getView(), orgList);
                qFilter = new QFilter("project", "in", (Object)projectIds);
                QFilter noProQFilter = new QFilter("org", "=", (Object)orgId).and("project", "=", (Object)0L);
                qFilter.or(noProQFilter);
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List bdProjectKey = (List)formShowParameter.getCustomParam(BD_PROJECT_KEY);
        if (bdProjectKey == null || bdProjectKey.isEmpty()) {
            return;
        }
        String formId = formShowParameter.getFormId();
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmco_procostsplit") && StringUtils.equals((CharSequence)"entryproject", (CharSequence)key)) {
            return;
        }
        if (bdProjectKey.contains(key)) {
            long orgId;
            String orgKey = ProjectPermFilterHelper.getOrgKey((String)this.getView().getEntityId());
            Object newValue = changeData.getNewValue();
            if (newValue == null) {
                orgId = RequestContext.get().getOrgId();
            } else {
                DynamicObject project = (DynamicObject)newValue;
                orgId = (project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")).getDynamicObject("pmascreateorg") != null ? Long.parseLong(project.getDynamicObject("pmascreateorg").getPkValue().toString()) : RequestContext.get().getOrgId();
            }
            this.getModel().beginInit();
            this.getModel().setValue(orgKey, (Object)orgId);
            this.getView().updateView(orgKey);
            this.getModel().endInit();
            this.enableOrgField();
        }
    }

    public void initOperateOption(InitOperateOptionEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("close".equals(operateKey) || "refresh".equals(operateKey) || "new".equals(operateKey)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List projectFilterNames = (List)formShowParameter.getCustomParam(BD_PROJECT_KEY);
        if (CollectionUtils.isEmpty((Collection)projectFilterNames)) {
            return;
        }
        String projectField = (String)projectFilterNames.get(0);
        DynamicObject project = (DynamicObject)this.getModel().getValue(projectField);
        if (project == null) {
            return;
        }
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        if (isTeamPerm) {
            OperateOption option = ((FormOperate)e.getSource()).getOption();
            option.setVariableValue("ishasright", String.valueOf(true));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (("save".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) && (operationResult = args.getOperationResult()).isSuccess()) {
            this.enableOrgField();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("close".equals(operateKey) || "refresh".equals(operateKey) || "new".equals(operateKey)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List projectFilterNames = (List)formShowParameter.getCustomParam(BD_PROJECT_KEY);
        long userId = RequestContext.get().getCurrUserId();
        String billFormId = this.getView().getEntityId();
        if (projectFilterNames == null || projectFilterNames.isEmpty()) {
            return;
        }
        String projectField = (String)projectFilterNames.get(0);
        DynamicObject project = (DynamicObject)this.getModel().getValue(projectField);
        if (project == null) {
            return;
        }
        boolean superUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (superUser) {
            return;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (adminUser) {
            return;
        }
        Map permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)((Long)project.getPkValue()), (String)billFormId, (String)operateKey, (Long)userId);
        if (permMap.get("noHasPerm") != null) {
            throw new KDBizException((String)permMap.get("noHasPerm"));
        }
    }

    private void enableOrgField() {
        String projectKey = ProjectPermFilterHelper.getProjectKey((String)this.getView().getEntityId());
        Object projectObj = this.getModel().getValue(projectKey);
        boolean enable = projectObj == null;
        String orgKey = ProjectPermFilterHelper.getOrgKey((String)this.getView().getEntityId());
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{orgKey});
    }

    protected DynamicObject getOrg() {
        String orgKey = ProjectPermFilterHelper.getOrgKey((String)this.getView().getEntityId());
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgKey);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bos_org");
        }
        return org;
    }

    protected String getContractName() {
        return "contract";
    }
}

