/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.InitOperateOptionEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsListPlugin;

public class ProjectPermListPlugin
extends AbstractPmbsListPlugin {
    private static final Log logger = LogFactory.getLog(ProjectPermListPlugin.class);
    public static final String CLICK_PROJECT_CACHE = "click_project_cache";
    public static final String PROJECTPERMLISTPLUGIN_PROJECTCACHE = "ProjectPermListPlugin_projectId";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (superUser) {
            return;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (adminUser) {
            return;
        }
        this.initProjectColumn();
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        List defaultValues;
        CommonFilterColumn projectFilterColumn;
        super.filterContainerAfterSearchClick(args);
        if (args.getCurrentCommonFilter() != null && args.getCurrentCommonFilter().get("FieldName") != null && ((List)args.getCurrentCommonFilter().get("FieldName")).get(0) != null && ProjectPermFilterHelper.getOrgFilterKey((String)((IListView)this.getView()).getBillFormId()).equalsIgnoreCase(((List)args.getCurrentCommonFilter().get("FieldName")).get(0).toString()) && (projectFilterColumn = ProjectPermFilterHelper.getProjectFilter((IListView)((IListView)this.getView()))) != null && projectFilterColumn.getDefaultValues() != null && !(defaultValues = projectFilterColumn.getDefaultValues()).isEmpty()) {
            CopyOnWriteArrayList comboItems = new CopyOnWriteArrayList(projectFilterColumn.getComboItems());
            for (ComboItem item : comboItems) {
                if (!defaultValues.contains(item.getValue())) continue;
                comboItems.remove(item);
            }
            projectFilterColumn.getComboItems().clear();
            projectFilterColumn.setComboItems(comboItems);
            defaultValues.clear();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getRefEntityId();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bd_project")) {
            boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            if (superUser) {
                return;
            }
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
            if (adminUser) {
                return;
            }
            IListView listView = (IListView)this.getView();
            String formId = listView.getBillFormId();
            String orgKey = ProjectPermFilterHelper.getOrgKey((String)formId);
            String orgFilterKey = ProjectPermFilterHelper.getOrgFilterKey((String)formId);
            Map hasPermOrgMap = ProjectPermFilterHelper.getHasPermOrgMap((IListView)listView, (String)orgKey, (String)orgFilterKey);
            String projectKey = ProjectPermFilterHelper.getProjectKey((String)formId);
            ArrayList projectIds = new ArrayList(ProjectPermFilterHelper.getHasPermProjectList((IListView)((IListView)this.getView()), (Map)hasPermOrgMap, (String)orgKey, (String)projectKey));
            QFilter idFilter = new QFilter("id", "in", projectIds);
            args.getQfilters().add(idFilter);
        }
    }

    public void setFilter(SetFilterEvent event) {
        boolean orgNoLimit;
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (superUser) {
            return;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (adminUser) {
            return;
        }
        List qFilters = event.getQFilters();
        IListView listView = (IListView)this.getView();
        String formId = listView.getBillFormId();
        String orgKey = ProjectPermFilterHelper.getOrgKey((String)formId);
        String orgFilterKey = ProjectPermFilterHelper.getOrgFilterKey((String)formId);
        String projectKey = ProjectPermFilterHelper.getProjectKey((String)formId);
        String projectFilterKey = ProjectPermFilterHelper.getProjectFilterKey((String)formId);
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        if (projectKey != null) {
            Map hasPermOrgMap = ProjectPermFilterHelper.getHasPermOrgMap((IListView)listView, (String)orgKey, (String)orgFilterKey);
            ArrayList projectIds = new ArrayList(ProjectPermFilterHelper.getHasPermProjectList((IListView)((IListView)this.getView()), (Map)hasPermOrgMap, (String)orgKey, (String)projectKey));
            QFilter projectQFilter = new QFilter(projectKey, "in", projectIds);
            List orgList = ProjectPermFilterHelper.getOrgFilterIdList((IListView)listView, (String)orgKey, (String)orgFilterKey);
            QFilter orgQFilter = new QFilter(orgKey, "in", (Object)orgList);
            QFilter projectIsNullFilter = new QFilter(projectKey, "=", (Object)0L);
            boolean projectNoLimit = ProjectPermFilterHelper.isFilterFieldSelectedNoLimit((IListView)listView, (String)projectFilterKey);
            if (projectNoLimit) {
                orgQFilter.addFirstNest(projectIsNullFilter, "AND");
                DynamicObjectCollection orgAndNoProBillIds = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{orgQFilter});
                DynamicObjectCollection proBillIds = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{projectQFilter});
                orgAndNoProBillIds.addAll((Collection)proBillIds);
                Set billIds = orgAndNoProBillIds.stream().map(obj -> obj.get("id")).collect(Collectors.toSet());
                if (isTeamPerm) {
                    qFilters.add(new QFilter("id", "in", billIds));
                } else if (!projectIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "in", billIds));
                }
            } else if (isTeamPerm) {
                qFilters.add(projectQFilter);
            } else if (!projectIds.isEmpty()) {
                qFilters.add(orgQFilter.and(projectQFilter));
            }
        }
        if ((orgNoLimit = ProjectPermFilterHelper.isFilterFieldSelectedNoLimit((IListView)listView, (String)orgFilterKey)) && isTeamPerm) {
            event.setMainOrgQFilter(null);
        }
    }

    public void initOperateOption(InitOperateOptionEventArgs e) {
        ListSelectedRowCollection listSelectedData = e.getListSelectedData().getBillListSelectedRowCollection();
        if (listSelectedData.getPrimaryKeyValues().length == 0) {
            return;
        }
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("close".equals(operateKey) || "refresh".equals(operateKey) || "new".equals(operateKey)) {
            return;
        }
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        if (isTeamPerm) {
            OperateOption option = ((FormOperate)e.getSource()).getOption();
            option.setVariableValue("ishasright", String.valueOf(true));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("close".equals(operateKey) || "refresh".equals(operateKey) || "new".equals(operateKey)) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        IListView listView = (IListView)this.getView();
        String formId = listView.getBillFormId();
        String orgKey = ProjectPermFilterHelper.getOrgKey((String)formId);
        String projectKey = ProjectPermFilterHelper.getProjectKey((String)formId);
        if (projectKey == null) {
            return;
        }
        ListSelectedRowCollection listSelectedData = args.getListSelectedData().getBillListSelectedRowCollection();
        Object[] pks = listSelectedData.getPrimaryKeyValues();
        if (pks.length == 0) {
            return;
        }
        boolean superUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (superUser) {
            return;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (adminUser) {
            return;
        }
        DynamicObjectCollection selectDataList = QueryServiceHelper.query((String)formId, (String)String.join((CharSequence)",", "id", projectKey, orgKey), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(16);
        if (selectDataList.size() > 0) {
            for (DynamicObject data : selectDataList) {
                dataMap.put(data.get("id"), data);
            }
        }
        StringBuilder errorTip = new StringBuilder();
        for (ListSelectedRow listSelected : listSelectedData) {
            Map permMap;
            DynamicObject data = (DynamicObject)dataMap.get(listSelected.getPrimaryKeyValue());
            if (data == null || data.getLong(orgKey) == 0L) continue;
            int row = listSelected.getRowKey() + 1;
            long projectId = data.getLong(projectKey);
            if (projectId == 0L) {
                Map permObj = ProjectPermissionHelper.getPermObj((String)formId, (String)operateKey);
                if (permObj.isEmpty()) continue;
                List permOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(userId), (String)this.getView().getFormShowParameter().getAppId(), (String)formId, (String)String.valueOf(permObj.get("id")));
                if (!permOrgList.contains(data.getLong(orgKey))) {
                    if (!StringUtils.isEmpty((CharSequence)errorTip.toString())) {
                        errorTip.append("\n");
                    }
                    errorTip.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u60a8\u6ca1\u6709\u3010%2$s\u3011\u5355\u636e\u7684\u3010%3$s\u3011\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectPermListPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), row, this.getView().getFormShowParameter().getFormName(), permObj.get("permName")));
                    continue;
                }
            }
            if ((permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)projectId, (String)formId, (String)operateKey, (Long)userId)).get("noHasPerm") == null) continue;
            if (!StringUtils.isEmpty((CharSequence)errorTip.toString())) {
                errorTip.append("\n");
            }
            errorTip.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a", (String)"ProjectPermListPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), row)).append((String)permMap.get("noHasPerm"));
        }
        if (!StringUtils.isEmpty((CharSequence)errorTip.toString())) {
            throw new KDBizException(errorTip.toString());
        }
    }

    protected void initProjectColumn() {
        CommonFilterColumn projectFilterColumn = ProjectPermFilterHelper.getProjectFilter((IListView)((IListView)this.getView()));
        if (projectFilterColumn == null) {
            return;
        }
        String projectKey = projectFilterColumn.getFieldName();
        if (projectKey.contains(".")) {
            projectKey = projectKey.substring(0, projectKey.indexOf("."));
        }
        IListView listView = (IListView)this.getView();
        String formId = listView.getBillFormId();
        String orgKey = ProjectPermFilterHelper.getOrgKey((String)formId);
        String orgFilterKey = ProjectPermFilterHelper.getOrgFilterKey((String)formId);
        Map hasPermOrgMap = ProjectPermFilterHelper.getHasPermOrgMap((IListView)listView, (String)orgKey, (String)orgFilterKey);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u5f00\u59cb\u91cd\u6784\u9879\u76ee\u8fc7\u6ee4\u6761\u4ef6\u503c\uff0c\u7ec4\u7ec7\u6761\u4ef6\u53c2\u6570\uff1a{}", (Object)hasPermOrgMap);
        ArrayList projectIdList = new ArrayList(ProjectPermFilterHelper.getHasPermProjectList((IListView)listView, (Map)hasPermOrgMap, (String)orgKey, (String)projectKey));
        QFilter qFilter = new QFilter("id", "in", projectIdList);
        List projectComboItems = BuildCommonFilterList.buildComboItem((String)"bd_project", (QFilter)qFilter);
        projectFilterColumn.setComboItems(projectComboItems);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u9879\u76ee\u8fc7\u6ee4\u6761\u4ef6\u503c\u91cd\u5efa\u5b8c\u6210");
    }
}

