/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.propermission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class ProPermissionBillPlugin
extends AbstractPmbsBillPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit user = (BasedataEdit)this.getControl("user");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        this.getModel().setValue("org", orgId);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"personseparate");
        this.getPageCache().put("pattern", pattern);
    }

    @Override
    public String getOrgViewType() {
        return "01";
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "exclusionproj": {
                Boolean isSubordinate = (Boolean)this.getModel().getValue("issubordinate");
                DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
                Long orgId = Long.valueOf(orgObj.getPkValue().toString());
                ArrayList<Long> orgList = new ArrayList<Long>();
                orgList.add(orgId);
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                if (isSubordinate.booleanValue()) {
                    List subOrgIds = OrgServiceHelper.getAllSubordinateOrgs((String)this.getOrgViewType(), orgList, (boolean)true);
                    orgList.addAll(subOrgIds);
                }
                DynamicObject[] projects = ProjectPermissionHelper.getPermProject(orgList);
                List ids = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                QFilter proStatusFilter = new QFilter("id", "in", ids);
                parameter.getListFilterParameter().getQFilters().add(proStatusFilter);
                break;
            }
            case "user": {
                List<Long> orgUnitIds = new ArrayList<Long>(16);
                long currUserId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)currUserId);
                if (userOrgRanges.size() > 0) {
                    long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                    if (userOrgRanges.contains(rootOrgId)) {
                        orgUnitIds = userOrgRanges;
                    } else {
                        String pattern = this.getPageCache().get("pattern");
                        if (StringUtils.isNotBlank((CharSequence)pattern)) {
                            orgUnitIds = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"01");
                        } else {
                            orgUnitIds.add(0L);
                        }
                    }
                } else {
                    orgUnitIds.add(0L);
                }
                if (orgUnitIds.size() <= 0) break;
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                qFilterList.add(new QFilter("entryentity.dpt.id", "in", orgUnitIds));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "exclusionproj": {
                DynamicObjectCollection projs = (DynamicObjectCollection)newValue;
                List proObjs = projs.stream().map(pro -> pro.getDynamicObject("fbasedataId")).collect(Collectors.toList());
                String projsStr = proObjs.stream().map(proj -> proj.getString("name")).collect(Collectors.joining(","));
                this.getModel().setValue("excluprojstr", (Object)projsStr);
                break;
            }
            case "roles": {
                DynamicObjectCollection roles = (DynamicObjectCollection)newValue;
                List roleObjs = roles.stream().map(ro -> ro.getDynamicObject("fbasedataId")).collect(Collectors.toList());
                String rolestr = roleObjs.stream().map(roleobj -> roleobj.getString("name")).collect(Collectors.joining(","));
                this.getModel().setValue("rolesstr", (Object)rolestr);
                break;
            }
        }
    }
}

