/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.propermission;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsBillPlugin;

public class ProPermissionViewPlugin
extends AbstractPmbsBillPlugin
implements BeforeF7SelectListener {
    private static final String projorg = "department";
    private static final String USER_KEY = "user";
    private static final String UserIDParam = "userid";
    private static final String OrgParam = "org";
    public static final String PROJECT = "project";
    private static final String selectors1 = Stream.of("org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj").collect(Collectors.joining(","));

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit user = (BasedataEdit)this.getControl(USER_KEY);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object userId = this.getView().getFormShowParameter().getCustomParam(UserIDParam);
        Object orgId = this.getView().getFormShowParameter().getCustomParam(OrgParam);
        this.getModel().setValue(USER_KEY, userId);
        this.loadData(userId, orgId);
        String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"personseparate");
        this.getPageCache().put("pattern", pattern);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "user": {
                DynamicObject user = (DynamicObject)newValue;
                Object orgId = this.getView().getFormShowParameter().getCustomParam(OrgParam);
                if (user != null) {
                    this.loadData(user.getPkValue(), orgId);
                    break;
                }
                this.loadData(null);
                break;
            }
        }
    }

    private void loadData(Object userId, Object orgId) {
        this.getModel().deleteEntryData("userexclusions");
        this.getModel().deleteEntryData("prolist");
        if (userId != null) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            QFilter userFilter = new QFilter(USER_KEY, "=", userId);
            QFilter orgFilter = new QFilter(OrgParam, "=", orgId);
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors1, (QFilter[])new QFilter[]{enableFilter, userFilter, orgFilter});
            HashSet<Object> orgIds = new HashSet<Object>();
            HashSet excluProIds = new HashSet();
            for (DynamicObject obj : objs) {
                boolean isSubordinate = obj.getBoolean("issubordinate");
                DynamicObjectCollection multiObjs = obj.getDynamicObjectCollection("exclusionproj");
                Set excludeProjIds = multiObjs.stream().map(pro -> pro.getDynamicObject("fbasedataId").getPkValue()).collect(Collectors.toSet());
                int rowIndex = this.getModel().createNewEntryRow("userexclusions");
                this.getModel().setValue(OrgParam, orgId, rowIndex);
                this.getModel().setValue("issubordinate", obj.get("issubordinate"), rowIndex);
                this.getModel().setValue("excluprojstr", obj.get("excluprojstr"), rowIndex);
                this.getModel().setValue("rolestr", obj.get("rolesstr"), rowIndex);
                if (isSubordinate) {
                    List ids = OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(orgId.toString())).collect(Collectors.toList()), (boolean)true);
                    orgIds.addAll(ids);
                } else {
                    orgIds.add(orgId);
                }
                excluProIds.addAll(excludeProjIds);
            }
            if (objs.length > 0) {
                DynamicObject[] permProjs;
                QFilter filter = new QFilter("projectstage", "=", (Object)Long.valueOf(ProjectStageEnum.PROPOSALSTAGE_S.getId()));
                QFilter filter3 = new QFilter("projectstatus", "=", (Object)Long.valueOf(ProjectStatusEnum.APPROVAL_SUCC.getId()));
                QFilter filter4 = new QFilter(PROJECT, "not in", excluProIds);
                filter.and(filter3).and(filter4);
                DynamicObject[] statgeEntries = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)PROJECT, (QFilter[])new QFilter[]{filter});
                Object[] filterProjects = new Object[]{};
                if (statgeEntries.length != 0) {
                    filterProjects = new Object[statgeEntries.length];
                    DynamicObject project = null;
                    for (int i = 0; i < statgeEntries.length; ++i) {
                        project = statgeEntries[i].getDynamicObject(PROJECT);
                        if (project == null) continue;
                        filterProjects[i] = project.getPkValue();
                    }
                }
                QFilter projOrgFilter = new QFilter(projorg, "in", orgIds);
                QFilter excluFilter = new QFilter("id", "in", (Object)filterProjects);
                for (DynamicObject proj : permProjs = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,name", (QFilter[])new QFilter[]{projOrgFilter, excluFilter})) {
                    int rowIndex = this.getModel().createNewEntryRow("prolist");
                    this.getModel().setValue("projnum", proj.getPkValue(), rowIndex);
                }
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "user": {
                List<Long> orgUnitIds = new ArrayList<Long>(16);
                long currUserId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)currUserId);
                if (userOrgRanges.size() > 0) {
                    String pattern = this.getPageCache().get("pattern");
                    if (!StringUtil.isEmpty((String)pattern)) {
                        orgUnitIds = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"01");
                    } else {
                        orgUnitIds.add(0L);
                    }
                } else {
                    orgUnitIds.add(0L);
                }
                if (orgUnitIds.isEmpty()) break;
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                qFilterList.add(new QFilter("entryentity.dpt.id", "in", orgUnitIds));
                break;
            }
        }
    }
}

