/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.supervision;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;

public class FieldSelectF7Plugin
extends AbstractPmbsFormPlugin {
    public static final String BILL_NUMBER = "billNumber";
    public static final String BILL_NAME = "billName";
    public static final String FIELD_TYPE = "filetype";
    public static final String FIELD_NOT_SHOW = "filenotshow";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";

    public void afterCreateNewData(EventObject e) {
        this.initTreeEntity();
    }

    private void initTreeEntity() {
        String billNumber = (String)this.getView().getFormShowParameter().getCustomParam(BILL_NUMBER);
        String billName = (String)this.getView().getFormShowParameter().getCustomParam(BILL_NAME);
        String fieldType = (String)this.getView().getFormShowParameter().getCustomParam(FIELD_TYPE);
        try {
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
            MainEntity rootEntity = entityMeta.getRootEntity();
            List items = rootEntity.getItems();
            int newEntryRow = this.getModel().createNewEntryRow(TREE_ENTRY_ENTITY);
            DynamicObject rootDy = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, newEntryRow);
            rootDy.set("number", (Object)billNumber);
            rootDy.set("name", (Object)billName);
            rootDy.set("fullnumber", (Object)billNumber);
            rootDy.set("fullname", (Object)billName);
            this.initTreeEntryEntity(items, rootDy, "", "", fieldType);
            this.getView().updateView(TREE_ENTRY_ENTITY);
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            treeEntryGrid.setCollapse(false);
            treeEntryGrid.setDroppable(false);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u3002", (String)"FieldSelectF7Plugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void initTreeEntryEntity(List<EntityItem<?>> properties, DynamicObject parentDy, String parentNum, String parentName, String fieldType) {
        Iterator<EntityItem<?>> iterator = properties.iterator();
        String fieldNotShow = (String)this.getView().getFormShowParameter().getCustomParam(FIELD_NOT_SHOW);
        List<String> notShowFields = null;
        if (StringUtils.isNotBlank((CharSequence)fieldNotShow)) {
            notShowFields = Arrays.asList(fieldNotShow.split(","));
        }
        while (iterator.hasNext()) {
            EntityItem<?> property = iterator.next();
            String number = property.getKey();
            LocaleString displayName = property.getName();
            String propertyType = property.getClass().getName();
            if (number == null || displayName == null || property instanceof EntryEntity || StringUtils.isNotBlank((CharSequence)fieldType) && !StringUtils.equals((CharSequence)fieldType, (CharSequence)propertyType)) continue;
            String name = displayName.getLocaleValue();
            String fullNum = this.getFullName(number, parentNum);
            String fullName = this.getFullName(name, parentName);
            if (notShowFields != null && notShowFields.contains(fullNum)) continue;
            int newEntryRow = this.getModel().createNewEntryRow(TREE_ENTRY_ENTITY);
            DynamicObject child = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, newEntryRow);
            child.set("pid", (Object)parentDy.getString("id"));
            child.set("number", (Object)number);
            child.set("name", (Object)name);
            child.set("fullnumber", (Object)fullNum);
            child.set("fullname", (Object)fullName);
            child.set("type", (Object)propertyType);
        }
    }

    private String getFullName(String curText, String parent) {
        String fullText = StringUtils.isEmpty((CharSequence)parent) ? curText : String.format("%s.%s", parent, curText);
        return fullText;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Donothing) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        int index = this.getModel().getEntryCurrentRowIndex(TREE_ENTRY_ENTITY);
        if (index == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"FieldSelectF7Plugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        } else if (index == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"FieldSelectF7Plugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, index);
            this.getView().returnDataToParent((Object)entryRowEntity);
            this.getView().close();
        }
    }
}

