/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.supervision;

import java.util.EventObject;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;

public class SupervisablePropEditPlugin
extends AbstractPmbsFormPlugin {
    private static final String ACTION_ID_SELECT_PROJECT_FIELD = "selectProjectField";
    private static final String ACTION_ID_SELECT_FORM_FIELD = "selectFormField";
    private static final String BTN_SAVE = "save";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"profieldname", "propname"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"profieldname")) {
            this.showFieldSelectForm(BasedataField.class.getName());
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"propname")) {
            this.showFieldSelectForm(null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "sysbill": {
                this.getModel().setValue("profieldname", null);
                this.getModel().setValue("profieldnum", null);
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue("billname", (Object)((DynamicObject)newValue).getString("name"));
                break;
            }
        }
    }

    private void showFieldSelectForm(String fieldType) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("sysbill");
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5355\u636e\u3002", (String)"SupervisablePropEditPlugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pmbs_fieldselectform");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("billNumber", (Object)bill.getString("number"));
        formShowParameter.setCustomParam("billName", (Object)bill.getString("name"));
        formShowParameter.setCustomParam("filetype", (Object)fieldType);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String fieldNotShow = entryEntity.stream().map(entry -> entry.getString("propnumber")).filter(Objects::nonNull).collect(Collectors.joining(","));
        formShowParameter.setCustomParam("filenotshow", (Object)fieldNotShow);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, StringUtils.isBlank((CharSequence)fieldType) ? ACTION_ID_SELECT_FORM_FIELD : ACTION_ID_SELECT_PROJECT_FIELD));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            DynamicObject data = (DynamicObject)returnData;
            String number = data.getString("number");
            String name = data.getString("name");
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_ID_SELECT_PROJECT_FIELD)) {
                this.getModel().setValue("profieldname", (Object)name);
                this.getModel().setValue("profieldnum", (Object)number);
            }
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_ID_SELECT_FORM_FIELD)) {
                String propType = data.getString("type");
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject currentRow = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
                currentRow.set("propname", (Object)name);
                currentRow.set("propnumber", (Object)number);
                currentRow.set("proptype", (Object)propType);
                this.getView().updateView("entryentity");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity;
        QFilter sysBillFilter;
        DynamicObject[] existDbObject;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)BTN_SAVE) && (existDbObject = BusinessDataServiceHelper.load((String)"pmbs_spvprop", (String)"sysbill", (QFilter[])new QFilter[]{sysBillFilter = new QFilter("sysbill", "=", (dataEntity = this.getModel().getDataEntity()).getDynamicObject("sysbill").getPkValue())})) != null && existDbObject.length > 0 && !StringUtils.equals((CharSequence)existDbObject[0].getPkValue().toString(), (CharSequence)dataEntity.getPkValue().toString())) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u672c\u5355\u636e\u7684\u5c5e\u6027\u5217\u8868\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\u3002", (String)"SupervisablePropEditPlugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)BTN_SAVE)) {
            this.getView().invokeOperation("close");
        }
    }
}

