/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.supervision;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.SupervisionPropDBHelper;
import kd.pmgt.pmbs.business.model.pmbs.SupervisePropModel;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class SupervisePropF7Plugin
extends AbstractPmbsFormPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(SupervisePropF7Plugin.class);
    public static final String SPV_PROP_BILL_PK = "spv_prop_bill_pk";
    public static final String SPV_PROP_PK = "spv_prop_pk";
    public static final String SPV_PROP_JSON = "spv_prop_json";
    public static final String SPV_PROJECT_ID = "spv_project_id";
    public static final String SPV_PROJECT_KIND_ENABLE = "spv_project_kind_enable";
    public static final String SPV_ENABLE_UPDATE = "spv_enable_update";
    protected static final String COMPARE_TYPES = "compareTypes";
    private static final String BTN_SAVE = "save";
    private static final String BTN_CLOSE = "close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid control = (FilterGrid)this.getView().getControl("commonfilter");
        control.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.init();
    }

    private void init() {
        Long spvPropPk = (Long)this.getView().getFormShowParameter().getCustomParam(SPV_PROP_BILL_PK);
        if (spvPropPk == null) {
            return;
        }
        String visible = (String)this.getView().getFormShowParameter().getCustomParam(SPV_PROJECT_KIND_ENABLE);
        visible = StringUtils.isNotBlank((CharSequence)visible) ? Boolean.FALSE.toString() : visible;
        DynamicObject superviableProp = BusinessDataServiceHelper.loadSingle((Object)spvPropPk, (String)"pmbs_spvprop");
        if (superviableProp == null || StringUtils.equals((CharSequence)Boolean.FALSE.toString(), (CharSequence)visible) && StringUtils.equals((CharSequence)superviableProp.getString("prokindvisible"), (CharSequence)"false")) {
            return;
        }
        String enableUpdate = (String)this.getView().getFormShowParameter().getCustomParam(SPV_ENABLE_UPDATE);
        if (StringUtils.equals((CharSequence)enableUpdate, (CharSequence)Boolean.FALSE.toString())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"propdesc", "commonfilter", "confirm", BTN_CLOSE});
        }
        String entityNumber = superviableProp.getDynamicObject("sysbill").getString("number");
        DynamicObjectCollection spvPropEntries = superviableProp.getDynamicObjectCollection("entryentity");
        String finalVisible = visible;
        List fieldKeys = spvPropEntries.stream().filter(propEntry -> {
            if (StringUtils.equals((CharSequence)Boolean.FALSE.toString(), (CharSequence)finalVisible)) {
                return !StringUtils.equals((CharSequence)propEntry.getString("fieldprokindvisible"), (CharSequence)finalVisible);
            }
            return true;
        }).map(propEntry -> {
            String propNumber = propEntry.getString("propnumber");
            if (StringUtils.equals((CharSequence)BasedataField.class.getName(), (CharSequence)propEntry.getString("proptype"))) {
                return String.format("%s.name", propNumber);
            }
            return propNumber;
        }).collect(Collectors.toList());
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
        filterGrid.setEntityNumber(entityNumber);
        if (CollectionUtils.isEmpty(fieldKeys)) {
            fieldKeys.add(null);
        }
        filterGrid.setFilterFieldKeys(fieldKeys);
    }

    private SupervisePropModel getSpvPropModel() {
        SupervisePropModel spvPropModel = null;
        String spvPropPk = (String)this.getView().getFormShowParameter().getCustomParam(SPV_PROP_PK);
        String spvPropJson = (String)this.getView().getFormShowParameter().getCustomParam(SPV_PROP_JSON);
        if (StringUtils.isNotBlank((CharSequence)spvPropJson)) {
            spvPropModel = (SupervisePropModel)JSON.parseObject((String)spvPropJson, SupervisePropModel.class);
        } else if (StringUtils.isNotBlank((CharSequence)spvPropPk)) {
            spvPropModel = SupervisionPropDBHelper.getById((Long)Long.valueOf(spvPropPk));
        }
        return spvPropModel;
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
        List filterColumns = filterGrid.getFilterColumns();
        this.customSetting(filterColumns);
        String propDesc = null;
        SupervisePropModel spvProp = this.getSpvPropModel();
        if (spvProp != null) {
            filterGrid.SetValue(spvProp.getCondition());
            propDesc = spvProp.getPropDesc();
        }
        if (StringUtils.isBlank(propDesc)) {
            Long spvPropPk = (Long)this.getView().getFormShowParameter().getCustomParam(SPV_PROP_BILL_PK);
            DynamicObject superviableProp = BusinessDataServiceHelper.loadSingle((Object)spvPropPk, (String)"pmbs_spvprop");
            String entityNumber = superviableProp.getDynamicObject("sysbill").getString("name");
            propDesc = String.format(ResManager.loadKDString((String)"%s\u7684\u5173\u952e\u5c5e\u6027\u914d\u7f6e\u3002", (String)"SupervisePropF7Plugin_4", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), entityNumber);
        }
        this.getModel().setValue("propdesc", (Object)propDesc);
        this.getView().updateView("propdesc");
    }

    protected void customSetting(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            this.setCompareTypes(filterColumn);
            this.setCustomShow(filterColumn);
        }
    }

    protected void setCustomShow(Map<String, Object> filterColumn) {
        String type = filterColumn.get("type").toString();
        if (StringUtils.equals((CharSequence)"basedata", (CharSequence)type)) {
            filterColumn.put("fieldCaption", filterColumn.get("fieldCaption").toString().split("\\.")[0]);
        }
    }

    protected void setCompareTypes(Map<String, Object> filterColumn) {
        List compareTypes = (List)filterColumn.get(COMPARE_TYPES);
        List newTypes = compareTypes.stream().filter(type -> Lists.newArrayList((Object[])new String[]{CompareTypeEnum.IN.getId(), CompareTypeEnum.EQUAL.getId()}).contains(type.getId())).collect(Collectors.toList());
        Collections.reverse(newTypes);
        filterColumn.put(COMPARE_TYPES, newTypes);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)BTN_SAVE, (CharSequence)operateKey)) {
            String propDesc = (String)this.getModel().getValue("propdesc");
            if (StringUtils.isBlank((CharSequence)propDesc)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u914d\u7f6e\u63cf\u8ff0\u3002", (String)"SupervisePropF7Plugin_1", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            boolean conditionOk = this.checkCondition(filterCondition);
            if (!conditionOk) {
                return;
            }
            String conditionString = SerializationUtils.toJsonString((Object)filterCondition);
            String entityNumber = filterGrid.getEntityNumber();
            SupervisePropModel spvPropModel = new SupervisePropModel(entityNumber, propDesc, conditionString);
            ListSelectedRowCollection collection = new ListSelectedRowCollection();
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setPrimaryKeyValue((Object)spvPropModel);
            collection.add((Object)selectedRow);
            this.getView().returnDataToParent((Object)collection);
            this.getView().invokeOperation(BTN_CLOSE);
        }
    }

    private boolean checkCondition(FilterCondition filterCondition) {
        int rightBracketCount;
        int leftBracketCount;
        boolean result = true;
        ArrayList<String> leftBrackets = new ArrayList<String>();
        ArrayList<String> rightBrackets = new ArrayList<String>();
        List filterRow = filterCondition.getFilterRow();
        for (SimpleFilterRow row : filterRow) {
            String fieldName = row.getFieldName();
            String compareType = row.getCompareType();
            List values = row.getValue();
            if (StringUtils.isBlank((CharSequence)fieldName) || StringUtils.isBlank((CharSequence)compareType) || CollectionUtils.isEmpty((Collection)values)) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b57\u6bb5\u201d\u201c\u6761\u4ef6\u201d\u201c\u503c\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"SupervisePropF7Plugin_0", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            leftBrackets.add(row.getLeftBracket());
            rightBrackets.add(row.getRightBracket());
        }
        if (result && (leftBracketCount = leftBrackets.stream().filter(Objects::nonNull).collect(Collectors.joining()).toCharArray().length) != (rightBracketCount = rightBrackets.stream().filter(Objects::nonNull).collect(Collectors.joining()).toCharArray().length)) {
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62ec\u53f7\u9700\u8981\u6210\u5bf9\u51fa\u73b0\u3002", (String)"SupervisePropF7Plugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        return result;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String projectId = (String)this.getView().getFormShowParameter().getCustomParam(SPV_PROJECT_ID);
        List<String> projectFieldNames = this.getProjectFieldNumber(event.getRefEntityId());
        QFilter projectFilter = null;
        if (!CollectionUtils.isEmpty(projectFieldNames)) {
            List projectFilters = projectFieldNames.stream().map(projectFieldName -> new QFilter(projectFieldName, "=", (Object)(StringUtils.isNotBlank((CharSequence)projectId) ? Long.parseLong(projectId) : 0L))).collect(Collectors.toList());
            for (QFilter filter : projectFilters) {
                if (projectFilter == null) {
                    projectFilter = filter;
                    continue;
                }
                projectFilter.or(filter);
            }
        }
        event.addCustomQFilter(projectFilter);
    }

    protected List<String> getProjectFieldNumber(String entityId) {
        ArrayList<String> projectFieldNames = new ArrayList<String>();
        ArrayList projectPropName = Lists.newArrayList((Object[])new String[]{"pro", "project"});
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntity = entityMeta.getRootEntity();
        List items = rootEntity.getItems();
        for (EntityItem property : items) {
            String number = property.getKey();
            if (!projectPropName.contains(number)) continue;
            projectFieldNames.add(number);
        }
        return projectFieldNames;
    }
}

