/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class OrgTreeListTemplatePlugin
extends StandardTreeListPlugin {
    public void initializeTree(EventObject e) {
        Object orgId1 = this.getView().getFormShowParameter().getCustomParam("org");
        OrgTreeParam param = new OrgTreeParam();
        if (StringUtils.isNotBlank((Object)orgId1)) {
            param.setId(Long.parseLong(orgId1.toString()));
        }
        param.setOrgViewNumber(this.getOrgViewType());
        String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
        this.getPageCache().put("pattern", pattern);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root != null) {
            root.setChildren(new ArrayList(0));
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            long currUserId = RequestContext.get().getCurrUserId();
            List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)currUserId);
            if (userOrgRanges.size() > 0) {
                if (StringUtils.isNotBlank((CharSequence)pattern)) {
                    List orgUnits;
                    if (rootId != null && userOrgRanges.contains(Long.parseLong(rootId.toString()))) {
                        orgUnits = userOrgRanges;
                    } else {
                        orgUnits = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"01");
                        if (orgUnits.size() > 0 && rootId != null && !orgUnits.contains(Long.parseLong(rootId.toString()))) {
                            orgUnits = OrgTreeUtils.getParentByOrgIds((List)orgUnits, (String)"01");
                        }
                    }
                    if (orgUnits.size() > 0) {
                        this.getPageCache().put("orgUnits", SerializationUtils.toJsonString((Object)orgUnits));
                        freezeFilter.and(new QFilter("org.id", "in", (Object)orgUnits));
                    } else {
                        freezeFilter.and(new QFilter("org.id", "=", (Object)0L));
                    }
                } else {
                    freezeFilter.and(new QFilter("org.id", "=", (Object)0L));
                }
            } else {
                freezeFilter.and(new QFilter("org.id", "=", (Object)0L));
            }
            List treeNodes = OrgTreeUtils.queryChildNodes((String)root.getId(), (String)this.getOrgViewType(), (QFilter)freezeFilter, (String)"sortcode");
            if (treeNodes != null && !treeNodes.isEmpty()) {
                this.getTreeModel().setRoot(root);
                root.addChildren(treeNodes);
                this.getTreeListView().getTreeView().addNode(root);
                this.getTreeListView().getTreeView().focusNode(root);
            }
        }
    }

    public String getOrgViewType() {
        return "01";
    }

    public void initialize() {
        super.initialize();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object nodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
        if (nodeId == null) {
            e.getQFilters().add(new QFilter("1", "=", (Object)"2"));
            return;
        }
        e.getQFilters().add(this.genRefreshFilter(nodeId.toString()));
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        String orgUnits = this.getPageCache().get("orgUnits");
        if (StringUtils.isBlank((CharSequence)nodeId) || orgUnits == null) {
            freezeFilter.and(new QFilter("org.id", "=", (Object)0L));
        } else {
            List orgUnitIds = SerializationUtils.fromJsonStringToList((String)orgUnits, Long.class);
            freezeFilter.and(new QFilter("org.id", "in", (Object)orgUnitIds));
        }
        List treeNodes = OrgTreeUtils.queryChildNodes((String)nodeId, (String)this.getOrgViewType(), (QFilter)freezeFilter, (String)"");
        e.setChildNodes(treeNodes);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        if (this.getNode(nodeId) != null) {
            TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
            node.setIsOpened(true);
            e.setExpandedNode(node);
        }
    }

    private TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (this.getNode(nodeId) != null) {
            this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
            this.refreshBillList();
        }
    }

    private QFilter genRefreshFilter(String nodeId) {
        String orgUnits = this.getPageCache().get("orgUnits");
        if (StringUtils.isBlank((CharSequence)nodeId) || orgUnits == null) {
            return null;
        }
        List orgUnitIds = SerializationUtils.fromJsonStringToList((String)orgUnits, Long.class);
        long orgId = Long.parseLong(nodeId);
        QFilter orgFilter = null;
        if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
            List<Long> orgIds = new ArrayList<Long>();
            orgIds.add(orgId);
            List lstChildOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(this.getOrgViewType()), orgIds, (boolean)true);
            if (!orgUnitIds.contains(Long.parseLong(nodeId))) {
                orgIds = lstChildOrgs.stream().filter(orgUnitIds::contains).collect(Collectors.toList());
                if (orgIds.size() > 0) {
                    List allChildOrg = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(this.getOrgViewType()), orgIds, (boolean)true);
                    orgFilter = new QFilter("org", "in", (Object)allChildOrg);
                }
            } else {
                orgFilter = new QFilter("org", "in", (Object)lstChildOrgs);
            }
        } else {
            orgFilter = !orgUnitIds.contains(Long.parseLong(nodeId)) ? new QFilter("org", "=", (Object)0L) : new QFilter("org", "=", (Object)orgId);
        }
        if (orgFilter == null) {
            orgFilter = new QFilter("org", "=", (Object)0L);
        }
        return orgFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
        e.setCancel(true);
    }

    private void refreshBillList() {
        Object nodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.setQueryFilterParameter(new FilterParameter(this.genRefreshFilter(nodeId.toString()), null));
        billList.refresh();
    }

    public void afterCreateNewData(EventObject e) {
        boolean isIncludeAllSub;
        if (this.getView().getFormShowParameter().getCustomParam("isIncludeAllSub") != null && (isIncludeAllSub = Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("isIncludeAllSub").toString()))) {
            this.getView().getModel().setValue("chkincludechild", (Object)Boolean.TRUE);
            this.getView().updateView("chkincludechild");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("chkincludechild".equals(e.getProperty().getName())) {
            this.refreshBillList();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String nodeId = String.valueOf(this.treeListView.getTreeModel().getCurrentNodeId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orgId", nodeId);
        e.getParameter().setCustomParams(param);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operateKey)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeView.TreeState treeState = treeView.getTreeState();
            Map focusOrg = treeState.getFocusNode();
            if (focusOrg == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"OrgTreeListTemplatePlugin_2", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
                return;
            }
            OrgServiceHelper orgServiceHelper = new OrgServiceHelper();
            DynamicObject org = orgServiceHelper.getBizOrg(Long.valueOf(String.valueOf(focusOrg.get("id"))), this.getOrgViewType());
            if (org == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8282\u70b9\u6ca1\u6709\u5bf9\u5e94\u7684\u804c\u80fd\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u3002", (String)"OrgTreeListTemplatePlugin_3", (String)"pmgt-pmbs-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

